/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.spin.impl.xml.dom.format;

import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.beans.Introspector;
import javax.xml.namespace.QName;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import org.camunda.commons.utils.EnsureUtil;
import org.camunda.spin.DeserializationTypeValidator;
import org.camunda.spin.SpinRuntimeException;
import org.camunda.spin.impl.util.SpinReflectUtil;
import org.camunda.spin.impl.xml.dom.DomXmlLogger;
import org.camunda.spin.impl.xml.dom.format.DomXmlDataFormat;
import org.camunda.spin.impl.xml.dom.format.spi.JaxBContextProvider;
import org.camunda.spin.spi.DataFormat;
import org.camunda.spin.spi.DataFormatMapper;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class DomXmlDataFormatMapper
implements DataFormatMapper {
    protected DomXmlDataFormat dataFormat;
    private static final DomXmlLogger LOG = DomXmlLogger.XML_DOM_LOGGER;

    public DomXmlDataFormatMapper(DomXmlDataFormat format) {
        this.dataFormat = format;
    }

    public boolean canMap(Object parameter) {
        return parameter != null;
    }

    public String getCanonicalTypeName(Object object) {
        return object.getClass().getName();
    }

    public Object mapJavaToInternal(Object parameter) {
        EnsureUtil.ensureNotNull((String)"Parameter", (Object)parameter);
        Class<?> parameterClass = parameter.getClass();
        DOMResult domResult = new DOMResult();
        try {
            boolean isRootElement;
            Marshaller marshaller = this.getMarshaller(parameterClass);
            boolean bl = isRootElement = parameterClass.getAnnotation(XmlRootElement.class) != null;
            if (isRootElement) {
                this.marshalRootElement(parameter, marshaller, domResult);
            } else {
                this.marshalNonRootElement(parameter, marshaller, domResult);
            }
            Node node = domResult.getNode();
            return ((Document)node).getDocumentElement();
        }
        catch (JAXBException e) {
            throw LOG.unableToMapInput(parameter, e);
        }
    }

    protected void marshalRootElement(Object parameter, Marshaller marshaller, DOMResult domResult) throws JAXBException {
        marshaller.marshal(parameter, (Result)domResult);
    }

    protected void marshalNonRootElement(Object parameter, Marshaller marshaller, DOMResult domResult) throws JAXBException {
        Class<?> parameterClass = parameter.getClass();
        String simpleName = Introspector.decapitalize(parameterClass.getSimpleName());
        JAXBElement root = new JAXBElement(new QName(simpleName), parameterClass, parameter);
        marshaller.marshal((Object)root, (Result)domResult);
    }

    public <T> T mapInternalToJava(Object parameter, Class<T> javaClass) {
        return this.mapInternalToJava(parameter, javaClass, null);
    }

    public <T> T mapInternalToJava(Object parameter, Class<T> javaClass, DeserializationTypeValidator validator) {
        EnsureUtil.ensureNotNull((String)"Parameter", (Object)parameter);
        EnsureUtil.ensureNotNull((String)"Type", javaClass);
        Node xmlNode = (Node)parameter;
        try {
            this.validateType(javaClass, validator);
            Unmarshaller unmarshaller = this.getUnmarshaller(javaClass);
            JAXBElement root = unmarshaller.unmarshal((Source)new DOMSource(xmlNode), javaClass);
            return (T)root.getValue();
        }
        catch (JAXBException e) {
            throw LOG.unableToDeserialize(parameter, javaClass.getCanonicalName(), e);
        }
    }

    protected void validateType(Class<?> type, DeserializationTypeValidator validator) {
        if (validator != null && !type.isPrimitive()) {
            String className;
            Class<?> typeToValidate = type;
            if (type.isArray()) {
                typeToValidate = type.getComponentType();
            }
            if (!validator.validate(className = typeToValidate.getName())) {
                throw new SpinRuntimeException("The class '" + className + "' is not whitelisted for deserialization.");
            }
        }
    }

    public <T> T mapInternalToJava(Object parameter, String classIdentifier) {
        return this.mapInternalToJava(parameter, classIdentifier, null);
    }

    public <T> T mapInternalToJava(Object parameter, String classIdentifier, DeserializationTypeValidator validator) {
        EnsureUtil.ensureNotNull((String)"Parameter", (Object)parameter);
        EnsureUtil.ensureNotNull((String)"classIdentifier", (Object)classIdentifier);
        try {
            Class javaClass = SpinReflectUtil.loadClass((String)classIdentifier, (DataFormat)this.dataFormat);
            return this.mapInternalToJava(parameter, javaClass, validator);
        }
        catch (Exception e) {
            throw LOG.unableToDeserialize(parameter, classIdentifier, e);
        }
    }

    protected Marshaller getMarshaller(Class<?> parameter) throws JAXBException {
        JaxBContextProvider jaxBContextProvider = this.dataFormat.getJaxBContextProvider();
        return jaxBContextProvider.createMarshaller(parameter);
    }

    protected Unmarshaller getUnmarshaller(Class<?> parameter) throws JAXBException {
        JaxBContextProvider jaxBContextProvider = this.dataFormat.getJaxBContextProvider();
        return jaxBContextProvider.createUnmarshaller(parameter);
    }
}

