/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.spin.impl.json.jackson.format;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;
import org.camunda.spin.impl.json.jackson.JacksonJsonLogger;
import org.camunda.spin.impl.json.jackson.format.JacksonJsonDataFormat;
import org.camunda.spin.spi.DataFormatMapper;

public class JacksonJsonDataFormatMapper
implements DataFormatMapper {
    private static final JacksonJsonLogger LOG = JacksonJsonLogger.JSON_TREE_LOGGER;
    protected JacksonJsonDataFormat format;

    public JacksonJsonDataFormatMapper(JacksonJsonDataFormat format) {
        this.format = format;
    }

    public boolean canMap(Object parameter) {
        return parameter != null;
    }

    public String getCanonicalTypeName(Object object) {
        return this.format.getCanonicalTypeName(object);
    }

    public Object mapJavaToInternal(Object parameter) {
        ObjectMapper mapper = this.format.getObjectMapper();
        try {
            return mapper.valueToTree(parameter);
        }
        catch (IllegalArgumentException e) {
            throw LOG.unableToMapInput(parameter, e);
        }
    }

    public <T> T mapInternalToJava(Object parameter, Class<T> type) {
        JavaType javaType = TypeFactory.defaultInstance().constructType(type);
        Object result = this.mapInternalToJava(parameter, javaType);
        return (T)result;
    }

    public <T> T mapInternalToJava(Object parameter, String typeIdentifier) {
        JavaType javaType = this.format.constructJavaTypeFromCanonicalString(typeIdentifier);
        Object result = this.mapInternalToJava(parameter, javaType);
        return (T)result;
    }

    public <C> C mapInternalToJava(Object parameter, JavaType type) {
        JsonNode jsonNode = (JsonNode)parameter;
        ObjectMapper mapper = this.format.getObjectMapper();
        try {
            return (C)mapper.readValue(mapper.treeAsTokens((TreeNode)jsonNode), type);
        }
        catch (IOException e) {
            throw LOG.unableToDeserialize(jsonNode, type, e);
        }
    }
}

