/*
 * Decompiled with CFR 0.152.
 */
package spinjar.com.jayway.jsonpath.internal;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import spinjar.com.jayway.jsonpath.Configuration;
import spinjar.com.jayway.jsonpath.InvalidModelException;
import spinjar.com.jayway.jsonpath.internal.filter.FilterFactory;
import spinjar.com.jayway.jsonpath.internal.filter.PathTokenFilter;

public class PathToken {
    private static final Pattern ARRAY_INDEX_PATTERN = Pattern.compile("\\[(\\d+)]");
    private final String fragment;
    private final int tokenIndex;
    private final boolean endToken;

    public PathToken(String fragment, int tokenIndex, boolean isEndToken) {
        this.fragment = fragment;
        this.tokenIndex = tokenIndex;
        this.endToken = isEndToken;
    }

    public PathTokenFilter getFilter() {
        return FilterFactory.createFilter(this);
    }

    public Object filter(Object model, Configuration configuration) {
        return FilterFactory.createFilter(this).filter(model, configuration);
    }

    public Object apply(Object model, Configuration configuration) {
        return FilterFactory.createFilter(this).getRef(model, configuration);
    }

    public String getFragment() {
        return this.fragment;
    }

    public boolean isRootToken() {
        return this.tokenIndex == 0;
    }

    public boolean isEndToken() {
        return this.endToken;
    }

    public boolean isArrayIndexToken() {
        return ARRAY_INDEX_PATTERN.matcher(this.fragment).matches();
    }

    public int getArrayIndex() {
        Matcher matcher = ARRAY_INDEX_PATTERN.matcher(this.fragment);
        if (matcher.find()) {
            return Integer.parseInt(matcher.group(1));
        }
        throw new InvalidModelException("Could not get array index from fragment " + this.fragment);
    }
}

