/*
 * Decompiled with CFR 0.152.
 */
package spinjar.com.jayway.jsonpath.internal.filter;

import spinjar.com.jayway.jsonpath.Configuration;
import spinjar.com.jayway.jsonpath.Filter;
import spinjar.com.jayway.jsonpath.JsonPath;
import spinjar.com.jayway.jsonpath.Option;
import spinjar.com.jayway.jsonpath.PathNotFoundException;
import spinjar.com.jayway.jsonpath.internal.filter.PathTokenFilter;
import spinjar.com.jayway.jsonpath.spi.JsonProvider;

public class HasPathFilter
extends PathTokenFilter {
    private final JsonPath path;

    public HasPathFilter(String condition) {
        super(condition);
        String trimmedCondition = condition;
        if (condition.contains("['")) {
            trimmedCondition = trimmedCondition.replace("['", ".");
            trimmedCondition = trimmedCondition.replace("']", "");
        }
        this.path = JsonPath.compile(HasPathFilter.trim(trimmedCondition, 5, 2), new Filter[0]);
    }

    @Override
    public Object filter(Object obj, Configuration configuration) {
        JsonProvider jsonProvider = configuration.getProvider();
        Iterable<Object> src = jsonProvider.toIterable(obj);
        Iterable result = jsonProvider.createArray();
        for (Object item : src) {
            if (!jsonProvider.isMap(item)) continue;
            try {
                this.path.read(item, Configuration.builder().options(Option.THROW_ON_MISSING_PROPERTY).jsonProvider(jsonProvider).build());
                jsonProvider.setProperty(result, jsonProvider.length(result), item);
            }
            catch (PathNotFoundException e) {}
        }
        return result;
    }

    @Override
    public Object getRef(Object obj, Configuration configuration) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isArrayFilter() {
        return true;
    }
}

