/*
 * Decompiled with CFR 0.152.
 */
package spinjar.com.jayway.jsonpath.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import spinjar.com.jayway.jsonpath.Configuration;
import spinjar.com.jayway.jsonpath.Filter;
import spinjar.com.jayway.jsonpath.JsonPath;
import spinjar.com.jayway.jsonpath.ParseContext;
import spinjar.com.jayway.jsonpath.ReadContext;
import spinjar.com.jayway.jsonpath.internal.Utils;
import spinjar.com.jayway.jsonpath.spi.HttpProviderFactory;
import spinjar.com.jayway.jsonpath.spi.JsonProvider;

public class JsonReader
implements ParseContext,
ReadContext {
    private final Configuration configuration;
    private Object json;

    public JsonReader() {
        this(Configuration.defaultConfiguration());
    }

    public JsonReader(JsonProvider jsonProvider) {
        this(Configuration.builder().jsonProvider(jsonProvider).build());
    }

    public JsonReader(Configuration configuration) {
        Utils.notNull(configuration, "configuration can not be null", new Object[0]);
        this.configuration = configuration;
    }

    @Override
    public ReadContext parse(Object json) {
        Utils.notNull(json, "json object can not be null", new Object[0]);
        this.json = json;
        return this;
    }

    @Override
    public ReadContext parse(String json) {
        Utils.notEmpty(json, "json string can not be null or empty", new Object[0]);
        this.json = this.configuration.getProvider().parse(json);
        return this;
    }

    @Override
    public ReadContext parse(InputStream json) {
        Utils.notNull(json, "json input stream can not be null", new Object[0]);
        this.json = this.configuration.getProvider().parse(json);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReadContext parse(File json) throws IOException {
        Utils.notNull(json, "json file can not be null", new Object[0]);
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(json);
            this.parse(fis);
        }
        catch (Throwable throwable) {
            Utils.closeQuietly(fis);
            throw throwable;
        }
        Utils.closeQuietly(fis);
        return this;
    }

    @Override
    public ReadContext parse(URL json) throws IOException {
        Utils.notNull(json, "json url can not be null", new Object[0]);
        InputStream is = HttpProviderFactory.getProvider().get(json);
        return this.parse(is);
    }

    @Override
    public Object json() {
        return this.json;
    }

    @Override
    public <T> T read(String path, Filter ... filters) {
        Utils.notEmpty(path, "path can not be null or empty", new Object[0]);
        return this.read(JsonPath.compile(path, filters));
    }

    @Override
    public <T> T read(JsonPath path) {
        Utils.notNull(path, "path can not be null", new Object[0]);
        return path.read(this.json, this.configuration);
    }
}

