/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.rest.client.dto;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.camunda.community.rest.client.dto.VariableValueDto;

public class LockedExternalTaskDto {
    public static final String SERIALIZED_NAME_ACTIVITY_ID = "activityId";
    @SerializedName(value="activityId")
    private String activityId;
    public static final String SERIALIZED_NAME_ACTIVITY_INSTANCE_ID = "activityInstanceId";
    @SerializedName(value="activityInstanceId")
    private String activityInstanceId;
    public static final String SERIALIZED_NAME_ERROR_MESSAGE = "errorMessage";
    @SerializedName(value="errorMessage")
    private String errorMessage;
    public static final String SERIALIZED_NAME_ERROR_DETAILS = "errorDetails";
    @SerializedName(value="errorDetails")
    private String errorDetails;
    public static final String SERIALIZED_NAME_EXECUTION_ID = "executionId";
    @SerializedName(value="executionId")
    private String executionId;
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_LOCK_EXPIRATION_TIME = "lockExpirationTime";
    @SerializedName(value="lockExpirationTime")
    private Date lockExpirationTime;
    public static final String SERIALIZED_NAME_PROCESS_DEFINITION_ID = "processDefinitionId";
    @SerializedName(value="processDefinitionId")
    private String processDefinitionId;
    public static final String SERIALIZED_NAME_PROCESS_DEFINITION_KEY = "processDefinitionKey";
    @SerializedName(value="processDefinitionKey")
    private String processDefinitionKey;
    public static final String SERIALIZED_NAME_PROCESS_DEFINITION_VERSION_TAG = "processDefinitionVersionTag";
    @SerializedName(value="processDefinitionVersionTag")
    private String processDefinitionVersionTag;
    public static final String SERIALIZED_NAME_PROCESS_INSTANCE_ID = "processInstanceId";
    @SerializedName(value="processInstanceId")
    private String processInstanceId;
    public static final String SERIALIZED_NAME_TENANT_ID = "tenantId";
    @SerializedName(value="tenantId")
    private String tenantId;
    public static final String SERIALIZED_NAME_RETRIES = "retries";
    @SerializedName(value="retries")
    private Integer retries;
    public static final String SERIALIZED_NAME_SUSPENDED = "suspended";
    @SerializedName(value="suspended")
    private Boolean suspended;
    public static final String SERIALIZED_NAME_WORKER_ID = "workerId";
    @SerializedName(value="workerId")
    private String workerId;
    public static final String SERIALIZED_NAME_PRIORITY = "priority";
    @SerializedName(value="priority")
    private Long priority;
    public static final String SERIALIZED_NAME_TOPIC_NAME = "topicName";
    @SerializedName(value="topicName")
    private String topicName;
    public static final String SERIALIZED_NAME_BUSINESS_KEY = "businessKey";
    @SerializedName(value="businessKey")
    private String businessKey;
    public static final String SERIALIZED_NAME_VARIABLES = "variables";
    @SerializedName(value="variables")
    private Map<String, VariableValueDto> variables = null;

    public LockedExternalTaskDto activityId(String activityId) {
        this.activityId = activityId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of the activity that this external task belongs to.")
    public String getActivityId() {
        return this.activityId;
    }

    public void setActivityId(String activityId) {
        this.activityId = activityId;
    }

    public LockedExternalTaskDto activityInstanceId(String activityInstanceId) {
        this.activityInstanceId = activityInstanceId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of the activity instance that the external task belongs to.")
    public String getActivityInstanceId() {
        return this.activityInstanceId;
    }

    public void setActivityInstanceId(String activityInstanceId) {
        this.activityInstanceId = activityInstanceId;
    }

    public LockedExternalTaskDto errorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The full error message submitted with the latest reported failure executing this task;`null` if no failure was reported previously or if no error message was submitted")
    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public LockedExternalTaskDto errorDetails(String errorDetails) {
        this.errorDetails = errorDetails;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The error details submitted with the latest reported failure executing this task.`null` if no failure was reported previously or if no error details was submitted")
    public String getErrorDetails() {
        return this.errorDetails;
    }

    public void setErrorDetails(String errorDetails) {
        this.errorDetails = errorDetails;
    }

    public LockedExternalTaskDto executionId(String executionId) {
        this.executionId = executionId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of the execution that the external task belongs to.")
    public String getExecutionId() {
        return this.executionId;
    }

    public void setExecutionId(String executionId) {
        this.executionId = executionId;
    }

    public LockedExternalTaskDto id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of the external task.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public LockedExternalTaskDto lockExpirationTime(Date lockExpirationTime) {
        this.lockExpirationTime = lockExpirationTime;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The date that the task's most recent lock expires or has expired.")
    public Date getLockExpirationTime() {
        return this.lockExpirationTime;
    }

    public void setLockExpirationTime(Date lockExpirationTime) {
        this.lockExpirationTime = lockExpirationTime;
    }

    public LockedExternalTaskDto processDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of the process definition the external task is defined in.")
    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public void setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    public LockedExternalTaskDto processDefinitionKey(String processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The key of the process definition the external task is defined in.")
    public String getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    public void setProcessDefinitionKey(String processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
    }

    public LockedExternalTaskDto processDefinitionVersionTag(String processDefinitionVersionTag) {
        this.processDefinitionVersionTag = processDefinitionVersionTag;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The version tag of the process definition the external task is defined in.")
    public String getProcessDefinitionVersionTag() {
        return this.processDefinitionVersionTag;
    }

    public void setProcessDefinitionVersionTag(String processDefinitionVersionTag) {
        this.processDefinitionVersionTag = processDefinitionVersionTag;
    }

    public LockedExternalTaskDto processInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of the process instance the external task belongs to.")
    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public LockedExternalTaskDto tenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of the tenant the external task belongs to.")
    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public LockedExternalTaskDto retries(Integer retries) {
        this.retries = retries;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of retries the task currently has left.")
    public Integer getRetries() {
        return this.retries;
    }

    public void setRetries(Integer retries) {
        this.retries = retries;
    }

    public LockedExternalTaskDto suspended(Boolean suspended) {
        this.suspended = suspended;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Whether the process instance the external task belongs to is suspended.")
    public Boolean getSuspended() {
        return this.suspended;
    }

    public void setSuspended(Boolean suspended) {
        this.suspended = suspended;
    }

    public LockedExternalTaskDto workerId(String workerId) {
        this.workerId = workerId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of the worker that posesses or posessed the most recent lock.")
    public String getWorkerId() {
        return this.workerId;
    }

    public void setWorkerId(String workerId) {
        this.workerId = workerId;
    }

    public LockedExternalTaskDto priority(Long priority) {
        this.priority = priority;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The priority of the external task.")
    public Long getPriority() {
        return this.priority;
    }

    public void setPriority(Long priority) {
        this.priority = priority;
    }

    public LockedExternalTaskDto topicName(String topicName) {
        this.topicName = topicName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The topic name of the external task.")
    public String getTopicName() {
        return this.topicName;
    }

    public void setTopicName(String topicName) {
        this.topicName = topicName;
    }

    public LockedExternalTaskDto businessKey(String businessKey) {
        this.businessKey = businessKey;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The business key of the process instance the external task belongs to.")
    public String getBusinessKey() {
        return this.businessKey;
    }

    public void setBusinessKey(String businessKey) {
        this.businessKey = businessKey;
    }

    public LockedExternalTaskDto variables(Map<String, VariableValueDto> variables) {
        this.variables = variables;
        return this;
    }

    public LockedExternalTaskDto putVariablesItem(String key, VariableValueDto variablesItem) {
        if (this.variables == null) {
            this.variables = new HashMap<String, VariableValueDto>();
        }
        this.variables.put(key, variablesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A JSON object containing a property for each of the requested variables. The key is the variable name, the value is a JSON object of serialized variable values with the following properties:")
    public Map<String, VariableValueDto> getVariables() {
        return this.variables;
    }

    public void setVariables(Map<String, VariableValueDto> variables) {
        this.variables = variables;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LockedExternalTaskDto lockedExternalTaskDto = (LockedExternalTaskDto)o;
        return Objects.equals(this.activityId, lockedExternalTaskDto.activityId) && Objects.equals(this.activityInstanceId, lockedExternalTaskDto.activityInstanceId) && Objects.equals(this.errorMessage, lockedExternalTaskDto.errorMessage) && Objects.equals(this.errorDetails, lockedExternalTaskDto.errorDetails) && Objects.equals(this.executionId, lockedExternalTaskDto.executionId) && Objects.equals(this.id, lockedExternalTaskDto.id) && Objects.equals(this.lockExpirationTime, lockedExternalTaskDto.lockExpirationTime) && Objects.equals(this.processDefinitionId, lockedExternalTaskDto.processDefinitionId) && Objects.equals(this.processDefinitionKey, lockedExternalTaskDto.processDefinitionKey) && Objects.equals(this.processDefinitionVersionTag, lockedExternalTaskDto.processDefinitionVersionTag) && Objects.equals(this.processInstanceId, lockedExternalTaskDto.processInstanceId) && Objects.equals(this.tenantId, lockedExternalTaskDto.tenantId) && Objects.equals(this.retries, lockedExternalTaskDto.retries) && Objects.equals(this.suspended, lockedExternalTaskDto.suspended) && Objects.equals(this.workerId, lockedExternalTaskDto.workerId) && Objects.equals(this.priority, lockedExternalTaskDto.priority) && Objects.equals(this.topicName, lockedExternalTaskDto.topicName) && Objects.equals(this.businessKey, lockedExternalTaskDto.businessKey) && Objects.equals(this.variables, lockedExternalTaskDto.variables);
    }

    public int hashCode() {
        return Objects.hash(this.activityId, this.activityInstanceId, this.errorMessage, this.errorDetails, this.executionId, this.id, this.lockExpirationTime, this.processDefinitionId, this.processDefinitionKey, this.processDefinitionVersionTag, this.processInstanceId, this.tenantId, this.retries, this.suspended, this.workerId, this.priority, this.topicName, this.businessKey, this.variables);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LockedExternalTaskDto {\n");
        sb.append("    activityId: ").append(this.toIndentedString(this.activityId)).append("\n");
        sb.append("    activityInstanceId: ").append(this.toIndentedString(this.activityInstanceId)).append("\n");
        sb.append("    errorMessage: ").append(this.toIndentedString(this.errorMessage)).append("\n");
        sb.append("    errorDetails: ").append(this.toIndentedString(this.errorDetails)).append("\n");
        sb.append("    executionId: ").append(this.toIndentedString(this.executionId)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    lockExpirationTime: ").append(this.toIndentedString(this.lockExpirationTime)).append("\n");
        sb.append("    processDefinitionId: ").append(this.toIndentedString(this.processDefinitionId)).append("\n");
        sb.append("    processDefinitionKey: ").append(this.toIndentedString(this.processDefinitionKey)).append("\n");
        sb.append("    processDefinitionVersionTag: ").append(this.toIndentedString(this.processDefinitionVersionTag)).append("\n");
        sb.append("    processInstanceId: ").append(this.toIndentedString(this.processInstanceId)).append("\n");
        sb.append("    tenantId: ").append(this.toIndentedString(this.tenantId)).append("\n");
        sb.append("    retries: ").append(this.toIndentedString(this.retries)).append("\n");
        sb.append("    suspended: ").append(this.toIndentedString(this.suspended)).append("\n");
        sb.append("    workerId: ").append(this.toIndentedString(this.workerId)).append("\n");
        sb.append("    priority: ").append(this.toIndentedString(this.priority)).append("\n");
        sb.append("    topicName: ").append(this.toIndentedString(this.topicName)).append("\n");
        sb.append("    businessKey: ").append(this.toIndentedString(this.businessKey)).append("\n");
        sb.append("    variables: ").append(this.toIndentedString(this.variables)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

