/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.rest.client.dto;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.camunda.community.rest.client.dto.HistoricDecisionInputInstanceDto;
import org.camunda.community.rest.client.dto.HistoricDecisionOutputInstanceDto;

public class HistoricDecisionInstanceDto {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_DECISION_DEFINITION_ID = "decisionDefinitionId";
    @SerializedName(value="decisionDefinitionId")
    private String decisionDefinitionId;
    public static final String SERIALIZED_NAME_DECISION_DEFINITION_KEY = "decisionDefinitionKey";
    @SerializedName(value="decisionDefinitionKey")
    private String decisionDefinitionKey;
    public static final String SERIALIZED_NAME_DECISION_DEFINITION_NAME = "decisionDefinitionName";
    @SerializedName(value="decisionDefinitionName")
    private String decisionDefinitionName;
    public static final String SERIALIZED_NAME_EVALUATION_TIME = "evaluationTime";
    @SerializedName(value="evaluationTime")
    private Date evaluationTime;
    public static final String SERIALIZED_NAME_REMOVAL_TIME = "removalTime";
    @SerializedName(value="removalTime")
    private Date removalTime;
    public static final String SERIALIZED_NAME_PROCESS_DEFINITION_ID = "processDefinitionId";
    @SerializedName(value="processDefinitionId")
    private String processDefinitionId;
    public static final String SERIALIZED_NAME_PROCESS_DEFINITION_KEY = "processDefinitionKey";
    @SerializedName(value="processDefinitionKey")
    private String processDefinitionKey;
    public static final String SERIALIZED_NAME_PROCESS_INSTANCE_ID = "processInstanceId";
    @SerializedName(value="processInstanceId")
    private String processInstanceId;
    public static final String SERIALIZED_NAME_CASE_DEFINITION_ID = "caseDefinitionId";
    @SerializedName(value="caseDefinitionId")
    private String caseDefinitionId;
    public static final String SERIALIZED_NAME_CASE_DEFINITION_KEY = "caseDefinitionKey";
    @SerializedName(value="caseDefinitionKey")
    private String caseDefinitionKey;
    public static final String SERIALIZED_NAME_CASE_INSTANCE_ID = "caseInstanceId";
    @SerializedName(value="caseInstanceId")
    private String caseInstanceId;
    public static final String SERIALIZED_NAME_ACTIVITY_ID = "activityId";
    @SerializedName(value="activityId")
    private String activityId;
    public static final String SERIALIZED_NAME_ACTIVITY_INSTANCE_ID = "activityInstanceId";
    @SerializedName(value="activityInstanceId")
    private String activityInstanceId;
    public static final String SERIALIZED_NAME_TENANT_ID = "tenantId";
    @SerializedName(value="tenantId")
    private String tenantId;
    public static final String SERIALIZED_NAME_USER_ID = "userId";
    @SerializedName(value="userId")
    private String userId;
    public static final String SERIALIZED_NAME_INPUTS = "inputs";
    @SerializedName(value="inputs")
    private List<HistoricDecisionInputInstanceDto> inputs = null;
    public static final String SERIALIZED_NAME_OUPUTS = "ouputs";
    @SerializedName(value="ouputs")
    private List<HistoricDecisionOutputInstanceDto> ouputs = null;
    public static final String SERIALIZED_NAME_COLLECT_RESULT_VALUE = "collectResultValue";
    @SerializedName(value="collectResultValue")
    private Double collectResultValue;
    public static final String SERIALIZED_NAME_ROOT_DECISION_INSTANCE_ID = "rootDecisionInstanceId";
    @SerializedName(value="rootDecisionInstanceId")
    private String rootDecisionInstanceId;
    public static final String SERIALIZED_NAME_ROOT_PROCESS_INSTANCE_ID = "rootProcessInstanceId";
    @SerializedName(value="rootProcessInstanceId")
    private String rootProcessInstanceId;
    public static final String SERIALIZED_NAME_DECISION_REQUIREMENTS_DEFINITION_ID = "decisionRequirementsDefinitionId";
    @SerializedName(value="decisionRequirementsDefinitionId")
    private String decisionRequirementsDefinitionId;
    public static final String SERIALIZED_NAME_DECISION_REQUIREMENTS_DEFINITION_KEY = "decisionRequirementsDefinitionKey";
    @SerializedName(value="decisionRequirementsDefinitionKey")
    private String decisionRequirementsDefinitionKey;

    public HistoricDecisionInstanceDto id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of the decision instance.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public HistoricDecisionInstanceDto decisionDefinitionId(String decisionDefinitionId) {
        this.decisionDefinitionId = decisionDefinitionId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of the decision definition that this decision instance belongs to.")
    public String getDecisionDefinitionId() {
        return this.decisionDefinitionId;
    }

    public void setDecisionDefinitionId(String decisionDefinitionId) {
        this.decisionDefinitionId = decisionDefinitionId;
    }

    public HistoricDecisionInstanceDto decisionDefinitionKey(String decisionDefinitionKey) {
        this.decisionDefinitionKey = decisionDefinitionKey;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The key of the decision definition that this decision instance belongs to.")
    public String getDecisionDefinitionKey() {
        return this.decisionDefinitionKey;
    }

    public void setDecisionDefinitionKey(String decisionDefinitionKey) {
        this.decisionDefinitionKey = decisionDefinitionKey;
    }

    public HistoricDecisionInstanceDto decisionDefinitionName(String decisionDefinitionName) {
        this.decisionDefinitionName = decisionDefinitionName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The name of the decision definition that this decision instance belongs to.")
    public String getDecisionDefinitionName() {
        return this.decisionDefinitionName;
    }

    public void setDecisionDefinitionName(String decisionDefinitionName) {
        this.decisionDefinitionName = decisionDefinitionName;
    }

    public HistoricDecisionInstanceDto evaluationTime(Date evaluationTime) {
        this.evaluationTime = evaluationTime;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The time the instance was evaluated.  [Default format](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/) `yyyy-MM-dd'T'HH:mm:ss.SSSZ`.")
    public Date getEvaluationTime() {
        return this.evaluationTime;
    }

    public void setEvaluationTime(Date evaluationTime) {
        this.evaluationTime = evaluationTime;
    }

    public HistoricDecisionInstanceDto removalTime(Date removalTime) {
        this.removalTime = removalTime;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The time after which the instance should be removed by the History Cleanup job. [Default format](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/) `yyyy-MM-dd'T'HH:mm:ss.SSSZ`.")
    public Date getRemovalTime() {
        return this.removalTime;
    }

    public void setRemovalTime(Date removalTime) {
        this.removalTime = removalTime;
    }

    public HistoricDecisionInstanceDto processDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of the process definition that this decision instance belongs to.")
    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public void setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    public HistoricDecisionInstanceDto processDefinitionKey(String processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The key of the process definition that this decision instance belongs to.")
    public String getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    public void setProcessDefinitionKey(String processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
    }

    public HistoricDecisionInstanceDto processInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of the process instance that this decision instance belongs to.")
    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public HistoricDecisionInstanceDto caseDefinitionId(String caseDefinitionId) {
        this.caseDefinitionId = caseDefinitionId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of the case definition that this decision instance belongs to.")
    public String getCaseDefinitionId() {
        return this.caseDefinitionId;
    }

    public void setCaseDefinitionId(String caseDefinitionId) {
        this.caseDefinitionId = caseDefinitionId;
    }

    public HistoricDecisionInstanceDto caseDefinitionKey(String caseDefinitionKey) {
        this.caseDefinitionKey = caseDefinitionKey;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The key of the case definition that this decision instance belongs to.")
    public String getCaseDefinitionKey() {
        return this.caseDefinitionKey;
    }

    public void setCaseDefinitionKey(String caseDefinitionKey) {
        this.caseDefinitionKey = caseDefinitionKey;
    }

    public HistoricDecisionInstanceDto caseInstanceId(String caseInstanceId) {
        this.caseInstanceId = caseInstanceId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of the case instance that this decision instance belongs to.")
    public String getCaseInstanceId() {
        return this.caseInstanceId;
    }

    public void setCaseInstanceId(String caseInstanceId) {
        this.caseInstanceId = caseInstanceId;
    }

    public HistoricDecisionInstanceDto activityId(String activityId) {
        this.activityId = activityId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of the activity that this decision instance belongs to.")
    public String getActivityId() {
        return this.activityId;
    }

    public void setActivityId(String activityId) {
        this.activityId = activityId;
    }

    public HistoricDecisionInstanceDto activityInstanceId(String activityInstanceId) {
        this.activityInstanceId = activityInstanceId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of the activity instance that this decision instance belongs to.")
    public String getActivityInstanceId() {
        return this.activityInstanceId;
    }

    public void setActivityInstanceId(String activityInstanceId) {
        this.activityInstanceId = activityInstanceId;
    }

    public HistoricDecisionInstanceDto tenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The tenant id of the historic decision instance.")
    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public HistoricDecisionInstanceDto userId(String userId) {
        this.userId = userId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of the authenticated user that has evaluated this decision instance without a process or case instance.")
    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public HistoricDecisionInstanceDto inputs(List<HistoricDecisionInputInstanceDto> inputs) {
        this.inputs = inputs;
        return this;
    }

    public HistoricDecisionInstanceDto addInputsItem(HistoricDecisionInputInstanceDto inputsItem) {
        if (this.inputs == null) {
            this.inputs = new ArrayList<HistoricDecisionInputInstanceDto>();
        }
        this.inputs.add(inputsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The list of decision input values. **Only exists** if `includeInputs` was set to `true` in the query.")
    public List<HistoricDecisionInputInstanceDto> getInputs() {
        return this.inputs;
    }

    public void setInputs(List<HistoricDecisionInputInstanceDto> inputs) {
        this.inputs = inputs;
    }

    public HistoricDecisionInstanceDto ouputs(List<HistoricDecisionOutputInstanceDto> ouputs) {
        this.ouputs = ouputs;
        return this;
    }

    public HistoricDecisionInstanceDto addOuputsItem(HistoricDecisionOutputInstanceDto ouputsItem) {
        if (this.ouputs == null) {
            this.ouputs = new ArrayList<HistoricDecisionOutputInstanceDto>();
        }
        this.ouputs.add(ouputsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The list of decision output values. **Only exists** if `includeOutputs` was set to `true` in the query.")
    public List<HistoricDecisionOutputInstanceDto> getOuputs() {
        return this.ouputs;
    }

    public void setOuputs(List<HistoricDecisionOutputInstanceDto> ouputs) {
        this.ouputs = ouputs;
    }

    public HistoricDecisionInstanceDto collectResultValue(Double collectResultValue) {
        this.collectResultValue = collectResultValue;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The result of the collect aggregation of the decision result if used. `null` if no aggregation was used.")
    public Double getCollectResultValue() {
        return this.collectResultValue;
    }

    public void setCollectResultValue(Double collectResultValue) {
        this.collectResultValue = collectResultValue;
    }

    public HistoricDecisionInstanceDto rootDecisionInstanceId(String rootDecisionInstanceId) {
        this.rootDecisionInstanceId = rootDecisionInstanceId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The decision instance id of the evaluated root decision. Can be `null` if this instance is the root decision instance of the evaluation.")
    public String getRootDecisionInstanceId() {
        return this.rootDecisionInstanceId;
    }

    public void setRootDecisionInstanceId(String rootDecisionInstanceId) {
        this.rootDecisionInstanceId = rootDecisionInstanceId;
    }

    public HistoricDecisionInstanceDto rootProcessInstanceId(String rootProcessInstanceId) {
        this.rootProcessInstanceId = rootProcessInstanceId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The process instance id of the root process instance that initiated the evaluation of this decision. Can be `null` if this decision instance is not evaluated as part of a BPMN process.")
    public String getRootProcessInstanceId() {
        return this.rootProcessInstanceId;
    }

    public void setRootProcessInstanceId(String rootProcessInstanceId) {
        this.rootProcessInstanceId = rootProcessInstanceId;
    }

    public HistoricDecisionInstanceDto decisionRequirementsDefinitionId(String decisionRequirementsDefinitionId) {
        this.decisionRequirementsDefinitionId = decisionRequirementsDefinitionId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of the decision requirements definition that this decision instance belongs to.")
    public String getDecisionRequirementsDefinitionId() {
        return this.decisionRequirementsDefinitionId;
    }

    public void setDecisionRequirementsDefinitionId(String decisionRequirementsDefinitionId) {
        this.decisionRequirementsDefinitionId = decisionRequirementsDefinitionId;
    }

    public HistoricDecisionInstanceDto decisionRequirementsDefinitionKey(String decisionRequirementsDefinitionKey) {
        this.decisionRequirementsDefinitionKey = decisionRequirementsDefinitionKey;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The key of the decision requirements definition that this decision instance belongs to.")
    public String getDecisionRequirementsDefinitionKey() {
        return this.decisionRequirementsDefinitionKey;
    }

    public void setDecisionRequirementsDefinitionKey(String decisionRequirementsDefinitionKey) {
        this.decisionRequirementsDefinitionKey = decisionRequirementsDefinitionKey;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HistoricDecisionInstanceDto historicDecisionInstanceDto = (HistoricDecisionInstanceDto)o;
        return Objects.equals(this.id, historicDecisionInstanceDto.id) && Objects.equals(this.decisionDefinitionId, historicDecisionInstanceDto.decisionDefinitionId) && Objects.equals(this.decisionDefinitionKey, historicDecisionInstanceDto.decisionDefinitionKey) && Objects.equals(this.decisionDefinitionName, historicDecisionInstanceDto.decisionDefinitionName) && Objects.equals(this.evaluationTime, historicDecisionInstanceDto.evaluationTime) && Objects.equals(this.removalTime, historicDecisionInstanceDto.removalTime) && Objects.equals(this.processDefinitionId, historicDecisionInstanceDto.processDefinitionId) && Objects.equals(this.processDefinitionKey, historicDecisionInstanceDto.processDefinitionKey) && Objects.equals(this.processInstanceId, historicDecisionInstanceDto.processInstanceId) && Objects.equals(this.caseDefinitionId, historicDecisionInstanceDto.caseDefinitionId) && Objects.equals(this.caseDefinitionKey, historicDecisionInstanceDto.caseDefinitionKey) && Objects.equals(this.caseInstanceId, historicDecisionInstanceDto.caseInstanceId) && Objects.equals(this.activityId, historicDecisionInstanceDto.activityId) && Objects.equals(this.activityInstanceId, historicDecisionInstanceDto.activityInstanceId) && Objects.equals(this.tenantId, historicDecisionInstanceDto.tenantId) && Objects.equals(this.userId, historicDecisionInstanceDto.userId) && Objects.equals(this.inputs, historicDecisionInstanceDto.inputs) && Objects.equals(this.ouputs, historicDecisionInstanceDto.ouputs) && Objects.equals(this.collectResultValue, historicDecisionInstanceDto.collectResultValue) && Objects.equals(this.rootDecisionInstanceId, historicDecisionInstanceDto.rootDecisionInstanceId) && Objects.equals(this.rootProcessInstanceId, historicDecisionInstanceDto.rootProcessInstanceId) && Objects.equals(this.decisionRequirementsDefinitionId, historicDecisionInstanceDto.decisionRequirementsDefinitionId) && Objects.equals(this.decisionRequirementsDefinitionKey, historicDecisionInstanceDto.decisionRequirementsDefinitionKey);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.decisionDefinitionId, this.decisionDefinitionKey, this.decisionDefinitionName, this.evaluationTime, this.removalTime, this.processDefinitionId, this.processDefinitionKey, this.processInstanceId, this.caseDefinitionId, this.caseDefinitionKey, this.caseInstanceId, this.activityId, this.activityInstanceId, this.tenantId, this.userId, this.inputs, this.ouputs, this.collectResultValue, this.rootDecisionInstanceId, this.rootProcessInstanceId, this.decisionRequirementsDefinitionId, this.decisionRequirementsDefinitionKey);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class HistoricDecisionInstanceDto {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    decisionDefinitionId: ").append(this.toIndentedString(this.decisionDefinitionId)).append("\n");
        sb.append("    decisionDefinitionKey: ").append(this.toIndentedString(this.decisionDefinitionKey)).append("\n");
        sb.append("    decisionDefinitionName: ").append(this.toIndentedString(this.decisionDefinitionName)).append("\n");
        sb.append("    evaluationTime: ").append(this.toIndentedString(this.evaluationTime)).append("\n");
        sb.append("    removalTime: ").append(this.toIndentedString(this.removalTime)).append("\n");
        sb.append("    processDefinitionId: ").append(this.toIndentedString(this.processDefinitionId)).append("\n");
        sb.append("    processDefinitionKey: ").append(this.toIndentedString(this.processDefinitionKey)).append("\n");
        sb.append("    processInstanceId: ").append(this.toIndentedString(this.processInstanceId)).append("\n");
        sb.append("    caseDefinitionId: ").append(this.toIndentedString(this.caseDefinitionId)).append("\n");
        sb.append("    caseDefinitionKey: ").append(this.toIndentedString(this.caseDefinitionKey)).append("\n");
        sb.append("    caseInstanceId: ").append(this.toIndentedString(this.caseInstanceId)).append("\n");
        sb.append("    activityId: ").append(this.toIndentedString(this.activityId)).append("\n");
        sb.append("    activityInstanceId: ").append(this.toIndentedString(this.activityInstanceId)).append("\n");
        sb.append("    tenantId: ").append(this.toIndentedString(this.tenantId)).append("\n");
        sb.append("    userId: ").append(this.toIndentedString(this.userId)).append("\n");
        sb.append("    inputs: ").append(this.toIndentedString(this.inputs)).append("\n");
        sb.append("    ouputs: ").append(this.toIndentedString(this.ouputs)).append("\n");
        sb.append("    collectResultValue: ").append(this.toIndentedString(this.collectResultValue)).append("\n");
        sb.append("    rootDecisionInstanceId: ").append(this.toIndentedString(this.rootDecisionInstanceId)).append("\n");
        sb.append("    rootProcessInstanceId: ").append(this.toIndentedString(this.rootProcessInstanceId)).append("\n");
        sb.append("    decisionRequirementsDefinitionId: ").append(this.toIndentedString(this.decisionRequirementsDefinitionId)).append("\n");
        sb.append("    decisionRequirementsDefinitionKey: ").append(this.toIndentedString(this.decisionRequirementsDefinitionKey)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

