/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.rest.client.dto;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

public class ExecutionDto {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_PROCESS_INSTANCE_ID = "processInstanceId";
    @SerializedName(value="processInstanceId")
    private String processInstanceId;
    public static final String SERIALIZED_NAME_ENDED = "ended";
    @SerializedName(value="ended")
    private Boolean ended;
    public static final String SERIALIZED_NAME_TENANT_ID = "tenantId";
    @SerializedName(value="tenantId")
    private String tenantId;

    public ExecutionDto id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of the Execution.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public ExecutionDto processInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of the root of the execution tree representing the process instance.")
    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public ExecutionDto ended(Boolean ended) {
        this.ended = ended;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Indicates if the execution is ended.")
    public Boolean getEnded() {
        return this.ended;
    }

    public void setEnded(Boolean ended) {
        this.ended = ended;
    }

    public ExecutionDto tenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of the tenant this execution belongs to. Can be `null` if the execution belongs to no single tenant.")
    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExecutionDto executionDto = (ExecutionDto)o;
        return Objects.equals(this.id, executionDto.id) && Objects.equals(this.processInstanceId, executionDto.processInstanceId) && Objects.equals(this.ended, executionDto.ended) && Objects.equals(this.tenantId, executionDto.tenantId);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.processInstanceId, this.ended, this.tenantId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ExecutionDto {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    processInstanceId: ").append(this.toIndentedString(this.processInstanceId)).append("\n");
        sb.append("    ended: ").append(this.toIndentedString(this.ended)).append("\n");
        sb.append("    tenantId: ").append(this.toIndentedString(this.tenantId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

