/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.rest.client.api;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;
import org.camunda.community.rest.client.dto.CountResultDto;
import org.camunda.community.rest.client.dto.CreateFilterDto;
import org.camunda.community.rest.client.dto.FilterDto;
import org.camunda.community.rest.client.dto.ResourceOptionsDto;
import org.camunda.community.rest.client.invoker.ApiCallback;
import org.camunda.community.rest.client.invoker.ApiClient;
import org.camunda.community.rest.client.invoker.ApiException;
import org.camunda.community.rest.client.invoker.ApiResponse;
import org.camunda.community.rest.client.invoker.Configuration;
import org.camunda.community.rest.client.invoker.Pair;

public class FilterApi {
    private ApiClient localVarApiClient;

    public FilterApi() {
        this(Configuration.getDefaultApiClient());
    }

    public FilterApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public Call createFilterCall(CreateFilterDto createFilterDto, ApiCallback _callback) throws ApiException {
        CreateFilterDto localVarPostBody = createFilterDto;
        String localVarPath = "/filter/create";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createFilterValidateBeforeCall(CreateFilterDto createFilterDto, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.createFilterCall(createFilterDto, _callback);
        return localVarCall;
    }

    public FilterDto createFilter(CreateFilterDto createFilterDto) throws ApiException {
        ApiResponse<FilterDto> localVarResp = this.createFilterWithHttpInfo(createFilterDto);
        return localVarResp.getData();
    }

    public ApiResponse<FilterDto> createFilterWithHttpInfo(CreateFilterDto createFilterDto) throws ApiException {
        Call localVarCall = this.createFilterValidateBeforeCall(createFilterDto, null);
        Type localVarReturnType = new TypeToken<FilterDto>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createFilterAsync(CreateFilterDto createFilterDto, ApiCallback<FilterDto> _callback) throws ApiException {
        Call localVarCall = this.createFilterValidateBeforeCall(createFilterDto, _callback);
        Type localVarReturnType = new TypeToken<FilterDto>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteFilterCall(String id, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/filter/{id}".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteFilterValidateBeforeCall(String id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling deleteFilter(Async)");
        }
        Call localVarCall = this.deleteFilterCall(id, _callback);
        return localVarCall;
    }

    public void deleteFilter(String id) throws ApiException {
        this.deleteFilterWithHttpInfo(id);
    }

    public ApiResponse<Void> deleteFilterWithHttpInfo(String id) throws ApiException {
        Call localVarCall = this.deleteFilterValidateBeforeCall(id, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteFilterAsync(String id, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteFilterValidateBeforeCall(id, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call executeFilterCountCall(String id, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/filter/{id}/count".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call executeFilterCountValidateBeforeCall(String id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling executeFilterCount(Async)");
        }
        Call localVarCall = this.executeFilterCountCall(id, _callback);
        return localVarCall;
    }

    public CountResultDto executeFilterCount(String id) throws ApiException {
        ApiResponse<CountResultDto> localVarResp = this.executeFilterCountWithHttpInfo(id);
        return localVarResp.getData();
    }

    public ApiResponse<CountResultDto> executeFilterCountWithHttpInfo(String id) throws ApiException {
        Call localVarCall = this.executeFilterCountValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<CountResultDto>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call executeFilterCountAsync(String id, ApiCallback<CountResultDto> _callback) throws ApiException {
        Call localVarCall = this.executeFilterCountValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<CountResultDto>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call executeFilterListCall(String id, Integer firstResult, Integer maxResults, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/filter/{id}/list".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (firstResult != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("firstResult", firstResult));
        }
        if (maxResults != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("maxResults", maxResults));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call executeFilterListValidateBeforeCall(String id, Integer firstResult, Integer maxResults, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling executeFilterList(Async)");
        }
        Call localVarCall = this.executeFilterListCall(id, firstResult, maxResults, _callback);
        return localVarCall;
    }

    public List<Object> executeFilterList(String id, Integer firstResult, Integer maxResults) throws ApiException {
        ApiResponse<List<Object>> localVarResp = this.executeFilterListWithHttpInfo(id, firstResult, maxResults);
        return localVarResp.getData();
    }

    public ApiResponse<List<Object>> executeFilterListWithHttpInfo(String id, Integer firstResult, Integer maxResults) throws ApiException {
        Call localVarCall = this.executeFilterListValidateBeforeCall(id, firstResult, maxResults, null);
        Type localVarReturnType = new TypeToken<List<Object>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call executeFilterListAsync(String id, Integer firstResult, Integer maxResults, ApiCallback<List<Object>> _callback) throws ApiException {
        Call localVarCall = this.executeFilterListValidateBeforeCall(id, firstResult, maxResults, _callback);
        Type localVarReturnType = new TypeToken<List<Object>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call executeFilterSingleResultCall(String id, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/filter/{id}/singleResult".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call executeFilterSingleResultValidateBeforeCall(String id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling executeFilterSingleResult(Async)");
        }
        Call localVarCall = this.executeFilterSingleResultCall(id, _callback);
        return localVarCall;
    }

    public Object executeFilterSingleResult(String id) throws ApiException {
        ApiResponse<Object> localVarResp = this.executeFilterSingleResultWithHttpInfo(id);
        return localVarResp.getData();
    }

    public ApiResponse<Object> executeFilterSingleResultWithHttpInfo(String id) throws ApiException {
        Call localVarCall = this.executeFilterSingleResultValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call executeFilterSingleResultAsync(String id, ApiCallback<Object> _callback) throws ApiException {
        Call localVarCall = this.executeFilterSingleResultValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call filterResourceOptionsCall(ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/filter";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "OPTIONS", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call filterResourceOptionsValidateBeforeCall(ApiCallback _callback) throws ApiException {
        Call localVarCall = this.filterResourceOptionsCall(_callback);
        return localVarCall;
    }

    public ResourceOptionsDto filterResourceOptions() throws ApiException {
        ApiResponse<ResourceOptionsDto> localVarResp = this.filterResourceOptionsWithHttpInfo();
        return localVarResp.getData();
    }

    public ApiResponse<ResourceOptionsDto> filterResourceOptionsWithHttpInfo() throws ApiException {
        Call localVarCall = this.filterResourceOptionsValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<ResourceOptionsDto>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call filterResourceOptionsAsync(ApiCallback<ResourceOptionsDto> _callback) throws ApiException {
        Call localVarCall = this.filterResourceOptionsValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<ResourceOptionsDto>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call filterResourceOptionsSingleCall(String id, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/filter/{id}".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "OPTIONS", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call filterResourceOptionsSingleValidateBeforeCall(String id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling filterResourceOptionsSingle(Async)");
        }
        Call localVarCall = this.filterResourceOptionsSingleCall(id, _callback);
        return localVarCall;
    }

    public ResourceOptionsDto filterResourceOptionsSingle(String id) throws ApiException {
        ApiResponse<ResourceOptionsDto> localVarResp = this.filterResourceOptionsSingleWithHttpInfo(id);
        return localVarResp.getData();
    }

    public ApiResponse<ResourceOptionsDto> filterResourceOptionsSingleWithHttpInfo(String id) throws ApiException {
        Call localVarCall = this.filterResourceOptionsSingleValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<ResourceOptionsDto>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call filterResourceOptionsSingleAsync(String id, ApiCallback<ResourceOptionsDto> _callback) throws ApiException {
        Call localVarCall = this.filterResourceOptionsSingleValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<ResourceOptionsDto>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getFilterCountCall(String filterId, String resourceType, String name, String nameLike, String owner, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/filter/count";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (filterId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("filterId", filterId));
        }
        if (resourceType != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceType", resourceType));
        }
        if (name != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("name", name));
        }
        if (nameLike != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("nameLike", nameLike));
        }
        if (owner != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("owner", owner));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getFilterCountValidateBeforeCall(String filterId, String resourceType, String name, String nameLike, String owner, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getFilterCountCall(filterId, resourceType, name, nameLike, owner, _callback);
        return localVarCall;
    }

    public CountResultDto getFilterCount(String filterId, String resourceType, String name, String nameLike, String owner) throws ApiException {
        ApiResponse<CountResultDto> localVarResp = this.getFilterCountWithHttpInfo(filterId, resourceType, name, nameLike, owner);
        return localVarResp.getData();
    }

    public ApiResponse<CountResultDto> getFilterCountWithHttpInfo(String filterId, String resourceType, String name, String nameLike, String owner) throws ApiException {
        Call localVarCall = this.getFilterCountValidateBeforeCall(filterId, resourceType, name, nameLike, owner, null);
        Type localVarReturnType = new TypeToken<CountResultDto>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getFilterCountAsync(String filterId, String resourceType, String name, String nameLike, String owner, ApiCallback<CountResultDto> _callback) throws ApiException {
        Call localVarCall = this.getFilterCountValidateBeforeCall(filterId, resourceType, name, nameLike, owner, _callback);
        Type localVarReturnType = new TypeToken<CountResultDto>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getFilterListCall(String filterId, String resourceType, String name, String nameLike, String owner, Boolean itemCount, String sortBy, String sortOrder, Integer firstResult, Integer maxResults, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/filter";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (filterId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("filterId", filterId));
        }
        if (resourceType != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceType", resourceType));
        }
        if (name != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("name", name));
        }
        if (nameLike != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("nameLike", nameLike));
        }
        if (owner != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("owner", owner));
        }
        if (itemCount != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("itemCount", itemCount));
        }
        if (sortBy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sortBy", sortBy));
        }
        if (sortOrder != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sortOrder", sortOrder));
        }
        if (firstResult != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("firstResult", firstResult));
        }
        if (maxResults != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("maxResults", maxResults));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getFilterListValidateBeforeCall(String filterId, String resourceType, String name, String nameLike, String owner, Boolean itemCount, String sortBy, String sortOrder, Integer firstResult, Integer maxResults, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getFilterListCall(filterId, resourceType, name, nameLike, owner, itemCount, sortBy, sortOrder, firstResult, maxResults, _callback);
        return localVarCall;
    }

    public List<FilterDto> getFilterList(String filterId, String resourceType, String name, String nameLike, String owner, Boolean itemCount, String sortBy, String sortOrder, Integer firstResult, Integer maxResults) throws ApiException {
        ApiResponse<List<FilterDto>> localVarResp = this.getFilterListWithHttpInfo(filterId, resourceType, name, nameLike, owner, itemCount, sortBy, sortOrder, firstResult, maxResults);
        return localVarResp.getData();
    }

    public ApiResponse<List<FilterDto>> getFilterListWithHttpInfo(String filterId, String resourceType, String name, String nameLike, String owner, Boolean itemCount, String sortBy, String sortOrder, Integer firstResult, Integer maxResults) throws ApiException {
        Call localVarCall = this.getFilterListValidateBeforeCall(filterId, resourceType, name, nameLike, owner, itemCount, sortBy, sortOrder, firstResult, maxResults, null);
        Type localVarReturnType = new TypeToken<List<FilterDto>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getFilterListAsync(String filterId, String resourceType, String name, String nameLike, String owner, Boolean itemCount, String sortBy, String sortOrder, Integer firstResult, Integer maxResults, ApiCallback<List<FilterDto>> _callback) throws ApiException {
        Call localVarCall = this.getFilterListValidateBeforeCall(filterId, resourceType, name, nameLike, owner, itemCount, sortBy, sortOrder, firstResult, maxResults, _callback);
        Type localVarReturnType = new TypeToken<List<FilterDto>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getSingleFilterCall(String id, Boolean itemCount, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/filter/{id}".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (itemCount != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("itemCount", itemCount));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getSingleFilterValidateBeforeCall(String id, Boolean itemCount, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getSingleFilter(Async)");
        }
        Call localVarCall = this.getSingleFilterCall(id, itemCount, _callback);
        return localVarCall;
    }

    public FilterDto getSingleFilter(String id, Boolean itemCount) throws ApiException {
        ApiResponse<FilterDto> localVarResp = this.getSingleFilterWithHttpInfo(id, itemCount);
        return localVarResp.getData();
    }

    public ApiResponse<FilterDto> getSingleFilterWithHttpInfo(String id, Boolean itemCount) throws ApiException {
        Call localVarCall = this.getSingleFilterValidateBeforeCall(id, itemCount, null);
        Type localVarReturnType = new TypeToken<FilterDto>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getSingleFilterAsync(String id, Boolean itemCount, ApiCallback<FilterDto> _callback) throws ApiException {
        Call localVarCall = this.getSingleFilterValidateBeforeCall(id, itemCount, _callback);
        Type localVarReturnType = new TypeToken<FilterDto>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call postExecuteFilterCountCall(String id, Object body, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = body;
        String localVarPath = "/filter/{id}/count".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call postExecuteFilterCountValidateBeforeCall(String id, Object body, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling postExecuteFilterCount(Async)");
        }
        Call localVarCall = this.postExecuteFilterCountCall(id, body, _callback);
        return localVarCall;
    }

    public CountResultDto postExecuteFilterCount(String id, Object body) throws ApiException {
        ApiResponse<CountResultDto> localVarResp = this.postExecuteFilterCountWithHttpInfo(id, body);
        return localVarResp.getData();
    }

    public ApiResponse<CountResultDto> postExecuteFilterCountWithHttpInfo(String id, Object body) throws ApiException {
        Call localVarCall = this.postExecuteFilterCountValidateBeforeCall(id, body, null);
        Type localVarReturnType = new TypeToken<CountResultDto>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call postExecuteFilterCountAsync(String id, Object body, ApiCallback<CountResultDto> _callback) throws ApiException {
        Call localVarCall = this.postExecuteFilterCountValidateBeforeCall(id, body, _callback);
        Type localVarReturnType = new TypeToken<CountResultDto>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call postExecuteFilterListCall(String id, Integer firstResult, Integer maxResults, Object body, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = body;
        String localVarPath = "/filter/{id}/list".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (firstResult != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("firstResult", firstResult));
        }
        if (maxResults != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("maxResults", maxResults));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call postExecuteFilterListValidateBeforeCall(String id, Integer firstResult, Integer maxResults, Object body, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling postExecuteFilterList(Async)");
        }
        Call localVarCall = this.postExecuteFilterListCall(id, firstResult, maxResults, body, _callback);
        return localVarCall;
    }

    public List<Object> postExecuteFilterList(String id, Integer firstResult, Integer maxResults, Object body) throws ApiException {
        ApiResponse<List<Object>> localVarResp = this.postExecuteFilterListWithHttpInfo(id, firstResult, maxResults, body);
        return localVarResp.getData();
    }

    public ApiResponse<List<Object>> postExecuteFilterListWithHttpInfo(String id, Integer firstResult, Integer maxResults, Object body) throws ApiException {
        Call localVarCall = this.postExecuteFilterListValidateBeforeCall(id, firstResult, maxResults, body, null);
        Type localVarReturnType = new TypeToken<List<Object>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call postExecuteFilterListAsync(String id, Integer firstResult, Integer maxResults, Object body, ApiCallback<List<Object>> _callback) throws ApiException {
        Call localVarCall = this.postExecuteFilterListValidateBeforeCall(id, firstResult, maxResults, body, _callback);
        Type localVarReturnType = new TypeToken<List<Object>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call postExecuteFilterSingleResultCall(String id, Object body, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = body;
        String localVarPath = "/filter/{id}/singleResult".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call postExecuteFilterSingleResultValidateBeforeCall(String id, Object body, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling postExecuteFilterSingleResult(Async)");
        }
        Call localVarCall = this.postExecuteFilterSingleResultCall(id, body, _callback);
        return localVarCall;
    }

    public Object postExecuteFilterSingleResult(String id, Object body) throws ApiException {
        ApiResponse<Object> localVarResp = this.postExecuteFilterSingleResultWithHttpInfo(id, body);
        return localVarResp.getData();
    }

    public ApiResponse<Object> postExecuteFilterSingleResultWithHttpInfo(String id, Object body) throws ApiException {
        Call localVarCall = this.postExecuteFilterSingleResultValidateBeforeCall(id, body, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call postExecuteFilterSingleResultAsync(String id, Object body, ApiCallback<Object> _callback) throws ApiException {
        Call localVarCall = this.postExecuteFilterSingleResultValidateBeforeCall(id, body, _callback);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateFilterCall(String id, CreateFilterDto createFilterDto, ApiCallback _callback) throws ApiException {
        CreateFilterDto localVarPostBody = createFilterDto;
        String localVarPath = "/filter/{id}".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateFilterValidateBeforeCall(String id, CreateFilterDto createFilterDto, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling updateFilter(Async)");
        }
        Call localVarCall = this.updateFilterCall(id, createFilterDto, _callback);
        return localVarCall;
    }

    public void updateFilter(String id, CreateFilterDto createFilterDto) throws ApiException {
        this.updateFilterWithHttpInfo(id, createFilterDto);
    }

    public ApiResponse<Void> updateFilterWithHttpInfo(String id, CreateFilterDto createFilterDto) throws ApiException {
        Call localVarCall = this.updateFilterValidateBeforeCall(id, createFilterDto, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call updateFilterAsync(String id, CreateFilterDto createFilterDto, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.updateFilterValidateBeforeCall(id, createFilterDto, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
}

