/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.rest.client.api;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;
import org.camunda.community.rest.client.dto.BatchDto;
import org.camunda.community.rest.client.dto.BatchStatisticsDto;
import org.camunda.community.rest.client.dto.CountResultDto;
import org.camunda.community.rest.client.dto.SuspensionStateDto;
import org.camunda.community.rest.client.invoker.ApiCallback;
import org.camunda.community.rest.client.invoker.ApiClient;
import org.camunda.community.rest.client.invoker.ApiException;
import org.camunda.community.rest.client.invoker.ApiResponse;
import org.camunda.community.rest.client.invoker.Configuration;
import org.camunda.community.rest.client.invoker.Pair;

public class BatchApi {
    private ApiClient localVarApiClient;

    public BatchApi() {
        this(Configuration.getDefaultApiClient());
    }

    public BatchApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public Call deleteBatchCall(String id, Boolean cascade, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/batch/{id}".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (cascade != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("cascade", cascade));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteBatchValidateBeforeCall(String id, Boolean cascade, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling deleteBatch(Async)");
        }
        Call localVarCall = this.deleteBatchCall(id, cascade, _callback);
        return localVarCall;
    }

    public void deleteBatch(String id, Boolean cascade) throws ApiException {
        this.deleteBatchWithHttpInfo(id, cascade);
    }

    public ApiResponse<Void> deleteBatchWithHttpInfo(String id, Boolean cascade) throws ApiException {
        Call localVarCall = this.deleteBatchValidateBeforeCall(id, cascade, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteBatchAsync(String id, Boolean cascade, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteBatchValidateBeforeCall(id, cascade, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call getBatchCall(String id, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/batch/{id}".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getBatchValidateBeforeCall(String id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getBatch(Async)");
        }
        Call localVarCall = this.getBatchCall(id, _callback);
        return localVarCall;
    }

    public BatchDto getBatch(String id) throws ApiException {
        ApiResponse<BatchDto> localVarResp = this.getBatchWithHttpInfo(id);
        return localVarResp.getData();
    }

    public ApiResponse<BatchDto> getBatchWithHttpInfo(String id) throws ApiException {
        Call localVarCall = this.getBatchValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<BatchDto>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getBatchAsync(String id, ApiCallback<BatchDto> _callback) throws ApiException {
        Call localVarCall = this.getBatchValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<BatchDto>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getBatchStatisticsCall(String sortBy, String sortOrder, Integer firstResult, Integer maxResults, String batchId, String type, String tenantIdIn, Boolean withoutTenantId, Boolean suspended, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/batch/statistics";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (sortBy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sortBy", sortBy));
        }
        if (sortOrder != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sortOrder", sortOrder));
        }
        if (firstResult != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("firstResult", firstResult));
        }
        if (maxResults != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("maxResults", maxResults));
        }
        if (batchId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("batchId", batchId));
        }
        if (type != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("type", type));
        }
        if (tenantIdIn != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("tenantIdIn", tenantIdIn));
        }
        if (withoutTenantId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("withoutTenantId", withoutTenantId));
        }
        if (suspended != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("suspended", suspended));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getBatchStatisticsValidateBeforeCall(String sortBy, String sortOrder, Integer firstResult, Integer maxResults, String batchId, String type, String tenantIdIn, Boolean withoutTenantId, Boolean suspended, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getBatchStatisticsCall(sortBy, sortOrder, firstResult, maxResults, batchId, type, tenantIdIn, withoutTenantId, suspended, _callback);
        return localVarCall;
    }

    public List<BatchStatisticsDto> getBatchStatistics(String sortBy, String sortOrder, Integer firstResult, Integer maxResults, String batchId, String type, String tenantIdIn, Boolean withoutTenantId, Boolean suspended) throws ApiException {
        ApiResponse<List<BatchStatisticsDto>> localVarResp = this.getBatchStatisticsWithHttpInfo(sortBy, sortOrder, firstResult, maxResults, batchId, type, tenantIdIn, withoutTenantId, suspended);
        return localVarResp.getData();
    }

    public ApiResponse<List<BatchStatisticsDto>> getBatchStatisticsWithHttpInfo(String sortBy, String sortOrder, Integer firstResult, Integer maxResults, String batchId, String type, String tenantIdIn, Boolean withoutTenantId, Boolean suspended) throws ApiException {
        Call localVarCall = this.getBatchStatisticsValidateBeforeCall(sortBy, sortOrder, firstResult, maxResults, batchId, type, tenantIdIn, withoutTenantId, suspended, null);
        Type localVarReturnType = new TypeToken<List<BatchStatisticsDto>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getBatchStatisticsAsync(String sortBy, String sortOrder, Integer firstResult, Integer maxResults, String batchId, String type, String tenantIdIn, Boolean withoutTenantId, Boolean suspended, ApiCallback<List<BatchStatisticsDto>> _callback) throws ApiException {
        Call localVarCall = this.getBatchStatisticsValidateBeforeCall(sortBy, sortOrder, firstResult, maxResults, batchId, type, tenantIdIn, withoutTenantId, suspended, _callback);
        Type localVarReturnType = new TypeToken<List<BatchStatisticsDto>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getBatchStatisticsCountCall(String batchId, String type, String tenantIdIn, Boolean withoutTenantId, Boolean suspended, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/batch/statistics/count";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (batchId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("batchId", batchId));
        }
        if (type != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("type", type));
        }
        if (tenantIdIn != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("tenantIdIn", tenantIdIn));
        }
        if (withoutTenantId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("withoutTenantId", withoutTenantId));
        }
        if (suspended != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("suspended", suspended));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getBatchStatisticsCountValidateBeforeCall(String batchId, String type, String tenantIdIn, Boolean withoutTenantId, Boolean suspended, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getBatchStatisticsCountCall(batchId, type, tenantIdIn, withoutTenantId, suspended, _callback);
        return localVarCall;
    }

    public CountResultDto getBatchStatisticsCount(String batchId, String type, String tenantIdIn, Boolean withoutTenantId, Boolean suspended) throws ApiException {
        ApiResponse<CountResultDto> localVarResp = this.getBatchStatisticsCountWithHttpInfo(batchId, type, tenantIdIn, withoutTenantId, suspended);
        return localVarResp.getData();
    }

    public ApiResponse<CountResultDto> getBatchStatisticsCountWithHttpInfo(String batchId, String type, String tenantIdIn, Boolean withoutTenantId, Boolean suspended) throws ApiException {
        Call localVarCall = this.getBatchStatisticsCountValidateBeforeCall(batchId, type, tenantIdIn, withoutTenantId, suspended, null);
        Type localVarReturnType = new TypeToken<CountResultDto>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getBatchStatisticsCountAsync(String batchId, String type, String tenantIdIn, Boolean withoutTenantId, Boolean suspended, ApiCallback<CountResultDto> _callback) throws ApiException {
        Call localVarCall = this.getBatchStatisticsCountValidateBeforeCall(batchId, type, tenantIdIn, withoutTenantId, suspended, _callback);
        Type localVarReturnType = new TypeToken<CountResultDto>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getBatchesCall(String sortBy, String sortOrder, Integer firstResult, Integer maxResults, String batchId, String type, String tenantIdIn, Boolean withoutTenantId, Boolean suspended, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/batch";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (sortBy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sortBy", sortBy));
        }
        if (sortOrder != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sortOrder", sortOrder));
        }
        if (firstResult != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("firstResult", firstResult));
        }
        if (maxResults != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("maxResults", maxResults));
        }
        if (batchId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("batchId", batchId));
        }
        if (type != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("type", type));
        }
        if (tenantIdIn != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("tenantIdIn", tenantIdIn));
        }
        if (withoutTenantId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("withoutTenantId", withoutTenantId));
        }
        if (suspended != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("suspended", suspended));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getBatchesValidateBeforeCall(String sortBy, String sortOrder, Integer firstResult, Integer maxResults, String batchId, String type, String tenantIdIn, Boolean withoutTenantId, Boolean suspended, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getBatchesCall(sortBy, sortOrder, firstResult, maxResults, batchId, type, tenantIdIn, withoutTenantId, suspended, _callback);
        return localVarCall;
    }

    public List<BatchDto> getBatches(String sortBy, String sortOrder, Integer firstResult, Integer maxResults, String batchId, String type, String tenantIdIn, Boolean withoutTenantId, Boolean suspended) throws ApiException {
        ApiResponse<List<BatchDto>> localVarResp = this.getBatchesWithHttpInfo(sortBy, sortOrder, firstResult, maxResults, batchId, type, tenantIdIn, withoutTenantId, suspended);
        return localVarResp.getData();
    }

    public ApiResponse<List<BatchDto>> getBatchesWithHttpInfo(String sortBy, String sortOrder, Integer firstResult, Integer maxResults, String batchId, String type, String tenantIdIn, Boolean withoutTenantId, Boolean suspended) throws ApiException {
        Call localVarCall = this.getBatchesValidateBeforeCall(sortBy, sortOrder, firstResult, maxResults, batchId, type, tenantIdIn, withoutTenantId, suspended, null);
        Type localVarReturnType = new TypeToken<List<BatchDto>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getBatchesAsync(String sortBy, String sortOrder, Integer firstResult, Integer maxResults, String batchId, String type, String tenantIdIn, Boolean withoutTenantId, Boolean suspended, ApiCallback<List<BatchDto>> _callback) throws ApiException {
        Call localVarCall = this.getBatchesValidateBeforeCall(sortBy, sortOrder, firstResult, maxResults, batchId, type, tenantIdIn, withoutTenantId, suspended, _callback);
        Type localVarReturnType = new TypeToken<List<BatchDto>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getBatchesCountCall(String batchId, String type, String tenantIdIn, Boolean withoutTenantId, Boolean suspended, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/batch/count";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (batchId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("batchId", batchId));
        }
        if (type != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("type", type));
        }
        if (tenantIdIn != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("tenantIdIn", tenantIdIn));
        }
        if (withoutTenantId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("withoutTenantId", withoutTenantId));
        }
        if (suspended != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("suspended", suspended));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getBatchesCountValidateBeforeCall(String batchId, String type, String tenantIdIn, Boolean withoutTenantId, Boolean suspended, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getBatchesCountCall(batchId, type, tenantIdIn, withoutTenantId, suspended, _callback);
        return localVarCall;
    }

    public CountResultDto getBatchesCount(String batchId, String type, String tenantIdIn, Boolean withoutTenantId, Boolean suspended) throws ApiException {
        ApiResponse<CountResultDto> localVarResp = this.getBatchesCountWithHttpInfo(batchId, type, tenantIdIn, withoutTenantId, suspended);
        return localVarResp.getData();
    }

    public ApiResponse<CountResultDto> getBatchesCountWithHttpInfo(String batchId, String type, String tenantIdIn, Boolean withoutTenantId, Boolean suspended) throws ApiException {
        Call localVarCall = this.getBatchesCountValidateBeforeCall(batchId, type, tenantIdIn, withoutTenantId, suspended, null);
        Type localVarReturnType = new TypeToken<CountResultDto>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getBatchesCountAsync(String batchId, String type, String tenantIdIn, Boolean withoutTenantId, Boolean suspended, ApiCallback<CountResultDto> _callback) throws ApiException {
        Call localVarCall = this.getBatchesCountValidateBeforeCall(batchId, type, tenantIdIn, withoutTenantId, suspended, _callback);
        Type localVarReturnType = new TypeToken<CountResultDto>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateBatchSuspensionStateCall(String id, SuspensionStateDto suspensionStateDto, ApiCallback _callback) throws ApiException {
        SuspensionStateDto localVarPostBody = suspensionStateDto;
        String localVarPath = "/batch/{id}/suspended".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateBatchSuspensionStateValidateBeforeCall(String id, SuspensionStateDto suspensionStateDto, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling updateBatchSuspensionState(Async)");
        }
        Call localVarCall = this.updateBatchSuspensionStateCall(id, suspensionStateDto, _callback);
        return localVarCall;
    }

    public void updateBatchSuspensionState(String id, SuspensionStateDto suspensionStateDto) throws ApiException {
        this.updateBatchSuspensionStateWithHttpInfo(id, suspensionStateDto);
    }

    public ApiResponse<Void> updateBatchSuspensionStateWithHttpInfo(String id, SuspensionStateDto suspensionStateDto) throws ApiException {
        Call localVarCall = this.updateBatchSuspensionStateValidateBeforeCall(id, suspensionStateDto, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call updateBatchSuspensionStateAsync(String id, SuspensionStateDto suspensionStateDto, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.updateBatchSuspensionStateValidateBeforeCall(id, suspensionStateDto, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
}

