/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.17.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.camunda.community.rest.client.dto;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.camunda.community.rest.client.dto.HistoricProcessInstanceQueryDtoSorting;
import org.camunda.community.rest.client.dto.VariableQueryParameterDto;

/**
 * A historic process instance query which defines a group of historic process instances
 */
@ApiModel(description = "A historic process instance query which defines a group of historic process instances")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-07-15T09:20:26.494044Z[Etc/UTC]")
public class HistoricProcessInstanceQueryDto {
  public static final String SERIALIZED_NAME_PROCESS_INSTANCE_ID = "processInstanceId";
  @SerializedName(SERIALIZED_NAME_PROCESS_INSTANCE_ID)
  private String processInstanceId;

  public static final String SERIALIZED_NAME_PROCESS_INSTANCE_IDS = "processInstanceIds";
  @SerializedName(SERIALIZED_NAME_PROCESS_INSTANCE_IDS)
  private List<String> processInstanceIds = null;

  public static final String SERIALIZED_NAME_PROCESS_DEFINITION_ID = "processDefinitionId";
  @SerializedName(SERIALIZED_NAME_PROCESS_DEFINITION_ID)
  private String processDefinitionId;

  public static final String SERIALIZED_NAME_PROCESS_DEFINITION_KEY = "processDefinitionKey";
  @SerializedName(SERIALIZED_NAME_PROCESS_DEFINITION_KEY)
  private String processDefinitionKey;

  public static final String SERIALIZED_NAME_PROCESS_DEFINITION_KEY_IN = "processDefinitionKeyIn";
  @SerializedName(SERIALIZED_NAME_PROCESS_DEFINITION_KEY_IN)
  private List<String> processDefinitionKeyIn = null;

  public static final String SERIALIZED_NAME_PROCESS_DEFINITION_NAME = "processDefinitionName";
  @SerializedName(SERIALIZED_NAME_PROCESS_DEFINITION_NAME)
  private String processDefinitionName;

  public static final String SERIALIZED_NAME_PROCESS_DEFINITION_NAME_LIKE = "processDefinitionNameLike";
  @SerializedName(SERIALIZED_NAME_PROCESS_DEFINITION_NAME_LIKE)
  private String processDefinitionNameLike;

  public static final String SERIALIZED_NAME_PROCESS_DEFINITION_KEY_NOT_IN = "processDefinitionKeyNotIn";
  @SerializedName(SERIALIZED_NAME_PROCESS_DEFINITION_KEY_NOT_IN)
  private List<String> processDefinitionKeyNotIn = null;

  public static final String SERIALIZED_NAME_PROCESS_INSTANCE_BUSINESS_KEY = "processInstanceBusinessKey";
  @SerializedName(SERIALIZED_NAME_PROCESS_INSTANCE_BUSINESS_KEY)
  private String processInstanceBusinessKey;

  public static final String SERIALIZED_NAME_PROCESS_INSTANCE_BUSINESS_KEY_IN = "processInstanceBusinessKeyIn";
  @SerializedName(SERIALIZED_NAME_PROCESS_INSTANCE_BUSINESS_KEY_IN)
  private List<String> processInstanceBusinessKeyIn = null;

  public static final String SERIALIZED_NAME_PROCESS_INSTANCE_BUSINESS_KEY_LIKE = "processInstanceBusinessKeyLike";
  @SerializedName(SERIALIZED_NAME_PROCESS_INSTANCE_BUSINESS_KEY_LIKE)
  private String processInstanceBusinessKeyLike;

  public static final String SERIALIZED_NAME_ROOT_PROCESS_INSTANCES = "rootProcessInstances";
  @SerializedName(SERIALIZED_NAME_ROOT_PROCESS_INSTANCES)
  private Boolean rootProcessInstances;

  public static final String SERIALIZED_NAME_FINISHED = "finished";
  @SerializedName(SERIALIZED_NAME_FINISHED)
  private Boolean finished;

  public static final String SERIALIZED_NAME_UNFINISHED = "unfinished";
  @SerializedName(SERIALIZED_NAME_UNFINISHED)
  private Boolean unfinished;

  public static final String SERIALIZED_NAME_WITH_INCIDENTS = "withIncidents";
  @SerializedName(SERIALIZED_NAME_WITH_INCIDENTS)
  private Boolean withIncidents;

  public static final String SERIALIZED_NAME_WITH_ROOT_INCIDENTS = "withRootIncidents";
  @SerializedName(SERIALIZED_NAME_WITH_ROOT_INCIDENTS)
  private Boolean withRootIncidents;

  public static final String SERIALIZED_NAME_INCIDENT_TYPE = "incidentType";
  @SerializedName(SERIALIZED_NAME_INCIDENT_TYPE)
  private String incidentType;

  /**
   * Only include process instances which have an incident in status either open or resolved. To get all process instances, use the query parameter withIncidents.
   */
  @JsonAdapter(IncidentStatusEnum.Adapter.class)
  public enum IncidentStatusEnum {
    OPEN("open"),
    
    RESOLVED("resolved");

    private String value;

    IncidentStatusEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static IncidentStatusEnum fromValue(String value) {
      for (IncidentStatusEnum b : IncidentStatusEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      return null;
    }

    public static class Adapter extends TypeAdapter<IncidentStatusEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final IncidentStatusEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public IncidentStatusEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return IncidentStatusEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_INCIDENT_STATUS = "incidentStatus";
  @SerializedName(SERIALIZED_NAME_INCIDENT_STATUS)
  private IncidentStatusEnum incidentStatus;

  public static final String SERIALIZED_NAME_INCIDENT_MESSAGE = "incidentMessage";
  @SerializedName(SERIALIZED_NAME_INCIDENT_MESSAGE)
  private String incidentMessage;

  public static final String SERIALIZED_NAME_INCIDENT_MESSAGE_LIKE = "incidentMessageLike";
  @SerializedName(SERIALIZED_NAME_INCIDENT_MESSAGE_LIKE)
  private String incidentMessageLike;

  public static final String SERIALIZED_NAME_STARTED_BEFORE = "startedBefore";
  @SerializedName(SERIALIZED_NAME_STARTED_BEFORE)
  private Date startedBefore;

  public static final String SERIALIZED_NAME_STARTED_AFTER = "startedAfter";
  @SerializedName(SERIALIZED_NAME_STARTED_AFTER)
  private Date startedAfter;

  public static final String SERIALIZED_NAME_FINISHED_BEFORE = "finishedBefore";
  @SerializedName(SERIALIZED_NAME_FINISHED_BEFORE)
  private Date finishedBefore;

  public static final String SERIALIZED_NAME_FINISHED_AFTER = "finishedAfter";
  @SerializedName(SERIALIZED_NAME_FINISHED_AFTER)
  private Date finishedAfter;

  public static final String SERIALIZED_NAME_EXECUTED_ACTIVITY_AFTER = "executedActivityAfter";
  @SerializedName(SERIALIZED_NAME_EXECUTED_ACTIVITY_AFTER)
  private Date executedActivityAfter;

  public static final String SERIALIZED_NAME_EXECUTED_ACTIVITY_BEFORE = "executedActivityBefore";
  @SerializedName(SERIALIZED_NAME_EXECUTED_ACTIVITY_BEFORE)
  private Date executedActivityBefore;

  public static final String SERIALIZED_NAME_EXECUTED_JOB_AFTER = "executedJobAfter";
  @SerializedName(SERIALIZED_NAME_EXECUTED_JOB_AFTER)
  private Date executedJobAfter;

  public static final String SERIALIZED_NAME_EXECUTED_JOB_BEFORE = "executedJobBefore";
  @SerializedName(SERIALIZED_NAME_EXECUTED_JOB_BEFORE)
  private Date executedJobBefore;

  public static final String SERIALIZED_NAME_STARTED_BY = "startedBy";
  @SerializedName(SERIALIZED_NAME_STARTED_BY)
  private String startedBy;

  public static final String SERIALIZED_NAME_SUPER_PROCESS_INSTANCE_ID = "superProcessInstanceId";
  @SerializedName(SERIALIZED_NAME_SUPER_PROCESS_INSTANCE_ID)
  private String superProcessInstanceId;

  public static final String SERIALIZED_NAME_SUB_PROCESS_INSTANCE_ID = "subProcessInstanceId";
  @SerializedName(SERIALIZED_NAME_SUB_PROCESS_INSTANCE_ID)
  private String subProcessInstanceId;

  public static final String SERIALIZED_NAME_SUPER_CASE_INSTANCE_ID = "superCaseInstanceId";
  @SerializedName(SERIALIZED_NAME_SUPER_CASE_INSTANCE_ID)
  private String superCaseInstanceId;

  public static final String SERIALIZED_NAME_SUB_CASE_INSTANCE_ID = "subCaseInstanceId";
  @SerializedName(SERIALIZED_NAME_SUB_CASE_INSTANCE_ID)
  private String subCaseInstanceId;

  public static final String SERIALIZED_NAME_CASE_INSTANCE_ID = "caseInstanceId";
  @SerializedName(SERIALIZED_NAME_CASE_INSTANCE_ID)
  private String caseInstanceId;

  public static final String SERIALIZED_NAME_TENANT_ID_IN = "tenantIdIn";
  @SerializedName(SERIALIZED_NAME_TENANT_ID_IN)
  private List<String> tenantIdIn = null;

  public static final String SERIALIZED_NAME_WITHOUT_TENANT_ID = "withoutTenantId";
  @SerializedName(SERIALIZED_NAME_WITHOUT_TENANT_ID)
  private Boolean withoutTenantId;

  public static final String SERIALIZED_NAME_EXECUTED_ACTIVITY_ID_IN = "executedActivityIdIn";
  @SerializedName(SERIALIZED_NAME_EXECUTED_ACTIVITY_ID_IN)
  private List<String> executedActivityIdIn = null;

  public static final String SERIALIZED_NAME_ACTIVE_ACTIVITY_ID_IN = "activeActivityIdIn";
  @SerializedName(SERIALIZED_NAME_ACTIVE_ACTIVITY_ID_IN)
  private List<String> activeActivityIdIn = null;

  public static final String SERIALIZED_NAME_ACTIVE = "active";
  @SerializedName(SERIALIZED_NAME_ACTIVE)
  private Boolean active;

  public static final String SERIALIZED_NAME_SUSPENDED = "suspended";
  @SerializedName(SERIALIZED_NAME_SUSPENDED)
  private Boolean suspended;

  public static final String SERIALIZED_NAME_COMPLETED = "completed";
  @SerializedName(SERIALIZED_NAME_COMPLETED)
  private Boolean completed;

  public static final String SERIALIZED_NAME_EXTERNALLY_TERMINATED = "externallyTerminated";
  @SerializedName(SERIALIZED_NAME_EXTERNALLY_TERMINATED)
  private Boolean externallyTerminated;

  public static final String SERIALIZED_NAME_INTERNALLY_TERMINATED = "internallyTerminated";
  @SerializedName(SERIALIZED_NAME_INTERNALLY_TERMINATED)
  private Boolean internallyTerminated;

  public static final String SERIALIZED_NAME_VARIABLES = "variables";
  @SerializedName(SERIALIZED_NAME_VARIABLES)
  private List<VariableQueryParameterDto> variables = null;

  public static final String SERIALIZED_NAME_VARIABLE_NAMES_IGNORE_CASE = "variableNamesIgnoreCase";
  @SerializedName(SERIALIZED_NAME_VARIABLE_NAMES_IGNORE_CASE)
  private Boolean variableNamesIgnoreCase;

  public static final String SERIALIZED_NAME_VARIABLE_VALUES_IGNORE_CASE = "variableValuesIgnoreCase";
  @SerializedName(SERIALIZED_NAME_VARIABLE_VALUES_IGNORE_CASE)
  private Boolean variableValuesIgnoreCase;

  public static final String SERIALIZED_NAME_OR_QUERIES = "orQueries";
  @SerializedName(SERIALIZED_NAME_OR_QUERIES)
  private List<HistoricProcessInstanceQueryDto> orQueries = null;

  public static final String SERIALIZED_NAME_SORTING = "sorting";
  @SerializedName(SERIALIZED_NAME_SORTING)
  private List<HistoricProcessInstanceQueryDtoSorting> sorting = null;


  public HistoricProcessInstanceQueryDto processInstanceId(String processInstanceId) {
    
    this.processInstanceId = processInstanceId;
    return this;
  }

   /**
   * Filter by process instance id.
   * @return processInstanceId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Filter by process instance id.")

  public String getProcessInstanceId() {
    return processInstanceId;
  }


  public void setProcessInstanceId(String processInstanceId) {
    this.processInstanceId = processInstanceId;
  }


  public HistoricProcessInstanceQueryDto processInstanceIds(List<String> processInstanceIds) {
    
    this.processInstanceIds = processInstanceIds;
    return this;
  }

  public HistoricProcessInstanceQueryDto addProcessInstanceIdsItem(String processInstanceIdsItem) {
    if (this.processInstanceIds == null) {
      this.processInstanceIds = new ArrayList<String>();
    }
    this.processInstanceIds.add(processInstanceIdsItem);
    return this;
  }

   /**
   * Filter by process instance ids. Must be a JSON array of &#x60;Strings&#x60;.
   * @return processInstanceIds
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Filter by process instance ids. Must be a JSON array of `Strings`.")

  public List<String> getProcessInstanceIds() {
    return processInstanceIds;
  }


  public void setProcessInstanceIds(List<String> processInstanceIds) {
    this.processInstanceIds = processInstanceIds;
  }


  public HistoricProcessInstanceQueryDto processDefinitionId(String processDefinitionId) {
    
    this.processDefinitionId = processDefinitionId;
    return this;
  }

   /**
   * Filter by the process definition the instances run on.
   * @return processDefinitionId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Filter by the process definition the instances run on.")

  public String getProcessDefinitionId() {
    return processDefinitionId;
  }


  public void setProcessDefinitionId(String processDefinitionId) {
    this.processDefinitionId = processDefinitionId;
  }


  public HistoricProcessInstanceQueryDto processDefinitionKey(String processDefinitionKey) {
    
    this.processDefinitionKey = processDefinitionKey;
    return this;
  }

   /**
   * Filter by the key of the process definition the instances run on.
   * @return processDefinitionKey
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Filter by the key of the process definition the instances run on.")

  public String getProcessDefinitionKey() {
    return processDefinitionKey;
  }


  public void setProcessDefinitionKey(String processDefinitionKey) {
    this.processDefinitionKey = processDefinitionKey;
  }


  public HistoricProcessInstanceQueryDto processDefinitionKeyIn(List<String> processDefinitionKeyIn) {
    
    this.processDefinitionKeyIn = processDefinitionKeyIn;
    return this;
  }

  public HistoricProcessInstanceQueryDto addProcessDefinitionKeyInItem(String processDefinitionKeyInItem) {
    if (this.processDefinitionKeyIn == null) {
      this.processDefinitionKeyIn = new ArrayList<String>();
    }
    this.processDefinitionKeyIn.add(processDefinitionKeyInItem);
    return this;
  }

   /**
   * Filter by a list of process definition keys. A process instance must have one of the given process definition keys. Must be a JSON array of &#x60;Strings&#x60;.
   * @return processDefinitionKeyIn
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Filter by a list of process definition keys. A process instance must have one of the given process definition keys. Must be a JSON array of `Strings`.")

  public List<String> getProcessDefinitionKeyIn() {
    return processDefinitionKeyIn;
  }


  public void setProcessDefinitionKeyIn(List<String> processDefinitionKeyIn) {
    this.processDefinitionKeyIn = processDefinitionKeyIn;
  }


  public HistoricProcessInstanceQueryDto processDefinitionName(String processDefinitionName) {
    
    this.processDefinitionName = processDefinitionName;
    return this;
  }

   /**
   * Filter by the name of the process definition the instances run on.
   * @return processDefinitionName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Filter by the name of the process definition the instances run on.")

  public String getProcessDefinitionName() {
    return processDefinitionName;
  }


  public void setProcessDefinitionName(String processDefinitionName) {
    this.processDefinitionName = processDefinitionName;
  }


  public HistoricProcessInstanceQueryDto processDefinitionNameLike(String processDefinitionNameLike) {
    
    this.processDefinitionNameLike = processDefinitionNameLike;
    return this;
  }

   /**
   * Filter by process definition names that the parameter is a substring of.
   * @return processDefinitionNameLike
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Filter by process definition names that the parameter is a substring of.")

  public String getProcessDefinitionNameLike() {
    return processDefinitionNameLike;
  }


  public void setProcessDefinitionNameLike(String processDefinitionNameLike) {
    this.processDefinitionNameLike = processDefinitionNameLike;
  }


  public HistoricProcessInstanceQueryDto processDefinitionKeyNotIn(List<String> processDefinitionKeyNotIn) {
    
    this.processDefinitionKeyNotIn = processDefinitionKeyNotIn;
    return this;
  }

  public HistoricProcessInstanceQueryDto addProcessDefinitionKeyNotInItem(String processDefinitionKeyNotInItem) {
    if (this.processDefinitionKeyNotIn == null) {
      this.processDefinitionKeyNotIn = new ArrayList<String>();
    }
    this.processDefinitionKeyNotIn.add(processDefinitionKeyNotInItem);
    return this;
  }

   /**
   * Exclude instances that belong to a set of process definitions. Must be a JSON array of &#x60;Strings&#x60;.
   * @return processDefinitionKeyNotIn
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Exclude instances that belong to a set of process definitions. Must be a JSON array of `Strings`.")

  public List<String> getProcessDefinitionKeyNotIn() {
    return processDefinitionKeyNotIn;
  }


  public void setProcessDefinitionKeyNotIn(List<String> processDefinitionKeyNotIn) {
    this.processDefinitionKeyNotIn = processDefinitionKeyNotIn;
  }


  public HistoricProcessInstanceQueryDto processInstanceBusinessKey(String processInstanceBusinessKey) {
    
    this.processInstanceBusinessKey = processInstanceBusinessKey;
    return this;
  }

   /**
   * Filter by process instance business key.
   * @return processInstanceBusinessKey
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Filter by process instance business key.")

  public String getProcessInstanceBusinessKey() {
    return processInstanceBusinessKey;
  }


  public void setProcessInstanceBusinessKey(String processInstanceBusinessKey) {
    this.processInstanceBusinessKey = processInstanceBusinessKey;
  }


  public HistoricProcessInstanceQueryDto processInstanceBusinessKeyIn(List<String> processInstanceBusinessKeyIn) {
    
    this.processInstanceBusinessKeyIn = processInstanceBusinessKeyIn;
    return this;
  }

  public HistoricProcessInstanceQueryDto addProcessInstanceBusinessKeyInItem(String processInstanceBusinessKeyInItem) {
    if (this.processInstanceBusinessKeyIn == null) {
      this.processInstanceBusinessKeyIn = new ArrayList<String>();
    }
    this.processInstanceBusinessKeyIn.add(processInstanceBusinessKeyInItem);
    return this;
  }

   /**
   * Filter by a list of business keys. A process instance must have one of the given business keys. Must be a JSON array of &#x60;Strings&#x60;
   * @return processInstanceBusinessKeyIn
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Filter by a list of business keys. A process instance must have one of the given business keys. Must be a JSON array of `Strings`")

  public List<String> getProcessInstanceBusinessKeyIn() {
    return processInstanceBusinessKeyIn;
  }


  public void setProcessInstanceBusinessKeyIn(List<String> processInstanceBusinessKeyIn) {
    this.processInstanceBusinessKeyIn = processInstanceBusinessKeyIn;
  }


  public HistoricProcessInstanceQueryDto processInstanceBusinessKeyLike(String processInstanceBusinessKeyLike) {
    
    this.processInstanceBusinessKeyLike = processInstanceBusinessKeyLike;
    return this;
  }

   /**
   * Filter by process instance business key that the parameter is a substring of.
   * @return processInstanceBusinessKeyLike
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Filter by process instance business key that the parameter is a substring of.")

  public String getProcessInstanceBusinessKeyLike() {
    return processInstanceBusinessKeyLike;
  }


  public void setProcessInstanceBusinessKeyLike(String processInstanceBusinessKeyLike) {
    this.processInstanceBusinessKeyLike = processInstanceBusinessKeyLike;
  }


  public HistoricProcessInstanceQueryDto rootProcessInstances(Boolean rootProcessInstances) {
    
    this.rootProcessInstances = rootProcessInstances;
    return this;
  }

   /**
   * Restrict the query to all process instances that are top level process instances.
   * @return rootProcessInstances
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Restrict the query to all process instances that are top level process instances.")

  public Boolean getRootProcessInstances() {
    return rootProcessInstances;
  }


  public void setRootProcessInstances(Boolean rootProcessInstances) {
    this.rootProcessInstances = rootProcessInstances;
  }


  public HistoricProcessInstanceQueryDto finished(Boolean finished) {
    
    this.finished = finished;
    return this;
  }

   /**
   * Only include finished process instances. This flag includes all process instances that are completed or terminated. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior.
   * @return finished
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Only include finished process instances. This flag includes all process instances that are completed or terminated. Value may only be `true`, as `false` is the default behavior.")

  public Boolean getFinished() {
    return finished;
  }


  public void setFinished(Boolean finished) {
    this.finished = finished;
  }


  public HistoricProcessInstanceQueryDto unfinished(Boolean unfinished) {
    
    this.unfinished = unfinished;
    return this;
  }

   /**
   * Only include unfinished process instances. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior.
   * @return unfinished
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Only include unfinished process instances. Value may only be `true`, as `false` is the default behavior.")

  public Boolean getUnfinished() {
    return unfinished;
  }


  public void setUnfinished(Boolean unfinished) {
    this.unfinished = unfinished;
  }


  public HistoricProcessInstanceQueryDto withIncidents(Boolean withIncidents) {
    
    this.withIncidents = withIncidents;
    return this;
  }

   /**
   * Only include process instances which have an incident. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior.
   * @return withIncidents
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Only include process instances which have an incident. Value may only be `true`, as `false` is the default behavior.")

  public Boolean getWithIncidents() {
    return withIncidents;
  }


  public void setWithIncidents(Boolean withIncidents) {
    this.withIncidents = withIncidents;
  }


  public HistoricProcessInstanceQueryDto withRootIncidents(Boolean withRootIncidents) {
    
    this.withRootIncidents = withRootIncidents;
    return this;
  }

   /**
   * Only include process instances which have a root incident. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior.
   * @return withRootIncidents
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Only include process instances which have a root incident. Value may only be `true`, as `false` is the default behavior.")

  public Boolean getWithRootIncidents() {
    return withRootIncidents;
  }


  public void setWithRootIncidents(Boolean withRootIncidents) {
    this.withRootIncidents = withRootIncidents;
  }


  public HistoricProcessInstanceQueryDto incidentType(String incidentType) {
    
    this.incidentType = incidentType;
    return this;
  }

   /**
   * Filter by the incident type. See the [User Guide](https://docs.camunda.org/manual/7.17/user-guide/process-engine/incidents/#incident-types) for a list of incident types.
   * @return incidentType
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Filter by the incident type. See the [User Guide](https://docs.camunda.org/manual/7.17/user-guide/process-engine/incidents/#incident-types) for a list of incident types.")

  public String getIncidentType() {
    return incidentType;
  }


  public void setIncidentType(String incidentType) {
    this.incidentType = incidentType;
  }


  public HistoricProcessInstanceQueryDto incidentStatus(IncidentStatusEnum incidentStatus) {
    
    this.incidentStatus = incidentStatus;
    return this;
  }

   /**
   * Only include process instances which have an incident in status either open or resolved. To get all process instances, use the query parameter withIncidents.
   * @return incidentStatus
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Only include process instances which have an incident in status either open or resolved. To get all process instances, use the query parameter withIncidents.")

  public IncidentStatusEnum getIncidentStatus() {
    return incidentStatus;
  }


  public void setIncidentStatus(IncidentStatusEnum incidentStatus) {
    this.incidentStatus = incidentStatus;
  }


  public HistoricProcessInstanceQueryDto incidentMessage(String incidentMessage) {
    
    this.incidentMessage = incidentMessage;
    return this;
  }

   /**
   * Filter by the incident message. Exact match.
   * @return incidentMessage
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Filter by the incident message. Exact match.")

  public String getIncidentMessage() {
    return incidentMessage;
  }


  public void setIncidentMessage(String incidentMessage) {
    this.incidentMessage = incidentMessage;
  }


  public HistoricProcessInstanceQueryDto incidentMessageLike(String incidentMessageLike) {
    
    this.incidentMessageLike = incidentMessageLike;
    return this;
  }

   /**
   * Filter by the incident message that the parameter is a substring of.
   * @return incidentMessageLike
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Filter by the incident message that the parameter is a substring of.")

  public String getIncidentMessageLike() {
    return incidentMessageLike;
  }


  public void setIncidentMessageLike(String incidentMessageLike) {
    this.incidentMessageLike = incidentMessageLike;
  }


  public HistoricProcessInstanceQueryDto startedBefore(Date startedBefore) {
    
    this.startedBefore = startedBefore;
    return this;
  }

   /**
   * Restrict to instances that were started before the given date. By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;.
   * @return startedBefore
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Restrict to instances that were started before the given date. By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.")

  public Date getStartedBefore() {
    return startedBefore;
  }


  public void setStartedBefore(Date startedBefore) {
    this.startedBefore = startedBefore;
  }


  public HistoricProcessInstanceQueryDto startedAfter(Date startedAfter) {
    
    this.startedAfter = startedAfter;
    return this;
  }

   /**
   * Restrict to instances that were started after the given date. By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;.
   * @return startedAfter
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Restrict to instances that were started after the given date. By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.")

  public Date getStartedAfter() {
    return startedAfter;
  }


  public void setStartedAfter(Date startedAfter) {
    this.startedAfter = startedAfter;
  }


  public HistoricProcessInstanceQueryDto finishedBefore(Date finishedBefore) {
    
    this.finishedBefore = finishedBefore;
    return this;
  }

   /**
   * Restrict to instances that were finished before the given date. By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;.
   * @return finishedBefore
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Restrict to instances that were finished before the given date. By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.")

  public Date getFinishedBefore() {
    return finishedBefore;
  }


  public void setFinishedBefore(Date finishedBefore) {
    this.finishedBefore = finishedBefore;
  }


  public HistoricProcessInstanceQueryDto finishedAfter(Date finishedAfter) {
    
    this.finishedAfter = finishedAfter;
    return this;
  }

   /**
   * Restrict to instances that were finished after the given date. By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;.
   * @return finishedAfter
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Restrict to instances that were finished after the given date. By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.")

  public Date getFinishedAfter() {
    return finishedAfter;
  }


  public void setFinishedAfter(Date finishedAfter) {
    this.finishedAfter = finishedAfter;
  }


  public HistoricProcessInstanceQueryDto executedActivityAfter(Date executedActivityAfter) {
    
    this.executedActivityAfter = executedActivityAfter;
    return this;
  }

   /**
   * Restrict to instances that executed an activity after the given date (inclusive). By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;.
   * @return executedActivityAfter
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Restrict to instances that executed an activity after the given date (inclusive). By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.")

  public Date getExecutedActivityAfter() {
    return executedActivityAfter;
  }


  public void setExecutedActivityAfter(Date executedActivityAfter) {
    this.executedActivityAfter = executedActivityAfter;
  }


  public HistoricProcessInstanceQueryDto executedActivityBefore(Date executedActivityBefore) {
    
    this.executedActivityBefore = executedActivityBefore;
    return this;
  }

   /**
   * Restrict to instances that executed an activity before the given date (inclusive). By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;.
   * @return executedActivityBefore
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Restrict to instances that executed an activity before the given date (inclusive). By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.")

  public Date getExecutedActivityBefore() {
    return executedActivityBefore;
  }


  public void setExecutedActivityBefore(Date executedActivityBefore) {
    this.executedActivityBefore = executedActivityBefore;
  }


  public HistoricProcessInstanceQueryDto executedJobAfter(Date executedJobAfter) {
    
    this.executedJobAfter = executedJobAfter;
    return this;
  }

   /**
   * Restrict to instances that executed an job after the given date (inclusive). By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;.
   * @return executedJobAfter
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Restrict to instances that executed an job after the given date (inclusive). By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.")

  public Date getExecutedJobAfter() {
    return executedJobAfter;
  }


  public void setExecutedJobAfter(Date executedJobAfter) {
    this.executedJobAfter = executedJobAfter;
  }


  public HistoricProcessInstanceQueryDto executedJobBefore(Date executedJobBefore) {
    
    this.executedJobBefore = executedJobBefore;
    return this;
  }

   /**
   * Restrict to instances that executed an job before the given date (inclusive). By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;, e.g., &#x60;2013-01-23T14:42:45.000+0200&#x60;.
   * @return executedJobBefore
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Restrict to instances that executed an job before the given date (inclusive). By [default](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.")

  public Date getExecutedJobBefore() {
    return executedJobBefore;
  }


  public void setExecutedJobBefore(Date executedJobBefore) {
    this.executedJobBefore = executedJobBefore;
  }


  public HistoricProcessInstanceQueryDto startedBy(String startedBy) {
    
    this.startedBy = startedBy;
    return this;
  }

   /**
   * Only include process instances that were started by the given user.
   * @return startedBy
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Only include process instances that were started by the given user.")

  public String getStartedBy() {
    return startedBy;
  }


  public void setStartedBy(String startedBy) {
    this.startedBy = startedBy;
  }


  public HistoricProcessInstanceQueryDto superProcessInstanceId(String superProcessInstanceId) {
    
    this.superProcessInstanceId = superProcessInstanceId;
    return this;
  }

   /**
   * Restrict query to all process instances that are sub process instances of the given process instance. Takes a process instance id.
   * @return superProcessInstanceId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Restrict query to all process instances that are sub process instances of the given process instance. Takes a process instance id.")

  public String getSuperProcessInstanceId() {
    return superProcessInstanceId;
  }


  public void setSuperProcessInstanceId(String superProcessInstanceId) {
    this.superProcessInstanceId = superProcessInstanceId;
  }


  public HistoricProcessInstanceQueryDto subProcessInstanceId(String subProcessInstanceId) {
    
    this.subProcessInstanceId = subProcessInstanceId;
    return this;
  }

   /**
   * Restrict query to one process instance that has a sub process instance with the given id.
   * @return subProcessInstanceId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Restrict query to one process instance that has a sub process instance with the given id.")

  public String getSubProcessInstanceId() {
    return subProcessInstanceId;
  }


  public void setSubProcessInstanceId(String subProcessInstanceId) {
    this.subProcessInstanceId = subProcessInstanceId;
  }


  public HistoricProcessInstanceQueryDto superCaseInstanceId(String superCaseInstanceId) {
    
    this.superCaseInstanceId = superCaseInstanceId;
    return this;
  }

   /**
   * Restrict query to all process instances that are sub process instances of the given case instance. Takes a case instance id.
   * @return superCaseInstanceId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Restrict query to all process instances that are sub process instances of the given case instance. Takes a case instance id.")

  public String getSuperCaseInstanceId() {
    return superCaseInstanceId;
  }


  public void setSuperCaseInstanceId(String superCaseInstanceId) {
    this.superCaseInstanceId = superCaseInstanceId;
  }


  public HistoricProcessInstanceQueryDto subCaseInstanceId(String subCaseInstanceId) {
    
    this.subCaseInstanceId = subCaseInstanceId;
    return this;
  }

   /**
   * Restrict query to one process instance that has a sub case instance with the given id.
   * @return subCaseInstanceId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Restrict query to one process instance that has a sub case instance with the given id.")

  public String getSubCaseInstanceId() {
    return subCaseInstanceId;
  }


  public void setSubCaseInstanceId(String subCaseInstanceId) {
    this.subCaseInstanceId = subCaseInstanceId;
  }


  public HistoricProcessInstanceQueryDto caseInstanceId(String caseInstanceId) {
    
    this.caseInstanceId = caseInstanceId;
    return this;
  }

   /**
   * Restrict query to all process instances that are sub process instances of the given case instance. Takes a case instance id.
   * @return caseInstanceId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Restrict query to all process instances that are sub process instances of the given case instance. Takes a case instance id.")

  public String getCaseInstanceId() {
    return caseInstanceId;
  }


  public void setCaseInstanceId(String caseInstanceId) {
    this.caseInstanceId = caseInstanceId;
  }


  public HistoricProcessInstanceQueryDto tenantIdIn(List<String> tenantIdIn) {
    
    this.tenantIdIn = tenantIdIn;
    return this;
  }

  public HistoricProcessInstanceQueryDto addTenantIdInItem(String tenantIdInItem) {
    if (this.tenantIdIn == null) {
      this.tenantIdIn = new ArrayList<String>();
    }
    this.tenantIdIn.add(tenantIdInItem);
    return this;
  }

   /**
   * Filter by a list of tenant ids. A process instance must have one of the given tenant ids. Must be a JSON array of &#x60;Strings&#x60;
   * @return tenantIdIn
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Filter by a list of tenant ids. A process instance must have one of the given tenant ids. Must be a JSON array of `Strings`")

  public List<String> getTenantIdIn() {
    return tenantIdIn;
  }


  public void setTenantIdIn(List<String> tenantIdIn) {
    this.tenantIdIn = tenantIdIn;
  }


  public HistoricProcessInstanceQueryDto withoutTenantId(Boolean withoutTenantId) {
    
    this.withoutTenantId = withoutTenantId;
    return this;
  }

   /**
   * Only include historic process instances which belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior.
   * @return withoutTenantId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Only include historic process instances which belong to no tenant. Value may only be `true`, as `false` is the default behavior.")

  public Boolean getWithoutTenantId() {
    return withoutTenantId;
  }


  public void setWithoutTenantId(Boolean withoutTenantId) {
    this.withoutTenantId = withoutTenantId;
  }


  public HistoricProcessInstanceQueryDto executedActivityIdIn(List<String> executedActivityIdIn) {
    
    this.executedActivityIdIn = executedActivityIdIn;
    return this;
  }

  public HistoricProcessInstanceQueryDto addExecutedActivityIdInItem(String executedActivityIdInItem) {
    if (this.executedActivityIdIn == null) {
      this.executedActivityIdIn = new ArrayList<String>();
    }
    this.executedActivityIdIn.add(executedActivityIdInItem);
    return this;
  }

   /**
   * Restrict to instances that executed an activity with one of given ids. Must be a JSON array of &#x60;Strings&#x60;
   * @return executedActivityIdIn
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Restrict to instances that executed an activity with one of given ids. Must be a JSON array of `Strings`")

  public List<String> getExecutedActivityIdIn() {
    return executedActivityIdIn;
  }


  public void setExecutedActivityIdIn(List<String> executedActivityIdIn) {
    this.executedActivityIdIn = executedActivityIdIn;
  }


  public HistoricProcessInstanceQueryDto activeActivityIdIn(List<String> activeActivityIdIn) {
    
    this.activeActivityIdIn = activeActivityIdIn;
    return this;
  }

  public HistoricProcessInstanceQueryDto addActiveActivityIdInItem(String activeActivityIdInItem) {
    if (this.activeActivityIdIn == null) {
      this.activeActivityIdIn = new ArrayList<String>();
    }
    this.activeActivityIdIn.add(activeActivityIdInItem);
    return this;
  }

   /**
   * Restrict to instances that have an active activity with one of given ids. Must be a JSON array of &#x60;Strings&#x60;
   * @return activeActivityIdIn
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Restrict to instances that have an active activity with one of given ids. Must be a JSON array of `Strings`")

  public List<String> getActiveActivityIdIn() {
    return activeActivityIdIn;
  }


  public void setActiveActivityIdIn(List<String> activeActivityIdIn) {
    this.activeActivityIdIn = activeActivityIdIn;
  }


  public HistoricProcessInstanceQueryDto active(Boolean active) {
    
    this.active = active;
    return this;
  }

   /**
   * Restrict to instances that are active.
   * @return active
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Restrict to instances that are active.")

  public Boolean getActive() {
    return active;
  }


  public void setActive(Boolean active) {
    this.active = active;
  }


  public HistoricProcessInstanceQueryDto suspended(Boolean suspended) {
    
    this.suspended = suspended;
    return this;
  }

   /**
   * Restrict to instances that are suspended.
   * @return suspended
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Restrict to instances that are suspended.")

  public Boolean getSuspended() {
    return suspended;
  }


  public void setSuspended(Boolean suspended) {
    this.suspended = suspended;
  }


  public HistoricProcessInstanceQueryDto completed(Boolean completed) {
    
    this.completed = completed;
    return this;
  }

   /**
   * Restrict to instances that are completed.
   * @return completed
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Restrict to instances that are completed.")

  public Boolean getCompleted() {
    return completed;
  }


  public void setCompleted(Boolean completed) {
    this.completed = completed;
  }


  public HistoricProcessInstanceQueryDto externallyTerminated(Boolean externallyTerminated) {
    
    this.externallyTerminated = externallyTerminated;
    return this;
  }

   /**
   * Restrict to instances that are externallyTerminated.
   * @return externallyTerminated
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Restrict to instances that are externallyTerminated.")

  public Boolean getExternallyTerminated() {
    return externallyTerminated;
  }


  public void setExternallyTerminated(Boolean externallyTerminated) {
    this.externallyTerminated = externallyTerminated;
  }


  public HistoricProcessInstanceQueryDto internallyTerminated(Boolean internallyTerminated) {
    
    this.internallyTerminated = internallyTerminated;
    return this;
  }

   /**
   * Restrict to instances that are internallyTerminated.
   * @return internallyTerminated
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Restrict to instances that are internallyTerminated.")

  public Boolean getInternallyTerminated() {
    return internallyTerminated;
  }


  public void setInternallyTerminated(Boolean internallyTerminated) {
    this.internallyTerminated = internallyTerminated;
  }


  public HistoricProcessInstanceQueryDto variables(List<VariableQueryParameterDto> variables) {
    
    this.variables = variables;
    return this;
  }

  public HistoricProcessInstanceQueryDto addVariablesItem(VariableQueryParameterDto variablesItem) {
    if (this.variables == null) {
      this.variables = new ArrayList<VariableQueryParameterDto>();
    }
    this.variables.add(variablesItem);
    return this;
  }

   /**
   * A JSON array to only include process instances that have/had variables with certain values. The array consists of objects with the three properties &#x60;name&#x60;, &#x60;operator&#x60; and &#x60;value&#x60;. &#x60;name&#x60; (&#x60;String&#x60;) is the variable name, &#x60;operator&#x60; (&#x60;String&#x60;) is the comparison operator to be used and &#x60;value&#x60; the variable value.  Value may be &#x60;String&#x60;, &#x60;Number&#x60; or &#x60;Boolean&#x60;.  Valid operator values are: &#x60;eq&#x60; - equal to; &#x60;neq&#x60; - not equal to; &#x60;gt&#x60; - greater than; &#x60;gteq&#x60; - greater than or equal to; &#x60;lt&#x60; - lower than; &#x60;lteq&#x60; - lower than or equal to; &#x60;like&#x60;. 
   * @return variables
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "A JSON array to only include process instances that have/had variables with certain values. The array consists of objects with the three properties `name`, `operator` and `value`. `name` (`String`) is the variable name, `operator` (`String`) is the comparison operator to be used and `value` the variable value.  Value may be `String`, `Number` or `Boolean`.  Valid operator values are: `eq` - equal to; `neq` - not equal to; `gt` - greater than; `gteq` - greater than or equal to; `lt` - lower than; `lteq` - lower than or equal to; `like`. ")

  public List<VariableQueryParameterDto> getVariables() {
    return variables;
  }


  public void setVariables(List<VariableQueryParameterDto> variables) {
    this.variables = variables;
  }


  public HistoricProcessInstanceQueryDto variableNamesIgnoreCase(Boolean variableNamesIgnoreCase) {
    
    this.variableNamesIgnoreCase = variableNamesIgnoreCase;
    return this;
  }

   /**
   * Match all variable names provided in variables case-insensitively. If set to &#x60;true&#x60; variableName and variablename are treated as equal.
   * @return variableNamesIgnoreCase
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Match all variable names provided in variables case-insensitively. If set to `true` variableName and variablename are treated as equal.")

  public Boolean getVariableNamesIgnoreCase() {
    return variableNamesIgnoreCase;
  }


  public void setVariableNamesIgnoreCase(Boolean variableNamesIgnoreCase) {
    this.variableNamesIgnoreCase = variableNamesIgnoreCase;
  }


  public HistoricProcessInstanceQueryDto variableValuesIgnoreCase(Boolean variableValuesIgnoreCase) {
    
    this.variableValuesIgnoreCase = variableValuesIgnoreCase;
    return this;
  }

   /**
   * Match all variable values provided in variables case-insensitively. If set to &#x60;true&#x60; variableValue and variablevalue are treated as equal.
   * @return variableValuesIgnoreCase
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Match all variable values provided in variables case-insensitively. If set to `true` variableValue and variablevalue are treated as equal.")

  public Boolean getVariableValuesIgnoreCase() {
    return variableValuesIgnoreCase;
  }


  public void setVariableValuesIgnoreCase(Boolean variableValuesIgnoreCase) {
    this.variableValuesIgnoreCase = variableValuesIgnoreCase;
  }


  public HistoricProcessInstanceQueryDto orQueries(List<HistoricProcessInstanceQueryDto> orQueries) {
    
    this.orQueries = orQueries;
    return this;
  }

  public HistoricProcessInstanceQueryDto addOrQueriesItem(HistoricProcessInstanceQueryDto orQueriesItem) {
    if (this.orQueries == null) {
      this.orQueries = new ArrayList<HistoricProcessInstanceQueryDto>();
    }
    this.orQueries.add(orQueriesItem);
    return this;
  }

   /**
   * A JSON array of nested historic process instance queries with OR semantics.  A process instance matches a nested query if it fulfills at least one of the query&#39;s predicates.  With multiple nested queries, a process instance must fulfill at least one predicate of each query ([Conjunctive Normal Form](https://en.wikipedia.org/wiki/Conjunctive_normal_form)).  All process instance query properties can be used except for: &#x60;sorting&#x60;  See the [User Guide](https://docs.camunda.org/manual/7.17/user-guide/process-engine/process-engine-api/#or-queries) for more information about OR queries.
   * @return orQueries
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "A JSON array of nested historic process instance queries with OR semantics.  A process instance matches a nested query if it fulfills at least one of the query's predicates.  With multiple nested queries, a process instance must fulfill at least one predicate of each query ([Conjunctive Normal Form](https://en.wikipedia.org/wiki/Conjunctive_normal_form)).  All process instance query properties can be used except for: `sorting`  See the [User Guide](https://docs.camunda.org/manual/7.17/user-guide/process-engine/process-engine-api/#or-queries) for more information about OR queries.")

  public List<HistoricProcessInstanceQueryDto> getOrQueries() {
    return orQueries;
  }


  public void setOrQueries(List<HistoricProcessInstanceQueryDto> orQueries) {
    this.orQueries = orQueries;
  }


  public HistoricProcessInstanceQueryDto sorting(List<HistoricProcessInstanceQueryDtoSorting> sorting) {
    
    this.sorting = sorting;
    return this;
  }

  public HistoricProcessInstanceQueryDto addSortingItem(HistoricProcessInstanceQueryDtoSorting sortingItem) {
    if (this.sorting == null) {
      this.sorting = new ArrayList<HistoricProcessInstanceQueryDtoSorting>();
    }
    this.sorting.add(sortingItem);
    return this;
  }

   /**
   * Apply sorting of the result
   * @return sorting
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Apply sorting of the result")

  public List<HistoricProcessInstanceQueryDtoSorting> getSorting() {
    return sorting;
  }


  public void setSorting(List<HistoricProcessInstanceQueryDtoSorting> sorting) {
    this.sorting = sorting;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    HistoricProcessInstanceQueryDto historicProcessInstanceQueryDto = (HistoricProcessInstanceQueryDto) o;
    return Objects.equals(this.processInstanceId, historicProcessInstanceQueryDto.processInstanceId) &&
        Objects.equals(this.processInstanceIds, historicProcessInstanceQueryDto.processInstanceIds) &&
        Objects.equals(this.processDefinitionId, historicProcessInstanceQueryDto.processDefinitionId) &&
        Objects.equals(this.processDefinitionKey, historicProcessInstanceQueryDto.processDefinitionKey) &&
        Objects.equals(this.processDefinitionKeyIn, historicProcessInstanceQueryDto.processDefinitionKeyIn) &&
        Objects.equals(this.processDefinitionName, historicProcessInstanceQueryDto.processDefinitionName) &&
        Objects.equals(this.processDefinitionNameLike, historicProcessInstanceQueryDto.processDefinitionNameLike) &&
        Objects.equals(this.processDefinitionKeyNotIn, historicProcessInstanceQueryDto.processDefinitionKeyNotIn) &&
        Objects.equals(this.processInstanceBusinessKey, historicProcessInstanceQueryDto.processInstanceBusinessKey) &&
        Objects.equals(this.processInstanceBusinessKeyIn, historicProcessInstanceQueryDto.processInstanceBusinessKeyIn) &&
        Objects.equals(this.processInstanceBusinessKeyLike, historicProcessInstanceQueryDto.processInstanceBusinessKeyLike) &&
        Objects.equals(this.rootProcessInstances, historicProcessInstanceQueryDto.rootProcessInstances) &&
        Objects.equals(this.finished, historicProcessInstanceQueryDto.finished) &&
        Objects.equals(this.unfinished, historicProcessInstanceQueryDto.unfinished) &&
        Objects.equals(this.withIncidents, historicProcessInstanceQueryDto.withIncidents) &&
        Objects.equals(this.withRootIncidents, historicProcessInstanceQueryDto.withRootIncidents) &&
        Objects.equals(this.incidentType, historicProcessInstanceQueryDto.incidentType) &&
        Objects.equals(this.incidentStatus, historicProcessInstanceQueryDto.incidentStatus) &&
        Objects.equals(this.incidentMessage, historicProcessInstanceQueryDto.incidentMessage) &&
        Objects.equals(this.incidentMessageLike, historicProcessInstanceQueryDto.incidentMessageLike) &&
        Objects.equals(this.startedBefore, historicProcessInstanceQueryDto.startedBefore) &&
        Objects.equals(this.startedAfter, historicProcessInstanceQueryDto.startedAfter) &&
        Objects.equals(this.finishedBefore, historicProcessInstanceQueryDto.finishedBefore) &&
        Objects.equals(this.finishedAfter, historicProcessInstanceQueryDto.finishedAfter) &&
        Objects.equals(this.executedActivityAfter, historicProcessInstanceQueryDto.executedActivityAfter) &&
        Objects.equals(this.executedActivityBefore, historicProcessInstanceQueryDto.executedActivityBefore) &&
        Objects.equals(this.executedJobAfter, historicProcessInstanceQueryDto.executedJobAfter) &&
        Objects.equals(this.executedJobBefore, historicProcessInstanceQueryDto.executedJobBefore) &&
        Objects.equals(this.startedBy, historicProcessInstanceQueryDto.startedBy) &&
        Objects.equals(this.superProcessInstanceId, historicProcessInstanceQueryDto.superProcessInstanceId) &&
        Objects.equals(this.subProcessInstanceId, historicProcessInstanceQueryDto.subProcessInstanceId) &&
        Objects.equals(this.superCaseInstanceId, historicProcessInstanceQueryDto.superCaseInstanceId) &&
        Objects.equals(this.subCaseInstanceId, historicProcessInstanceQueryDto.subCaseInstanceId) &&
        Objects.equals(this.caseInstanceId, historicProcessInstanceQueryDto.caseInstanceId) &&
        Objects.equals(this.tenantIdIn, historicProcessInstanceQueryDto.tenantIdIn) &&
        Objects.equals(this.withoutTenantId, historicProcessInstanceQueryDto.withoutTenantId) &&
        Objects.equals(this.executedActivityIdIn, historicProcessInstanceQueryDto.executedActivityIdIn) &&
        Objects.equals(this.activeActivityIdIn, historicProcessInstanceQueryDto.activeActivityIdIn) &&
        Objects.equals(this.active, historicProcessInstanceQueryDto.active) &&
        Objects.equals(this.suspended, historicProcessInstanceQueryDto.suspended) &&
        Objects.equals(this.completed, historicProcessInstanceQueryDto.completed) &&
        Objects.equals(this.externallyTerminated, historicProcessInstanceQueryDto.externallyTerminated) &&
        Objects.equals(this.internallyTerminated, historicProcessInstanceQueryDto.internallyTerminated) &&
        Objects.equals(this.variables, historicProcessInstanceQueryDto.variables) &&
        Objects.equals(this.variableNamesIgnoreCase, historicProcessInstanceQueryDto.variableNamesIgnoreCase) &&
        Objects.equals(this.variableValuesIgnoreCase, historicProcessInstanceQueryDto.variableValuesIgnoreCase) &&
        Objects.equals(this.orQueries, historicProcessInstanceQueryDto.orQueries) &&
        Objects.equals(this.sorting, historicProcessInstanceQueryDto.sorting);
  }

  @Override
  public int hashCode() {
    return Objects.hash(processInstanceId, processInstanceIds, processDefinitionId, processDefinitionKey, processDefinitionKeyIn, processDefinitionName, processDefinitionNameLike, processDefinitionKeyNotIn, processInstanceBusinessKey, processInstanceBusinessKeyIn, processInstanceBusinessKeyLike, rootProcessInstances, finished, unfinished, withIncidents, withRootIncidents, incidentType, incidentStatus, incidentMessage, incidentMessageLike, startedBefore, startedAfter, finishedBefore, finishedAfter, executedActivityAfter, executedActivityBefore, executedJobAfter, executedJobBefore, startedBy, superProcessInstanceId, subProcessInstanceId, superCaseInstanceId, subCaseInstanceId, caseInstanceId, tenantIdIn, withoutTenantId, executedActivityIdIn, activeActivityIdIn, active, suspended, completed, externallyTerminated, internallyTerminated, variables, variableNamesIgnoreCase, variableValuesIgnoreCase, orQueries, sorting);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class HistoricProcessInstanceQueryDto {\n");
    sb.append("    processInstanceId: ").append(toIndentedString(processInstanceId)).append("\n");
    sb.append("    processInstanceIds: ").append(toIndentedString(processInstanceIds)).append("\n");
    sb.append("    processDefinitionId: ").append(toIndentedString(processDefinitionId)).append("\n");
    sb.append("    processDefinitionKey: ").append(toIndentedString(processDefinitionKey)).append("\n");
    sb.append("    processDefinitionKeyIn: ").append(toIndentedString(processDefinitionKeyIn)).append("\n");
    sb.append("    processDefinitionName: ").append(toIndentedString(processDefinitionName)).append("\n");
    sb.append("    processDefinitionNameLike: ").append(toIndentedString(processDefinitionNameLike)).append("\n");
    sb.append("    processDefinitionKeyNotIn: ").append(toIndentedString(processDefinitionKeyNotIn)).append("\n");
    sb.append("    processInstanceBusinessKey: ").append(toIndentedString(processInstanceBusinessKey)).append("\n");
    sb.append("    processInstanceBusinessKeyIn: ").append(toIndentedString(processInstanceBusinessKeyIn)).append("\n");
    sb.append("    processInstanceBusinessKeyLike: ").append(toIndentedString(processInstanceBusinessKeyLike)).append("\n");
    sb.append("    rootProcessInstances: ").append(toIndentedString(rootProcessInstances)).append("\n");
    sb.append("    finished: ").append(toIndentedString(finished)).append("\n");
    sb.append("    unfinished: ").append(toIndentedString(unfinished)).append("\n");
    sb.append("    withIncidents: ").append(toIndentedString(withIncidents)).append("\n");
    sb.append("    withRootIncidents: ").append(toIndentedString(withRootIncidents)).append("\n");
    sb.append("    incidentType: ").append(toIndentedString(incidentType)).append("\n");
    sb.append("    incidentStatus: ").append(toIndentedString(incidentStatus)).append("\n");
    sb.append("    incidentMessage: ").append(toIndentedString(incidentMessage)).append("\n");
    sb.append("    incidentMessageLike: ").append(toIndentedString(incidentMessageLike)).append("\n");
    sb.append("    startedBefore: ").append(toIndentedString(startedBefore)).append("\n");
    sb.append("    startedAfter: ").append(toIndentedString(startedAfter)).append("\n");
    sb.append("    finishedBefore: ").append(toIndentedString(finishedBefore)).append("\n");
    sb.append("    finishedAfter: ").append(toIndentedString(finishedAfter)).append("\n");
    sb.append("    executedActivityAfter: ").append(toIndentedString(executedActivityAfter)).append("\n");
    sb.append("    executedActivityBefore: ").append(toIndentedString(executedActivityBefore)).append("\n");
    sb.append("    executedJobAfter: ").append(toIndentedString(executedJobAfter)).append("\n");
    sb.append("    executedJobBefore: ").append(toIndentedString(executedJobBefore)).append("\n");
    sb.append("    startedBy: ").append(toIndentedString(startedBy)).append("\n");
    sb.append("    superProcessInstanceId: ").append(toIndentedString(superProcessInstanceId)).append("\n");
    sb.append("    subProcessInstanceId: ").append(toIndentedString(subProcessInstanceId)).append("\n");
    sb.append("    superCaseInstanceId: ").append(toIndentedString(superCaseInstanceId)).append("\n");
    sb.append("    subCaseInstanceId: ").append(toIndentedString(subCaseInstanceId)).append("\n");
    sb.append("    caseInstanceId: ").append(toIndentedString(caseInstanceId)).append("\n");
    sb.append("    tenantIdIn: ").append(toIndentedString(tenantIdIn)).append("\n");
    sb.append("    withoutTenantId: ").append(toIndentedString(withoutTenantId)).append("\n");
    sb.append("    executedActivityIdIn: ").append(toIndentedString(executedActivityIdIn)).append("\n");
    sb.append("    activeActivityIdIn: ").append(toIndentedString(activeActivityIdIn)).append("\n");
    sb.append("    active: ").append(toIndentedString(active)).append("\n");
    sb.append("    suspended: ").append(toIndentedString(suspended)).append("\n");
    sb.append("    completed: ").append(toIndentedString(completed)).append("\n");
    sb.append("    externallyTerminated: ").append(toIndentedString(externallyTerminated)).append("\n");
    sb.append("    internallyTerminated: ").append(toIndentedString(internallyTerminated)).append("\n");
    sb.append("    variables: ").append(toIndentedString(variables)).append("\n");
    sb.append("    variableNamesIgnoreCase: ").append(toIndentedString(variableNamesIgnoreCase)).append("\n");
    sb.append("    variableValuesIgnoreCase: ").append(toIndentedString(variableValuesIgnoreCase)).append("\n");
    sb.append("    orQueries: ").append(toIndentedString(orQueries)).append("\n");
    sb.append("    sorting: ").append(toIndentedString(sorting)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

