/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.17.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.camunda.community.rest.client.dto;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Date;

/**
 * HistoricExternalTaskLogDto
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-07-15T09:20:26.494044Z[Etc/UTC]")
public class HistoricExternalTaskLogDto {
  public static final String SERIALIZED_NAME_ID = "id";
  @SerializedName(SERIALIZED_NAME_ID)
  private String id;

  public static final String SERIALIZED_NAME_EXTERNAL_TASK_ID = "externalTaskId";
  @SerializedName(SERIALIZED_NAME_EXTERNAL_TASK_ID)
  private String externalTaskId;

  public static final String SERIALIZED_NAME_TIMESTAMP = "timestamp";
  @SerializedName(SERIALIZED_NAME_TIMESTAMP)
  private Date timestamp;

  public static final String SERIALIZED_NAME_TOPIC_NAME = "topicName";
  @SerializedName(SERIALIZED_NAME_TOPIC_NAME)
  private String topicName;

  public static final String SERIALIZED_NAME_WORKER_ID = "workerId";
  @SerializedName(SERIALIZED_NAME_WORKER_ID)
  private String workerId;

  public static final String SERIALIZED_NAME_RETRIES = "retries";
  @SerializedName(SERIALIZED_NAME_RETRIES)
  private Integer retries;

  public static final String SERIALIZED_NAME_PRIORITY = "priority";
  @SerializedName(SERIALIZED_NAME_PRIORITY)
  private Long priority;

  public static final String SERIALIZED_NAME_ERROR_MESSAGE = "errorMessage";
  @SerializedName(SERIALIZED_NAME_ERROR_MESSAGE)
  private String errorMessage;

  public static final String SERIALIZED_NAME_ACTIVITY_ID = "activityId";
  @SerializedName(SERIALIZED_NAME_ACTIVITY_ID)
  private String activityId;

  public static final String SERIALIZED_NAME_ACTIVITY_INSTANCE_ID = "activityInstanceId";
  @SerializedName(SERIALIZED_NAME_ACTIVITY_INSTANCE_ID)
  private String activityInstanceId;

  public static final String SERIALIZED_NAME_EXECUTION_ID = "executionId";
  @SerializedName(SERIALIZED_NAME_EXECUTION_ID)
  private String executionId;

  public static final String SERIALIZED_NAME_PROCESS_INSTANCE_ID = "processInstanceId";
  @SerializedName(SERIALIZED_NAME_PROCESS_INSTANCE_ID)
  private String processInstanceId;

  public static final String SERIALIZED_NAME_PROCESS_DEFINITION_ID = "processDefinitionId";
  @SerializedName(SERIALIZED_NAME_PROCESS_DEFINITION_ID)
  private String processDefinitionId;

  public static final String SERIALIZED_NAME_PROCESS_DEFINITION_KEY = "processDefinitionKey";
  @SerializedName(SERIALIZED_NAME_PROCESS_DEFINITION_KEY)
  private String processDefinitionKey;

  public static final String SERIALIZED_NAME_TENANT_ID = "tenantId";
  @SerializedName(SERIALIZED_NAME_TENANT_ID)
  private String tenantId;

  public static final String SERIALIZED_NAME_CREATION_LOG = "creationLog";
  @SerializedName(SERIALIZED_NAME_CREATION_LOG)
  private Boolean creationLog;

  public static final String SERIALIZED_NAME_FAILURE_LOG = "failureLog";
  @SerializedName(SERIALIZED_NAME_FAILURE_LOG)
  private Boolean failureLog;

  public static final String SERIALIZED_NAME_SUCCESS_LOG = "successLog";
  @SerializedName(SERIALIZED_NAME_SUCCESS_LOG)
  private Boolean successLog;

  public static final String SERIALIZED_NAME_DELETION_LOG = "deletionLog";
  @SerializedName(SERIALIZED_NAME_DELETION_LOG)
  private Boolean deletionLog;

  public static final String SERIALIZED_NAME_REMOVAL_TIME = "removalTime";
  @SerializedName(SERIALIZED_NAME_REMOVAL_TIME)
  private Date removalTime;

  public static final String SERIALIZED_NAME_ROOT_PROCESS_INSTANCE_ID = "rootProcessInstanceId";
  @SerializedName(SERIALIZED_NAME_ROOT_PROCESS_INSTANCE_ID)
  private String rootProcessInstanceId;


  public HistoricExternalTaskLogDto id(String id) {
    
    this.id = id;
    return this;
  }

   /**
   * The id of the log entry.
   * @return id
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The id of the log entry.")

  public String getId() {
    return id;
  }


  public void setId(String id) {
    this.id = id;
  }


  public HistoricExternalTaskLogDto externalTaskId(String externalTaskId) {
    
    this.externalTaskId = externalTaskId;
    return this;
  }

   /**
   * The id of the external task.
   * @return externalTaskId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The id of the external task.")

  public String getExternalTaskId() {
    return externalTaskId;
  }


  public void setExternalTaskId(String externalTaskId) {
    this.externalTaskId = externalTaskId;
  }


  public HistoricExternalTaskLogDto timestamp(Date timestamp) {
    
    this.timestamp = timestamp;
    return this;
  }

   /**
   * The time when the log entry has been written.
   * @return timestamp
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The time when the log entry has been written.")

  public Date getTimestamp() {
    return timestamp;
  }


  public void setTimestamp(Date timestamp) {
    this.timestamp = timestamp;
  }


  public HistoricExternalTaskLogDto topicName(String topicName) {
    
    this.topicName = topicName;
    return this;
  }

   /**
   * The topic name of the associated external task.
   * @return topicName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The topic name of the associated external task.")

  public String getTopicName() {
    return topicName;
  }


  public void setTopicName(String topicName) {
    this.topicName = topicName;
  }


  public HistoricExternalTaskLogDto workerId(String workerId) {
    
    this.workerId = workerId;
    return this;
  }

   /**
   * The id of the worker that posessed the most recent lock.
   * @return workerId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The id of the worker that posessed the most recent lock.")

  public String getWorkerId() {
    return workerId;
  }


  public void setWorkerId(String workerId) {
    this.workerId = workerId;
  }


  public HistoricExternalTaskLogDto retries(Integer retries) {
    
    this.retries = retries;
    return this;
  }

   /**
   * The number of retries the associated external task has left.
   * @return retries
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The number of retries the associated external task has left.")

  public Integer getRetries() {
    return retries;
  }


  public void setRetries(Integer retries) {
    this.retries = retries;
  }


  public HistoricExternalTaskLogDto priority(Long priority) {
    
    this.priority = priority;
    return this;
  }

   /**
   * The execution priority the external task had when the log entry was created.
   * @return priority
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The execution priority the external task had when the log entry was created.")

  public Long getPriority() {
    return priority;
  }


  public void setPriority(Long priority) {
    this.priority = priority;
  }


  public HistoricExternalTaskLogDto errorMessage(String errorMessage) {
    
    this.errorMessage = errorMessage;
    return this;
  }

   /**
   * The message of the error that occurred by executing the associated external task.
   * @return errorMessage
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The message of the error that occurred by executing the associated external task.")

  public String getErrorMessage() {
    return errorMessage;
  }


  public void setErrorMessage(String errorMessage) {
    this.errorMessage = errorMessage;
  }


  public HistoricExternalTaskLogDto activityId(String activityId) {
    
    this.activityId = activityId;
    return this;
  }

   /**
   * The id of the activity on which the associated external task was created.
   * @return activityId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The id of the activity on which the associated external task was created.")

  public String getActivityId() {
    return activityId;
  }


  public void setActivityId(String activityId) {
    this.activityId = activityId;
  }


  public HistoricExternalTaskLogDto activityInstanceId(String activityInstanceId) {
    
    this.activityInstanceId = activityInstanceId;
    return this;
  }

   /**
   * The id of the activity instance on which the associated external task was created.
   * @return activityInstanceId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The id of the activity instance on which the associated external task was created.")

  public String getActivityInstanceId() {
    return activityInstanceId;
  }


  public void setActivityInstanceId(String activityInstanceId) {
    this.activityInstanceId = activityInstanceId;
  }


  public HistoricExternalTaskLogDto executionId(String executionId) {
    
    this.executionId = executionId;
    return this;
  }

   /**
   * The execution id on which the associated external task was created.
   * @return executionId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The execution id on which the associated external task was created.")

  public String getExecutionId() {
    return executionId;
  }


  public void setExecutionId(String executionId) {
    this.executionId = executionId;
  }


  public HistoricExternalTaskLogDto processInstanceId(String processInstanceId) {
    
    this.processInstanceId = processInstanceId;
    return this;
  }

   /**
   * The id of the process instance on which the associated external task was created.
   * @return processInstanceId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The id of the process instance on which the associated external task was created.")

  public String getProcessInstanceId() {
    return processInstanceId;
  }


  public void setProcessInstanceId(String processInstanceId) {
    this.processInstanceId = processInstanceId;
  }


  public HistoricExternalTaskLogDto processDefinitionId(String processDefinitionId) {
    
    this.processDefinitionId = processDefinitionId;
    return this;
  }

   /**
   * The id of the process definition which the associated external task belongs to.
   * @return processDefinitionId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The id of the process definition which the associated external task belongs to.")

  public String getProcessDefinitionId() {
    return processDefinitionId;
  }


  public void setProcessDefinitionId(String processDefinitionId) {
    this.processDefinitionId = processDefinitionId;
  }


  public HistoricExternalTaskLogDto processDefinitionKey(String processDefinitionKey) {
    
    this.processDefinitionKey = processDefinitionKey;
    return this;
  }

   /**
   * The key of the process definition which the associated external task belongs to.
   * @return processDefinitionKey
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The key of the process definition which the associated external task belongs to.")

  public String getProcessDefinitionKey() {
    return processDefinitionKey;
  }


  public void setProcessDefinitionKey(String processDefinitionKey) {
    this.processDefinitionKey = processDefinitionKey;
  }


  public HistoricExternalTaskLogDto tenantId(String tenantId) {
    
    this.tenantId = tenantId;
    return this;
  }

   /**
   * The id of the tenant that this historic external task log entry belongs to.
   * @return tenantId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The id of the tenant that this historic external task log entry belongs to.")

  public String getTenantId() {
    return tenantId;
  }


  public void setTenantId(String tenantId) {
    this.tenantId = tenantId;
  }


  public HistoricExternalTaskLogDto creationLog(Boolean creationLog) {
    
    this.creationLog = creationLog;
    return this;
  }

   /**
   * A flag indicating whether this log represents the creation of the associated external task.
   * @return creationLog
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "A flag indicating whether this log represents the creation of the associated external task.")

  public Boolean getCreationLog() {
    return creationLog;
  }


  public void setCreationLog(Boolean creationLog) {
    this.creationLog = creationLog;
  }


  public HistoricExternalTaskLogDto failureLog(Boolean failureLog) {
    
    this.failureLog = failureLog;
    return this;
  }

   /**
   * A flag indicating whether this log represents the failed execution of the associated external task.
   * @return failureLog
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "A flag indicating whether this log represents the failed execution of the associated external task.")

  public Boolean getFailureLog() {
    return failureLog;
  }


  public void setFailureLog(Boolean failureLog) {
    this.failureLog = failureLog;
  }


  public HistoricExternalTaskLogDto successLog(Boolean successLog) {
    
    this.successLog = successLog;
    return this;
  }

   /**
   * A flag indicating whether this log represents the successful execution of the associated external task.
   * @return successLog
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "A flag indicating whether this log represents the successful execution of the associated external task.")

  public Boolean getSuccessLog() {
    return successLog;
  }


  public void setSuccessLog(Boolean successLog) {
    this.successLog = successLog;
  }


  public HistoricExternalTaskLogDto deletionLog(Boolean deletionLog) {
    
    this.deletionLog = deletionLog;
    return this;
  }

   /**
   * A flag indicating whether this log represents the deletion of the associated external task.
   * @return deletionLog
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "A flag indicating whether this log represents the deletion of the associated external task.")

  public Boolean getDeletionLog() {
    return deletionLog;
  }


  public void setDeletionLog(Boolean deletionLog) {
    this.deletionLog = deletionLog;
  }


  public HistoricExternalTaskLogDto removalTime(Date removalTime) {
    
    this.removalTime = removalTime;
    return this;
  }

   /**
   * The time after which this log should be removed by the History Cleanup job. Default format &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;.  For further information, please see the [documentation](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/)
   * @return removalTime
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The time after which this log should be removed by the History Cleanup job. Default format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`.  For further information, please see the [documentation](https://docs.camunda.org/manual/7.17/reference/rest/overview/date-format/)")

  public Date getRemovalTime() {
    return removalTime;
  }


  public void setRemovalTime(Date removalTime) {
    this.removalTime = removalTime;
  }


  public HistoricExternalTaskLogDto rootProcessInstanceId(String rootProcessInstanceId) {
    
    this.rootProcessInstanceId = rootProcessInstanceId;
    return this;
  }

   /**
   * The process instance id of the root process instance that initiated the process containing this log.
   * @return rootProcessInstanceId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The process instance id of the root process instance that initiated the process containing this log.")

  public String getRootProcessInstanceId() {
    return rootProcessInstanceId;
  }


  public void setRootProcessInstanceId(String rootProcessInstanceId) {
    this.rootProcessInstanceId = rootProcessInstanceId;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    HistoricExternalTaskLogDto historicExternalTaskLogDto = (HistoricExternalTaskLogDto) o;
    return Objects.equals(this.id, historicExternalTaskLogDto.id) &&
        Objects.equals(this.externalTaskId, historicExternalTaskLogDto.externalTaskId) &&
        Objects.equals(this.timestamp, historicExternalTaskLogDto.timestamp) &&
        Objects.equals(this.topicName, historicExternalTaskLogDto.topicName) &&
        Objects.equals(this.workerId, historicExternalTaskLogDto.workerId) &&
        Objects.equals(this.retries, historicExternalTaskLogDto.retries) &&
        Objects.equals(this.priority, historicExternalTaskLogDto.priority) &&
        Objects.equals(this.errorMessage, historicExternalTaskLogDto.errorMessage) &&
        Objects.equals(this.activityId, historicExternalTaskLogDto.activityId) &&
        Objects.equals(this.activityInstanceId, historicExternalTaskLogDto.activityInstanceId) &&
        Objects.equals(this.executionId, historicExternalTaskLogDto.executionId) &&
        Objects.equals(this.processInstanceId, historicExternalTaskLogDto.processInstanceId) &&
        Objects.equals(this.processDefinitionId, historicExternalTaskLogDto.processDefinitionId) &&
        Objects.equals(this.processDefinitionKey, historicExternalTaskLogDto.processDefinitionKey) &&
        Objects.equals(this.tenantId, historicExternalTaskLogDto.tenantId) &&
        Objects.equals(this.creationLog, historicExternalTaskLogDto.creationLog) &&
        Objects.equals(this.failureLog, historicExternalTaskLogDto.failureLog) &&
        Objects.equals(this.successLog, historicExternalTaskLogDto.successLog) &&
        Objects.equals(this.deletionLog, historicExternalTaskLogDto.deletionLog) &&
        Objects.equals(this.removalTime, historicExternalTaskLogDto.removalTime) &&
        Objects.equals(this.rootProcessInstanceId, historicExternalTaskLogDto.rootProcessInstanceId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, externalTaskId, timestamp, topicName, workerId, retries, priority, errorMessage, activityId, activityInstanceId, executionId, processInstanceId, processDefinitionId, processDefinitionKey, tenantId, creationLog, failureLog, successLog, deletionLog, removalTime, rootProcessInstanceId);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class HistoricExternalTaskLogDto {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    externalTaskId: ").append(toIndentedString(externalTaskId)).append("\n");
    sb.append("    timestamp: ").append(toIndentedString(timestamp)).append("\n");
    sb.append("    topicName: ").append(toIndentedString(topicName)).append("\n");
    sb.append("    workerId: ").append(toIndentedString(workerId)).append("\n");
    sb.append("    retries: ").append(toIndentedString(retries)).append("\n");
    sb.append("    priority: ").append(toIndentedString(priority)).append("\n");
    sb.append("    errorMessage: ").append(toIndentedString(errorMessage)).append("\n");
    sb.append("    activityId: ").append(toIndentedString(activityId)).append("\n");
    sb.append("    activityInstanceId: ").append(toIndentedString(activityInstanceId)).append("\n");
    sb.append("    executionId: ").append(toIndentedString(executionId)).append("\n");
    sb.append("    processInstanceId: ").append(toIndentedString(processInstanceId)).append("\n");
    sb.append("    processDefinitionId: ").append(toIndentedString(processDefinitionId)).append("\n");
    sb.append("    processDefinitionKey: ").append(toIndentedString(processDefinitionKey)).append("\n");
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("    creationLog: ").append(toIndentedString(creationLog)).append("\n");
    sb.append("    failureLog: ").append(toIndentedString(failureLog)).append("\n");
    sb.append("    successLog: ").append(toIndentedString(successLog)).append("\n");
    sb.append("    deletionLog: ").append(toIndentedString(deletionLog)).append("\n");
    sb.append("    removalTime: ").append(toIndentedString(removalTime)).append("\n");
    sb.append("    rootProcessInstanceId: ").append(toIndentedString(rootProcessInstanceId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

