/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.17.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.camunda.community.rest.client.dto;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.camunda.community.rest.client.dto.HistoricBatchQueryDtoSorting;

/**
 * Query for the historic batches to set the removal time for.
 */
@ApiModel(description = "Query for the historic batches to set the removal time for.")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-07-15T09:20:26.494044Z[Etc/UTC]")
public class HistoricBatchQueryDto {
  public static final String SERIALIZED_NAME_BATCH_ID = "batchId";
  @SerializedName(SERIALIZED_NAME_BATCH_ID)
  private String batchId;

  public static final String SERIALIZED_NAME_TYPE = "type";
  @SerializedName(SERIALIZED_NAME_TYPE)
  private String type;

  public static final String SERIALIZED_NAME_COMPLETED = "completed";
  @SerializedName(SERIALIZED_NAME_COMPLETED)
  private Boolean completed;

  public static final String SERIALIZED_NAME_TENANT_ID_IN = "tenantIdIn";
  @SerializedName(SERIALIZED_NAME_TENANT_ID_IN)
  private List<String> tenantIdIn = null;

  public static final String SERIALIZED_NAME_WITHOUT_TENANT_ID = "withoutTenantId";
  @SerializedName(SERIALIZED_NAME_WITHOUT_TENANT_ID)
  private Boolean withoutTenantId;

  public static final String SERIALIZED_NAME_SORTING = "sorting";
  @SerializedName(SERIALIZED_NAME_SORTING)
  private List<HistoricBatchQueryDtoSorting> sorting = null;


  public HistoricBatchQueryDto batchId(String batchId) {
    
    this.batchId = batchId;
    return this;
  }

   /**
   * Filter by batch id.
   * @return batchId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Filter by batch id.")

  public String getBatchId() {
    return batchId;
  }


  public void setBatchId(String batchId) {
    this.batchId = batchId;
  }


  public HistoricBatchQueryDto type(String type) {
    
    this.type = type;
    return this;
  }

   /**
   * Filter by batch type. See the [User Guide](https://docs.camunda.org/manual/7.17/user-guide/process-engine/batch/#creating-a-batch) for more information about batch types.
   * @return type
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Filter by batch type. See the [User Guide](https://docs.camunda.org/manual/7.17/user-guide/process-engine/batch/#creating-a-batch) for more information about batch types.")

  public String getType() {
    return type;
  }


  public void setType(String type) {
    this.type = type;
  }


  public HistoricBatchQueryDto completed(Boolean completed) {
    
    this.completed = completed;
    return this;
  }

   /**
   *  Filter completed or not completed batches. If the value is &#x60;true&#x60;, only completed batches, i.e., end time is set, are returned. Otherwise, if the value is &#x60;false&#x60;, only running batches, i.e., end time is null, are returned.
   * @return completed
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = " Filter completed or not completed batches. If the value is `true`, only completed batches, i.e., end time is set, are returned. Otherwise, if the value is `false`, only running batches, i.e., end time is null, are returned.")

  public Boolean getCompleted() {
    return completed;
  }


  public void setCompleted(Boolean completed) {
    this.completed = completed;
  }


  public HistoricBatchQueryDto tenantIdIn(List<String> tenantIdIn) {
    
    this.tenantIdIn = tenantIdIn;
    return this;
  }

  public HistoricBatchQueryDto addTenantIdInItem(String tenantIdInItem) {
    if (this.tenantIdIn == null) {
      this.tenantIdIn = new ArrayList<String>();
    }
    this.tenantIdIn.add(tenantIdInItem);
    return this;
  }

   /**
   * Filter by a comma-separated list of tenant ids. A batch matches if it has one of the given tenant ids.
   * @return tenantIdIn
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Filter by a comma-separated list of tenant ids. A batch matches if it has one of the given tenant ids.")

  public List<String> getTenantIdIn() {
    return tenantIdIn;
  }


  public void setTenantIdIn(List<String> tenantIdIn) {
    this.tenantIdIn = tenantIdIn;
  }


  public HistoricBatchQueryDto withoutTenantId(Boolean withoutTenantId) {
    
    this.withoutTenantId = withoutTenantId;
    return this;
  }

   /**
   * Only include batches which belong to no tenant. Value can effectively only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior.
   * @return withoutTenantId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Only include batches which belong to no tenant. Value can effectively only be `true`, as `false` is the default behavior.")

  public Boolean getWithoutTenantId() {
    return withoutTenantId;
  }


  public void setWithoutTenantId(Boolean withoutTenantId) {
    this.withoutTenantId = withoutTenantId;
  }


  public HistoricBatchQueryDto sorting(List<HistoricBatchQueryDtoSorting> sorting) {
    
    this.sorting = sorting;
    return this;
  }

  public HistoricBatchQueryDto addSortingItem(HistoricBatchQueryDtoSorting sortingItem) {
    if (this.sorting == null) {
      this.sorting = new ArrayList<HistoricBatchQueryDtoSorting>();
    }
    this.sorting.add(sortingItem);
    return this;
  }

   /**
   * An array of criteria to sort the result by. Each element of the array is                        an object that specifies one ordering. The position in the array                        identifies the rank of an ordering, i.e., whether it is primary, secondary,                        etc. Has no effect for the &#x60;/count&#x60; endpoint
   * @return sorting
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "An array of criteria to sort the result by. Each element of the array is                        an object that specifies one ordering. The position in the array                        identifies the rank of an ordering, i.e., whether it is primary, secondary,                        etc. Has no effect for the `/count` endpoint")

  public List<HistoricBatchQueryDtoSorting> getSorting() {
    return sorting;
  }


  public void setSorting(List<HistoricBatchQueryDtoSorting> sorting) {
    this.sorting = sorting;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    HistoricBatchQueryDto historicBatchQueryDto = (HistoricBatchQueryDto) o;
    return Objects.equals(this.batchId, historicBatchQueryDto.batchId) &&
        Objects.equals(this.type, historicBatchQueryDto.type) &&
        Objects.equals(this.completed, historicBatchQueryDto.completed) &&
        Objects.equals(this.tenantIdIn, historicBatchQueryDto.tenantIdIn) &&
        Objects.equals(this.withoutTenantId, historicBatchQueryDto.withoutTenantId) &&
        Objects.equals(this.sorting, historicBatchQueryDto.sorting);
  }

  @Override
  public int hashCode() {
    return Objects.hash(batchId, type, completed, tenantIdIn, withoutTenantId, sorting);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class HistoricBatchQueryDto {\n");
    sb.append("    batchId: ").append(toIndentedString(batchId)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    completed: ").append(toIndentedString(completed)).append("\n");
    sb.append("    tenantIdIn: ").append(toIndentedString(tenantIdIn)).append("\n");
    sb.append("    withoutTenantId: ").append(toIndentedString(withoutTenantId)).append("\n");
    sb.append("    sorting: ").append(toIndentedString(sorting)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

