/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.17.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.camunda.community.rest.client.api;

import org.camunda.community.rest.client.invoker.ApiCallback;
import org.camunda.community.rest.client.invoker.ApiClient;
import org.camunda.community.rest.client.invoker.ApiException;
import org.camunda.community.rest.client.invoker.ApiResponse;
import org.camunda.community.rest.client.invoker.Configuration;
import org.camunda.community.rest.client.invoker.Pair;
import org.camunda.community.rest.client.invoker.ProgressRequestBody;
import org.camunda.community.rest.client.invoker.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import org.camunda.community.rest.client.dto.CountResultDto;
import org.camunda.community.rest.client.dto.ExceptionDto;
import java.io.File;
import org.camunda.community.rest.client.dto.HistoricVariableInstanceDto;
import org.camunda.community.rest.client.dto.HistoricVariableInstanceQueryDto;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HistoricVariableInstanceApi {
    private ApiClient localVarApiClient;

    public HistoricVariableInstanceApi() {
        this(Configuration.getDefaultApiClient());
    }

    public HistoricVariableInstanceApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    /**
     * Build call for deleteHistoricVariableInstance
     * @param id The id of the variable instance. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. This method returns no content. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Variable with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteHistoricVariableInstanceCall(String id, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/history/variable-instance/{id}"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call deleteHistoricVariableInstanceValidateBeforeCall(String id, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling deleteHistoricVariableInstance(Async)");
        }
        

        okhttp3.Call localVarCall = deleteHistoricVariableInstanceCall(id, _callback);
        return localVarCall;

    }

    /**
     * Delete Variable Instance
     * Deletes a historic variable instance by id.
     * @param id The id of the variable instance. (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. This method returns no content. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Variable with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public void deleteHistoricVariableInstance(String id) throws ApiException {
        deleteHistoricVariableInstanceWithHttpInfo(id);
    }

    /**
     * Delete Variable Instance
     * Deletes a historic variable instance by id.
     * @param id The id of the variable instance. (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. This method returns no content. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Variable with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> deleteHistoricVariableInstanceWithHttpInfo(String id) throws ApiException {
        okhttp3.Call localVarCall = deleteHistoricVariableInstanceValidateBeforeCall(id, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Delete Variable Instance (asynchronously)
     * Deletes a historic variable instance by id.
     * @param id The id of the variable instance. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> Request successful. This method returns no content. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Variable with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteHistoricVariableInstanceAsync(String id, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = deleteHistoricVariableInstanceValidateBeforeCall(id, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for getHistoricVariableInstance
     * @param id The id of the variable instance. (required)
     * @param deserializeValues Determines whether serializable variable values (typically variables that store custom Java objects) should be deserialized on server side (default &#x60;true&#x60;).  If set to &#x60;true&#x60;, a serializable variable will be deserialized on server side and transformed to JSON using [Jackson&#39;s](https://github.com/FasterXML/jackson) POJO/bean property introspection feature. Note that this requires the Java classes of the variable value to be on the REST API&#39;s classpath.  If set to &#x60;false&#x60;, a serializable variable will be returned in its serialized format. For example, a variable that is serialized as XML will be returned as a JSON string containing XML.  **Note:** While &#x60;true&#x60; is the default value for reasons of backward compatibility, we recommend setting this parameter to &#x60;false&#x60; when developing web applications that are independent of the Java process applications deployed to the engine. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Variable with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getHistoricVariableInstanceCall(String id, Boolean deserializeValues, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/history/variable-instance/{id}"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (deserializeValues != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("deserializeValues", deserializeValues));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getHistoricVariableInstanceValidateBeforeCall(String id, Boolean deserializeValues, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getHistoricVariableInstance(Async)");
        }
        

        okhttp3.Call localVarCall = getHistoricVariableInstanceCall(id, deserializeValues, _callback);
        return localVarCall;

    }

    /**
     * Get Variable Instance
     * Retrieves a historic variable by id.
     * @param id The id of the variable instance. (required)
     * @param deserializeValues Determines whether serializable variable values (typically variables that store custom Java objects) should be deserialized on server side (default &#x60;true&#x60;).  If set to &#x60;true&#x60;, a serializable variable will be deserialized on server side and transformed to JSON using [Jackson&#39;s](https://github.com/FasterXML/jackson) POJO/bean property introspection feature. Note that this requires the Java classes of the variable value to be on the REST API&#39;s classpath.  If set to &#x60;false&#x60;, a serializable variable will be returned in its serialized format. For example, a variable that is serialized as XML will be returned as a JSON string containing XML.  **Note:** While &#x60;true&#x60; is the default value for reasons of backward compatibility, we recommend setting this parameter to &#x60;false&#x60; when developing web applications that are independent of the Java process applications deployed to the engine. (optional)
     * @return HistoricVariableInstanceDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Variable with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public HistoricVariableInstanceDto getHistoricVariableInstance(String id, Boolean deserializeValues) throws ApiException {
        ApiResponse<HistoricVariableInstanceDto> localVarResp = getHistoricVariableInstanceWithHttpInfo(id, deserializeValues);
        return localVarResp.getData();
    }

    /**
     * Get Variable Instance
     * Retrieves a historic variable by id.
     * @param id The id of the variable instance. (required)
     * @param deserializeValues Determines whether serializable variable values (typically variables that store custom Java objects) should be deserialized on server side (default &#x60;true&#x60;).  If set to &#x60;true&#x60;, a serializable variable will be deserialized on server side and transformed to JSON using [Jackson&#39;s](https://github.com/FasterXML/jackson) POJO/bean property introspection feature. Note that this requires the Java classes of the variable value to be on the REST API&#39;s classpath.  If set to &#x60;false&#x60;, a serializable variable will be returned in its serialized format. For example, a variable that is serialized as XML will be returned as a JSON string containing XML.  **Note:** While &#x60;true&#x60; is the default value for reasons of backward compatibility, we recommend setting this parameter to &#x60;false&#x60; when developing web applications that are independent of the Java process applications deployed to the engine. (optional)
     * @return ApiResponse&lt;HistoricVariableInstanceDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Variable with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<HistoricVariableInstanceDto> getHistoricVariableInstanceWithHttpInfo(String id, Boolean deserializeValues) throws ApiException {
        okhttp3.Call localVarCall = getHistoricVariableInstanceValidateBeforeCall(id, deserializeValues, null);
        Type localVarReturnType = new TypeToken<HistoricVariableInstanceDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get Variable Instance (asynchronously)
     * Retrieves a historic variable by id.
     * @param id The id of the variable instance. (required)
     * @param deserializeValues Determines whether serializable variable values (typically variables that store custom Java objects) should be deserialized on server side (default &#x60;true&#x60;).  If set to &#x60;true&#x60;, a serializable variable will be deserialized on server side and transformed to JSON using [Jackson&#39;s](https://github.com/FasterXML/jackson) POJO/bean property introspection feature. Note that this requires the Java classes of the variable value to be on the REST API&#39;s classpath.  If set to &#x60;false&#x60;, a serializable variable will be returned in its serialized format. For example, a variable that is serialized as XML will be returned as a JSON string containing XML.  **Note:** While &#x60;true&#x60; is the default value for reasons of backward compatibility, we recommend setting this parameter to &#x60;false&#x60; when developing web applications that are independent of the Java process applications deployed to the engine. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Variable with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getHistoricVariableInstanceAsync(String id, Boolean deserializeValues, final ApiCallback<HistoricVariableInstanceDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = getHistoricVariableInstanceValidateBeforeCall(id, deserializeValues, _callback);
        Type localVarReturnType = new TypeToken<HistoricVariableInstanceDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getHistoricVariableInstanceBinary
     * @param id The id of the variable instance. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Variable with given id exists but is not a binary variable. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Variable with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getHistoricVariableInstanceBinaryCall(String id, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/history/variable-instance/{id}/data"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/octet-stream", "*/*", "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getHistoricVariableInstanceBinaryValidateBeforeCall(String id, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getHistoricVariableInstanceBinary(Async)");
        }
        

        okhttp3.Call localVarCall = getHistoricVariableInstanceBinaryCall(id, _callback);
        return localVarCall;

    }

    /**
     * Get Variable Instance (Binary)
     * Retrieves the content of a historic variable by id. Applicable for variables that are serialized as binary data.
     * @param id The id of the variable instance. (required)
     * @return File
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Variable with given id exists but is not a binary variable. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Variable with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public File getHistoricVariableInstanceBinary(String id) throws ApiException {
        ApiResponse<File> localVarResp = getHistoricVariableInstanceBinaryWithHttpInfo(id);
        return localVarResp.getData();
    }

    /**
     * Get Variable Instance (Binary)
     * Retrieves the content of a historic variable by id. Applicable for variables that are serialized as binary data.
     * @param id The id of the variable instance. (required)
     * @return ApiResponse&lt;File&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Variable with given id exists but is not a binary variable. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Variable with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<File> getHistoricVariableInstanceBinaryWithHttpInfo(String id) throws ApiException {
        okhttp3.Call localVarCall = getHistoricVariableInstanceBinaryValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get Variable Instance (Binary) (asynchronously)
     * Retrieves the content of a historic variable by id. Applicable for variables that are serialized as binary data.
     * @param id The id of the variable instance. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Variable with given id exists but is not a binary variable. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Variable with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getHistoricVariableInstanceBinaryAsync(String id, final ApiCallback<File> _callback) throws ApiException {

        okhttp3.Call localVarCall = getHistoricVariableInstanceBinaryValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getHistoricVariableInstances
     * @param variableName Filter by variable name. (optional)
     * @param variableNameLike Restrict to variables with a name like the parameter. (optional)
     * @param variableValue Filter by variable value. Is treated as a &#x60;String&#x60; object on server side. (optional)
     * @param variableNamesIgnoreCase Match the variable name provided in &#x60;variableName&#x60; and &#x60;variableNameLike&#x60; case- insensitively. If set to &#x60;true&#x60; **variableName** and **variablename** are treated as equal. (optional)
     * @param variableValuesIgnoreCase Match the variable value provided in &#x60;variableValue&#x60; case-insensitively. If set to &#x60;true&#x60; **variableValue** and **variablevalue** are treated as equal. (optional)
     * @param variableTypeIn Only include historic variable instances which belong to one of the passed and comma- separated variable types. A list of all supported variable types can be found [here](https://docs.camunda.org/manual/7.17/user-guide/process-engine/variables/#supported-variable-values). **Note:** All non-primitive variables are associated with the type &#39;serializable&#39;. (optional)
     * @param includeDeleted Include variables that has already been deleted during the execution. (optional)
     * @param processInstanceId Filter by the process instance the variable belongs to. (optional)
     * @param processInstanceIdIn Only include historic variable instances which belong to one of the passed and comma-separated process instance ids. (optional)
     * @param processDefinitionId Filter by the process definition the variable belongs to. (optional)
     * @param processDefinitionKey Filter by a key of the process definition the variable belongs to. (optional)
     * @param executionIdIn Only include historic variable instances which belong to one of the passed and and comma-separated execution ids. (optional)
     * @param caseInstanceId Filter by the case instance the variable belongs to. (optional)
     * @param caseExecutionIdIn Only include historic variable instances which belong to one of the passed and and comma-separated case execution ids. (optional)
     * @param caseActivityIdIn Only include historic variable instances which belong to one of the passed and and comma-separated case activity ids. (optional)
     * @param taskIdIn Only include historic variable instances which belong to one of the passed and and comma-separated task ids. (optional)
     * @param activityInstanceIdIn Only include historic variable instances which belong to one of the passed and and comma-separated activity instance ids. (optional)
     * @param tenantIdIn Only include historic variable instances which belong to one of the passed and comma- separated tenant ids. (optional)
     * @param withoutTenantId Only include historic variable instances that belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param variableNameIn Only include historic variable instances which belong to one of the passed and comma-separated variable names. (optional)
     * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
     * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @param deserializeValues Determines whether serializable variable values (typically variables that store custom Java objects) should be deserialized on server side (default &#x60;true&#x60;).  If set to &#x60;true&#x60;, a serializable variable will be deserialized on server side and transformed to JSON using [Jackson&#39;s](https://github.com/FasterXML/jackson) POJO/bean property introspection feature. Note that this requires the Java classes of the variable value to be on the REST API&#39;s classpath.  If set to &#x60;false&#x60;, a serializable variable will be returned in its serialized format. For example, a variable that is serialized as XML will be returned as a JSON string containing XML.  **Note:** While &#x60;true&#x60; is the default value for reasons of backward compatibility, we recommend setting this parameter to &#x60;false&#x60; when developing web applications that are independent of the Java process applications deployed to the engine. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if a &#x60;sortOrder&#x60; parameter is supplied, but no &#x60;sortBy&#x60;. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getHistoricVariableInstancesCall(String variableName, String variableNameLike, Object variableValue, Boolean variableNamesIgnoreCase, Boolean variableValuesIgnoreCase, String variableTypeIn, Boolean includeDeleted, String processInstanceId, String processInstanceIdIn, String processDefinitionId, String processDefinitionKey, String executionIdIn, String caseInstanceId, String caseExecutionIdIn, String caseActivityIdIn, String taskIdIn, String activityInstanceIdIn, String tenantIdIn, Boolean withoutTenantId, String variableNameIn, String sortBy, String sortOrder, Integer firstResult, Integer maxResults, Boolean deserializeValues, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/history/variable-instance";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (variableName != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("variableName", variableName));
        }

        if (variableNameLike != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("variableNameLike", variableNameLike));
        }

        if (variableValue != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("variableValue", variableValue));
        }

        if (variableNamesIgnoreCase != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("variableNamesIgnoreCase", variableNamesIgnoreCase));
        }

        if (variableValuesIgnoreCase != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("variableValuesIgnoreCase", variableValuesIgnoreCase));
        }

        if (variableTypeIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("variableTypeIn", variableTypeIn));
        }

        if (includeDeleted != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("includeDeleted", includeDeleted));
        }

        if (processInstanceId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("processInstanceId", processInstanceId));
        }

        if (processInstanceIdIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("processInstanceIdIn", processInstanceIdIn));
        }

        if (processDefinitionId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("processDefinitionId", processDefinitionId));
        }

        if (processDefinitionKey != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("processDefinitionKey", processDefinitionKey));
        }

        if (executionIdIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("executionIdIn", executionIdIn));
        }

        if (caseInstanceId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("caseInstanceId", caseInstanceId));
        }

        if (caseExecutionIdIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("caseExecutionIdIn", caseExecutionIdIn));
        }

        if (caseActivityIdIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("caseActivityIdIn", caseActivityIdIn));
        }

        if (taskIdIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("taskIdIn", taskIdIn));
        }

        if (activityInstanceIdIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("activityInstanceIdIn", activityInstanceIdIn));
        }

        if (tenantIdIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("tenantIdIn", tenantIdIn));
        }

        if (withoutTenantId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("withoutTenantId", withoutTenantId));
        }

        if (variableNameIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("variableNameIn", variableNameIn));
        }

        if (sortBy != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("sortBy", sortBy));
        }

        if (sortOrder != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("sortOrder", sortOrder));
        }

        if (firstResult != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("firstResult", firstResult));
        }

        if (maxResults != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("maxResults", maxResults));
        }

        if (deserializeValues != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("deserializeValues", deserializeValues));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getHistoricVariableInstancesValidateBeforeCall(String variableName, String variableNameLike, Object variableValue, Boolean variableNamesIgnoreCase, Boolean variableValuesIgnoreCase, String variableTypeIn, Boolean includeDeleted, String processInstanceId, String processInstanceIdIn, String processDefinitionId, String processDefinitionKey, String executionIdIn, String caseInstanceId, String caseExecutionIdIn, String caseActivityIdIn, String taskIdIn, String activityInstanceIdIn, String tenantIdIn, Boolean withoutTenantId, String variableNameIn, String sortBy, String sortOrder, Integer firstResult, Integer maxResults, Boolean deserializeValues, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = getHistoricVariableInstancesCall(variableName, variableNameLike, variableValue, variableNamesIgnoreCase, variableValuesIgnoreCase, variableTypeIn, includeDeleted, processInstanceId, processInstanceIdIn, processDefinitionId, processDefinitionKey, executionIdIn, caseInstanceId, caseExecutionIdIn, caseActivityIdIn, taskIdIn, activityInstanceIdIn, tenantIdIn, withoutTenantId, variableNameIn, sortBy, sortOrder, firstResult, maxResults, deserializeValues, _callback);
        return localVarCall;

    }

    /**
     * Get Variable Instances
     * Queries for historic variable instances that fulfill the given parameters. The size of the result set can be retrieved by using the [Get Variable Instance Count](https://docs.camunda.org/manual/7.17/reference/rest/history/variable-instance/get-variable-instance-query-count/) method.
     * @param variableName Filter by variable name. (optional)
     * @param variableNameLike Restrict to variables with a name like the parameter. (optional)
     * @param variableValue Filter by variable value. Is treated as a &#x60;String&#x60; object on server side. (optional)
     * @param variableNamesIgnoreCase Match the variable name provided in &#x60;variableName&#x60; and &#x60;variableNameLike&#x60; case- insensitively. If set to &#x60;true&#x60; **variableName** and **variablename** are treated as equal. (optional)
     * @param variableValuesIgnoreCase Match the variable value provided in &#x60;variableValue&#x60; case-insensitively. If set to &#x60;true&#x60; **variableValue** and **variablevalue** are treated as equal. (optional)
     * @param variableTypeIn Only include historic variable instances which belong to one of the passed and comma- separated variable types. A list of all supported variable types can be found [here](https://docs.camunda.org/manual/7.17/user-guide/process-engine/variables/#supported-variable-values). **Note:** All non-primitive variables are associated with the type &#39;serializable&#39;. (optional)
     * @param includeDeleted Include variables that has already been deleted during the execution. (optional)
     * @param processInstanceId Filter by the process instance the variable belongs to. (optional)
     * @param processInstanceIdIn Only include historic variable instances which belong to one of the passed and comma-separated process instance ids. (optional)
     * @param processDefinitionId Filter by the process definition the variable belongs to. (optional)
     * @param processDefinitionKey Filter by a key of the process definition the variable belongs to. (optional)
     * @param executionIdIn Only include historic variable instances which belong to one of the passed and and comma-separated execution ids. (optional)
     * @param caseInstanceId Filter by the case instance the variable belongs to. (optional)
     * @param caseExecutionIdIn Only include historic variable instances which belong to one of the passed and and comma-separated case execution ids. (optional)
     * @param caseActivityIdIn Only include historic variable instances which belong to one of the passed and and comma-separated case activity ids. (optional)
     * @param taskIdIn Only include historic variable instances which belong to one of the passed and and comma-separated task ids. (optional)
     * @param activityInstanceIdIn Only include historic variable instances which belong to one of the passed and and comma-separated activity instance ids. (optional)
     * @param tenantIdIn Only include historic variable instances which belong to one of the passed and comma- separated tenant ids. (optional)
     * @param withoutTenantId Only include historic variable instances that belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param variableNameIn Only include historic variable instances which belong to one of the passed and comma-separated variable names. (optional)
     * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
     * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @param deserializeValues Determines whether serializable variable values (typically variables that store custom Java objects) should be deserialized on server side (default &#x60;true&#x60;).  If set to &#x60;true&#x60;, a serializable variable will be deserialized on server side and transformed to JSON using [Jackson&#39;s](https://github.com/FasterXML/jackson) POJO/bean property introspection feature. Note that this requires the Java classes of the variable value to be on the REST API&#39;s classpath.  If set to &#x60;false&#x60;, a serializable variable will be returned in its serialized format. For example, a variable that is serialized as XML will be returned as a JSON string containing XML.  **Note:** While &#x60;true&#x60; is the default value for reasons of backward compatibility, we recommend setting this parameter to &#x60;false&#x60; when developing web applications that are independent of the Java process applications deployed to the engine. (optional)
     * @return List&lt;HistoricVariableInstanceDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if a &#x60;sortOrder&#x60; parameter is supplied, but no &#x60;sortBy&#x60;. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public List<HistoricVariableInstanceDto> getHistoricVariableInstances(String variableName, String variableNameLike, Object variableValue, Boolean variableNamesIgnoreCase, Boolean variableValuesIgnoreCase, String variableTypeIn, Boolean includeDeleted, String processInstanceId, String processInstanceIdIn, String processDefinitionId, String processDefinitionKey, String executionIdIn, String caseInstanceId, String caseExecutionIdIn, String caseActivityIdIn, String taskIdIn, String activityInstanceIdIn, String tenantIdIn, Boolean withoutTenantId, String variableNameIn, String sortBy, String sortOrder, Integer firstResult, Integer maxResults, Boolean deserializeValues) throws ApiException {
        ApiResponse<List<HistoricVariableInstanceDto>> localVarResp = getHistoricVariableInstancesWithHttpInfo(variableName, variableNameLike, variableValue, variableNamesIgnoreCase, variableValuesIgnoreCase, variableTypeIn, includeDeleted, processInstanceId, processInstanceIdIn, processDefinitionId, processDefinitionKey, executionIdIn, caseInstanceId, caseExecutionIdIn, caseActivityIdIn, taskIdIn, activityInstanceIdIn, tenantIdIn, withoutTenantId, variableNameIn, sortBy, sortOrder, firstResult, maxResults, deserializeValues);
        return localVarResp.getData();
    }

    /**
     * Get Variable Instances
     * Queries for historic variable instances that fulfill the given parameters. The size of the result set can be retrieved by using the [Get Variable Instance Count](https://docs.camunda.org/manual/7.17/reference/rest/history/variable-instance/get-variable-instance-query-count/) method.
     * @param variableName Filter by variable name. (optional)
     * @param variableNameLike Restrict to variables with a name like the parameter. (optional)
     * @param variableValue Filter by variable value. Is treated as a &#x60;String&#x60; object on server side. (optional)
     * @param variableNamesIgnoreCase Match the variable name provided in &#x60;variableName&#x60; and &#x60;variableNameLike&#x60; case- insensitively. If set to &#x60;true&#x60; **variableName** and **variablename** are treated as equal. (optional)
     * @param variableValuesIgnoreCase Match the variable value provided in &#x60;variableValue&#x60; case-insensitively. If set to &#x60;true&#x60; **variableValue** and **variablevalue** are treated as equal. (optional)
     * @param variableTypeIn Only include historic variable instances which belong to one of the passed and comma- separated variable types. A list of all supported variable types can be found [here](https://docs.camunda.org/manual/7.17/user-guide/process-engine/variables/#supported-variable-values). **Note:** All non-primitive variables are associated with the type &#39;serializable&#39;. (optional)
     * @param includeDeleted Include variables that has already been deleted during the execution. (optional)
     * @param processInstanceId Filter by the process instance the variable belongs to. (optional)
     * @param processInstanceIdIn Only include historic variable instances which belong to one of the passed and comma-separated process instance ids. (optional)
     * @param processDefinitionId Filter by the process definition the variable belongs to. (optional)
     * @param processDefinitionKey Filter by a key of the process definition the variable belongs to. (optional)
     * @param executionIdIn Only include historic variable instances which belong to one of the passed and and comma-separated execution ids. (optional)
     * @param caseInstanceId Filter by the case instance the variable belongs to. (optional)
     * @param caseExecutionIdIn Only include historic variable instances which belong to one of the passed and and comma-separated case execution ids. (optional)
     * @param caseActivityIdIn Only include historic variable instances which belong to one of the passed and and comma-separated case activity ids. (optional)
     * @param taskIdIn Only include historic variable instances which belong to one of the passed and and comma-separated task ids. (optional)
     * @param activityInstanceIdIn Only include historic variable instances which belong to one of the passed and and comma-separated activity instance ids. (optional)
     * @param tenantIdIn Only include historic variable instances which belong to one of the passed and comma- separated tenant ids. (optional)
     * @param withoutTenantId Only include historic variable instances that belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param variableNameIn Only include historic variable instances which belong to one of the passed and comma-separated variable names. (optional)
     * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
     * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @param deserializeValues Determines whether serializable variable values (typically variables that store custom Java objects) should be deserialized on server side (default &#x60;true&#x60;).  If set to &#x60;true&#x60;, a serializable variable will be deserialized on server side and transformed to JSON using [Jackson&#39;s](https://github.com/FasterXML/jackson) POJO/bean property introspection feature. Note that this requires the Java classes of the variable value to be on the REST API&#39;s classpath.  If set to &#x60;false&#x60;, a serializable variable will be returned in its serialized format. For example, a variable that is serialized as XML will be returned as a JSON string containing XML.  **Note:** While &#x60;true&#x60; is the default value for reasons of backward compatibility, we recommend setting this parameter to &#x60;false&#x60; when developing web applications that are independent of the Java process applications deployed to the engine. (optional)
     * @return ApiResponse&lt;List&lt;HistoricVariableInstanceDto&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if a &#x60;sortOrder&#x60; parameter is supplied, but no &#x60;sortBy&#x60;. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<HistoricVariableInstanceDto>> getHistoricVariableInstancesWithHttpInfo(String variableName, String variableNameLike, Object variableValue, Boolean variableNamesIgnoreCase, Boolean variableValuesIgnoreCase, String variableTypeIn, Boolean includeDeleted, String processInstanceId, String processInstanceIdIn, String processDefinitionId, String processDefinitionKey, String executionIdIn, String caseInstanceId, String caseExecutionIdIn, String caseActivityIdIn, String taskIdIn, String activityInstanceIdIn, String tenantIdIn, Boolean withoutTenantId, String variableNameIn, String sortBy, String sortOrder, Integer firstResult, Integer maxResults, Boolean deserializeValues) throws ApiException {
        okhttp3.Call localVarCall = getHistoricVariableInstancesValidateBeforeCall(variableName, variableNameLike, variableValue, variableNamesIgnoreCase, variableValuesIgnoreCase, variableTypeIn, includeDeleted, processInstanceId, processInstanceIdIn, processDefinitionId, processDefinitionKey, executionIdIn, caseInstanceId, caseExecutionIdIn, caseActivityIdIn, taskIdIn, activityInstanceIdIn, tenantIdIn, withoutTenantId, variableNameIn, sortBy, sortOrder, firstResult, maxResults, deserializeValues, null);
        Type localVarReturnType = new TypeToken<List<HistoricVariableInstanceDto>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get Variable Instances (asynchronously)
     * Queries for historic variable instances that fulfill the given parameters. The size of the result set can be retrieved by using the [Get Variable Instance Count](https://docs.camunda.org/manual/7.17/reference/rest/history/variable-instance/get-variable-instance-query-count/) method.
     * @param variableName Filter by variable name. (optional)
     * @param variableNameLike Restrict to variables with a name like the parameter. (optional)
     * @param variableValue Filter by variable value. Is treated as a &#x60;String&#x60; object on server side. (optional)
     * @param variableNamesIgnoreCase Match the variable name provided in &#x60;variableName&#x60; and &#x60;variableNameLike&#x60; case- insensitively. If set to &#x60;true&#x60; **variableName** and **variablename** are treated as equal. (optional)
     * @param variableValuesIgnoreCase Match the variable value provided in &#x60;variableValue&#x60; case-insensitively. If set to &#x60;true&#x60; **variableValue** and **variablevalue** are treated as equal. (optional)
     * @param variableTypeIn Only include historic variable instances which belong to one of the passed and comma- separated variable types. A list of all supported variable types can be found [here](https://docs.camunda.org/manual/7.17/user-guide/process-engine/variables/#supported-variable-values). **Note:** All non-primitive variables are associated with the type &#39;serializable&#39;. (optional)
     * @param includeDeleted Include variables that has already been deleted during the execution. (optional)
     * @param processInstanceId Filter by the process instance the variable belongs to. (optional)
     * @param processInstanceIdIn Only include historic variable instances which belong to one of the passed and comma-separated process instance ids. (optional)
     * @param processDefinitionId Filter by the process definition the variable belongs to. (optional)
     * @param processDefinitionKey Filter by a key of the process definition the variable belongs to. (optional)
     * @param executionIdIn Only include historic variable instances which belong to one of the passed and and comma-separated execution ids. (optional)
     * @param caseInstanceId Filter by the case instance the variable belongs to. (optional)
     * @param caseExecutionIdIn Only include historic variable instances which belong to one of the passed and and comma-separated case execution ids. (optional)
     * @param caseActivityIdIn Only include historic variable instances which belong to one of the passed and and comma-separated case activity ids. (optional)
     * @param taskIdIn Only include historic variable instances which belong to one of the passed and and comma-separated task ids. (optional)
     * @param activityInstanceIdIn Only include historic variable instances which belong to one of the passed and and comma-separated activity instance ids. (optional)
     * @param tenantIdIn Only include historic variable instances which belong to one of the passed and comma- separated tenant ids. (optional)
     * @param withoutTenantId Only include historic variable instances that belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param variableNameIn Only include historic variable instances which belong to one of the passed and comma-separated variable names. (optional)
     * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
     * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @param deserializeValues Determines whether serializable variable values (typically variables that store custom Java objects) should be deserialized on server side (default &#x60;true&#x60;).  If set to &#x60;true&#x60;, a serializable variable will be deserialized on server side and transformed to JSON using [Jackson&#39;s](https://github.com/FasterXML/jackson) POJO/bean property introspection feature. Note that this requires the Java classes of the variable value to be on the REST API&#39;s classpath.  If set to &#x60;false&#x60;, a serializable variable will be returned in its serialized format. For example, a variable that is serialized as XML will be returned as a JSON string containing XML.  **Note:** While &#x60;true&#x60; is the default value for reasons of backward compatibility, we recommend setting this parameter to &#x60;false&#x60; when developing web applications that are independent of the Java process applications deployed to the engine. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if a &#x60;sortOrder&#x60; parameter is supplied, but no &#x60;sortBy&#x60;. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getHistoricVariableInstancesAsync(String variableName, String variableNameLike, Object variableValue, Boolean variableNamesIgnoreCase, Boolean variableValuesIgnoreCase, String variableTypeIn, Boolean includeDeleted, String processInstanceId, String processInstanceIdIn, String processDefinitionId, String processDefinitionKey, String executionIdIn, String caseInstanceId, String caseExecutionIdIn, String caseActivityIdIn, String taskIdIn, String activityInstanceIdIn, String tenantIdIn, Boolean withoutTenantId, String variableNameIn, String sortBy, String sortOrder, Integer firstResult, Integer maxResults, Boolean deserializeValues, final ApiCallback<List<HistoricVariableInstanceDto>> _callback) throws ApiException {

        okhttp3.Call localVarCall = getHistoricVariableInstancesValidateBeforeCall(variableName, variableNameLike, variableValue, variableNamesIgnoreCase, variableValuesIgnoreCase, variableTypeIn, includeDeleted, processInstanceId, processInstanceIdIn, processDefinitionId, processDefinitionKey, executionIdIn, caseInstanceId, caseExecutionIdIn, caseActivityIdIn, taskIdIn, activityInstanceIdIn, tenantIdIn, withoutTenantId, variableNameIn, sortBy, sortOrder, firstResult, maxResults, deserializeValues, _callback);
        Type localVarReturnType = new TypeToken<List<HistoricVariableInstanceDto>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getHistoricVariableInstancesCount
     * @param variableName Filter by variable name. (optional)
     * @param variableNameLike Restrict to variables with a name like the parameter. (optional)
     * @param variableValue Filter by variable value. Is treated as a &#x60;String&#x60; object on server side. (optional)
     * @param variableNamesIgnoreCase Match the variable name provided in &#x60;variableName&#x60; and &#x60;variableNameLike&#x60; case- insensitively. If set to &#x60;true&#x60; **variableName** and **variablename** are treated as equal. (optional)
     * @param variableValuesIgnoreCase Match the variable value provided in &#x60;variableValue&#x60; case-insensitively. If set to &#x60;true&#x60; **variableValue** and **variablevalue** are treated as equal. (optional)
     * @param variableTypeIn Only include historic variable instances which belong to one of the passed and comma- separated variable types. A list of all supported variable types can be found [here](https://docs.camunda.org/manual/7.17/user-guide/process-engine/variables/#supported-variable-values). **Note:** All non-primitive variables are associated with the type &#39;serializable&#39;. (optional)
     * @param includeDeleted Include variables that has already been deleted during the execution. (optional)
     * @param processInstanceId Filter by the process instance the variable belongs to. (optional)
     * @param processInstanceIdIn Only include historic variable instances which belong to one of the passed and comma-separated process instance ids. (optional)
     * @param processDefinitionId Filter by the process definition the variable belongs to. (optional)
     * @param processDefinitionKey Filter by a key of the process definition the variable belongs to. (optional)
     * @param executionIdIn Only include historic variable instances which belong to one of the passed and and comma-separated execution ids. (optional)
     * @param caseInstanceId Filter by the case instance the variable belongs to. (optional)
     * @param caseExecutionIdIn Only include historic variable instances which belong to one of the passed and and comma-separated case execution ids. (optional)
     * @param caseActivityIdIn Only include historic variable instances which belong to one of the passed and and comma-separated case activity ids. (optional)
     * @param taskIdIn Only include historic variable instances which belong to one of the passed and and comma-separated task ids. (optional)
     * @param activityInstanceIdIn Only include historic variable instances which belong to one of the passed and and comma-separated activity instance ids. (optional)
     * @param tenantIdIn Only include historic variable instances which belong to one of the passed and comma- separated tenant ids. (optional)
     * @param withoutTenantId Only include historic variable instances that belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param variableNameIn Only include historic variable instances which belong to one of the passed and comma-separated variable names. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getHistoricVariableInstancesCountCall(String variableName, String variableNameLike, Object variableValue, Boolean variableNamesIgnoreCase, Boolean variableValuesIgnoreCase, String variableTypeIn, Boolean includeDeleted, String processInstanceId, String processInstanceIdIn, String processDefinitionId, String processDefinitionKey, String executionIdIn, String caseInstanceId, String caseExecutionIdIn, String caseActivityIdIn, String taskIdIn, String activityInstanceIdIn, String tenantIdIn, Boolean withoutTenantId, String variableNameIn, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/history/variable-instance/count";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (variableName != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("variableName", variableName));
        }

        if (variableNameLike != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("variableNameLike", variableNameLike));
        }

        if (variableValue != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("variableValue", variableValue));
        }

        if (variableNamesIgnoreCase != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("variableNamesIgnoreCase", variableNamesIgnoreCase));
        }

        if (variableValuesIgnoreCase != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("variableValuesIgnoreCase", variableValuesIgnoreCase));
        }

        if (variableTypeIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("variableTypeIn", variableTypeIn));
        }

        if (includeDeleted != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("includeDeleted", includeDeleted));
        }

        if (processInstanceId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("processInstanceId", processInstanceId));
        }

        if (processInstanceIdIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("processInstanceIdIn", processInstanceIdIn));
        }

        if (processDefinitionId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("processDefinitionId", processDefinitionId));
        }

        if (processDefinitionKey != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("processDefinitionKey", processDefinitionKey));
        }

        if (executionIdIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("executionIdIn", executionIdIn));
        }

        if (caseInstanceId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("caseInstanceId", caseInstanceId));
        }

        if (caseExecutionIdIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("caseExecutionIdIn", caseExecutionIdIn));
        }

        if (caseActivityIdIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("caseActivityIdIn", caseActivityIdIn));
        }

        if (taskIdIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("taskIdIn", taskIdIn));
        }

        if (activityInstanceIdIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("activityInstanceIdIn", activityInstanceIdIn));
        }

        if (tenantIdIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("tenantIdIn", tenantIdIn));
        }

        if (withoutTenantId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("withoutTenantId", withoutTenantId));
        }

        if (variableNameIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("variableNameIn", variableNameIn));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getHistoricVariableInstancesCountValidateBeforeCall(String variableName, String variableNameLike, Object variableValue, Boolean variableNamesIgnoreCase, Boolean variableValuesIgnoreCase, String variableTypeIn, Boolean includeDeleted, String processInstanceId, String processInstanceIdIn, String processDefinitionId, String processDefinitionKey, String executionIdIn, String caseInstanceId, String caseExecutionIdIn, String caseActivityIdIn, String taskIdIn, String activityInstanceIdIn, String tenantIdIn, Boolean withoutTenantId, String variableNameIn, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = getHistoricVariableInstancesCountCall(variableName, variableNameLike, variableValue, variableNamesIgnoreCase, variableValuesIgnoreCase, variableTypeIn, includeDeleted, processInstanceId, processInstanceIdIn, processDefinitionId, processDefinitionKey, executionIdIn, caseInstanceId, caseExecutionIdIn, caseActivityIdIn, taskIdIn, activityInstanceIdIn, tenantIdIn, withoutTenantId, variableNameIn, _callback);
        return localVarCall;

    }

    /**
     * Get Variable Instance Count
     * Queries for the number of historic variable instances that fulfill the given parameters. Takes the same parameters as the [Get Variable Instances](https://docs.camunda.org/manual/7.17/reference/rest/history/variable-instance/get-variable-instance-query/) method.
     * @param variableName Filter by variable name. (optional)
     * @param variableNameLike Restrict to variables with a name like the parameter. (optional)
     * @param variableValue Filter by variable value. Is treated as a &#x60;String&#x60; object on server side. (optional)
     * @param variableNamesIgnoreCase Match the variable name provided in &#x60;variableName&#x60; and &#x60;variableNameLike&#x60; case- insensitively. If set to &#x60;true&#x60; **variableName** and **variablename** are treated as equal. (optional)
     * @param variableValuesIgnoreCase Match the variable value provided in &#x60;variableValue&#x60; case-insensitively. If set to &#x60;true&#x60; **variableValue** and **variablevalue** are treated as equal. (optional)
     * @param variableTypeIn Only include historic variable instances which belong to one of the passed and comma- separated variable types. A list of all supported variable types can be found [here](https://docs.camunda.org/manual/7.17/user-guide/process-engine/variables/#supported-variable-values). **Note:** All non-primitive variables are associated with the type &#39;serializable&#39;. (optional)
     * @param includeDeleted Include variables that has already been deleted during the execution. (optional)
     * @param processInstanceId Filter by the process instance the variable belongs to. (optional)
     * @param processInstanceIdIn Only include historic variable instances which belong to one of the passed and comma-separated process instance ids. (optional)
     * @param processDefinitionId Filter by the process definition the variable belongs to. (optional)
     * @param processDefinitionKey Filter by a key of the process definition the variable belongs to. (optional)
     * @param executionIdIn Only include historic variable instances which belong to one of the passed and and comma-separated execution ids. (optional)
     * @param caseInstanceId Filter by the case instance the variable belongs to. (optional)
     * @param caseExecutionIdIn Only include historic variable instances which belong to one of the passed and and comma-separated case execution ids. (optional)
     * @param caseActivityIdIn Only include historic variable instances which belong to one of the passed and and comma-separated case activity ids. (optional)
     * @param taskIdIn Only include historic variable instances which belong to one of the passed and and comma-separated task ids. (optional)
     * @param activityInstanceIdIn Only include historic variable instances which belong to one of the passed and and comma-separated activity instance ids. (optional)
     * @param tenantIdIn Only include historic variable instances which belong to one of the passed and comma- separated tenant ids. (optional)
     * @param withoutTenantId Only include historic variable instances that belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param variableNameIn Only include historic variable instances which belong to one of the passed and comma-separated variable names. (optional)
     * @return CountResultDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public CountResultDto getHistoricVariableInstancesCount(String variableName, String variableNameLike, Object variableValue, Boolean variableNamesIgnoreCase, Boolean variableValuesIgnoreCase, String variableTypeIn, Boolean includeDeleted, String processInstanceId, String processInstanceIdIn, String processDefinitionId, String processDefinitionKey, String executionIdIn, String caseInstanceId, String caseExecutionIdIn, String caseActivityIdIn, String taskIdIn, String activityInstanceIdIn, String tenantIdIn, Boolean withoutTenantId, String variableNameIn) throws ApiException {
        ApiResponse<CountResultDto> localVarResp = getHistoricVariableInstancesCountWithHttpInfo(variableName, variableNameLike, variableValue, variableNamesIgnoreCase, variableValuesIgnoreCase, variableTypeIn, includeDeleted, processInstanceId, processInstanceIdIn, processDefinitionId, processDefinitionKey, executionIdIn, caseInstanceId, caseExecutionIdIn, caseActivityIdIn, taskIdIn, activityInstanceIdIn, tenantIdIn, withoutTenantId, variableNameIn);
        return localVarResp.getData();
    }

    /**
     * Get Variable Instance Count
     * Queries for the number of historic variable instances that fulfill the given parameters. Takes the same parameters as the [Get Variable Instances](https://docs.camunda.org/manual/7.17/reference/rest/history/variable-instance/get-variable-instance-query/) method.
     * @param variableName Filter by variable name. (optional)
     * @param variableNameLike Restrict to variables with a name like the parameter. (optional)
     * @param variableValue Filter by variable value. Is treated as a &#x60;String&#x60; object on server side. (optional)
     * @param variableNamesIgnoreCase Match the variable name provided in &#x60;variableName&#x60; and &#x60;variableNameLike&#x60; case- insensitively. If set to &#x60;true&#x60; **variableName** and **variablename** are treated as equal. (optional)
     * @param variableValuesIgnoreCase Match the variable value provided in &#x60;variableValue&#x60; case-insensitively. If set to &#x60;true&#x60; **variableValue** and **variablevalue** are treated as equal. (optional)
     * @param variableTypeIn Only include historic variable instances which belong to one of the passed and comma- separated variable types. A list of all supported variable types can be found [here](https://docs.camunda.org/manual/7.17/user-guide/process-engine/variables/#supported-variable-values). **Note:** All non-primitive variables are associated with the type &#39;serializable&#39;. (optional)
     * @param includeDeleted Include variables that has already been deleted during the execution. (optional)
     * @param processInstanceId Filter by the process instance the variable belongs to. (optional)
     * @param processInstanceIdIn Only include historic variable instances which belong to one of the passed and comma-separated process instance ids. (optional)
     * @param processDefinitionId Filter by the process definition the variable belongs to. (optional)
     * @param processDefinitionKey Filter by a key of the process definition the variable belongs to. (optional)
     * @param executionIdIn Only include historic variable instances which belong to one of the passed and and comma-separated execution ids. (optional)
     * @param caseInstanceId Filter by the case instance the variable belongs to. (optional)
     * @param caseExecutionIdIn Only include historic variable instances which belong to one of the passed and and comma-separated case execution ids. (optional)
     * @param caseActivityIdIn Only include historic variable instances which belong to one of the passed and and comma-separated case activity ids. (optional)
     * @param taskIdIn Only include historic variable instances which belong to one of the passed and and comma-separated task ids. (optional)
     * @param activityInstanceIdIn Only include historic variable instances which belong to one of the passed and and comma-separated activity instance ids. (optional)
     * @param tenantIdIn Only include historic variable instances which belong to one of the passed and comma- separated tenant ids. (optional)
     * @param withoutTenantId Only include historic variable instances that belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param variableNameIn Only include historic variable instances which belong to one of the passed and comma-separated variable names. (optional)
     * @return ApiResponse&lt;CountResultDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<CountResultDto> getHistoricVariableInstancesCountWithHttpInfo(String variableName, String variableNameLike, Object variableValue, Boolean variableNamesIgnoreCase, Boolean variableValuesIgnoreCase, String variableTypeIn, Boolean includeDeleted, String processInstanceId, String processInstanceIdIn, String processDefinitionId, String processDefinitionKey, String executionIdIn, String caseInstanceId, String caseExecutionIdIn, String caseActivityIdIn, String taskIdIn, String activityInstanceIdIn, String tenantIdIn, Boolean withoutTenantId, String variableNameIn) throws ApiException {
        okhttp3.Call localVarCall = getHistoricVariableInstancesCountValidateBeforeCall(variableName, variableNameLike, variableValue, variableNamesIgnoreCase, variableValuesIgnoreCase, variableTypeIn, includeDeleted, processInstanceId, processInstanceIdIn, processDefinitionId, processDefinitionKey, executionIdIn, caseInstanceId, caseExecutionIdIn, caseActivityIdIn, taskIdIn, activityInstanceIdIn, tenantIdIn, withoutTenantId, variableNameIn, null);
        Type localVarReturnType = new TypeToken<CountResultDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get Variable Instance Count (asynchronously)
     * Queries for the number of historic variable instances that fulfill the given parameters. Takes the same parameters as the [Get Variable Instances](https://docs.camunda.org/manual/7.17/reference/rest/history/variable-instance/get-variable-instance-query/) method.
     * @param variableName Filter by variable name. (optional)
     * @param variableNameLike Restrict to variables with a name like the parameter. (optional)
     * @param variableValue Filter by variable value. Is treated as a &#x60;String&#x60; object on server side. (optional)
     * @param variableNamesIgnoreCase Match the variable name provided in &#x60;variableName&#x60; and &#x60;variableNameLike&#x60; case- insensitively. If set to &#x60;true&#x60; **variableName** and **variablename** are treated as equal. (optional)
     * @param variableValuesIgnoreCase Match the variable value provided in &#x60;variableValue&#x60; case-insensitively. If set to &#x60;true&#x60; **variableValue** and **variablevalue** are treated as equal. (optional)
     * @param variableTypeIn Only include historic variable instances which belong to one of the passed and comma- separated variable types. A list of all supported variable types can be found [here](https://docs.camunda.org/manual/7.17/user-guide/process-engine/variables/#supported-variable-values). **Note:** All non-primitive variables are associated with the type &#39;serializable&#39;. (optional)
     * @param includeDeleted Include variables that has already been deleted during the execution. (optional)
     * @param processInstanceId Filter by the process instance the variable belongs to. (optional)
     * @param processInstanceIdIn Only include historic variable instances which belong to one of the passed and comma-separated process instance ids. (optional)
     * @param processDefinitionId Filter by the process definition the variable belongs to. (optional)
     * @param processDefinitionKey Filter by a key of the process definition the variable belongs to. (optional)
     * @param executionIdIn Only include historic variable instances which belong to one of the passed and and comma-separated execution ids. (optional)
     * @param caseInstanceId Filter by the case instance the variable belongs to. (optional)
     * @param caseExecutionIdIn Only include historic variable instances which belong to one of the passed and and comma-separated case execution ids. (optional)
     * @param caseActivityIdIn Only include historic variable instances which belong to one of the passed and and comma-separated case activity ids. (optional)
     * @param taskIdIn Only include historic variable instances which belong to one of the passed and and comma-separated task ids. (optional)
     * @param activityInstanceIdIn Only include historic variable instances which belong to one of the passed and and comma-separated activity instance ids. (optional)
     * @param tenantIdIn Only include historic variable instances which belong to one of the passed and comma- separated tenant ids. (optional)
     * @param withoutTenantId Only include historic variable instances that belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param variableNameIn Only include historic variable instances which belong to one of the passed and comma-separated variable names. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getHistoricVariableInstancesCountAsync(String variableName, String variableNameLike, Object variableValue, Boolean variableNamesIgnoreCase, Boolean variableValuesIgnoreCase, String variableTypeIn, Boolean includeDeleted, String processInstanceId, String processInstanceIdIn, String processDefinitionId, String processDefinitionKey, String executionIdIn, String caseInstanceId, String caseExecutionIdIn, String caseActivityIdIn, String taskIdIn, String activityInstanceIdIn, String tenantIdIn, Boolean withoutTenantId, String variableNameIn, final ApiCallback<CountResultDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = getHistoricVariableInstancesCountValidateBeforeCall(variableName, variableNameLike, variableValue, variableNamesIgnoreCase, variableValuesIgnoreCase, variableTypeIn, includeDeleted, processInstanceId, processInstanceIdIn, processDefinitionId, processDefinitionKey, executionIdIn, caseInstanceId, caseExecutionIdIn, caseActivityIdIn, taskIdIn, activityInstanceIdIn, tenantIdIn, withoutTenantId, variableNameIn, _callback);
        Type localVarReturnType = new TypeToken<CountResultDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for queryHistoricVariableInstances
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @param deserializeValues Determines whether serializable variable values (typically variables that store custom Java objects) should be deserialized on server side (default &#x60;true&#x60;).  If set to &#x60;true&#x60;, a serializable variable will be deserialized on server side and transformed to JSON using [Jackson&#39;s](https://github.com/FasterXML/jackson) POJO/bean property introspection feature. Note that this requires the Java classes of the variable value to be on the REST API&#39;s classpath.  If set to &#x60;false&#x60;, a serializable variable will be returned in its serialized format. For example, a variable that is serialized as XML will be returned as a JSON string containing XML.  **Note:** While &#x60;true&#x60; is the default value for reasons of backward compatibility, we recommend setting this parameter to &#x60;false&#x60; when developing web applications that are independent of the Java process applications deployed to the engine. (optional)
     * @param historicVariableInstanceQueryDto  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if a &#x60;sortOrder&#x60; parameter is supplied, but no &#x60;sortBy&#x60;. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call queryHistoricVariableInstancesCall(Integer firstResult, Integer maxResults, Boolean deserializeValues, HistoricVariableInstanceQueryDto historicVariableInstanceQueryDto, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = historicVariableInstanceQueryDto;

        // create path and map variables
        String localVarPath = "/history/variable-instance";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (firstResult != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("firstResult", firstResult));
        }

        if (maxResults != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("maxResults", maxResults));
        }

        if (deserializeValues != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("deserializeValues", deserializeValues));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call queryHistoricVariableInstancesValidateBeforeCall(Integer firstResult, Integer maxResults, Boolean deserializeValues, HistoricVariableInstanceQueryDto historicVariableInstanceQueryDto, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = queryHistoricVariableInstancesCall(firstResult, maxResults, deserializeValues, historicVariableInstanceQueryDto, _callback);
        return localVarCall;

    }

    /**
     * Get Variable Instances (POST)
     * Queries for historic variable instances that fulfill the given parameters. This method is slightly more powerful than the [Get Variable Instances](https://docs.camunda.org/manual/7.17/reference/rest/history/variable-instance/get-variable-instance-query/) method because it allows filtering by variable values of the different types &#x60;String&#x60;, &#x60;Number&#x60; or &#x60;Boolean&#x60;.
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @param deserializeValues Determines whether serializable variable values (typically variables that store custom Java objects) should be deserialized on server side (default &#x60;true&#x60;).  If set to &#x60;true&#x60;, a serializable variable will be deserialized on server side and transformed to JSON using [Jackson&#39;s](https://github.com/FasterXML/jackson) POJO/bean property introspection feature. Note that this requires the Java classes of the variable value to be on the REST API&#39;s classpath.  If set to &#x60;false&#x60;, a serializable variable will be returned in its serialized format. For example, a variable that is serialized as XML will be returned as a JSON string containing XML.  **Note:** While &#x60;true&#x60; is the default value for reasons of backward compatibility, we recommend setting this parameter to &#x60;false&#x60; when developing web applications that are independent of the Java process applications deployed to the engine. (optional)
     * @param historicVariableInstanceQueryDto  (optional)
     * @return List&lt;HistoricVariableInstanceDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if a &#x60;sortOrder&#x60; parameter is supplied, but no &#x60;sortBy&#x60;. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public List<HistoricVariableInstanceDto> queryHistoricVariableInstances(Integer firstResult, Integer maxResults, Boolean deserializeValues, HistoricVariableInstanceQueryDto historicVariableInstanceQueryDto) throws ApiException {
        ApiResponse<List<HistoricVariableInstanceDto>> localVarResp = queryHistoricVariableInstancesWithHttpInfo(firstResult, maxResults, deserializeValues, historicVariableInstanceQueryDto);
        return localVarResp.getData();
    }

    /**
     * Get Variable Instances (POST)
     * Queries for historic variable instances that fulfill the given parameters. This method is slightly more powerful than the [Get Variable Instances](https://docs.camunda.org/manual/7.17/reference/rest/history/variable-instance/get-variable-instance-query/) method because it allows filtering by variable values of the different types &#x60;String&#x60;, &#x60;Number&#x60; or &#x60;Boolean&#x60;.
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @param deserializeValues Determines whether serializable variable values (typically variables that store custom Java objects) should be deserialized on server side (default &#x60;true&#x60;).  If set to &#x60;true&#x60;, a serializable variable will be deserialized on server side and transformed to JSON using [Jackson&#39;s](https://github.com/FasterXML/jackson) POJO/bean property introspection feature. Note that this requires the Java classes of the variable value to be on the REST API&#39;s classpath.  If set to &#x60;false&#x60;, a serializable variable will be returned in its serialized format. For example, a variable that is serialized as XML will be returned as a JSON string containing XML.  **Note:** While &#x60;true&#x60; is the default value for reasons of backward compatibility, we recommend setting this parameter to &#x60;false&#x60; when developing web applications that are independent of the Java process applications deployed to the engine. (optional)
     * @param historicVariableInstanceQueryDto  (optional)
     * @return ApiResponse&lt;List&lt;HistoricVariableInstanceDto&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if a &#x60;sortOrder&#x60; parameter is supplied, but no &#x60;sortBy&#x60;. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<HistoricVariableInstanceDto>> queryHistoricVariableInstancesWithHttpInfo(Integer firstResult, Integer maxResults, Boolean deserializeValues, HistoricVariableInstanceQueryDto historicVariableInstanceQueryDto) throws ApiException {
        okhttp3.Call localVarCall = queryHistoricVariableInstancesValidateBeforeCall(firstResult, maxResults, deserializeValues, historicVariableInstanceQueryDto, null);
        Type localVarReturnType = new TypeToken<List<HistoricVariableInstanceDto>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get Variable Instances (POST) (asynchronously)
     * Queries for historic variable instances that fulfill the given parameters. This method is slightly more powerful than the [Get Variable Instances](https://docs.camunda.org/manual/7.17/reference/rest/history/variable-instance/get-variable-instance-query/) method because it allows filtering by variable values of the different types &#x60;String&#x60;, &#x60;Number&#x60; or &#x60;Boolean&#x60;.
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @param deserializeValues Determines whether serializable variable values (typically variables that store custom Java objects) should be deserialized on server side (default &#x60;true&#x60;).  If set to &#x60;true&#x60;, a serializable variable will be deserialized on server side and transformed to JSON using [Jackson&#39;s](https://github.com/FasterXML/jackson) POJO/bean property introspection feature. Note that this requires the Java classes of the variable value to be on the REST API&#39;s classpath.  If set to &#x60;false&#x60;, a serializable variable will be returned in its serialized format. For example, a variable that is serialized as XML will be returned as a JSON string containing XML.  **Note:** While &#x60;true&#x60; is the default value for reasons of backward compatibility, we recommend setting this parameter to &#x60;false&#x60; when developing web applications that are independent of the Java process applications deployed to the engine. (optional)
     * @param historicVariableInstanceQueryDto  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if a &#x60;sortOrder&#x60; parameter is supplied, but no &#x60;sortBy&#x60;. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call queryHistoricVariableInstancesAsync(Integer firstResult, Integer maxResults, Boolean deserializeValues, HistoricVariableInstanceQueryDto historicVariableInstanceQueryDto, final ApiCallback<List<HistoricVariableInstanceDto>> _callback) throws ApiException {

        okhttp3.Call localVarCall = queryHistoricVariableInstancesValidateBeforeCall(firstResult, maxResults, deserializeValues, historicVariableInstanceQueryDto, _callback);
        Type localVarReturnType = new TypeToken<List<HistoricVariableInstanceDto>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for queryHistoricVariableInstancesCount
     * @param historicVariableInstanceQueryDto  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call queryHistoricVariableInstancesCountCall(HistoricVariableInstanceQueryDto historicVariableInstanceQueryDto, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = historicVariableInstanceQueryDto;

        // create path and map variables
        String localVarPath = "/history/variable-instance/count";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call queryHistoricVariableInstancesCountValidateBeforeCall(HistoricVariableInstanceQueryDto historicVariableInstanceQueryDto, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = queryHistoricVariableInstancesCountCall(historicVariableInstanceQueryDto, _callback);
        return localVarCall;

    }

    /**
     * Get Variable Instance Count (POST)
     * Queries for historic variable instances that fulfill the given parameters. This method takes the same message body as the [Get Variable Instances (POST)](https://docs.camunda.org/manual/7.17/reference/rest/history/variable-instance/post-variable-instance-query/) method and therefore it is more powerful regarding variable values than the [Get Variable Instance Count](https://docs.camunda.org/manual/7.17/reference/rest/history/variable-instance/get-variable-instance-query-count/) method.
     * @param historicVariableInstanceQueryDto  (optional)
     * @return CountResultDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public CountResultDto queryHistoricVariableInstancesCount(HistoricVariableInstanceQueryDto historicVariableInstanceQueryDto) throws ApiException {
        ApiResponse<CountResultDto> localVarResp = queryHistoricVariableInstancesCountWithHttpInfo(historicVariableInstanceQueryDto);
        return localVarResp.getData();
    }

    /**
     * Get Variable Instance Count (POST)
     * Queries for historic variable instances that fulfill the given parameters. This method takes the same message body as the [Get Variable Instances (POST)](https://docs.camunda.org/manual/7.17/reference/rest/history/variable-instance/post-variable-instance-query/) method and therefore it is more powerful regarding variable values than the [Get Variable Instance Count](https://docs.camunda.org/manual/7.17/reference/rest/history/variable-instance/get-variable-instance-query-count/) method.
     * @param historicVariableInstanceQueryDto  (optional)
     * @return ApiResponse&lt;CountResultDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<CountResultDto> queryHistoricVariableInstancesCountWithHttpInfo(HistoricVariableInstanceQueryDto historicVariableInstanceQueryDto) throws ApiException {
        okhttp3.Call localVarCall = queryHistoricVariableInstancesCountValidateBeforeCall(historicVariableInstanceQueryDto, null);
        Type localVarReturnType = new TypeToken<CountResultDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get Variable Instance Count (POST) (asynchronously)
     * Queries for historic variable instances that fulfill the given parameters. This method takes the same message body as the [Get Variable Instances (POST)](https://docs.camunda.org/manual/7.17/reference/rest/history/variable-instance/post-variable-instance-query/) method and therefore it is more powerful regarding variable values than the [Get Variable Instance Count](https://docs.camunda.org/manual/7.17/reference/rest/history/variable-instance/get-variable-instance-query-count/) method.
     * @param historicVariableInstanceQueryDto  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call queryHistoricVariableInstancesCountAsync(HistoricVariableInstanceQueryDto historicVariableInstanceQueryDto, final ApiCallback<CountResultDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = queryHistoricVariableInstancesCountValidateBeforeCall(historicVariableInstanceQueryDto, _callback);
        Type localVarReturnType = new TypeToken<CountResultDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}
