/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.17.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.camunda.community.rest.client.api;

import org.camunda.community.rest.client.invoker.ApiCallback;
import org.camunda.community.rest.client.invoker.ApiClient;
import org.camunda.community.rest.client.invoker.ApiException;
import org.camunda.community.rest.client.invoker.ApiResponse;
import org.camunda.community.rest.client.invoker.Configuration;
import org.camunda.community.rest.client.invoker.Pair;
import org.camunda.community.rest.client.invoker.ProgressRequestBody;
import org.camunda.community.rest.client.invoker.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import org.camunda.community.rest.client.dto.CountResultDto;
import org.camunda.community.rest.client.dto.ExceptionDto;
import org.camunda.community.rest.client.dto.HistoricJobLogDto;
import org.camunda.community.rest.client.dto.HistoricJobLogQueryDto;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HistoricJobLogApi {
    private ApiClient localVarApiClient;

    public HistoricJobLogApi() {
        this(Configuration.getDefaultApiClient());
    }

    public HistoricJobLogApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    /**
     * Build call for getHistoricJobLog
     * @param id The id of the log entry. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Historic job log with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getHistoricJobLogCall(String id, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/history/job-log/{id}"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getHistoricJobLogValidateBeforeCall(String id, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getHistoricJobLog(Async)");
        }
        

        okhttp3.Call localVarCall = getHistoricJobLogCall(id, _callback);
        return localVarCall;

    }

    /**
     * Get Job Log
     * Retrieves a historic job log by id.
     * @param id The id of the log entry. (required)
     * @return HistoricJobLogDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Historic job log with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public HistoricJobLogDto getHistoricJobLog(String id) throws ApiException {
        ApiResponse<HistoricJobLogDto> localVarResp = getHistoricJobLogWithHttpInfo(id);
        return localVarResp.getData();
    }

    /**
     * Get Job Log
     * Retrieves a historic job log by id.
     * @param id The id of the log entry. (required)
     * @return ApiResponse&lt;HistoricJobLogDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Historic job log with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<HistoricJobLogDto> getHistoricJobLogWithHttpInfo(String id) throws ApiException {
        okhttp3.Call localVarCall = getHistoricJobLogValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<HistoricJobLogDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get Job Log (asynchronously)
     * Retrieves a historic job log by id.
     * @param id The id of the log entry. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Historic job log with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getHistoricJobLogAsync(String id, final ApiCallback<HistoricJobLogDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = getHistoricJobLogValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<HistoricJobLogDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getHistoricJobLogs
     * @param logId Filter by historic job log id. (optional)
     * @param jobId Filter by job id. (optional)
     * @param jobExceptionMessage Filter by job exception message. (optional)
     * @param jobDefinitionId Filter by job definition id. (optional)
     * @param jobDefinitionType Filter by job definition type. See the [User Guide](https://docs.camunda.org/manual/7.17/user-guide/process-engine/the-job-executor/#job-creation) for more information about job definition types. (optional)
     * @param jobDefinitionConfiguration Filter by job definition configuration. (optional)
     * @param activityIdIn Only include historic job logs which belong to one of the passed activity ids. (optional)
     * @param failedActivityIdIn Only include historic job logs which belong to failures of one of the passed activity ids. (optional)
     * @param executionIdIn Only include historic job logs which belong to one of the passed execution ids. (optional)
     * @param processInstanceId Filter by process instance id. (optional)
     * @param processDefinitionId Filter by process definition id. (optional)
     * @param processDefinitionKey Filter by process definition key. (optional)
     * @param deploymentId Filter by deployment id. (optional)
     * @param tenantIdIn Only include historic job log entries which belong to one of the passed and comma- separated tenant ids. (optional)
     * @param withoutTenantId Only include historic job log entries that belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param hostname Filter by hostname. (optional)
     * @param jobPriorityLowerThanOrEquals Only include logs for which the associated job had a priority lower than or equal to the given value. Value must be a valid &#x60;long&#x60; value. (optional)
     * @param jobPriorityHigherThanOrEquals Only include logs for which the associated job had a priority higher than or equal to the given value. Value must be a valid &#x60;long&#x60; value. (optional)
     * @param creationLog Only include creation logs. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param failureLog Only include failure logs. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param successLog Only include success logs. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param deletionLog Only include deletion logs. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
     * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if a &#x60;sortOrder&#x60; parameter is supplied, but no &#x60;sortBy&#x60;. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getHistoricJobLogsCall(String logId, String jobId, String jobExceptionMessage, String jobDefinitionId, String jobDefinitionType, String jobDefinitionConfiguration, String activityIdIn, String failedActivityIdIn, String executionIdIn, String processInstanceId, String processDefinitionId, String processDefinitionKey, String deploymentId, String tenantIdIn, Boolean withoutTenantId, String hostname, Long jobPriorityLowerThanOrEquals, Long jobPriorityHigherThanOrEquals, Boolean creationLog, Boolean failureLog, Boolean successLog, Boolean deletionLog, String sortBy, String sortOrder, Integer firstResult, Integer maxResults, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/history/job-log";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (logId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("logId", logId));
        }

        if (jobId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("jobId", jobId));
        }

        if (jobExceptionMessage != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("jobExceptionMessage", jobExceptionMessage));
        }

        if (jobDefinitionId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("jobDefinitionId", jobDefinitionId));
        }

        if (jobDefinitionType != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("jobDefinitionType", jobDefinitionType));
        }

        if (jobDefinitionConfiguration != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("jobDefinitionConfiguration", jobDefinitionConfiguration));
        }

        if (activityIdIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("activityIdIn", activityIdIn));
        }

        if (failedActivityIdIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("failedActivityIdIn", failedActivityIdIn));
        }

        if (executionIdIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("executionIdIn", executionIdIn));
        }

        if (processInstanceId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("processInstanceId", processInstanceId));
        }

        if (processDefinitionId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("processDefinitionId", processDefinitionId));
        }

        if (processDefinitionKey != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("processDefinitionKey", processDefinitionKey));
        }

        if (deploymentId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("deploymentId", deploymentId));
        }

        if (tenantIdIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("tenantIdIn", tenantIdIn));
        }

        if (withoutTenantId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("withoutTenantId", withoutTenantId));
        }

        if (hostname != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("hostname", hostname));
        }

        if (jobPriorityLowerThanOrEquals != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("jobPriorityLowerThanOrEquals", jobPriorityLowerThanOrEquals));
        }

        if (jobPriorityHigherThanOrEquals != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("jobPriorityHigherThanOrEquals", jobPriorityHigherThanOrEquals));
        }

        if (creationLog != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("creationLog", creationLog));
        }

        if (failureLog != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("failureLog", failureLog));
        }

        if (successLog != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("successLog", successLog));
        }

        if (deletionLog != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("deletionLog", deletionLog));
        }

        if (sortBy != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("sortBy", sortBy));
        }

        if (sortOrder != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("sortOrder", sortOrder));
        }

        if (firstResult != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("firstResult", firstResult));
        }

        if (maxResults != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("maxResults", maxResults));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getHistoricJobLogsValidateBeforeCall(String logId, String jobId, String jobExceptionMessage, String jobDefinitionId, String jobDefinitionType, String jobDefinitionConfiguration, String activityIdIn, String failedActivityIdIn, String executionIdIn, String processInstanceId, String processDefinitionId, String processDefinitionKey, String deploymentId, String tenantIdIn, Boolean withoutTenantId, String hostname, Long jobPriorityLowerThanOrEquals, Long jobPriorityHigherThanOrEquals, Boolean creationLog, Boolean failureLog, Boolean successLog, Boolean deletionLog, String sortBy, String sortOrder, Integer firstResult, Integer maxResults, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = getHistoricJobLogsCall(logId, jobId, jobExceptionMessage, jobDefinitionId, jobDefinitionType, jobDefinitionConfiguration, activityIdIn, failedActivityIdIn, executionIdIn, processInstanceId, processDefinitionId, processDefinitionKey, deploymentId, tenantIdIn, withoutTenantId, hostname, jobPriorityLowerThanOrEquals, jobPriorityHigherThanOrEquals, creationLog, failureLog, successLog, deletionLog, sortBy, sortOrder, firstResult, maxResults, _callback);
        return localVarCall;

    }

    /**
     * Get Job Logs
     * Queries for historic job logs that fulfill the given parameters. The size of the result set can be retrieved by using the [Get Job Log Count](https://docs.camunda.org/manual/7.17/reference/rest/history/job-log/get-job-log-query-count/) method.
     * @param logId Filter by historic job log id. (optional)
     * @param jobId Filter by job id. (optional)
     * @param jobExceptionMessage Filter by job exception message. (optional)
     * @param jobDefinitionId Filter by job definition id. (optional)
     * @param jobDefinitionType Filter by job definition type. See the [User Guide](https://docs.camunda.org/manual/7.17/user-guide/process-engine/the-job-executor/#job-creation) for more information about job definition types. (optional)
     * @param jobDefinitionConfiguration Filter by job definition configuration. (optional)
     * @param activityIdIn Only include historic job logs which belong to one of the passed activity ids. (optional)
     * @param failedActivityIdIn Only include historic job logs which belong to failures of one of the passed activity ids. (optional)
     * @param executionIdIn Only include historic job logs which belong to one of the passed execution ids. (optional)
     * @param processInstanceId Filter by process instance id. (optional)
     * @param processDefinitionId Filter by process definition id. (optional)
     * @param processDefinitionKey Filter by process definition key. (optional)
     * @param deploymentId Filter by deployment id. (optional)
     * @param tenantIdIn Only include historic job log entries which belong to one of the passed and comma- separated tenant ids. (optional)
     * @param withoutTenantId Only include historic job log entries that belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param hostname Filter by hostname. (optional)
     * @param jobPriorityLowerThanOrEquals Only include logs for which the associated job had a priority lower than or equal to the given value. Value must be a valid &#x60;long&#x60; value. (optional)
     * @param jobPriorityHigherThanOrEquals Only include logs for which the associated job had a priority higher than or equal to the given value. Value must be a valid &#x60;long&#x60; value. (optional)
     * @param creationLog Only include creation logs. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param failureLog Only include failure logs. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param successLog Only include success logs. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param deletionLog Only include deletion logs. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
     * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @return List&lt;HistoricJobLogDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if a &#x60;sortOrder&#x60; parameter is supplied, but no &#x60;sortBy&#x60;. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public List<HistoricJobLogDto> getHistoricJobLogs(String logId, String jobId, String jobExceptionMessage, String jobDefinitionId, String jobDefinitionType, String jobDefinitionConfiguration, String activityIdIn, String failedActivityIdIn, String executionIdIn, String processInstanceId, String processDefinitionId, String processDefinitionKey, String deploymentId, String tenantIdIn, Boolean withoutTenantId, String hostname, Long jobPriorityLowerThanOrEquals, Long jobPriorityHigherThanOrEquals, Boolean creationLog, Boolean failureLog, Boolean successLog, Boolean deletionLog, String sortBy, String sortOrder, Integer firstResult, Integer maxResults) throws ApiException {
        ApiResponse<List<HistoricJobLogDto>> localVarResp = getHistoricJobLogsWithHttpInfo(logId, jobId, jobExceptionMessage, jobDefinitionId, jobDefinitionType, jobDefinitionConfiguration, activityIdIn, failedActivityIdIn, executionIdIn, processInstanceId, processDefinitionId, processDefinitionKey, deploymentId, tenantIdIn, withoutTenantId, hostname, jobPriorityLowerThanOrEquals, jobPriorityHigherThanOrEquals, creationLog, failureLog, successLog, deletionLog, sortBy, sortOrder, firstResult, maxResults);
        return localVarResp.getData();
    }

    /**
     * Get Job Logs
     * Queries for historic job logs that fulfill the given parameters. The size of the result set can be retrieved by using the [Get Job Log Count](https://docs.camunda.org/manual/7.17/reference/rest/history/job-log/get-job-log-query-count/) method.
     * @param logId Filter by historic job log id. (optional)
     * @param jobId Filter by job id. (optional)
     * @param jobExceptionMessage Filter by job exception message. (optional)
     * @param jobDefinitionId Filter by job definition id. (optional)
     * @param jobDefinitionType Filter by job definition type. See the [User Guide](https://docs.camunda.org/manual/7.17/user-guide/process-engine/the-job-executor/#job-creation) for more information about job definition types. (optional)
     * @param jobDefinitionConfiguration Filter by job definition configuration. (optional)
     * @param activityIdIn Only include historic job logs which belong to one of the passed activity ids. (optional)
     * @param failedActivityIdIn Only include historic job logs which belong to failures of one of the passed activity ids. (optional)
     * @param executionIdIn Only include historic job logs which belong to one of the passed execution ids. (optional)
     * @param processInstanceId Filter by process instance id. (optional)
     * @param processDefinitionId Filter by process definition id. (optional)
     * @param processDefinitionKey Filter by process definition key. (optional)
     * @param deploymentId Filter by deployment id. (optional)
     * @param tenantIdIn Only include historic job log entries which belong to one of the passed and comma- separated tenant ids. (optional)
     * @param withoutTenantId Only include historic job log entries that belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param hostname Filter by hostname. (optional)
     * @param jobPriorityLowerThanOrEquals Only include logs for which the associated job had a priority lower than or equal to the given value. Value must be a valid &#x60;long&#x60; value. (optional)
     * @param jobPriorityHigherThanOrEquals Only include logs for which the associated job had a priority higher than or equal to the given value. Value must be a valid &#x60;long&#x60; value. (optional)
     * @param creationLog Only include creation logs. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param failureLog Only include failure logs. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param successLog Only include success logs. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param deletionLog Only include deletion logs. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
     * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @return ApiResponse&lt;List&lt;HistoricJobLogDto&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if a &#x60;sortOrder&#x60; parameter is supplied, but no &#x60;sortBy&#x60;. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<HistoricJobLogDto>> getHistoricJobLogsWithHttpInfo(String logId, String jobId, String jobExceptionMessage, String jobDefinitionId, String jobDefinitionType, String jobDefinitionConfiguration, String activityIdIn, String failedActivityIdIn, String executionIdIn, String processInstanceId, String processDefinitionId, String processDefinitionKey, String deploymentId, String tenantIdIn, Boolean withoutTenantId, String hostname, Long jobPriorityLowerThanOrEquals, Long jobPriorityHigherThanOrEquals, Boolean creationLog, Boolean failureLog, Boolean successLog, Boolean deletionLog, String sortBy, String sortOrder, Integer firstResult, Integer maxResults) throws ApiException {
        okhttp3.Call localVarCall = getHistoricJobLogsValidateBeforeCall(logId, jobId, jobExceptionMessage, jobDefinitionId, jobDefinitionType, jobDefinitionConfiguration, activityIdIn, failedActivityIdIn, executionIdIn, processInstanceId, processDefinitionId, processDefinitionKey, deploymentId, tenantIdIn, withoutTenantId, hostname, jobPriorityLowerThanOrEquals, jobPriorityHigherThanOrEquals, creationLog, failureLog, successLog, deletionLog, sortBy, sortOrder, firstResult, maxResults, null);
        Type localVarReturnType = new TypeToken<List<HistoricJobLogDto>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get Job Logs (asynchronously)
     * Queries for historic job logs that fulfill the given parameters. The size of the result set can be retrieved by using the [Get Job Log Count](https://docs.camunda.org/manual/7.17/reference/rest/history/job-log/get-job-log-query-count/) method.
     * @param logId Filter by historic job log id. (optional)
     * @param jobId Filter by job id. (optional)
     * @param jobExceptionMessage Filter by job exception message. (optional)
     * @param jobDefinitionId Filter by job definition id. (optional)
     * @param jobDefinitionType Filter by job definition type. See the [User Guide](https://docs.camunda.org/manual/7.17/user-guide/process-engine/the-job-executor/#job-creation) for more information about job definition types. (optional)
     * @param jobDefinitionConfiguration Filter by job definition configuration. (optional)
     * @param activityIdIn Only include historic job logs which belong to one of the passed activity ids. (optional)
     * @param failedActivityIdIn Only include historic job logs which belong to failures of one of the passed activity ids. (optional)
     * @param executionIdIn Only include historic job logs which belong to one of the passed execution ids. (optional)
     * @param processInstanceId Filter by process instance id. (optional)
     * @param processDefinitionId Filter by process definition id. (optional)
     * @param processDefinitionKey Filter by process definition key. (optional)
     * @param deploymentId Filter by deployment id. (optional)
     * @param tenantIdIn Only include historic job log entries which belong to one of the passed and comma- separated tenant ids. (optional)
     * @param withoutTenantId Only include historic job log entries that belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param hostname Filter by hostname. (optional)
     * @param jobPriorityLowerThanOrEquals Only include logs for which the associated job had a priority lower than or equal to the given value. Value must be a valid &#x60;long&#x60; value. (optional)
     * @param jobPriorityHigherThanOrEquals Only include logs for which the associated job had a priority higher than or equal to the given value. Value must be a valid &#x60;long&#x60; value. (optional)
     * @param creationLog Only include creation logs. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param failureLog Only include failure logs. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param successLog Only include success logs. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param deletionLog Only include deletion logs. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param sortBy Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter. (optional)
     * @param sortOrder Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter. (optional)
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if a &#x60;sortOrder&#x60; parameter is supplied, but no &#x60;sortBy&#x60;. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getHistoricJobLogsAsync(String logId, String jobId, String jobExceptionMessage, String jobDefinitionId, String jobDefinitionType, String jobDefinitionConfiguration, String activityIdIn, String failedActivityIdIn, String executionIdIn, String processInstanceId, String processDefinitionId, String processDefinitionKey, String deploymentId, String tenantIdIn, Boolean withoutTenantId, String hostname, Long jobPriorityLowerThanOrEquals, Long jobPriorityHigherThanOrEquals, Boolean creationLog, Boolean failureLog, Boolean successLog, Boolean deletionLog, String sortBy, String sortOrder, Integer firstResult, Integer maxResults, final ApiCallback<List<HistoricJobLogDto>> _callback) throws ApiException {

        okhttp3.Call localVarCall = getHistoricJobLogsValidateBeforeCall(logId, jobId, jobExceptionMessage, jobDefinitionId, jobDefinitionType, jobDefinitionConfiguration, activityIdIn, failedActivityIdIn, executionIdIn, processInstanceId, processDefinitionId, processDefinitionKey, deploymentId, tenantIdIn, withoutTenantId, hostname, jobPriorityLowerThanOrEquals, jobPriorityHigherThanOrEquals, creationLog, failureLog, successLog, deletionLog, sortBy, sortOrder, firstResult, maxResults, _callback);
        Type localVarReturnType = new TypeToken<List<HistoricJobLogDto>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getHistoricJobLogsCount
     * @param logId Filter by historic job log id. (optional)
     * @param jobId Filter by job id. (optional)
     * @param jobExceptionMessage Filter by job exception message. (optional)
     * @param jobDefinitionId Filter by job definition id. (optional)
     * @param jobDefinitionType Filter by job definition type. See the [User Guide](https://docs.camunda.org/manual/7.17/user-guide/process-engine/the-job-executor/#job-creation) for more information about job definition types. (optional)
     * @param jobDefinitionConfiguration Filter by job definition configuration. (optional)
     * @param activityIdIn Only include historic job logs which belong to one of the passed activity ids. (optional)
     * @param failedActivityIdIn Only include historic job logs which belong to failures of one of the passed activity ids. (optional)
     * @param executionIdIn Only include historic job logs which belong to one of the passed execution ids. (optional)
     * @param processInstanceId Filter by process instance id. (optional)
     * @param processDefinitionId Filter by process definition id. (optional)
     * @param processDefinitionKey Filter by process definition key. (optional)
     * @param deploymentId Filter by deployment id. (optional)
     * @param tenantIdIn Only include historic job log entries which belong to one of the passed and comma- separated tenant ids. (optional)
     * @param withoutTenantId Only include historic job log entries that belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param hostname Filter by hostname. (optional)
     * @param jobPriorityLowerThanOrEquals Only include logs for which the associated job had a priority lower than or equal to the given value. Value must be a valid &#x60;long&#x60; value. (optional)
     * @param jobPriorityHigherThanOrEquals Only include logs for which the associated job had a priority higher than or equal to the given value. Value must be a valid &#x60;long&#x60; value. (optional)
     * @param creationLog Only include creation logs. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param failureLog Only include failure logs. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param successLog Only include success logs. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param deletionLog Only include deletion logs. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getHistoricJobLogsCountCall(String logId, String jobId, String jobExceptionMessage, String jobDefinitionId, String jobDefinitionType, String jobDefinitionConfiguration, String activityIdIn, String failedActivityIdIn, String executionIdIn, String processInstanceId, String processDefinitionId, String processDefinitionKey, String deploymentId, String tenantIdIn, Boolean withoutTenantId, String hostname, Long jobPriorityLowerThanOrEquals, Long jobPriorityHigherThanOrEquals, Boolean creationLog, Boolean failureLog, Boolean successLog, Boolean deletionLog, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/history/job-log/count";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (logId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("logId", logId));
        }

        if (jobId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("jobId", jobId));
        }

        if (jobExceptionMessage != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("jobExceptionMessage", jobExceptionMessage));
        }

        if (jobDefinitionId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("jobDefinitionId", jobDefinitionId));
        }

        if (jobDefinitionType != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("jobDefinitionType", jobDefinitionType));
        }

        if (jobDefinitionConfiguration != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("jobDefinitionConfiguration", jobDefinitionConfiguration));
        }

        if (activityIdIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("activityIdIn", activityIdIn));
        }

        if (failedActivityIdIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("failedActivityIdIn", failedActivityIdIn));
        }

        if (executionIdIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("executionIdIn", executionIdIn));
        }

        if (processInstanceId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("processInstanceId", processInstanceId));
        }

        if (processDefinitionId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("processDefinitionId", processDefinitionId));
        }

        if (processDefinitionKey != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("processDefinitionKey", processDefinitionKey));
        }

        if (deploymentId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("deploymentId", deploymentId));
        }

        if (tenantIdIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("tenantIdIn", tenantIdIn));
        }

        if (withoutTenantId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("withoutTenantId", withoutTenantId));
        }

        if (hostname != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("hostname", hostname));
        }

        if (jobPriorityLowerThanOrEquals != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("jobPriorityLowerThanOrEquals", jobPriorityLowerThanOrEquals));
        }

        if (jobPriorityHigherThanOrEquals != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("jobPriorityHigherThanOrEquals", jobPriorityHigherThanOrEquals));
        }

        if (creationLog != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("creationLog", creationLog));
        }

        if (failureLog != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("failureLog", failureLog));
        }

        if (successLog != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("successLog", successLog));
        }

        if (deletionLog != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("deletionLog", deletionLog));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getHistoricJobLogsCountValidateBeforeCall(String logId, String jobId, String jobExceptionMessage, String jobDefinitionId, String jobDefinitionType, String jobDefinitionConfiguration, String activityIdIn, String failedActivityIdIn, String executionIdIn, String processInstanceId, String processDefinitionId, String processDefinitionKey, String deploymentId, String tenantIdIn, Boolean withoutTenantId, String hostname, Long jobPriorityLowerThanOrEquals, Long jobPriorityHigherThanOrEquals, Boolean creationLog, Boolean failureLog, Boolean successLog, Boolean deletionLog, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = getHistoricJobLogsCountCall(logId, jobId, jobExceptionMessage, jobDefinitionId, jobDefinitionType, jobDefinitionConfiguration, activityIdIn, failedActivityIdIn, executionIdIn, processInstanceId, processDefinitionId, processDefinitionKey, deploymentId, tenantIdIn, withoutTenantId, hostname, jobPriorityLowerThanOrEquals, jobPriorityHigherThanOrEquals, creationLog, failureLog, successLog, deletionLog, _callback);
        return localVarCall;

    }

    /**
     * Get Job Log Count
     * Queries for the number of historic job logs that fulfill the given parameters. Takes the same parameters as the [Get Job Logs](https://docs.camunda.org/manual/7.17/reference/rest/history/job-log/get-job-log-query/) method.
     * @param logId Filter by historic job log id. (optional)
     * @param jobId Filter by job id. (optional)
     * @param jobExceptionMessage Filter by job exception message. (optional)
     * @param jobDefinitionId Filter by job definition id. (optional)
     * @param jobDefinitionType Filter by job definition type. See the [User Guide](https://docs.camunda.org/manual/7.17/user-guide/process-engine/the-job-executor/#job-creation) for more information about job definition types. (optional)
     * @param jobDefinitionConfiguration Filter by job definition configuration. (optional)
     * @param activityIdIn Only include historic job logs which belong to one of the passed activity ids. (optional)
     * @param failedActivityIdIn Only include historic job logs which belong to failures of one of the passed activity ids. (optional)
     * @param executionIdIn Only include historic job logs which belong to one of the passed execution ids. (optional)
     * @param processInstanceId Filter by process instance id. (optional)
     * @param processDefinitionId Filter by process definition id. (optional)
     * @param processDefinitionKey Filter by process definition key. (optional)
     * @param deploymentId Filter by deployment id. (optional)
     * @param tenantIdIn Only include historic job log entries which belong to one of the passed and comma- separated tenant ids. (optional)
     * @param withoutTenantId Only include historic job log entries that belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param hostname Filter by hostname. (optional)
     * @param jobPriorityLowerThanOrEquals Only include logs for which the associated job had a priority lower than or equal to the given value. Value must be a valid &#x60;long&#x60; value. (optional)
     * @param jobPriorityHigherThanOrEquals Only include logs for which the associated job had a priority higher than or equal to the given value. Value must be a valid &#x60;long&#x60; value. (optional)
     * @param creationLog Only include creation logs. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param failureLog Only include failure logs. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param successLog Only include success logs. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param deletionLog Only include deletion logs. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @return CountResultDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid. </td><td>  -  </td></tr>
     </table>
     */
    public CountResultDto getHistoricJobLogsCount(String logId, String jobId, String jobExceptionMessage, String jobDefinitionId, String jobDefinitionType, String jobDefinitionConfiguration, String activityIdIn, String failedActivityIdIn, String executionIdIn, String processInstanceId, String processDefinitionId, String processDefinitionKey, String deploymentId, String tenantIdIn, Boolean withoutTenantId, String hostname, Long jobPriorityLowerThanOrEquals, Long jobPriorityHigherThanOrEquals, Boolean creationLog, Boolean failureLog, Boolean successLog, Boolean deletionLog) throws ApiException {
        ApiResponse<CountResultDto> localVarResp = getHistoricJobLogsCountWithHttpInfo(logId, jobId, jobExceptionMessage, jobDefinitionId, jobDefinitionType, jobDefinitionConfiguration, activityIdIn, failedActivityIdIn, executionIdIn, processInstanceId, processDefinitionId, processDefinitionKey, deploymentId, tenantIdIn, withoutTenantId, hostname, jobPriorityLowerThanOrEquals, jobPriorityHigherThanOrEquals, creationLog, failureLog, successLog, deletionLog);
        return localVarResp.getData();
    }

    /**
     * Get Job Log Count
     * Queries for the number of historic job logs that fulfill the given parameters. Takes the same parameters as the [Get Job Logs](https://docs.camunda.org/manual/7.17/reference/rest/history/job-log/get-job-log-query/) method.
     * @param logId Filter by historic job log id. (optional)
     * @param jobId Filter by job id. (optional)
     * @param jobExceptionMessage Filter by job exception message. (optional)
     * @param jobDefinitionId Filter by job definition id. (optional)
     * @param jobDefinitionType Filter by job definition type. See the [User Guide](https://docs.camunda.org/manual/7.17/user-guide/process-engine/the-job-executor/#job-creation) for more information about job definition types. (optional)
     * @param jobDefinitionConfiguration Filter by job definition configuration. (optional)
     * @param activityIdIn Only include historic job logs which belong to one of the passed activity ids. (optional)
     * @param failedActivityIdIn Only include historic job logs which belong to failures of one of the passed activity ids. (optional)
     * @param executionIdIn Only include historic job logs which belong to one of the passed execution ids. (optional)
     * @param processInstanceId Filter by process instance id. (optional)
     * @param processDefinitionId Filter by process definition id. (optional)
     * @param processDefinitionKey Filter by process definition key. (optional)
     * @param deploymentId Filter by deployment id. (optional)
     * @param tenantIdIn Only include historic job log entries which belong to one of the passed and comma- separated tenant ids. (optional)
     * @param withoutTenantId Only include historic job log entries that belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param hostname Filter by hostname. (optional)
     * @param jobPriorityLowerThanOrEquals Only include logs for which the associated job had a priority lower than or equal to the given value. Value must be a valid &#x60;long&#x60; value. (optional)
     * @param jobPriorityHigherThanOrEquals Only include logs for which the associated job had a priority higher than or equal to the given value. Value must be a valid &#x60;long&#x60; value. (optional)
     * @param creationLog Only include creation logs. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param failureLog Only include failure logs. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param successLog Only include success logs. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param deletionLog Only include deletion logs. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @return ApiResponse&lt;CountResultDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<CountResultDto> getHistoricJobLogsCountWithHttpInfo(String logId, String jobId, String jobExceptionMessage, String jobDefinitionId, String jobDefinitionType, String jobDefinitionConfiguration, String activityIdIn, String failedActivityIdIn, String executionIdIn, String processInstanceId, String processDefinitionId, String processDefinitionKey, String deploymentId, String tenantIdIn, Boolean withoutTenantId, String hostname, Long jobPriorityLowerThanOrEquals, Long jobPriorityHigherThanOrEquals, Boolean creationLog, Boolean failureLog, Boolean successLog, Boolean deletionLog) throws ApiException {
        okhttp3.Call localVarCall = getHistoricJobLogsCountValidateBeforeCall(logId, jobId, jobExceptionMessage, jobDefinitionId, jobDefinitionType, jobDefinitionConfiguration, activityIdIn, failedActivityIdIn, executionIdIn, processInstanceId, processDefinitionId, processDefinitionKey, deploymentId, tenantIdIn, withoutTenantId, hostname, jobPriorityLowerThanOrEquals, jobPriorityHigherThanOrEquals, creationLog, failureLog, successLog, deletionLog, null);
        Type localVarReturnType = new TypeToken<CountResultDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get Job Log Count (asynchronously)
     * Queries for the number of historic job logs that fulfill the given parameters. Takes the same parameters as the [Get Job Logs](https://docs.camunda.org/manual/7.17/reference/rest/history/job-log/get-job-log-query/) method.
     * @param logId Filter by historic job log id. (optional)
     * @param jobId Filter by job id. (optional)
     * @param jobExceptionMessage Filter by job exception message. (optional)
     * @param jobDefinitionId Filter by job definition id. (optional)
     * @param jobDefinitionType Filter by job definition type. See the [User Guide](https://docs.camunda.org/manual/7.17/user-guide/process-engine/the-job-executor/#job-creation) for more information about job definition types. (optional)
     * @param jobDefinitionConfiguration Filter by job definition configuration. (optional)
     * @param activityIdIn Only include historic job logs which belong to one of the passed activity ids. (optional)
     * @param failedActivityIdIn Only include historic job logs which belong to failures of one of the passed activity ids. (optional)
     * @param executionIdIn Only include historic job logs which belong to one of the passed execution ids. (optional)
     * @param processInstanceId Filter by process instance id. (optional)
     * @param processDefinitionId Filter by process definition id. (optional)
     * @param processDefinitionKey Filter by process definition key. (optional)
     * @param deploymentId Filter by deployment id. (optional)
     * @param tenantIdIn Only include historic job log entries which belong to one of the passed and comma- separated tenant ids. (optional)
     * @param withoutTenantId Only include historic job log entries that belong to no tenant. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param hostname Filter by hostname. (optional)
     * @param jobPriorityLowerThanOrEquals Only include logs for which the associated job had a priority lower than or equal to the given value. Value must be a valid &#x60;long&#x60; value. (optional)
     * @param jobPriorityHigherThanOrEquals Only include logs for which the associated job had a priority higher than or equal to the given value. Value must be a valid &#x60;long&#x60; value. (optional)
     * @param creationLog Only include creation logs. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param failureLog Only include failure logs. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param successLog Only include success logs. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param deletionLog Only include deletion logs. Value may only be &#x60;true&#x60;, as &#x60;false&#x60; is the default behavior. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getHistoricJobLogsCountAsync(String logId, String jobId, String jobExceptionMessage, String jobDefinitionId, String jobDefinitionType, String jobDefinitionConfiguration, String activityIdIn, String failedActivityIdIn, String executionIdIn, String processInstanceId, String processDefinitionId, String processDefinitionKey, String deploymentId, String tenantIdIn, Boolean withoutTenantId, String hostname, Long jobPriorityLowerThanOrEquals, Long jobPriorityHigherThanOrEquals, Boolean creationLog, Boolean failureLog, Boolean successLog, Boolean deletionLog, final ApiCallback<CountResultDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = getHistoricJobLogsCountValidateBeforeCall(logId, jobId, jobExceptionMessage, jobDefinitionId, jobDefinitionType, jobDefinitionConfiguration, activityIdIn, failedActivityIdIn, executionIdIn, processInstanceId, processDefinitionId, processDefinitionKey, deploymentId, tenantIdIn, withoutTenantId, hostname, jobPriorityLowerThanOrEquals, jobPriorityHigherThanOrEquals, creationLog, failureLog, successLog, deletionLog, _callback);
        Type localVarReturnType = new TypeToken<CountResultDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getStacktraceHistoricJobLog
     * @param id The id of the historic job log to get the exception stacktrace for. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Historic job log with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getStacktraceHistoricJobLogCall(String id, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/history/job-log/{id}/stacktrace"
            .replaceAll("\\{" + "id" + "\\}", localVarApiClient.escapeString(id.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "text/plain", "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getStacktraceHistoricJobLogValidateBeforeCall(String id, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'id' is set
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getStacktraceHistoricJobLog(Async)");
        }
        

        okhttp3.Call localVarCall = getStacktraceHistoricJobLogCall(id, _callback);
        return localVarCall;

    }

    /**
     * Get Job Log Exception Stacktrace
     * Retrieves the corresponding exception stacktrace to the passed historic job log by id.
     * @param id The id of the historic job log to get the exception stacktrace for. (required)
     * @return Object
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Historic job log with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public Object getStacktraceHistoricJobLog(String id) throws ApiException {
        ApiResponse<Object> localVarResp = getStacktraceHistoricJobLogWithHttpInfo(id);
        return localVarResp.getData();
    }

    /**
     * Get Job Log Exception Stacktrace
     * Retrieves the corresponding exception stacktrace to the passed historic job log by id.
     * @param id The id of the historic job log to get the exception stacktrace for. (required)
     * @return ApiResponse&lt;Object&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Historic job log with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Object> getStacktraceHistoricJobLogWithHttpInfo(String id) throws ApiException {
        okhttp3.Call localVarCall = getStacktraceHistoricJobLogValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get Job Log Exception Stacktrace (asynchronously)
     * Retrieves the corresponding exception stacktrace to the passed historic job log by id.
     * @param id The id of the historic job log to get the exception stacktrace for. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Historic job log with given id does not exist. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getStacktraceHistoricJobLogAsync(String id, final ApiCallback<Object> _callback) throws ApiException {

        okhttp3.Call localVarCall = getStacktraceHistoricJobLogValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for queryHistoricJobLogs
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @param historicJobLogQueryDto  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if a &#x60;sortOrder&#x60; parameter is supplied, but no &#x60;sortBy&#x60;. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call queryHistoricJobLogsCall(Integer firstResult, Integer maxResults, HistoricJobLogQueryDto historicJobLogQueryDto, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = historicJobLogQueryDto;

        // create path and map variables
        String localVarPath = "/history/job-log";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (firstResult != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("firstResult", firstResult));
        }

        if (maxResults != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("maxResults", maxResults));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call queryHistoricJobLogsValidateBeforeCall(Integer firstResult, Integer maxResults, HistoricJobLogQueryDto historicJobLogQueryDto, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = queryHistoricJobLogsCall(firstResult, maxResults, historicJobLogQueryDto, _callback);
        return localVarCall;

    }

    /**
     * Get Job Logs (POST)
     * Queries for historic job logs that fulfill the given parameters. This method is slightly more powerful than the [Get Job Logs](https://docs.camunda.org/manual/7.17/reference/rest/history/job-log/get-job-log-query/) method because it allows filtering by historic job logs values of the different types &#x60;String&#x60;, &#x60;Number&#x60; or &#x60;Boolean&#x60;.
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @param historicJobLogQueryDto  (optional)
     * @return List&lt;HistoricJobLogDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if a &#x60;sortOrder&#x60; parameter is supplied, but no &#x60;sortBy&#x60;. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public List<HistoricJobLogDto> queryHistoricJobLogs(Integer firstResult, Integer maxResults, HistoricJobLogQueryDto historicJobLogQueryDto) throws ApiException {
        ApiResponse<List<HistoricJobLogDto>> localVarResp = queryHistoricJobLogsWithHttpInfo(firstResult, maxResults, historicJobLogQueryDto);
        return localVarResp.getData();
    }

    /**
     * Get Job Logs (POST)
     * Queries for historic job logs that fulfill the given parameters. This method is slightly more powerful than the [Get Job Logs](https://docs.camunda.org/manual/7.17/reference/rest/history/job-log/get-job-log-query/) method because it allows filtering by historic job logs values of the different types &#x60;String&#x60;, &#x60;Number&#x60; or &#x60;Boolean&#x60;.
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @param historicJobLogQueryDto  (optional)
     * @return ApiResponse&lt;List&lt;HistoricJobLogDto&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if a &#x60;sortOrder&#x60; parameter is supplied, but no &#x60;sortBy&#x60;. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<HistoricJobLogDto>> queryHistoricJobLogsWithHttpInfo(Integer firstResult, Integer maxResults, HistoricJobLogQueryDto historicJobLogQueryDto) throws ApiException {
        okhttp3.Call localVarCall = queryHistoricJobLogsValidateBeforeCall(firstResult, maxResults, historicJobLogQueryDto, null);
        Type localVarReturnType = new TypeToken<List<HistoricJobLogDto>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get Job Logs (POST) (asynchronously)
     * Queries for historic job logs that fulfill the given parameters. This method is slightly more powerful than the [Get Job Logs](https://docs.camunda.org/manual/7.17/reference/rest/history/job-log/get-job-log-query/) method because it allows filtering by historic job logs values of the different types &#x60;String&#x60;, &#x60;Number&#x60; or &#x60;Boolean&#x60;.
     * @param firstResult Pagination of results. Specifies the index of the first result to return. (optional)
     * @param maxResults Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left. (optional)
     * @param historicJobLogQueryDto  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid, for example if a &#x60;sortOrder&#x60; parameter is supplied, but no &#x60;sortBy&#x60;. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call queryHistoricJobLogsAsync(Integer firstResult, Integer maxResults, HistoricJobLogQueryDto historicJobLogQueryDto, final ApiCallback<List<HistoricJobLogDto>> _callback) throws ApiException {

        okhttp3.Call localVarCall = queryHistoricJobLogsValidateBeforeCall(firstResult, maxResults, historicJobLogQueryDto, _callback);
        Type localVarReturnType = new TypeToken<List<HistoricJobLogDto>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for queryHistoricJobLogsCount
     * @param historicJobLogQueryDto  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call queryHistoricJobLogsCountCall(HistoricJobLogQueryDto historicJobLogQueryDto, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = historicJobLogQueryDto;

        // create path and map variables
        String localVarPath = "/history/job-log/count";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call queryHistoricJobLogsCountValidateBeforeCall(HistoricJobLogQueryDto historicJobLogQueryDto, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = queryHistoricJobLogsCountCall(historicJobLogQueryDto, _callback);
        return localVarCall;

    }

    /**
     * Get Job Log Count (POST)
     * Queries for the number of historic job logs that fulfill the given parameters. This method takes the same message body as the [Get Job Logs (POST)](https://docs.camunda.org/manual/7.17/reference/rest/history/job-log/post-job-log-query/) method and therefore it is slightly more powerful than the [Get Job Log Count](https://docs.camunda.org/manual/7.17/reference/rest/history/job-log/get-job-log-query-count/) method.
     * @param historicJobLogQueryDto  (optional)
     * @return CountResultDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public CountResultDto queryHistoricJobLogsCount(HistoricJobLogQueryDto historicJobLogQueryDto) throws ApiException {
        ApiResponse<CountResultDto> localVarResp = queryHistoricJobLogsCountWithHttpInfo(historicJobLogQueryDto);
        return localVarResp.getData();
    }

    /**
     * Get Job Log Count (POST)
     * Queries for the number of historic job logs that fulfill the given parameters. This method takes the same message body as the [Get Job Logs (POST)](https://docs.camunda.org/manual/7.17/reference/rest/history/job-log/post-job-log-query/) method and therefore it is slightly more powerful than the [Get Job Log Count](https://docs.camunda.org/manual/7.17/reference/rest/history/job-log/get-job-log-query-count/) method.
     * @param historicJobLogQueryDto  (optional)
     * @return ApiResponse&lt;CountResultDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<CountResultDto> queryHistoricJobLogsCountWithHttpInfo(HistoricJobLogQueryDto historicJobLogQueryDto) throws ApiException {
        okhttp3.Call localVarCall = queryHistoricJobLogsCountValidateBeforeCall(historicJobLogQueryDto, null);
        Type localVarReturnType = new TypeToken<CountResultDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get Job Log Count (POST) (asynchronously)
     * Queries for the number of historic job logs that fulfill the given parameters. This method takes the same message body as the [Get Job Logs (POST)](https://docs.camunda.org/manual/7.17/reference/rest/history/job-log/post-job-log-query/) method and therefore it is slightly more powerful than the [Get Job Log Count](https://docs.camunda.org/manual/7.17/reference/rest/history/job-log/get-job-log-query-count/) method.
     * @param historicJobLogQueryDto  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Request successful. </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Returned if some of the query parameters are invalid. See the [Introduction](https://docs.camunda.org/manual/7.17/reference/rest/overview/#error-handling) for the error response format. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call queryHistoricJobLogsCountAsync(HistoricJobLogQueryDto historicJobLogQueryDto, final ApiCallback<CountResultDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = queryHistoricJobLogsCountValidateBeforeCall(historicJobLogQueryDto, _callback);
        Type localVarReturnType = new TypeToken<CountResultDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}
