/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.webapp.impl.filter;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class AbstractTemplateFilter
implements Filter {
    private FilterConfig filterConfig;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.filterConfig = filterConfig;
    }

    public void destroy() {
        this.filterConfig = null;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        this.applyFilter((HttpServletRequest)request, (HttpServletResponse)response, chain);
    }

    protected abstract void applyFilter(HttpServletRequest var1, HttpServletResponse var2, FilterChain var3) throws IOException, ServletException;

    protected boolean hasWebResource(String name) {
        try {
            URL resource = this.filterConfig.getServletContext().getResource(name);
            return resource != null;
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getWebResourceContents(String name) throws IOException {
        InputStream is = null;
        try {
            is = this.filterConfig.getServletContext().getResourceAsStream(name);
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            StringWriter writer = new StringWriter();
            String line = null;
            while ((line = reader.readLine()) != null) {
                writer.write(line);
                writer.append("\n");
            }
            String string = writer.toString();
            return string;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

