/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.cockpit.impl.plugin.base.sub.resources;

import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriInfo;
import org.camunda.bpm.cockpit.impl.plugin.base.dto.CalledProcessInstanceDto;
import org.camunda.bpm.cockpit.impl.plugin.base.dto.query.CalledProcessInstanceQueryDto;
import org.camunda.bpm.cockpit.plugin.resource.AbstractPluginResource;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;

public class ProcessInstanceResource
extends AbstractPluginResource {
    protected String id;

    public ProcessInstanceResource(String engineName, String id) {
        super(engineName);
        this.id = id;
    }

    @GET
    @Path(value="/called-process-instances")
    @Produces(value={"application/json"})
    public List<CalledProcessInstanceDto> getCalledProcessInstances(@Context UriInfo uriInfo) {
        CalledProcessInstanceQueryDto queryParameter = new CalledProcessInstanceQueryDto((MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        return this.queryCalledProcessInstances(queryParameter);
    }

    @POST
    @Path(value="/called-process-instances")
    @Produces(value={"application/json"})
    public List<CalledProcessInstanceDto> queryCalledProcessInstances(CalledProcessInstanceQueryDto queryParameter) {
        queryParameter.setParentProcessInstanceId(this.id);
        this.configureExecutionQuery(queryParameter);
        queryParameter.disableMaxResultsLimit();
        return this.getQueryService().executeQuery("selectCalledProcessInstances", queryParameter);
    }

    protected void configureExecutionQuery(CalledProcessInstanceQueryDto query) {
        this.configureAuthorizationCheck(query);
        this.configureTenantCheck(query);
        this.addPermissionCheck(query, (Resource)Resources.PROCESS_INSTANCE, "EXEC1.PROC_INST_ID_", (Permission)Permissions.READ);
        this.addPermissionCheck(query, (Resource)Resources.PROCESS_DEFINITION, "PROCDEF.KEY_", (Permission)Permissions.READ_INSTANCE);
    }
}

