/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.webapp.impl.security.auth;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.identity.Group;
import org.camunda.bpm.engine.identity.Tenant;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.webapp.impl.security.auth.Authentication;
import org.camunda.bpm.webapp.impl.security.auth.AuthenticationDto;
import org.camunda.bpm.webapp.impl.security.auth.AuthenticationService;
import org.camunda.bpm.webapp.impl.security.auth.Authentications;
import org.camunda.bpm.webapp.impl.security.auth.UserAuthentication;
import org.camunda.bpm.webapp.impl.util.ProcessEngineUtil;

@Path(value="/auth/user")
public class UserAuthenticationResource {
    public static final String PATH = "/auth/user";
    @Context
    protected HttpServletRequest request;

    @GET
    @Path(value="/{processEngineName}")
    public Response getAuthenticatedUser(@PathParam(value="processEngineName") String engineName) {
        Authentications allAuthentications = Authentications.getCurrent();
        if (allAuthentications == null) {
            return this.notFound();
        }
        Authentication engineAuth = allAuthentications.getAuthenticationForProcessEngine(engineName);
        if (engineAuth == null) {
            return this.notFound();
        }
        return Response.ok((Object)AuthenticationDto.fromAuthentication(engineAuth)).build();
    }

    @POST
    @Path(value="/{processEngineName}/login/{appName}")
    public Response doLogin(@PathParam(value="processEngineName") String engineName, @PathParam(value="appName") String appName, @FormParam(value="username") String username, @FormParam(value="password") String password) {
        ProcessEngine processEngine = ProcessEngineUtil.lookupProcessEngine(engineName);
        if (processEngine == null) {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, "Process engine with name " + engineName + " does not exist");
        }
        processEngine.getIdentityService().clearAuthentication();
        boolean isPasswordValid = processEngine.getIdentityService().checkPassword(username, password);
        if (!isPasswordValid) {
            return this.unauthorized();
        }
        AuthenticationService authenticationService = new AuthenticationService();
        UserAuthentication authentication = (UserAuthentication)authenticationService.createAuthenticate(processEngine, username, null, null);
        Set<String> authorizedApps = authentication.getAuthorizedApps();
        if (!authorizedApps.contains(appName)) {
            return this.forbidden();
        }
        if (this.request != null) {
            Authentications.revalidateSession(this.request, authentication);
        }
        return Response.ok((Object)AuthenticationDto.fromAuthentication(authentication)).build();
    }

    protected List<String> getGroupsOfUser(ProcessEngine engine, String userId) {
        List groups = engine.getIdentityService().createGroupQuery().groupMember(userId).list();
        ArrayList<String> groupIds = new ArrayList<String>();
        for (Group group : groups) {
            groupIds.add(group.getId());
        }
        return groupIds;
    }

    protected List<String> getTenantsOfUser(ProcessEngine engine, String userId) {
        List tenants = engine.getIdentityService().createTenantQuery().userMember(userId).includingGroupsOfUser(true).list();
        ArrayList<String> tenantIds = new ArrayList<String>();
        for (Tenant tenant : tenants) {
            tenantIds.add(tenant.getId());
        }
        return tenantIds;
    }

    @POST
    @Path(value="/{processEngineName}/logout")
    public Response doLogout(@PathParam(value="processEngineName") String engineName) {
        Authentications authentications = Authentications.getCurrent();
        authentications.removeAuthenticationForProcessEngine(engineName);
        return Response.ok().build();
    }

    protected Response unauthorized() {
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
    }

    protected Response forbidden() {
        return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
    }

    protected Response notFound() {
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }
}

