/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.spring.boot.starter.property;

import org.camunda.bpm.spring.boot.starter.property.CamundaBpmProperties;
import org.camunda.bpm.spring.boot.starter.property.CsrfProperties;
import org.camunda.bpm.spring.boot.starter.property.HeaderSecurityProperties;
import org.camunda.bpm.spring.boot.starter.property.SessionCookieProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;

public class WebappProperty {
    public static final String DEFAULT_APP_PATH = "/camunda";
    public static final String PREFIX = "camunda.bpm.webapp";
    protected boolean indexRedirectEnabled = true;
    protected String webjarClasspath = "/META-INF/resources/webjars/camunda";
    protected String securityConfigFile = "/securityFilterRules.json";
    protected String applicationPath = "/camunda";
    @NestedConfigurationProperty
    private CsrfProperties csrf = new CsrfProperties();
    @NestedConfigurationProperty
    private SessionCookieProperties sessionCookie = new SessionCookieProperties();
    @NestedConfigurationProperty
    protected HeaderSecurityProperties headerSecurity = new HeaderSecurityProperties();

    public boolean isIndexRedirectEnabled() {
        return this.indexRedirectEnabled;
    }

    public void setIndexRedirectEnabled(boolean indexRedirectEnabled) {
        this.indexRedirectEnabled = indexRedirectEnabled;
    }

    public String getWebjarClasspath() {
        return this.webjarClasspath;
    }

    public void setWebjarClasspath(String webjarClasspath) {
        this.webjarClasspath = webjarClasspath;
    }

    public String getSecurityConfigFile() {
        return this.securityConfigFile;
    }

    public void setSecurityConfigFile(String securityConfigFile) {
        this.securityConfigFile = securityConfigFile;
    }

    public String getApplicationPath() {
        return this.applicationPath;
    }

    public void setApplicationPath(String applicationPath) {
        this.applicationPath = this.sanitizeApplicationPath(applicationPath);
    }

    protected String sanitizeApplicationPath(String applicationPath) {
        if (applicationPath == null || applicationPath.isEmpty()) {
            return "";
        }
        if (!applicationPath.startsWith("/")) {
            applicationPath = "/" + applicationPath;
        }
        if (applicationPath.endsWith("/")) {
            applicationPath = applicationPath.substring(0, applicationPath.length() - 1);
        }
        return applicationPath;
    }

    public CsrfProperties getCsrf() {
        return this.csrf;
    }

    public void setCsrf(CsrfProperties csrf) {
        this.csrf = csrf;
    }

    public SessionCookieProperties getSessionCookie() {
        return this.sessionCookie;
    }

    public void setSessionCookie(SessionCookieProperties sessionCookie) {
        this.sessionCookie = sessionCookie;
    }

    public HeaderSecurityProperties getHeaderSecurity() {
        return this.headerSecurity;
    }

    public void setHeaderSecurity(HeaderSecurityProperties headerSecurity) {
        this.headerSecurity = headerSecurity;
    }

    public String toString() {
        return CamundaBpmProperties.joinOn(this.getClass()).add("indexRedirectEnabled=" + this.indexRedirectEnabled).add("webjarClasspath='" + this.webjarClasspath + '\'').add("securityConfigFile='" + this.securityConfigFile + '\'').add("webappPath='" + this.applicationPath + '\'').add("csrf='" + this.csrf + '\'').add("headerSecurityProperties='" + this.headerSecurity + '\'').add("sessionCookie='" + this.sessionCookie + '\'').toString();
    }
}

