/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.spring.boot.starter.configuration.impl.custom;

import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.PostConstruct;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.filter.Filter;
import org.camunda.bpm.spring.boot.starter.configuration.impl.AbstractCamundaConfiguration;
import org.camunda.bpm.spring.boot.starter.property.FilterProperty;

public class CreateFilterConfiguration
extends AbstractCamundaConfiguration {
    protected String filterName;

    @PostConstruct
    public void init() {
        this.filterName = Optional.ofNullable(this.camundaBpmProperties.getFilter()).map(FilterProperty::getCreate).orElseThrow(CreateFilterConfiguration.fail("filter.create not configured!"));
    }

    @Override
    public void postProcessEngineBuild(ProcessEngine processEngine) {
        Objects.requireNonNull(this.filterName);
        long filterCount = processEngine.getFilterService().createFilterQuery().filterName(this.filterName).count();
        if (filterCount == 0L) {
            Filter filter = processEngine.getFilterService().newTaskFilter(this.filterName);
            processEngine.getFilterService().saveFilter(filter);
            LOG.createInitialFilter(filter);
        } else {
            LOG.skipCreateInitialFilter(this.filterName);
        }
    }

    public String toString() {
        return this.createToString(Collections.singletonMap("filterName", this.filterName));
    }
}

