/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.spring.boot.starter.configuration.impl;

import org.camunda.bpm.engine.impl.history.handler.CompositeDbHistoryEventHandler;
import org.camunda.bpm.engine.impl.history.handler.CompositeHistoryEventHandler;
import org.camunda.bpm.engine.impl.history.handler.HistoryEventHandler;
import org.camunda.bpm.engine.spring.SpringProcessEngineConfiguration;
import org.camunda.bpm.spring.boot.starter.configuration.CamundaHistoryConfiguration;
import org.camunda.bpm.spring.boot.starter.configuration.impl.AbstractCamundaConfiguration;
import org.springframework.beans.factory.annotation.Autowired;

public class DefaultHistoryConfiguration
extends AbstractCamundaConfiguration
implements CamundaHistoryConfiguration {
    @Autowired(required=false)
    protected HistoryEventHandler historyEventHandler;

    @Override
    public void preInit(SpringProcessEngineConfiguration configuration) {
        String historyLevel = this.camundaBpmProperties.getHistoryLevel();
        if (historyLevel != null) {
            configuration.setHistory(historyLevel);
        }
        HistoryEventHandler existingHandler = configuration.getHistoryEventHandler();
        if (this.historyEventHandler != null) {
            this.logger.debug("registered history event handler: {}", this.historyEventHandler.getClass());
            CompositeHistoryEventHandler compositeHandler = new CompositeHistoryEventHandler(new HistoryEventHandler[]{this.historyEventHandler});
            if (existingHandler != null) {
                compositeHandler.add(existingHandler);
            }
            configuration.setHistoryEventHandler((HistoryEventHandler)compositeHandler);
        } else {
            this.logger.debug("registered history event handler: {}", CompositeDbHistoryEventHandler.class);
            CompositeDbHistoryEventHandler compositeDbHandler = new CompositeDbHistoryEventHandler();
            if (existingHandler != null) {
                compositeDbHandler.add(existingHandler);
            }
            configuration.setHistoryEventHandler((HistoryEventHandler)compositeDbHandler);
        }
    }
}

