/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.spring.boot.starter.event;

import org.camunda.bpm.engine.impl.history.handler.CompositeHistoryEventHandler;
import org.camunda.bpm.engine.impl.history.handler.HistoryEventHandler;
import org.camunda.bpm.engine.spring.SpringProcessEngineConfiguration;
import org.camunda.bpm.spring.boot.starter.event.PublishDelegateParseListener;
import org.camunda.bpm.spring.boot.starter.event.PublishHistoryEventHandler;
import org.camunda.bpm.spring.boot.starter.property.CamundaBpmProperties;
import org.camunda.bpm.spring.boot.starter.property.EventingProperty;
import org.camunda.bpm.spring.boot.starter.util.SpringBootProcessEnginePlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;

public class EventPublisherPlugin
extends SpringBootProcessEnginePlugin {
    private static final Logger logger = LoggerFactory.getLogger(EventPublisherPlugin.class);
    private final EventingProperty property;
    private final ApplicationEventPublisher publisher;

    public EventPublisherPlugin(CamundaBpmProperties properties, ApplicationEventPublisher publisher) {
        this(properties.getEventing(), publisher);
    }

    public EventPublisherPlugin(EventingProperty property, ApplicationEventPublisher publisher) {
        this.property = property;
        this.publisher = publisher;
    }

    @Override
    public void preInit(SpringProcessEngineConfiguration processEngineConfiguration) {
        if (!(this.property.isTask().booleanValue() || this.property.isExecution() || this.property.isHistory().booleanValue())) {
            logger.info("EVENTING-002: Camunda Spring Boot Eventing Plugin is found, but disabled via property.");
            return;
        }
        if (this.property.isTask().booleanValue() || this.property.isExecution()) {
            logger.info("EVENTING-001: Initialized Camunda Spring Boot Eventing Engine Plugin.");
            if (this.property.isTask().booleanValue()) {
                logger.info("EVENTING-003: Task events will be published as Spring Events.");
            } else {
                logger.info("EVENTING-004: Task eventing is disabled via property.");
            }
            if (this.property.isExecution()) {
                logger.info("EVENTING-005: Execution events will be published as Spring Events.");
            } else {
                logger.info("EVENTING-006: Execution eventing is disabled via property.");
            }
            processEngineConfiguration.getCustomPostBPMNParseListeners().add(new PublishDelegateParseListener(this.publisher, this.property));
        }
        if (this.property.isHistory().booleanValue()) {
            logger.info("EVENTING-007: History events will be published as Spring events.");
            CompositeHistoryEventHandler compositeHandler = new CompositeHistoryEventHandler(new HistoryEventHandler[]{new PublishHistoryEventHandler(this.publisher)});
            HistoryEventHandler existingHandler = processEngineConfiguration.getHistoryEventHandler();
            if (existingHandler != null) {
                compositeHandler.add(existingHandler);
            }
            processEngineConfiguration.setHistoryEventHandler((HistoryEventHandler)compositeHandler);
        } else {
            logger.info("EVENTING-008: History eventing is disabled via property.");
        }
    }
}

