/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.spring.boot.starter.util;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.apache.commons.lang.StringUtils;
import org.camunda.bpm.spring.boot.starter.annotation.EnableProcessApplication;
import org.springframework.context.ApplicationContext;

public class GetProcessApplicationNameFromAnnotation
implements Supplier<Optional<String>>,
UnaryOperator<Optional<String>> {
    private static final Predicate<Map.Entry<String, Object>> ANNOTATED_WITH_ENABLEPROCESSAPPLICATION = e -> Optional.ofNullable(e.getValue()).map(Object::getClass).map(c -> c.isAnnotationPresent(EnableProcessApplication.class)).orElse(false);
    private final ApplicationContext applicationContext;
    public static Function<ApplicationContext, Optional<AnnotatedBean>> getAnnotatedBean = applicationContext -> {
        Set beans = Optional.ofNullable(applicationContext.getBeansWithAnnotation(EnableProcessApplication.class)).map(Map::entrySet).orElse(Collections.emptySet());
        return beans.stream().filter(ANNOTATED_WITH_ENABLEPROCESSAPPLICATION).map(e -> AnnotatedBean.of((String)e.getKey(), e.getValue())).reduce((u, v) -> {
            throw new IllegalStateException("requires exactly one bean to be annotated with @EnableProcessApplication, found: " + beans);
        });
    };
    public static Function<EnableProcessApplication, Optional<String>> getAnnotationValue = annotation -> Optional.of(annotation).map(EnableProcessApplication::value).filter(StringUtils::isNotBlank);
    public static Function<AnnotatedBean, String> getName = pair -> Optional.of(pair.getAnnotation()).flatMap(getAnnotationValue).orElse(pair.getName());
    public static Function<ApplicationContext, Optional<String>> getProcessApplicationName = applicationContext -> getAnnotatedBean.apply((ApplicationContext)applicationContext).map(getName);

    public static GetProcessApplicationNameFromAnnotation processApplicationNameFromAnnotation(ApplicationContext applicationContext) {
        return new GetProcessApplicationNameFromAnnotation(applicationContext);
    }

    private GetProcessApplicationNameFromAnnotation(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @Override
    public Optional<String> get() {
        return getProcessApplicationName.apply(this.applicationContext);
    }

    @Override
    public Optional<String> apply(Optional<String> springApplicationName) {
        Optional<String> processApplicationName = getProcessApplicationName.apply(this.applicationContext);
        if (processApplicationName.isPresent()) {
            return processApplicationName;
        }
        if (springApplicationName.isPresent()) {
            return springApplicationName;
        }
        return Optional.empty();
    }

    public static class AnnotatedBean {
        String name;
        EnableProcessApplication annotation;

        public AnnotatedBean(String name, EnableProcessApplication annotation) {
            this.name = name;
            this.annotation = annotation;
        }

        public static AnnotatedBean of(String name, EnableProcessApplication annotation) {
            return new AnnotatedBean(name, annotation);
        }

        public static AnnotatedBean of(String name, Object instance) {
            return AnnotatedBean.of(name, instance.getClass().getAnnotation(EnableProcessApplication.class));
        }

        public static AnnotatedBean ofEntry(Map.Entry<String, Object> entry) {
            return AnnotatedBean.of(entry.getKey(), entry.getValue());
        }

        public String getName() {
            return this.name;
        }

        public EnableProcessApplication getAnnotation() {
            return this.annotation;
        }

        public int hashCode() {
            return Objects.hash(this.name, this.annotation);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof AnnotatedBean)) {
                return false;
            }
            AnnotatedBean other = (AnnotatedBean)obj;
            return Objects.equals(this.name, other.name) && Objects.equals(this.annotation, other.annotation);
        }

        public String toString() {
            return "AnnotatedBean [name=" + this.name + ", annotation=" + this.annotation + "]";
        }
    }
}

