/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.spring.boot.starter.configuration.impl.custom;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Optional;
import java.util.Scanner;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.ManagementServiceImpl;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.spring.boot.starter.configuration.impl.AbstractCamundaConfiguration;
import org.camunda.bpm.spring.boot.starter.util.CamundaBpmVersion;
import org.springframework.beans.factory.annotation.Autowired;

public class EnterLicenseKeyConfiguration
extends AbstractCamundaConfiguration {
    protected static final String LICENSE_KEY_PROPERTY = "camunda-license-key";
    protected static final String DEFAULT_LICENSE_FILE = "camunda-license.txt";
    private static final String LICENSE_HEADER_FOOTER_REGEX = "(?i)[-\\s]*(BEGIN|END)\\s*(OPTIMIZE|CAMUNDA|CAMUNDA\\s*BPM)\\s*LICENSE\\s*KEY[-\\s]*";
    @Autowired
    protected CamundaBpmVersion version;

    @Override
    public void postProcessEngineBuild(ProcessEngine processEngine) {
        if (!this.version.isEnterprise()) {
            return;
        }
        URL fileUrl = this.camundaBpmProperties.getLicenseFile();
        Optional<String> licenseKey = this.readLicenseKeyFromUrl(fileUrl);
        if (!licenseKey.isPresent()) {
            fileUrl = EnterLicenseKeyConfiguration.class.getClassLoader().getResource(DEFAULT_LICENSE_FILE);
            licenseKey = this.readLicenseKeyFromUrl(fileUrl);
        }
        if (!licenseKey.isPresent()) {
            return;
        }
        Optional<String> existingLicenseKey = Optional.ofNullable(this.getLicenseKey(processEngine));
        if (existingLicenseKey.isPresent()) {
            return;
        }
        Optional<String> finalLicenseKey = licenseKey;
        ProcessEngineConfigurationImpl processEngineConfiguration = (ProcessEngineConfigurationImpl)processEngine.getProcessEngineConfiguration();
        processEngineConfiguration.getCommandExecutorTxRequired().execute(commandContext -> {
            this.setLicenseKey(processEngine, (String)finalLicenseKey.get());
            return null;
        });
        LOG.enterLicenseKey(fileUrl);
    }

    protected Optional<String> readLicenseKeyFromUrl(URL licenseFileUrl) {
        if (licenseFileUrl == null) {
            return Optional.empty();
        }
        try {
            return Optional.of(new Scanner(licenseFileUrl.openStream(), "UTF-8").useDelimiter("\\A")).filter(Scanner::hasNext).map(Scanner::next).map(s -> s.replaceAll(LICENSE_HEADER_FOOTER_REGEX, "")).map(s -> s.replaceAll("\\n", "")).map(String::trim);
        }
        catch (IOException e) {
            LOG.enterLicenseKeyFailed(licenseFileUrl, e);
            return Optional.empty();
        }
    }

    protected String getLicenseKey(ProcessEngine processEngine) {
        try {
            return (String)ManagementServiceImpl.class.getDeclaredMethod("getLicenseKey", new Class[0]).invoke((Object)processEngine.getManagementService(), new Object[0]);
        }
        catch (NoSuchMethodException e) {
            return (String)processEngine.getManagementService().getProperties().get(LICENSE_KEY_PROPERTY);
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException e) {
            throw new ProcessEngineException((Throwable)e);
        }
    }

    private void setLicenseKey(ProcessEngine processEngine, String license) {
        try {
            ManagementServiceImpl.class.getDeclaredMethod("setLicenseKey", String.class).invoke((Object)processEngine.getManagementService(), license);
        }
        catch (NoSuchMethodException e) {
            processEngine.getManagementService().setProperty(LICENSE_KEY_PROPERTY, license);
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException e) {
            throw new ProcessEngineException((Throwable)e);
        }
    }
}

