/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.spring.boot.starter.util;

import java.util.Arrays;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.camunda.bpm.engine.ProcessEngine;
import org.springframework.core.env.PropertiesPropertySource;

public class CamundaBpmVersion
implements Supplier<String> {
    private static final String VERSION_FORMAT = "(v%s)";
    public static final String VERSION = "version";
    public static final String IS_ENTERPRISE = "is-enterprise";
    public static final String FORMATTED_VERSION = "formatted-version";
    private final String version;
    private final boolean isEnterprise;
    private final String formattedVersion;

    public static String key(String name) {
        return "camunda.bpm." + name;
    }

    public CamundaBpmVersion() {
        this(ProcessEngine.class.getPackage());
    }

    CamundaBpmVersion(Package pkg) {
        this.version = Optional.ofNullable(pkg.getImplementationVersion()).map(String::trim).orElse("");
        this.isEnterprise = this.version.endsWith("-ee");
        this.formattedVersion = String.format(VERSION_FORMAT, this.version);
    }

    @Override
    public String get() {
        return this.version;
    }

    public boolean isEnterprise() {
        return this.isEnterprise;
    }

    public PropertiesPropertySource getPropertiesPropertySource() {
        Properties props = new Properties();
        props.put(CamundaBpmVersion.key(VERSION), this.version);
        props.put(CamundaBpmVersion.key(IS_ENTERPRISE), (Object)this.isEnterprise);
        props.put(CamundaBpmVersion.key(FORMATTED_VERSION), this.formattedVersion);
        return new PropertiesPropertySource(this.getClass().getSimpleName(), props);
    }

    public boolean isLaterThanOrEqual(String versionToCompare) {
        String currentVersion = this.version;
        Pattern semVerRegex = Pattern.compile("^((0|[1-9]\\d*)\\.(0|[1-9]\\d*)\\.(0|[1-9]\\d*)).*");
        Matcher srcVersionMatcher = semVerRegex.matcher(this.version);
        Matcher trgVersionMatcher = semVerRegex.matcher(versionToCompare);
        if (!srcVersionMatcher.matches() || !trgVersionMatcher.matches()) {
            throw new RuntimeException(String.format("Exception while checking version numbers '%s' and '%s'. Version numbers are missing or incompatible.", this.version, versionToCompare));
        }
        currentVersion = srcVersionMatcher.group(1);
        if (currentVersion.equals(versionToCompare = trgVersionMatcher.group(1))) {
            return true;
        }
        int[] currentVersionNumbers = Arrays.stream(currentVersion.split("\\.")).mapToInt(Integer::parseInt).toArray();
        int[] comparingVersionNumbers = Arrays.stream(versionToCompare.split("\\.")).mapToInt(Integer::parseInt).toArray();
        for (int i = 0; i < 3; ++i) {
            if (currentVersionNumbers[i] == comparingVersionNumbers[i]) continue;
            return currentVersionNumbers[i] > comparingVersionNumbers[i];
        }
        return false;
    }
}

