/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.spring.boot.starter.security.oauth2;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;

@ConfigurationProperties(value="camunda.bpm.oauth2")
public class OAuth2Properties {
    public static final String PREFIX = "camunda.bpm.oauth2";
    @NestedConfigurationProperty
    private OAuth2SSOLogoutProperties ssoLogout = new OAuth2SSOLogoutProperties();
    @NestedConfigurationProperty
    private OAuth2IdentityProviderProperties identityProvider = new OAuth2IdentityProviderProperties();

    public OAuth2SSOLogoutProperties getSsoLogout() {
        return this.ssoLogout;
    }

    public void setSsoLogout(OAuth2SSOLogoutProperties ssoLogout) {
        this.ssoLogout = ssoLogout;
    }

    public OAuth2IdentityProviderProperties getIdentityProvider() {
        return this.identityProvider;
    }

    public void setIdentityProvider(OAuth2IdentityProviderProperties identityProvider) {
        this.identityProvider = identityProvider;
    }

    public static class OAuth2SSOLogoutProperties {
        private boolean enabled = false;
        private String postLogoutRedirectUri = "{baseUrl}";

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public String getPostLogoutRedirectUri() {
            return this.postLogoutRedirectUri;
        }

        public void setPostLogoutRedirectUri(String postLogoutRedirectUri) {
            this.postLogoutRedirectUri = postLogoutRedirectUri;
        }
    }

    public static class OAuth2IdentityProviderProperties {
        private boolean enabled = true;
        private String groupNameAttribute;
        private String groupNameDelimiter = ",";

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public String getGroupNameAttribute() {
            return this.groupNameAttribute;
        }

        public void setGroupNameAttribute(String groupNameAttribute) {
            this.groupNameAttribute = groupNameAttribute;
        }

        public String getGroupNameDelimiter() {
            return this.groupNameDelimiter;
        }

        public void setGroupNameDelimiter(String groupNameDelimiter) {
            this.groupNameDelimiter = groupNameDelimiter;
        }
    }
}

