/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.spring.boot.starter.security.oauth2;

import jakarta.annotation.Nullable;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.Filter;
import java.util.Map;
import org.camunda.bpm.engine.spring.SpringProcessEngineServicesConfiguration;
import org.camunda.bpm.spring.boot.starter.CamundaBpmAutoConfiguration;
import org.camunda.bpm.spring.boot.starter.property.CamundaBpmProperties;
import org.camunda.bpm.spring.boot.starter.property.WebappProperty;
import org.camunda.bpm.spring.boot.starter.security.oauth2.OAuth2Properties;
import org.camunda.bpm.spring.boot.starter.security.oauth2.impl.AuthorizeTokenFilter;
import org.camunda.bpm.spring.boot.starter.security.oauth2.impl.OAuth2AuthenticationProvider;
import org.camunda.bpm.spring.boot.starter.security.oauth2.impl.OAuth2GrantedAuthoritiesMapper;
import org.camunda.bpm.spring.boot.starter.security.oauth2.impl.OAuth2IdentityProviderPlugin;
import org.camunda.bpm.spring.boot.starter.security.oauth2.impl.SsoLogoutSuccessHandler;
import org.camunda.bpm.webapp.impl.security.auth.ContainerBasedAuthenticationFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.security.oauth2.client.ClientsConfiguredCondition;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.core.authority.mapping.GrantedAuthoritiesMapper;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientManager;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.client.web.OAuth2AuthorizationRequestRedirectFilter;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;

@AutoConfigureOrder(value=-2147483548)
@AutoConfigureAfter(value={CamundaBpmAutoConfiguration.class, SpringProcessEngineServicesConfiguration.class})
@ConditionalOnBean(value={CamundaBpmProperties.class})
@Conditional(value={ClientsConfiguredCondition.class})
@EnableConfigurationProperties(value={OAuth2Properties.class})
public class CamundaSpringSecurityOAuth2AutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(CamundaSpringSecurityOAuth2AutoConfiguration.class);
    public static final int CAMUNDA_OAUTH2_ORDER = -2147483548;
    private final OAuth2Properties oAuth2Properties;
    private final String webappPath;

    public CamundaSpringSecurityOAuth2AutoConfiguration(CamundaBpmProperties properties, OAuth2Properties oAuth2Properties) {
        this.oAuth2Properties = oAuth2Properties;
        WebappProperty webapp = properties.getWebapp();
        this.webappPath = webapp.getApplicationPath();
    }

    @Bean
    public FilterRegistrationBean<?> webappAuthenticationFilter() {
        FilterRegistrationBean filterRegistration = new FilterRegistrationBean();
        filterRegistration.setName("Container Based Authentication Filter");
        filterRegistration.setFilter((Filter)new ContainerBasedAuthenticationFilter());
        filterRegistration.setInitParameters(Map.of("authentication-provider", OAuth2AuthenticationProvider.class.getName()));
        filterRegistration.setOrder(-99);
        filterRegistration.addUrlPatterns(new String[]{this.webappPath + "/app/*", this.webappPath + "/api/*"});
        filterRegistration.setDispatcherTypes(DispatcherType.REQUEST, new DispatcherType[0]);
        return filterRegistration;
    }

    @Bean
    @ConditionalOnProperty(name={"identity-provider.enabled"}, havingValue="true", prefix="camunda.bpm.oauth2", matchIfMissing=true)
    public OAuth2IdentityProviderPlugin identityProviderPlugin() {
        logger.debug("Registering OAuth2IdentityProviderPlugin");
        return new OAuth2IdentityProviderPlugin();
    }

    @Bean
    @ConditionalOnProperty(name={"identity-provider.group-name-attribute"}, prefix="camunda.bpm.oauth2")
    protected GrantedAuthoritiesMapper grantedAuthoritiesMapper() {
        logger.debug("Registering OAuth2GrantedAuthoritiesMapper");
        return new OAuth2GrantedAuthoritiesMapper(this.oAuth2Properties);
    }

    @Bean
    @ConditionalOnProperty(name={"sso-logout.enabled"}, havingValue="true", prefix="camunda.bpm.oauth2")
    protected SsoLogoutSuccessHandler ssoLogoutSuccessHandler(ClientRegistrationRepository clientRegistrationRepository) {
        logger.debug("Registering SsoLogoutSuccessHandler");
        return new SsoLogoutSuccessHandler(clientRegistrationRepository, this.oAuth2Properties);
    }

    @Bean
    protected AuthorizeTokenFilter authorizeTokenFilter(OAuth2AuthorizedClientManager clientManager) {
        logger.debug("Registering AuthorizeTokenFilter");
        return new AuthorizeTokenFilter(clientManager);
    }

    @Bean
    public SecurityFilterChain filterChain(HttpSecurity http, AuthorizeTokenFilter authorizeTokenFilter, @Nullable SsoLogoutSuccessHandler ssoLogoutSuccessHandler) throws Exception {
        logger.info("Enabling Camunda Spring Security oauth2 integration");
        http.authorizeHttpRequests(c -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)c.requestMatchers(new String[]{this.webappPath + "/app/**"})).authenticated().requestMatchers(new String[]{this.webappPath + "/api/**"})).authenticated().anyRequest()).permitAll()).addFilterAfter((Filter)authorizeTokenFilter, OAuth2AuthorizationRequestRedirectFilter.class).anonymous(AbstractHttpConfigurer::disable).oidcLogout(c -> c.backChannel(Customizer.withDefaults())).oauth2Login(Customizer.withDefaults()).logout(c -> c.clearAuthentication(true).invalidateHttpSession(true)).oauth2Client(Customizer.withDefaults()).cors(AbstractHttpConfigurer::disable).csrf(AbstractHttpConfigurer::disable);
        if (this.oAuth2Properties.getSsoLogout().isEnabled()) {
            http.logout(c -> c.logoutSuccessHandler((LogoutSuccessHandler)ssoLogoutSuccessHandler));
        }
        return (SecurityFilterChain)http.build();
    }
}

