/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.spring.boot.starter.security.oauth2.impl;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.camunda.bpm.engine.identity.Group;
import org.camunda.bpm.engine.identity.GroupQuery;
import org.camunda.bpm.engine.identity.NativeUserQuery;
import org.camunda.bpm.engine.identity.Tenant;
import org.camunda.bpm.engine.identity.TenantQuery;
import org.camunda.bpm.engine.identity.User;
import org.camunda.bpm.engine.identity.UserQuery;
import org.camunda.bpm.engine.impl.GroupQueryImpl;
import org.camunda.bpm.engine.impl.Page;
import org.camunda.bpm.engine.impl.TenantQueryImpl;
import org.camunda.bpm.engine.impl.UserQueryImpl;
import org.camunda.bpm.engine.impl.identity.IdentityOperationResult;
import org.camunda.bpm.engine.impl.identity.IdentityProviderException;
import org.camunda.bpm.engine.impl.identity.db.DbIdentityServiceProvider;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.GroupEntity;
import org.camunda.bpm.engine.impl.persistence.entity.TenantEntity;
import org.camunda.bpm.engine.impl.persistence.entity.UserEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.core.oidc.user.OidcUser;

public class OAuth2IdentityProvider
extends DbIdentityServiceProvider {
    private static final Logger logger = LoggerFactory.getLogger(OAuth2IdentityProvider.class);

    protected static void unsupportedOperationForOAuth2() {
        throw new IdentityProviderException("This operation is not supported for OAuth2 identity provider.");
    }

    protected static void unsupportedFilterForOAuth2() {
        throw new IdentityProviderException("This filter is not supported for OAuth2 identity provider.");
    }

    protected static boolean nullOrContainsIgnoreCase(String searchLike, String value) {
        return searchLike == null || value == null || value.toLowerCase().contains(searchLike.replaceAll("%", "").toLowerCase());
    }

    protected boolean springSecurityAuthentication() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        boolean springSecurityAuthenticated = authentication != null && authentication.isAuthenticated();
        logger.debug("Using {}", (Object)(springSecurityAuthenticated ? "OAuth2IdentityProvider" : "DbIdentityServiceProvider"));
        return springSecurityAuthenticated;
    }

    protected static UserEntity transformUser() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication == null) {
            return null;
        }
        Object principal = authentication.getPrincipal();
        String userId = authentication.getName();
        UserEntity user = new UserEntity();
        user.setId(userId);
        if (principal instanceof OidcUser) {
            OidcUser oidcUser = (OidcUser)principal;
            user.setFirstName(oidcUser.getGivenName());
            user.setLastName(oidcUser.getFamilyName());
            user.setEmail(oidcUser.getEmail());
        }
        return user;
    }

    protected static List<Group> transformGroups() {
        return SecurityContextHolder.getContext().getAuthentication().getAuthorities().stream().map(a -> {
            GroupEntity group = new GroupEntity();
            group.setId(a.getAuthority());
            group.setName(a.getAuthority());
            return group;
        }).collect(Collectors.toList());
    }

    public UserEntity findUserById(String userId) {
        if (this.springSecurityAuthentication()) {
            UserEntity user = OAuth2IdentityProvider.transformUser();
            return user != null && Objects.equals(userId, user.getId()) ? user : null;
        }
        return super.findUserById(userId);
    }

    public UserQuery createUserQuery() {
        return this.springSecurityAuthentication() ? new OAuth2UserQuery() : super.createUserQuery();
    }

    public UserQueryImpl createUserQuery(CommandContext commandContext) {
        return this.springSecurityAuthentication() ? new OAuth2UserQuery() : super.createUserQuery(commandContext);
    }

    public NativeUserQuery createNativeUserQuery() {
        if (this.springSecurityAuthentication()) {
            OAuth2IdentityProvider.unsupportedFilterForOAuth2();
            return null;
        }
        return super.createNativeUserQuery();
    }

    public boolean checkPassword(String userId, String password) {
        return !this.springSecurityAuthentication() && super.checkPassword(userId, password);
    }

    public GroupEntity findGroupById(String groupId) {
        if (this.springSecurityAuthentication()) {
            List<Group> groups = OAuth2IdentityProvider.transformGroups();
            return groups.stream().filter(g -> g.getId().equals(groupId)).findFirst().orElse(null);
        }
        return super.findGroupById(groupId);
    }

    public GroupQuery createGroupQuery() {
        return this.springSecurityAuthentication() ? new OAuth2GroupQuery() : super.createGroupQuery();
    }

    public GroupQuery createGroupQuery(CommandContext commandContext) {
        return this.springSecurityAuthentication() ? new OAuth2GroupQuery() : super.createGroupQuery(commandContext);
    }

    public TenantEntity findTenantById(String tenantId) {
        return this.springSecurityAuthentication() ? null : super.findTenantById(tenantId);
    }

    public TenantQuery createTenantQuery() {
        return this.springSecurityAuthentication() ? new OAuth2TenantQuery() : super.createTenantQuery();
    }

    public TenantQuery createTenantQuery(CommandContext commandContext) {
        return this.springSecurityAuthentication() ? new OAuth2TenantQuery() : super.createTenantQuery();
    }

    public void flush() {
        if (!this.springSecurityAuthentication()) {
            super.flush();
        }
    }

    public void close() {
        if (!this.springSecurityAuthentication()) {
            super.flush();
        }
    }

    public UserEntity createNewUser(String userId) {
        if (this.springSecurityAuthentication()) {
            OAuth2IdentityProvider.unsupportedOperationForOAuth2();
        }
        return super.createNewUser(userId);
    }

    public IdentityOperationResult saveUser(User user) {
        if (this.springSecurityAuthentication()) {
            OAuth2IdentityProvider.unsupportedOperationForOAuth2();
        }
        return super.saveUser(user);
    }

    public IdentityOperationResult deleteUser(String userId) {
        if (this.springSecurityAuthentication()) {
            OAuth2IdentityProvider.unsupportedOperationForOAuth2();
        }
        return super.deleteUser(userId);
    }

    public IdentityOperationResult unlockUser(String userId) {
        if (this.springSecurityAuthentication()) {
            OAuth2IdentityProvider.unsupportedOperationForOAuth2();
        }
        return super.unlockUser(userId);
    }

    public GroupEntity createNewGroup(String groupId) {
        if (this.springSecurityAuthentication()) {
            OAuth2IdentityProvider.unsupportedOperationForOAuth2();
        }
        return super.createNewGroup(groupId);
    }

    public IdentityOperationResult saveGroup(Group group) {
        if (this.springSecurityAuthentication()) {
            OAuth2IdentityProvider.unsupportedOperationForOAuth2();
        }
        return super.saveGroup(group);
    }

    public IdentityOperationResult deleteGroup(String groupId) {
        if (this.springSecurityAuthentication()) {
            OAuth2IdentityProvider.unsupportedOperationForOAuth2();
        }
        return super.deleteGroup(groupId);
    }

    public Tenant createNewTenant(String tenantId) {
        if (this.springSecurityAuthentication()) {
            OAuth2IdentityProvider.unsupportedOperationForOAuth2();
        }
        return super.createNewTenant(tenantId);
    }

    public IdentityOperationResult saveTenant(Tenant tenant) {
        if (this.springSecurityAuthentication()) {
            OAuth2IdentityProvider.unsupportedOperationForOAuth2();
        }
        return super.saveTenant(tenant);
    }

    public IdentityOperationResult deleteTenant(String tenantId) {
        if (this.springSecurityAuthentication()) {
            OAuth2IdentityProvider.unsupportedOperationForOAuth2();
        }
        return super.deleteTenant(tenantId);
    }

    public IdentityOperationResult createMembership(String userId, String groupId) {
        if (this.springSecurityAuthentication()) {
            OAuth2IdentityProvider.unsupportedOperationForOAuth2();
        }
        return super.createMembership(userId, groupId);
    }

    public IdentityOperationResult deleteMembership(String userId, String groupId) {
        if (this.springSecurityAuthentication()) {
            OAuth2IdentityProvider.unsupportedOperationForOAuth2();
        }
        return super.deleteMembership(userId, groupId);
    }

    public IdentityOperationResult createTenantUserMembership(String tenantId, String userId) {
        if (this.springSecurityAuthentication()) {
            OAuth2IdentityProvider.unsupportedOperationForOAuth2();
        }
        return super.createTenantUserMembership(tenantId, userId);
    }

    public IdentityOperationResult createTenantGroupMembership(String tenantId, String groupId) {
        if (this.springSecurityAuthentication()) {
            OAuth2IdentityProvider.unsupportedOperationForOAuth2();
        }
        return super.createTenantGroupMembership(tenantId, groupId);
    }

    public IdentityOperationResult deleteTenantUserMembership(String tenantId, String userId) {
        if (this.springSecurityAuthentication()) {
            OAuth2IdentityProvider.unsupportedOperationForOAuth2();
        }
        return super.deleteTenantUserMembership(tenantId, userId);
    }

    public IdentityOperationResult deleteTenantGroupMembership(String tenantId, String groupId) {
        if (this.springSecurityAuthentication()) {
            OAuth2IdentityProvider.unsupportedOperationForOAuth2();
        }
        return super.deleteTenantGroupMembership(tenantId, groupId);
    }

    public static class OAuth2UserQuery
    extends UserQueryImpl {
        public long executeCount(CommandContext commandContext) {
            return 1L;
        }

        public List<User> executeList(CommandContext commandContext, Page page) {
            if (this.tenantId != null) {
                OAuth2IdentityProvider.unsupportedFilterForOAuth2();
            }
            return Stream.of(OAuth2IdentityProvider.transformUser()).filter(Objects::nonNull).filter(u -> this.id == null || this.id.equals(u.getId())).filter(u -> this.ids == null || Arrays.stream(this.ids).anyMatch(id -> u.getId().equals(id))).filter(u -> this.firstName == null || this.firstName.equals(u.getFirstName())).filter(u -> OAuth2IdentityProvider.nullOrContainsIgnoreCase(this.firstNameLike, u.getFirstName())).filter(u -> this.lastName == null || this.lastName.equals(u.getLastName())).filter(u -> OAuth2IdentityProvider.nullOrContainsIgnoreCase(this.lastNameLike, u.getLastName())).filter(u -> this.email == null || this.email.equals(u.getEmail())).filter(u -> OAuth2IdentityProvider.nullOrContainsIgnoreCase(this.emailLike, u.getEmail())).filter(u -> this.groupId == null || OAuth2IdentityProvider.transformGroups().stream().anyMatch(g -> g.getId().equals(this.groupId))).collect(Collectors.toList());
        }
    }

    public static class OAuth2GroupQuery
    extends GroupQueryImpl {
        public long executeCount(CommandContext commandContext) {
            return this.executeList(commandContext, null).size();
        }

        public List<Group> executeList(CommandContext commandContext, Page page) {
            if (this.type != null || this.tenantId != null) {
                OAuth2IdentityProvider.unsupportedFilterForOAuth2();
            }
            return OAuth2IdentityProvider.transformGroups().stream().filter(g -> this.id == null || this.id.equals(g.getId())).filter(g -> this.ids == null || Arrays.stream(this.ids).anyMatch(id -> g.getId().equals(id))).filter(g -> this.name == null || this.name.equals(g.getName())).filter(g -> OAuth2IdentityProvider.nullOrContainsIgnoreCase(this.nameLike, g.getName())).filter(g -> {
                UserEntity user = OAuth2IdentityProvider.transformUser();
                return this.userId == null || user == null || this.userId.equals(user.getId());
            }).collect(Collectors.toList());
        }
    }

    public static class OAuth2TenantQuery
    extends TenantQueryImpl {
        public long executeCount(CommandContext commandContext) {
            return 0L;
        }

        public List<Tenant> executeList(CommandContext commandContext, Page page) {
            return Collections.emptyList();
        }
    }
}

