/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.spring.boot.starter.security.oauth2.impl;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.camunda.bpm.spring.boot.starter.security.oauth2.OAuth2Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.client.oidc.web.logout.OidcClientInitiatedLogoutSuccessHandler;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;

public class SsoLogoutSuccessHandler
extends OidcClientInitiatedLogoutSuccessHandler {
    private static final Logger logger = LoggerFactory.getLogger(SsoLogoutSuccessHandler.class);

    public SsoLogoutSuccessHandler(ClientRegistrationRepository clientRegistrationRepository, OAuth2Properties oAuth2Properties) {
        super(clientRegistrationRepository);
        this.setPostLogoutRedirectUri(oAuth2Properties.getSsoLogout().getPostLogoutRedirectUri());
    }

    public void onLogoutSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException, ServletException {
        logger.debug("Initiating SSO logout for '{}'", (Object)authentication.getName());
        super.onLogoutSuccess(request, response, authentication);
    }
}

