/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.model.xml.test.assertions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.assertj.core.api.AbstractAssert;
import org.camunda.bpm.model.xml.Model;
import org.camunda.bpm.model.xml.impl.util.QName;
import org.camunda.bpm.model.xml.instance.ModelElementInstance;
import org.camunda.bpm.model.xml.type.ModelElementType;
import org.camunda.bpm.model.xml.type.attribute.Attribute;

public class ModelElementTypeAssert
extends AbstractAssert<ModelElementTypeAssert, ModelElementType> {
    private final String typeName;

    protected ModelElementTypeAssert(ModelElementType actual) {
        super((Object)actual, ModelElementTypeAssert.class);
        this.typeName = actual.getTypeName();
    }

    private List<String> getActualAttributeNames() {
        ArrayList<String> actualAttributeNames = new ArrayList<String>();
        for (Attribute<?> attribute : ((ModelElementType)this.actual).getAttributes()) {
            actualAttributeNames.add(attribute.getAttributeName());
        }
        return actualAttributeNames;
    }

    private Collection<String> getTypeNames(Collection<ModelElementType> elementTypes) {
        ArrayList<String> typeNames = new ArrayList<String>();
        for (ModelElementType elementType : elementTypes) {
            QName qName = new QName(elementType.getTypeNamespace(), elementType.getTypeName());
            typeNames.add(qName.toString());
        }
        return typeNames;
    }

    public ModelElementTypeAssert isAbstract() {
        this.isNotNull();
        if (!((ModelElementType)this.actual).isAbstract()) {
            this.failWithMessage("Expected element type <%s> to be abstract but was not", new Object[]{this.typeName});
        }
        return this;
    }

    public ModelElementTypeAssert isNotAbstract() {
        this.isNotNull();
        if (((ModelElementType)this.actual).isAbstract()) {
            this.failWithMessage("Expected element type <%s> not to be abstract but was", new Object[]{this.typeName});
        }
        return this;
    }

    public ModelElementTypeAssert extendsType(ModelElementType baseType) {
        this.isNotNull();
        ModelElementType actualBaseType = ((ModelElementType)this.actual).getBaseType();
        if (!actualBaseType.equals(baseType)) {
            this.failWithMessage("Expected element type <%s> to extend type <%s> but extends <%s>", new Object[]{this.typeName, actualBaseType.getTypeName(), baseType.getTypeName()});
        }
        return this;
    }

    public ModelElementTypeAssert extendsNoType() {
        this.isNotNull();
        ModelElementType actualBaseType = ((ModelElementType)this.actual).getBaseType();
        if (actualBaseType != null) {
            this.failWithMessage("Expected element type <%s> to not extend any type but extends <%s>", new Object[]{this.typeName, actualBaseType.getTypeName()});
        }
        return this;
    }

    public ModelElementTypeAssert hasAttributes() {
        this.isNotNull();
        List<Attribute<?>> actualAttributes = ((ModelElementType)this.actual).getAttributes();
        if (actualAttributes.isEmpty()) {
            this.failWithMessage("Expected element type <%s> to have attributes but has none", new Object[]{this.typeName});
        }
        return this;
    }

    public ModelElementTypeAssert hasAttributes(String ... attributeNames) {
        this.isNotNull();
        List<String> actualAttributeNames = this.getActualAttributeNames();
        if (!actualAttributeNames.containsAll(Arrays.asList(attributeNames))) {
            this.failWithMessage("Expected element type <%s> to have attributes <%s> but has <%s>", new Object[]{this.typeName, attributeNames, actualAttributeNames});
        }
        return this;
    }

    public ModelElementTypeAssert hasNoAttributes() {
        this.isNotNull();
        List<String> actualAttributeNames = this.getActualAttributeNames();
        if (!actualAttributeNames.isEmpty()) {
            this.failWithMessage("Expected element type <%s> to have no attributes but has <%s>", new Object[]{this.typeName, actualAttributeNames});
        }
        return this;
    }

    public ModelElementTypeAssert hasChildElements() {
        this.isNotNull();
        List<ModelElementType> childElementTypes = ((ModelElementType)this.actual).getChildElementTypes();
        if (childElementTypes.isEmpty()) {
            this.failWithMessage("Expected element type <%s> to have child elements but has non", new Object[]{this.typeName});
        }
        return this;
    }

    public ModelElementTypeAssert hasChildElements(ModelElementType ... types) {
        this.isNotNull();
        List<ModelElementType> childElementTypes = Arrays.asList(types);
        List<ModelElementType> actualChildElementTypes = ((ModelElementType)this.actual).getChildElementTypes();
        if (!actualChildElementTypes.containsAll(childElementTypes)) {
            Collection<String> typeNames = this.getTypeNames(childElementTypes);
            Collection<String> actualTypeNames = this.getTypeNames(actualChildElementTypes);
            this.failWithMessage("Expected element type <%s> to have child elements <%s> but has <%s>", new Object[]{this.typeName, typeNames, actualTypeNames});
        }
        return this;
    }

    public ModelElementTypeAssert hasNoChildElements() {
        this.isNotNull();
        Collection<String> actualChildElementTypeNames = this.getTypeNames(((ModelElementType)this.actual).getChildElementTypes());
        if (!actualChildElementTypeNames.isEmpty()) {
            this.failWithMessage("Expected element type <%s> to have no child elements but has <%s>", new Object[]{this.typeName, actualChildElementTypeNames});
        }
        return this;
    }

    public ModelElementTypeAssert hasTypeName(String typeName) {
        this.isNotNull();
        if (!typeName.equals(this.typeName)) {
            this.failWithMessage("Expected element type to have name <%s> but was <%s>", new Object[]{typeName, this.typeName});
        }
        return this;
    }

    public ModelElementTypeAssert hasTypeNamespace(String typeNamespace) {
        this.isNotNull();
        String actualTypeNamespace = ((ModelElementType)this.actual).getTypeNamespace();
        if (!typeNamespace.equals(actualTypeNamespace)) {
            this.failWithMessage("Expected element type <%s> has type namespace <%s> but was <%s>", new Object[]{this.typeName, typeNamespace, actualTypeNamespace});
        }
        return this;
    }

    public ModelElementTypeAssert hasInstanceType(Class<? extends ModelElementInstance> instanceType) {
        this.isNotNull();
        Class<? extends ModelElementInstance> actualInstanceType = ((ModelElementType)this.actual).getInstanceType();
        if (!instanceType.equals(actualInstanceType)) {
            this.failWithMessage("Expected element type <%s> has instance type <%s> but was <%s>", new Object[]{this.typeName, instanceType, actualInstanceType});
        }
        return this;
    }

    public ModelElementTypeAssert isExtended() {
        this.isNotNull();
        Collection<ModelElementType> actualExtendingTypes = ((ModelElementType)this.actual).getExtendingTypes();
        if (actualExtendingTypes.isEmpty()) {
            this.failWithMessage("Expected element type <%s> to be extended by types but was not", new Object[]{this.typeName});
        }
        return this;
    }

    public ModelElementTypeAssert isExtendedBy(ModelElementType ... types) {
        this.isNotNull();
        List<ModelElementType> extendingTypes = Arrays.asList(types);
        Collection<ModelElementType> actualExtendingTypes = ((ModelElementType)this.actual).getExtendingTypes();
        if (!actualExtendingTypes.containsAll(extendingTypes)) {
            Collection<String> typeNames = this.getTypeNames(extendingTypes);
            Collection<String> actualTypeNames = this.getTypeNames(actualExtendingTypes);
            this.failWithMessage("Expected element type <%s> to be extended by types <%s> but is extended by <%s>", new Object[]{this.typeName, typeNames, actualTypeNames});
        }
        return this;
    }

    public ModelElementTypeAssert isNotExtended() {
        this.isNotNull();
        Collection<String> actualExtendingTypeNames = this.getTypeNames(((ModelElementType)this.actual).getExtendingTypes());
        if (!actualExtendingTypeNames.isEmpty()) {
            this.failWithMessage("Expected element type <%s> to be not extend but is extended by <%s>", new Object[]{this.typeName, actualExtendingTypeNames});
        }
        return this;
    }

    public ModelElementTypeAssert isNotExtendedBy(ModelElementType ... types) {
        this.isNotNull();
        List<ModelElementType> notExtendingTypes = Arrays.asList(types);
        Collection<ModelElementType> actualExtendingTypes = ((ModelElementType)this.actual).getExtendingTypes();
        ArrayList<ModelElementType> errorTypes = new ArrayList<ModelElementType>();
        for (ModelElementType notExtendingType : notExtendingTypes) {
            if (!actualExtendingTypes.contains(notExtendingType)) continue;
            errorTypes.add(notExtendingType);
        }
        if (!errorTypes.isEmpty()) {
            Collection<String> errorTypeNames = this.getTypeNames(errorTypes);
            Collection<String> notExtendingTypeNames = this.getTypeNames(notExtendingTypes);
            this.failWithMessage("Expected element type <%s> to be not extended by types <%s> but is extended by <%s>", new Object[]{this.typeName, notExtendingTypeNames, errorTypeNames});
        }
        return this;
    }

    public ModelElementTypeAssert isPartOfModel(Model model) {
        this.isNotNull();
        Model actualModel = ((ModelElementType)this.actual).getModel();
        if (!model.equals(actualModel)) {
            this.failWithMessage("Expected element type <%s> to be part of model <%s> but was part of <%s>", new Object[]{this.typeName, model.getModelName(), actualModel.getModelName()});
        }
        return this;
    }
}

