/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.client.topic.impl;

import java.util.List;
import org.camunda.bpm.client.exception.ExternalTaskClientException;
import org.camunda.bpm.client.impl.EngineClientException;
import org.camunda.bpm.client.impl.ExternalTaskClientLogger;
import org.camunda.bpm.client.topic.impl.dto.TopicRequestDto;

public class TopicSubscriptionManagerLogger
extends ExternalTaskClientLogger {
    protected void exceptionWhilePerformingFetchAndLock(EngineClientException e) {
        this.logError("001", "Exception while fetch and lock task.", e);
    }

    protected void exceptionWhileExecutingExternalTaskHandler(String topicName, Throwable e) {
        this.logError("002", String.format("Exception while executing external task handler '%s'.", topicName), e);
    }

    protected void exceptionWhileShuttingDown(InterruptedException e) {
        this.logError("003", "Exception while shutting down:", e);
    }

    protected void exceptionOnExternalTaskServiceMethodInvocation(String topicName, ExternalTaskClientException e) {
        this.logError("004", String.format("Exception on external task service method invocation for topic '%s':", topicName), e);
    }

    protected void exceptionWhileExecutingBackoffStrategyMethod(Throwable e) {
        this.logError("005", "Exception while executing back off strategy method.", e);
    }

    protected void exceptionWhileAcquiringTasks(Throwable e) {
        this.logError("006", "Exception while acquiring tasks.", e);
    }

    protected void taskHandlerIsNull(String topicName) {
        this.logError("007", String.format("Task handler is null for topic '%s'.", topicName), new Object[0]);
    }

    protected void fetchAndLock(List<TopicRequestDto> subscriptions) {
        this.logDebug("008", String.format("Fetch and lock new external tasks for %d topics", subscriptions.size()), new Object[0]);
    }
}

