/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.client.impl;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.AbstractResponseHandler;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicHeader;
import org.apache.http.util.EntityUtils;
import org.camunda.bpm.client.impl.EngineClientException;
import org.camunda.bpm.client.impl.EngineClientLogger;
import org.camunda.bpm.client.impl.ExternalTaskClientLogger;
import org.camunda.bpm.client.impl.RequestDto;
import org.camunda.bpm.client.interceptor.impl.RequestInterceptorHandler;
import org.camunda.commons.utils.IoUtil;

public class RequestExecutor {
    protected static final EngineClientLogger LOG = ExternalTaskClientLogger.ENGINE_CLIENT_LOGGER;
    protected static final Header HEADER_CONTENT_TYPE_JSON = new BasicHeader("Content-Type", "application/json");
    protected static final Header HEADER_USER_AGENT = new BasicHeader("User-Agent", "Camunda External Task Client");
    protected HttpClient httpClient;
    protected ObjectMapper objectMapper;

    protected RequestExecutor(RequestInterceptorHandler requestInterceptorHandler, ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
        this.initHttpClient(requestInterceptorHandler);
    }

    protected <T> T postRequest(String resourceUrl, RequestDto requestDto, Class<T> responseClass) throws EngineClientException {
        ByteArrayEntity serializedRequest = this.serializeRequest(requestDto);
        HttpUriRequest httpRequest = RequestBuilder.post((String)resourceUrl).addHeader(HEADER_USER_AGENT).addHeader(HEADER_CONTENT_TYPE_JSON).setEntity((HttpEntity)serializedRequest).build();
        return this.executeRequest(httpRequest, responseClass);
    }

    protected byte[] getRequest(String resourceUrl) throws EngineClientException {
        HttpUriRequest httpRequest = RequestBuilder.get((String)resourceUrl).addHeader(HEADER_USER_AGENT).addHeader(HEADER_CONTENT_TYPE_JSON).build();
        return this.executeRequest(httpRequest, byte[].class);
    }

    protected <T> T executeRequest(HttpUriRequest httpRequest, Class<T> responseClass) throws EngineClientException {
        try {
            return (T)this.httpClient.execute(httpRequest, this.handleResponse(responseClass));
        }
        catch (RuntimeException e) {
            Throwable cause = e.getCause();
            if (cause instanceof EngineClientException) {
                throw (EngineClientException)e.getCause();
            }
            throw e;
        }
        catch (HttpResponseException e) {
            throw LOG.exceptionWhileReceivingResponse((HttpRequest)httpRequest, e);
        }
        catch (ClientProtocolException e) {
            throw LOG.exceptionWhileEstablishingConnection((HttpRequest)httpRequest, (IOException)((Object)e));
        }
        catch (IOException e) {
            throw LOG.exceptionWhileEstablishingConnection((HttpRequest)httpRequest, e);
        }
    }

    protected <T> ResponseHandler<T> handleResponse(final Class<T> responseClass) {
        return new AbstractResponseHandler<T>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public T handleEntity(HttpEntity responseEntity) throws IOException {
                Object response = null;
                if (responseClass.isAssignableFrom(byte[].class)) {
                    InputStream inputStream = null;
                    try {
                        inputStream = responseEntity.getContent();
                        response = IoUtil.inputStreamAsByteArray((InputStream)inputStream);
                    }
                    finally {
                        IoUtil.closeSilently((Closeable)inputStream);
                    }
                }
                if (!responseClass.isAssignableFrom(Void.class)) {
                    try {
                        response = RequestExecutor.this.deserializeResponse(responseEntity, responseClass);
                    }
                    catch (EngineClientException e) {
                        throw new RuntimeException(e);
                    }
                }
                try {
                    EntityUtils.consume((HttpEntity)responseEntity);
                }
                catch (IOException e) {
                    LOG.exceptionWhileClosingResourceStream(response, e);
                }
                return response;
            }
        };
    }

    protected <T> T deserializeResponse(HttpEntity httpEntity, Class<T> responseClass) throws EngineClientException {
        try {
            InputStream responseBody = httpEntity.getContent();
            return (T)this.objectMapper.readValue(responseBody, responseClass);
        }
        catch (JsonParseException e) {
            throw LOG.exceptionWhileParsingJsonObject(responseClass, e);
        }
        catch (JsonMappingException e) {
            throw LOG.exceptionWhileMappingJsonObject(responseClass, e);
        }
        catch (IOException e) {
            throw LOG.exceptionWhileDeserializingJsonObject(responseClass, e);
        }
    }

    protected ByteArrayEntity serializeRequest(RequestDto dto) throws EngineClientException {
        byte[] serializedRequest = null;
        try {
            serializedRequest = this.objectMapper.writeValueAsBytes((Object)dto);
        }
        catch (JsonProcessingException e) {
            throw LOG.exceptionWhileSerializingJsonObject(dto, e);
        }
        ByteArrayEntity byteArrayEntity = null;
        if (serializedRequest != null) {
            byteArrayEntity = new ByteArrayEntity(serializedRequest);
        }
        return byteArrayEntity;
    }

    protected void initHttpClient(RequestInterceptorHandler requestInterceptorHandler) {
        HttpClientBuilder httpClientBuilder = HttpClients.custom().addInterceptorLast((HttpRequestInterceptor)requestInterceptorHandler);
        this.httpClient = httpClientBuilder.build();
    }
}

