/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.exception.NotValidException;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.ProcessInstanceModificationBuilderImpl;
import org.camunda.bpm.engine.impl.ProcessInstantiationBuilderImpl;
import org.camunda.bpm.engine.impl.cfg.CommandChecker;
import org.camunda.bpm.engine.impl.cmd.AbstractInstantiationCmd;
import org.camunda.bpm.engine.impl.cmd.AbstractProcessInstanceModificationCommand;
import org.camunda.bpm.engine.impl.cmd.CommandLogger;
import org.camunda.bpm.engine.impl.cmd.GetDeployedProcessDefinitionCmd;
import org.camunda.bpm.engine.impl.core.model.CoreModelElement;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionVariableSnapshotObserver;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessInstanceWithVariablesImpl;
import org.camunda.bpm.engine.impl.pvm.process.ActivityImpl;
import org.camunda.bpm.engine.impl.pvm.process.ProcessDefinitionImpl;
import org.camunda.bpm.engine.impl.pvm.process.TransitionImpl;
import org.camunda.bpm.engine.impl.util.EnsureUtil;
import org.camunda.bpm.engine.runtime.ProcessInstanceWithVariables;
import org.camunda.bpm.engine.variable.VariableMap;

public class StartProcessInstanceAtActivitiesCmd
implements Command<ProcessInstanceWithVariables> {
    private static final CommandLogger LOG = ProcessEngineLogger.CMD_LOGGER;
    protected ProcessInstantiationBuilderImpl instantiationBuilder;

    public StartProcessInstanceAtActivitiesCmd(ProcessInstantiationBuilderImpl instantiationBuilder) {
        this.instantiationBuilder = instantiationBuilder;
    }

    @Override
    public ProcessInstanceWithVariables execute(CommandContext commandContext) {
        ProcessDefinitionEntity processDefinition = new GetDeployedProcessDefinitionCmd(this.instantiationBuilder, false).execute(commandContext);
        for (CommandChecker checker : commandContext.getProcessEngineConfiguration().getCommandCheckers()) {
            checker.checkCreateProcessInstance(processDefinition);
        }
        ProcessInstanceModificationBuilderImpl modificationBuilder = this.instantiationBuilder.getModificationBuilder();
        EnsureUtil.ensureNotEmpty("At least one instantiation instruction required (e.g. by invoking startBefore(..), startAfter(..) or startTransition(..))", "instructions", modificationBuilder.getModificationOperations());
        ActivityImpl initialActivity = this.determineFirstActivity(processDefinition, modificationBuilder);
        ExecutionEntity processInstance = processDefinition.createProcessInstance(this.instantiationBuilder.getBusinessKey(), this.instantiationBuilder.getCaseInstanceId(), initialActivity);
        if (this.instantiationBuilder.getTenantId() != null) {
            processInstance.setTenantId(this.instantiationBuilder.getTenantId());
        }
        processInstance.setSkipCustomListeners(modificationBuilder.isSkipCustomListeners());
        VariableMap variables = modificationBuilder.getProcessVariables();
        ExecutionVariableSnapshotObserver variablesListener = new ExecutionVariableSnapshotObserver(processInstance);
        processInstance.startWithoutExecuting((Map<String, Object>)variables);
        processInstance.setPreserveScope(true);
        List<AbstractProcessInstanceModificationCommand> instructions = modificationBuilder.getModificationOperations();
        for (int i = 0; i < instructions.size(); ++i) {
            AbstractProcessInstanceModificationCommand instruction = instructions.get(i);
            LOG.debugStartingInstruction(processInstance.getId(), i, instruction.describe());
            instruction.setProcessInstanceId(processInstance.getId());
            instruction.setSkipCustomListeners(modificationBuilder.isSkipCustomListeners());
            instruction.setSkipIoMappings(modificationBuilder.isSkipIoMappings());
            instruction.execute(commandContext);
        }
        if (!processInstance.hasChildren() && processInstance.isEnded()) {
            processInstance.propagateEnd();
        }
        return new ProcessInstanceWithVariablesImpl(processInstance, variablesListener.getVariables());
    }

    protected ActivityImpl determineFirstActivity(ProcessDefinitionImpl processDefinition, ProcessInstanceModificationBuilderImpl modificationBuilder) {
        AbstractProcessInstanceModificationCommand firstInstruction = modificationBuilder.getModificationOperations().get(0);
        if (firstInstruction instanceof AbstractInstantiationCmd) {
            AbstractInstantiationCmd instantiationInstruction = (AbstractInstantiationCmd)firstInstruction;
            CoreModelElement targetElement = instantiationInstruction.getTargetElement(processDefinition);
            EnsureUtil.ensureNotNull(NotValidException.class, "Element '" + instantiationInstruction.getTargetElementId() + "' does not exist in process " + processDefinition.getId(), "targetElement", (Object)targetElement);
            if (targetElement instanceof ActivityImpl) {
                return (ActivityImpl)targetElement;
            }
            if (targetElement instanceof TransitionImpl) {
                return (ActivityImpl)((TransitionImpl)targetElement).getDestination();
            }
        }
        return null;
    }
}

