/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import org.camunda.bpm.application.ProcessApplicationReference;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.cfg.CommandChecker;
import org.camunda.bpm.engine.impl.cfg.TransactionLogger;
import org.camunda.bpm.engine.impl.cfg.TransactionState;
import org.camunda.bpm.engine.impl.cmd.UnregisterDeploymentCmd;
import org.camunda.bpm.engine.impl.cmd.UnregisterProcessApplicationCmd;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.deploy.DeleteDeploymentFailListener;
import org.camunda.bpm.engine.impl.persistence.entity.PropertyChange;
import org.camunda.bpm.engine.impl.persistence.entity.UserOperationLogManager;
import org.camunda.bpm.engine.impl.util.EnsureUtil;

public class DeleteDeploymentCmd
implements Command<Void>,
Serializable {
    private static final TransactionLogger TX_LOG = ProcessEngineLogger.TX_LOGGER;
    private static final long serialVersionUID = 1L;
    protected String deploymentId;
    protected boolean cascade;
    protected boolean skipCustomListeners;
    protected boolean skipIoMappings;

    public DeleteDeploymentCmd(String deploymentId, boolean cascade, boolean skipCustomListeners, boolean skipIoMappings) {
        this.deploymentId = deploymentId;
        this.cascade = cascade;
        this.skipCustomListeners = skipCustomListeners;
        this.skipIoMappings = skipIoMappings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void execute(final CommandContext commandContext) {
        EnsureUtil.ensureNotNull("deploymentId", (Object)this.deploymentId);
        for (CommandChecker checker : commandContext.getProcessEngineConfiguration().getCommandCheckers()) {
            checker.checkDeleteDeployment(this.deploymentId);
        }
        UserOperationLogManager logManager = commandContext.getOperationLogManager();
        List<PropertyChange> propertyChanges = Arrays.asList(new PropertyChange("cascade", null, this.cascade));
        logManager.logDeploymentOperation("Delete", this.deploymentId, propertyChanges);
        commandContext.getDeploymentManager().deleteDeployment(this.deploymentId, this.cascade, this.skipCustomListeners, this.skipIoMappings);
        ProcessApplicationReference processApplicationReference = Context.getProcessEngineConfiguration().getProcessApplicationManager().getProcessApplicationForDeployment(this.deploymentId);
        DeleteDeploymentFailListener listener = new DeleteDeploymentFailListener(this.deploymentId, processApplicationReference, Context.getProcessEngineConfiguration().getCommandExecutorTxRequiresNew());
        try {
            commandContext.runWithoutAuthorization(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    new UnregisterProcessApplicationCmd(DeleteDeploymentCmd.this.deploymentId, false).execute(commandContext);
                    new UnregisterDeploymentCmd(Collections.singleton(DeleteDeploymentCmd.this.deploymentId)).execute(commandContext);
                    return null;
                }
            });
        }
        finally {
            try {
                commandContext.getTransactionContext().addTransactionListener(TransactionState.ROLLED_BACK, listener);
            }
            catch (Exception e) {
                TX_LOG.debugTransactionOperation("Could not register transaction synchronization. Probably the TX has already been rolled back by application code.");
                listener.execute(commandContext);
            }
        }
        return null;
    }
}

