/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.util.concurrent.Callable;
import org.camunda.bpm.engine.exception.NotValidException;
import org.camunda.bpm.engine.impl.ActivityExecutionTreeMapping;
import org.camunda.bpm.engine.impl.cmd.AbstractInstanceCancellationCmd;
import org.camunda.bpm.engine.impl.cmd.GetActivityInstanceCmd;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.util.EnsureUtil;
import org.camunda.bpm.engine.runtime.ActivityInstance;

public class ActivityInstanceCancellationCmd
extends AbstractInstanceCancellationCmd {
    protected String activityInstanceId;

    public ActivityInstanceCancellationCmd(String processInstanceId, String activityInstanceId) {
        super(processInstanceId);
        this.activityInstanceId = activityInstanceId;
    }

    public ActivityInstanceCancellationCmd(String processInstanceId, String activityInstanceId, String cancellationReason) {
        super(processInstanceId, cancellationReason);
        this.activityInstanceId = activityInstanceId;
    }

    @Override
    protected ExecutionEntity determineSourceInstanceExecution(final CommandContext commandContext) {
        ExecutionEntity processInstance = commandContext.getExecutionManager().findExecutionById(this.processInstanceId);
        ActivityExecutionTreeMapping mapping = new ActivityExecutionTreeMapping(commandContext, this.processInstanceId);
        ActivityInstance instance = commandContext.runWithoutAuthorization(new Callable<ActivityInstance>(){

            @Override
            public ActivityInstance call() throws Exception {
                return new GetActivityInstanceCmd(ActivityInstanceCancellationCmd.this.processInstanceId).execute(commandContext);
            }
        });
        ActivityInstance instanceToCancel = this.findActivityInstance(instance, this.activityInstanceId);
        EnsureUtil.ensureNotNull(NotValidException.class, this.describeFailure("Activity instance '" + this.activityInstanceId + "' does not exist"), "activityInstance", (Object)instanceToCancel);
        ExecutionEntity scopeExecution = this.getScopeExecutionForActivityInstance(processInstance, mapping, instanceToCancel);
        return scopeExecution;
    }

    @Override
    protected String describe() {
        return "Cancel activity instance '" + this.activityInstanceId + "'";
    }
}

