/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.persistence.entity;

import java.io.Serializable;
import java.util.ArrayList;
import org.camunda.bpm.engine.history.HistoricVariableInstance;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.db.DbEntity;
import org.camunda.bpm.engine.impl.db.DbEntityLifecycleAware;
import org.camunda.bpm.engine.impl.db.EnginePersistenceLogger;
import org.camunda.bpm.engine.impl.db.HasDbRevision;
import org.camunda.bpm.engine.impl.history.event.HistoricVariableUpdateEventEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ByteArrayEntity;
import org.camunda.bpm.engine.impl.persistence.entity.util.ByteArrayField;
import org.camunda.bpm.engine.impl.persistence.entity.util.TypedValueField;
import org.camunda.bpm.engine.impl.variable.serializer.TypedValueSerializer;
import org.camunda.bpm.engine.impl.variable.serializer.ValueFields;
import org.camunda.bpm.engine.variable.value.TypedValue;

public class HistoricVariableInstanceEntity
implements ValueFields,
HistoricVariableInstance,
DbEntity,
HasDbRevision,
Serializable,
DbEntityLifecycleAware {
    private static final long serialVersionUID = 1L;
    protected static final EnginePersistenceLogger LOG = ProcessEngineLogger.PERSISTENCE_LOGGER;
    protected String id;
    protected String processDefinitionKey;
    protected String processDefinitionId;
    protected String processInstanceId;
    protected String taskId;
    protected String executionId;
    protected String activityInstanceId;
    protected String tenantId;
    protected String caseDefinitionKey;
    protected String caseDefinitionId;
    protected String caseInstanceId;
    protected String caseExecutionId;
    protected String name;
    protected int revision;
    protected Long longValue;
    protected Double doubleValue;
    protected String textValue;
    protected String textValue2;
    protected String state = "CREATED";
    protected ByteArrayField byteArrayField = new ByteArrayField(this);
    protected TypedValueField typedValueField = new TypedValueField(this, false);

    public HistoricVariableInstanceEntity() {
    }

    public HistoricVariableInstanceEntity(HistoricVariableUpdateEventEntity historyEvent) {
        this.updateFromEvent(historyEvent);
    }

    public void updateFromEvent(HistoricVariableUpdateEventEntity historyEvent) {
        this.id = historyEvent.getVariableInstanceId();
        this.processDefinitionKey = historyEvent.getProcessDefinitionKey();
        this.processDefinitionId = historyEvent.getProcessDefinitionId();
        this.processInstanceId = historyEvent.getProcessInstanceId();
        this.taskId = historyEvent.getTaskId();
        this.executionId = historyEvent.getExecutionId();
        this.activityInstanceId = historyEvent.getScopeActivityInstanceId();
        this.tenantId = historyEvent.getTenantId();
        this.caseDefinitionKey = historyEvent.getCaseDefinitionKey();
        this.caseDefinitionId = historyEvent.getCaseDefinitionId();
        this.caseInstanceId = historyEvent.getCaseInstanceId();
        this.caseExecutionId = historyEvent.getCaseExecutionId();
        this.name = historyEvent.getVariableName();
        this.longValue = historyEvent.getLongValue();
        this.doubleValue = historyEvent.getDoubleValue();
        this.textValue = historyEvent.getTextValue();
        this.textValue2 = historyEvent.getTextValue2();
        this.setSerializerName(historyEvent.getSerializerName());
        this.byteArrayField.deleteByteArrayValue();
        if (historyEvent.getByteValue() != null) {
            this.setByteArrayValue(historyEvent.getByteValue());
        }
    }

    public void delete() {
        this.byteArrayField.deleteByteArrayValue();
        Context.getCommandContext().getDbEntityManager().delete(this);
    }

    @Override
    public Object getPersistentState() {
        ArrayList<Object> state = new ArrayList<Object>(8);
        state.add(this.getSerializerName());
        state.add(this.textValue);
        state.add(this.textValue2);
        state.add(this.state);
        state.add(this.doubleValue);
        state.add(this.longValue);
        state.add(this.processDefinitionId);
        state.add(this.processDefinitionKey);
        state.add(this.getByteArrayId());
        return state;
    }

    @Override
    public int getRevisionNext() {
        return this.revision + 1;
    }

    @Override
    public Object getValue() {
        return this.typedValueField.getValue();
    }

    @Override
    public TypedValue getTypedValue() {
        return this.typedValueField.getTypedValue();
    }

    public TypedValue getTypedValue(boolean deserializeValue) {
        return this.typedValueField.getTypedValue(deserializeValue);
    }

    public TypedValueSerializer<?> getSerializer() {
        return this.typedValueField.getSerializer();
    }

    public String getByteArrayValueId() {
        return this.byteArrayField.getByteArrayId();
    }

    public String getByteArrayId() {
        return this.byteArrayField.getByteArrayId();
    }

    public void setByteArrayId(String byteArrayId) {
        this.byteArrayField.setByteArrayId(byteArrayId);
    }

    @Override
    public byte[] getByteArrayValue() {
        return this.byteArrayField.getByteArrayValue();
    }

    @Override
    public void setByteArrayValue(byte[] bytes) {
        this.byteArrayField.setByteArrayValue(bytes);
    }

    @Override
    public void postLoad() {
        this.typedValueField.postLoad();
    }

    public String getSerializerName() {
        return this.typedValueField.getSerializerName();
    }

    public void setSerializerName(String serializerName) {
        this.typedValueField.setSerializerName(serializerName);
    }

    @Override
    public String getTypeName() {
        return this.typedValueField.getTypeName();
    }

    @Override
    public String getVariableTypeName() {
        return this.getTypeName();
    }

    @Override
    public String getVariableName() {
        return this.name;
    }

    @Override
    public int getRevision() {
        return this.revision;
    }

    @Override
    public void setRevision(int revision) {
        this.revision = revision;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Long getLongValue() {
        return this.longValue;
    }

    @Override
    public void setLongValue(Long longValue) {
        this.longValue = longValue;
    }

    @Override
    public Double getDoubleValue() {
        return this.doubleValue;
    }

    @Override
    public void setDoubleValue(Double doubleValue) {
        this.doubleValue = doubleValue;
    }

    @Override
    public String getTextValue() {
        return this.textValue;
    }

    @Override
    public void setTextValue(String textValue) {
        this.textValue = textValue;
    }

    @Override
    public String getTextValue2() {
        return this.textValue2;
    }

    @Override
    public void setTextValue2(String textValue2) {
        this.textValue2 = textValue2;
    }

    public void setByteArrayValue(ByteArrayEntity byteArrayValue) {
        this.byteArrayField.setByteArrayValue(byteArrayValue);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    public void setProcessDefinitionKey(String processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
    }

    @Override
    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public void setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    @Override
    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    @Override
    public String getTaskId() {
        return this.taskId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    @Override
    public String getExecutionId() {
        return this.executionId;
    }

    public void setExecutionId(String executionId) {
        this.executionId = executionId;
    }

    @Override
    @Deprecated
    public String getActivtyInstanceId() {
        return this.activityInstanceId;
    }

    @Override
    public String getActivityInstanceId() {
        return this.activityInstanceId;
    }

    public void setActivityInstanceId(String activityInstanceId) {
        this.activityInstanceId = activityInstanceId;
    }

    @Override
    public String getCaseDefinitionKey() {
        return this.caseDefinitionKey;
    }

    public void setCaseDefinitionKey(String caseDefinitionKey) {
        this.caseDefinitionKey = caseDefinitionKey;
    }

    @Override
    public String getCaseDefinitionId() {
        return this.caseDefinitionId;
    }

    public void setCaseDefinitionId(String caseDefinitionId) {
        this.caseDefinitionId = caseDefinitionId;
    }

    @Override
    public String getCaseInstanceId() {
        return this.caseInstanceId;
    }

    public void setCaseInstanceId(String caseInstanceId) {
        this.caseInstanceId = caseInstanceId;
    }

    @Override
    public String getCaseExecutionId() {
        return this.caseExecutionId;
    }

    public void setCaseExecutionId(String caseExecutionId) {
        this.caseExecutionId = caseExecutionId;
    }

    @Override
    public String getErrorMessage() {
        return this.typedValueField.getErrorMessage();
    }

    @Override
    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    @Override
    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[id=" + this.id + ", processDefinitionKey=" + this.processDefinitionKey + ", processDefinitionId=" + this.processDefinitionId + ", processInstanceId=" + this.processInstanceId + ", taskId=" + this.taskId + ", executionId=" + this.executionId + ", tenantId=" + this.tenantId + ", activityInstanceId=" + this.activityInstanceId + ", caseDefinitionKey=" + this.caseDefinitionKey + ", caseDefinitionId=" + this.caseDefinitionId + ", caseInstanceId=" + this.caseInstanceId + ", caseExecutionId=" + this.caseExecutionId + ", name=" + this.name + ", revision=" + this.revision + ", serializerName=" + this.getSerializerName() + ", longValue=" + this.longValue + ", doubleValue=" + this.doubleValue + ", textValue=" + this.textValue + ", textValue2=" + this.textValue2 + ", state=" + this.state + ", byteArrayId=" + this.getByteArrayId() + "]";
    }
}

