/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.io.Serializable;
import java.util.Date;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.cfg.CommandChecker;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;

public class SetJobDuedateCmd
implements Command<Void>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String jobId;
    private final Date newDuedate;

    public SetJobDuedateCmd(String jobId, Date newDuedate) {
        if (jobId == null || jobId.length() < 1) {
            throw new ProcessEngineException("The job id is mandatory, but '" + jobId + "' has been provided.");
        }
        this.jobId = jobId;
        this.newDuedate = newDuedate;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        JobEntity job = commandContext.getJobManager().findJobById(this.jobId);
        if (job != null) {
            for (CommandChecker checker : commandContext.getProcessEngineConfiguration().getCommandCheckers()) {
                checker.checkUpdateJob(job);
            }
        } else {
            throw new ProcessEngineException("No job found with id '" + this.jobId + "'.");
        }
        job.setDuedate(this.newDuedate);
        return null;
    }
}

