/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.bpmn.behavior;

import java.util.List;
import java.util.concurrent.Callable;
import org.camunda.bpm.application.InvocationContext;
import org.camunda.bpm.application.ProcessApplicationReference;
import org.camunda.bpm.engine.delegate.JavaDelegate;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.bpmn.behavior.AbstractBpmnActivityBehavior;
import org.camunda.bpm.engine.impl.bpmn.behavior.BpmnBehaviorLogger;
import org.camunda.bpm.engine.impl.bpmn.behavior.CustomActivityBehavior;
import org.camunda.bpm.engine.impl.bpmn.behavior.ServiceTaskJavaDelegateActivityBehavior;
import org.camunda.bpm.engine.impl.bpmn.parser.FieldDeclaration;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.context.ProcessApplicationContextUtil;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.pvm.delegate.ActivityBehavior;
import org.camunda.bpm.engine.impl.pvm.delegate.ActivityExecution;
import org.camunda.bpm.engine.impl.pvm.delegate.SignallableActivityBehavior;
import org.camunda.bpm.engine.impl.util.ClassDelegateUtil;

public class ClassDelegateActivityBehavior
extends AbstractBpmnActivityBehavior {
    protected static final BpmnBehaviorLogger LOG = ProcessEngineLogger.BPMN_BEHAVIOR_LOGGER;
    protected String className;
    protected List<FieldDeclaration> fieldDeclarations;

    public ClassDelegateActivityBehavior(String className, List<FieldDeclaration> fieldDeclarations) {
        this.className = className;
        this.fieldDeclarations = fieldDeclarations;
    }

    public ClassDelegateActivityBehavior(Class<?> clazz, List<FieldDeclaration> fieldDeclarations) {
        this(clazz.getName(), fieldDeclarations);
    }

    @Override
    public void execute(final ActivityExecution execution) throws Exception {
        this.executeWithErrorPropagation(execution, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                ClassDelegateActivityBehavior.this.getActivityBehaviorInstance(execution).execute(execution);
                return null;
            }
        });
    }

    @Override
    public void signal(final ActivityExecution execution, final String signalName, final Object signalData) throws Exception {
        ProcessApplicationReference targetProcessApplication = ProcessApplicationContextUtil.getTargetProcessApplication((ExecutionEntity)execution);
        if (ProcessApplicationContextUtil.requiresContextSwitch(targetProcessApplication)) {
            Context.executeWithinProcessApplication(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    ClassDelegateActivityBehavior.this.signal(execution, signalName, signalData);
                    return null;
                }
            }, targetProcessApplication, new InvocationContext(execution));
        } else {
            this.doSignal(execution, signalName, signalData);
        }
    }

    protected void doSignal(final ActivityExecution execution, final String signalName, final Object signalData) throws Exception {
        CustomActivityBehavior behavior;
        ActivityBehavior delegate;
        final ActivityBehavior activityBehaviorInstance = this.getActivityBehaviorInstance(execution);
        if (activityBehaviorInstance instanceof CustomActivityBehavior && !((delegate = (behavior = (CustomActivityBehavior)activityBehaviorInstance).getDelegateActivityBehavior()) instanceof SignallableActivityBehavior)) {
            throw LOG.incorrectlyUsedSignalException(SignallableActivityBehavior.class.getName());
        }
        this.executeWithErrorPropagation(execution, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                ((SignallableActivityBehavior)activityBehaviorInstance).signal(execution, signalName, signalData);
                return null;
            }
        });
    }

    protected ActivityBehavior getActivityBehaviorInstance(ActivityExecution execution) {
        Object delegateInstance = ClassDelegateUtil.instantiateDelegate(this.className, this.fieldDeclarations);
        if (delegateInstance instanceof ActivityBehavior) {
            return new CustomActivityBehavior((ActivityBehavior)delegateInstance);
        }
        if (delegateInstance instanceof JavaDelegate) {
            return new ServiceTaskJavaDelegateActivityBehavior((JavaDelegate)delegateInstance);
        }
        throw LOG.missingDelegateParentClassException(delegateInstance.getClass().getName(), JavaDelegate.class.getName(), ActivityBehavior.class.getName());
    }
}

