/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.persistence.deploy;

import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.camunda.bpm.engine.exception.cmmn.CaseDefinitionNotFoundException;
import org.camunda.bpm.engine.exception.dmn.DecisionDefinitionNotFoundException;
import org.camunda.bpm.engine.impl.ProcessDefinitionQueryImpl;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.cmd.GetDeploymentResourceCmd;
import org.camunda.bpm.engine.impl.cmmn.entity.repository.CaseDefinitionEntity;
import org.camunda.bpm.engine.impl.cmmn.entity.repository.CaseDefinitionQueryImpl;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.db.EnginePersistenceLogger;
import org.camunda.bpm.engine.impl.dmn.entity.repository.DecisionDefinitionEntity;
import org.camunda.bpm.engine.impl.dmn.entity.repository.DecisionDefinitionQueryImpl;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.deploy.Deployer;
import org.camunda.bpm.engine.impl.persistence.entity.DeploymentEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.impl.util.EnsureUtil;
import org.camunda.bpm.engine.repository.CaseDefinition;
import org.camunda.bpm.engine.repository.DecisionDefinition;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.cmmn.Cmmn;
import org.camunda.bpm.model.cmmn.CmmnModelInstance;
import org.camunda.bpm.model.dmn.Dmn;
import org.camunda.bpm.model.dmn.DmnModelInstance;

public class DeploymentCache {
    protected static final EnginePersistenceLogger LOG = ProcessEngineLogger.PERSISTENCE_LOGGER;
    protected Map<String, ProcessDefinitionEntity> processDefinitionCache = new HashMap<String, ProcessDefinitionEntity>();
    protected Map<String, CaseDefinitionEntity> caseDefinitionCache = new HashMap<String, CaseDefinitionEntity>();
    protected Map<String, DecisionDefinitionEntity> decisionDefinitionCache = new HashMap<String, DecisionDefinitionEntity>();
    protected Map<String, BpmnModelInstance> bpmnModelInstanceCache = new HashMap<String, BpmnModelInstance>();
    protected Map<String, CmmnModelInstance> cmmnModelInstanceCache = new HashMap<String, CmmnModelInstance>();
    protected Map<String, DmnModelInstance> dmnModelInstanceCache = new HashMap<String, DmnModelInstance>();
    protected List<Deployer> deployers;

    public void deploy(final DeploymentEntity deployment) {
        Context.getCommandContext().runWithoutAuthorization(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                for (Deployer deployer : DeploymentCache.this.deployers) {
                    deployer.deploy(deployment);
                }
                return null;
            }
        });
    }

    public ProcessDefinitionEntity findProcessDefinitionFromCache(String processDefinitionId) {
        return this.processDefinitionCache.get(processDefinitionId);
    }

    public ProcessDefinitionEntity findDeployedProcessDefinitionById(String processDefinitionId) {
        EnsureUtil.ensureNotNull("Invalid process definition id", "processDefinitionId", (Object)processDefinitionId);
        CommandContext commandContext = Context.getCommandContext();
        ProcessDefinitionEntity processDefinition = commandContext.getDbEntityManager().getCachedEntity(ProcessDefinitionEntity.class, processDefinitionId);
        if (processDefinition == null) {
            processDefinition = commandContext.getProcessDefinitionManager().findLatestProcessDefinitionById(processDefinitionId);
        }
        EnsureUtil.ensureNotNull("no deployed process definition found with id '" + processDefinitionId + "'", "processDefinition", (Object)processDefinition);
        processDefinition = this.resolveProcessDefinition(processDefinition);
        return processDefinition;
    }

    public ProcessDefinitionEntity findDeployedLatestProcessDefinitionByKey(String processDefinitionKey) {
        ProcessDefinitionEntity processDefinition = Context.getCommandContext().getProcessDefinitionManager().findLatestProcessDefinitionByKey(processDefinitionKey);
        EnsureUtil.ensureNotNull("no processes deployed with key '" + processDefinitionKey + "'", "processDefinition", (Object)processDefinition);
        processDefinition = this.resolveProcessDefinition(processDefinition);
        return processDefinition;
    }

    public ProcessDefinitionEntity findDeployedLatestProcessDefinitionByKeyAndTenantId(String processDefinitionKey, String tenantId) {
        ProcessDefinitionEntity processDefinition = Context.getCommandContext().getProcessDefinitionManager().findLatestProcessDefinitionByKeyAndTenantId(processDefinitionKey, tenantId);
        EnsureUtil.ensureNotNull("no processes deployed with key '" + processDefinitionKey + "' and tenant-id '" + tenantId + "'", "processDefinition", (Object)processDefinition);
        processDefinition = this.resolveProcessDefinition(processDefinition);
        return processDefinition;
    }

    public ProcessDefinitionEntity findDeployedProcessDefinitionByKeyVersionAndTenantId(final String processDefinitionKey, final Integer processDefinitionVersion, final String tenantId) {
        final CommandContext commandContext = Context.getCommandContext();
        ProcessDefinitionEntity processDefinition = commandContext.runWithoutAuthorization(new Callable<ProcessDefinitionEntity>(){

            @Override
            public ProcessDefinitionEntity call() throws Exception {
                return (ProcessDefinitionEntity)commandContext.getProcessDefinitionManager().findProcessDefinitionByKeyVersionAndTenantId(processDefinitionKey, processDefinitionVersion, tenantId);
            }
        });
        EnsureUtil.ensureNotNull("no processes deployed with key = '" + processDefinitionKey + "', version = '" + processDefinitionVersion + "' and tenant-id = '" + tenantId + "'", "processDefinition", (Object)processDefinition);
        processDefinition = this.resolveProcessDefinition(processDefinition);
        return processDefinition;
    }

    public ProcessDefinitionEntity findDeployedProcessDefinitionByDeploymentAndKey(String deploymentId, String processDefinitionKey) {
        ProcessDefinitionEntity processDefinition = Context.getCommandContext().getProcessDefinitionManager().findProcessDefinitionByDeploymentAndKey(deploymentId, processDefinitionKey);
        EnsureUtil.ensureNotNull("no processes deployed with key = '" + processDefinitionKey + "' in deployment = '" + deploymentId + "'", "processDefinition", (Object)processDefinition);
        processDefinition = this.resolveProcessDefinition(processDefinition);
        return processDefinition;
    }

    public ProcessDefinitionEntity resolveProcessDefinition(ProcessDefinitionEntity processDefinition) {
        String processDefinitionId = processDefinition.getId();
        String deploymentId = processDefinition.getDeploymentId();
        ProcessDefinitionEntity cachedProcessDefinition = this.processDefinitionCache.get(processDefinitionId);
        if (cachedProcessDefinition == null) {
            DeploymentEntity deployment = Context.getCommandContext().getDeploymentManager().findDeploymentById(deploymentId);
            deployment.setNew(false);
            this.deploy(deployment);
            cachedProcessDefinition = this.processDefinitionCache.get(processDefinitionId);
            EnsureUtil.ensureNotNull("deployment '" + deploymentId + "' didn't put process definition '" + processDefinitionId + "' in the cache", "cachedProcessDefinition", (Object)cachedProcessDefinition);
        } else {
            cachedProcessDefinition.updateModifiedFieldsFromEntity(processDefinition);
        }
        return cachedProcessDefinition;
    }

    public BpmnModelInstance findBpmnModelInstanceForProcessDefinition(ProcessDefinitionEntity processDefinitionEntity) {
        BpmnModelInstance bpmnModelInstance = this.bpmnModelInstanceCache.get(processDefinitionEntity.getId());
        if (bpmnModelInstance == null) {
            bpmnModelInstance = this.loadAndCacheBpmnModelInstance(processDefinitionEntity);
        }
        return bpmnModelInstance;
    }

    public BpmnModelInstance findBpmnModelInstanceForProcessDefinition(String processDefinitionId) {
        BpmnModelInstance bpmnModelInstance = this.bpmnModelInstanceCache.get(processDefinitionId);
        if (bpmnModelInstance == null) {
            ProcessDefinitionEntity processDefinition = this.findDeployedProcessDefinitionById(processDefinitionId);
            bpmnModelInstance = this.loadAndCacheBpmnModelInstance(processDefinition);
        }
        return bpmnModelInstance;
    }

    protected BpmnModelInstance loadAndCacheBpmnModelInstance(final ProcessDefinitionEntity processDefinitionEntity) {
        final CommandContext commandContext = Context.getCommandContext();
        InputStream bpmnResourceInputStream = commandContext.runWithoutAuthorization(new Callable<InputStream>(){

            @Override
            public InputStream call() throws Exception {
                return new GetDeploymentResourceCmd(processDefinitionEntity.getDeploymentId(), processDefinitionEntity.getResourceName()).execute(commandContext);
            }
        });
        try {
            BpmnModelInstance bpmnModelInstance = Bpmn.readModelFromStream((InputStream)bpmnResourceInputStream);
            this.bpmnModelInstanceCache.put(processDefinitionEntity.getId(), bpmnModelInstance);
            return bpmnModelInstance;
        }
        catch (Exception e) {
            throw LOG.loadModelException("BPMN", "process", processDefinitionEntity.getId(), e);
        }
    }

    public void addProcessDefinition(ProcessDefinitionEntity processDefinition) {
        this.processDefinitionCache.put(processDefinition.getId(), processDefinition);
    }

    public void removeProcessDefinition(String processDefinitionId) {
        this.processDefinitionCache.remove(processDefinitionId);
        this.bpmnModelInstanceCache.remove(processDefinitionId);
    }

    public void discardProcessDefinitionCache() {
        this.processDefinitionCache.clear();
        this.bpmnModelInstanceCache.clear();
    }

    public CaseDefinitionEntity findCaseDefinitionFromCache(String caseDefinitionId) {
        return this.caseDefinitionCache.get(caseDefinitionId);
    }

    public CaseDefinitionEntity findDeployedCaseDefinitionById(String caseDefinitionId) {
        EnsureUtil.ensureNotNull("Invalid case definition id", "caseDefinitionId", (Object)caseDefinitionId);
        CommandContext commandContext = Context.getCommandContext();
        CaseDefinitionEntity caseDefinition = commandContext.getDbEntityManager().getCachedEntity(CaseDefinitionEntity.class, caseDefinitionId);
        if (caseDefinition == null) {
            caseDefinition = commandContext.getCaseDefinitionManager().findCaseDefinitionById(caseDefinitionId);
        }
        EnsureUtil.ensureNotNull(CaseDefinitionNotFoundException.class, "no deployed case definition found with id '" + caseDefinitionId + "'", "caseDefinition", (Object)caseDefinition);
        caseDefinition = this.resolveCaseDefinition(caseDefinition);
        return caseDefinition;
    }

    public CaseDefinitionEntity findDeployedLatestCaseDefinitionByKey(String caseDefinitionKey) {
        EnsureUtil.ensureNotNull("Invalid case definition key", "caseDefinitionKey", (Object)caseDefinitionKey);
        CaseDefinitionEntity caseDefinition = Context.getCommandContext().getCaseDefinitionManager().findLatestCaseDefinitionByKey(caseDefinitionKey);
        EnsureUtil.ensureNotNull(CaseDefinitionNotFoundException.class, "no case definition deployed with key '" + caseDefinitionKey + "'", "caseDefinition", (Object)caseDefinition);
        caseDefinition = this.resolveCaseDefinition(caseDefinition);
        return caseDefinition;
    }

    public CaseDefinitionEntity findDeployedLatestCaseDefinitionByKeyAndTenantId(String caseDefinitionKey, String tenantId) {
        EnsureUtil.ensureNotNull("Invalid case definition key", "caseDefinitionKey", (Object)caseDefinitionKey);
        CaseDefinitionEntity caseDefinition = Context.getCommandContext().getCaseDefinitionManager().findLatestCaseDefinitionByKeyAndTenantId(caseDefinitionKey, tenantId);
        EnsureUtil.ensureNotNull(CaseDefinitionNotFoundException.class, "no case definition deployed with key '" + caseDefinitionKey + "' and tenant-id '" + tenantId + "'", "caseDefinition", (Object)caseDefinition);
        caseDefinition = this.resolveCaseDefinition(caseDefinition);
        return caseDefinition;
    }

    public CaseDefinitionEntity findDeployedCaseDefinitionByKeyVersionAndTenantId(String caseDefinitionKey, Integer caseDefinitionVersion, String tenantId) {
        CaseDefinitionEntity caseDefinition = Context.getCommandContext().getCaseDefinitionManager().findCaseDefinitionByKeyVersionAndTenantId(caseDefinitionKey, caseDefinitionVersion, tenantId);
        EnsureUtil.ensureNotNull(CaseDefinitionNotFoundException.class, "no case definition deployed with key = '" + caseDefinitionKey + "', version = '" + caseDefinitionVersion + "'" + " and tenant-id = '" + tenantId + "'", "caseDefinition", (Object)caseDefinition);
        caseDefinition = this.resolveCaseDefinition(caseDefinition);
        return caseDefinition;
    }

    public CaseDefinitionEntity findDeployedCaseDefinitionByDeploymentAndKey(String deploymentId, String caseDefinitionKey) {
        CaseDefinitionEntity caseDefinition = Context.getCommandContext().getCaseDefinitionManager().findCaseDefinitionByDeploymentAndKey(deploymentId, caseDefinitionKey);
        EnsureUtil.ensureNotNull(CaseDefinitionNotFoundException.class, "no case definition deployed with key = '" + caseDefinitionKey + "' in deployment = '" + deploymentId + "'", "caseDefinition", (Object)caseDefinition);
        caseDefinition = this.resolveCaseDefinition(caseDefinition);
        return caseDefinition;
    }

    public CaseDefinitionEntity getCaseDefinitionById(String caseDefinitionId) {
        EnsureUtil.ensureNotNull("caseDefinitionId", (Object)caseDefinitionId);
        CaseDefinitionEntity caseDefinition = this.caseDefinitionCache.get(caseDefinitionId);
        if (caseDefinition == null) {
            caseDefinition = this.findDeployedCaseDefinitionById(caseDefinitionId);
        }
        return caseDefinition;
    }

    public CaseDefinitionEntity resolveCaseDefinition(CaseDefinitionEntity caseDefinition) {
        String caseDefinitionId = caseDefinition.getId();
        String deploymentId = caseDefinition.getDeploymentId();
        CaseDefinitionEntity cachedCaseDefinition = this.caseDefinitionCache.get(caseDefinitionId);
        if (cachedCaseDefinition == null) {
            DeploymentEntity deployment = Context.getCommandContext().getDeploymentManager().findDeploymentById(deploymentId);
            deployment.setNew(false);
            this.deploy(deployment);
            cachedCaseDefinition = this.caseDefinitionCache.get(caseDefinitionId);
            EnsureUtil.ensureNotNull("deployment '" + deploymentId + "' didn't put case definition '" + caseDefinitionId + "' in the cache", "cachedCaseDefinition", (Object)cachedCaseDefinition);
        }
        return cachedCaseDefinition;
    }

    public CmmnModelInstance findCmmnModelInstanceForCaseDefinition(String caseDefinitionId) {
        CmmnModelInstance cmmnModelInstance = this.cmmnModelInstanceCache.get(caseDefinitionId);
        if (cmmnModelInstance == null) {
            CaseDefinitionEntity caseDefinition = this.findDeployedCaseDefinitionById(caseDefinitionId);
            final String deploymentId = caseDefinition.getDeploymentId();
            final String resourceName = caseDefinition.getResourceName();
            final CommandContext commandContext = Context.getCommandContext();
            InputStream cmmnResourceInputStream = commandContext.runWithoutAuthorization(new Callable<InputStream>(){

                @Override
                public InputStream call() throws Exception {
                    return new GetDeploymentResourceCmd(deploymentId, resourceName).execute(commandContext);
                }
            });
            try {
                cmmnModelInstance = Cmmn.readModelFromStream((InputStream)cmmnResourceInputStream);
            }
            catch (Exception e) {
                throw LOG.loadModelException("CMMN", "case", caseDefinitionId, e);
            }
            this.cmmnModelInstanceCache.put(caseDefinitionId, cmmnModelInstance);
        }
        return cmmnModelInstance;
    }

    public void addCaseDefinition(CaseDefinitionEntity caseDefinition) {
        this.caseDefinitionCache.put(caseDefinition.getId(), caseDefinition);
    }

    public void removeCaseDefinition(String caseDefinitionId) {
        this.caseDefinitionCache.remove(caseDefinitionId);
        this.cmmnModelInstanceCache.remove(caseDefinitionId);
    }

    public void discardCaseDefinitionCache() {
        this.caseDefinitionCache.clear();
        this.cmmnModelInstanceCache.clear();
    }

    public DecisionDefinitionEntity findDecisionDefinitionFromCache(String decisionDefinitionId) {
        return this.decisionDefinitionCache.get(decisionDefinitionId);
    }

    public DecisionDefinitionEntity findDeployedDecisionDefinitionById(String decisionDefinitionId) {
        EnsureUtil.ensureNotNull("Invalid decision definition id", "decisionDefinitionId", (Object)decisionDefinitionId);
        CommandContext commandContext = Context.getCommandContext();
        DecisionDefinitionEntity decisionDefinition = commandContext.getDbEntityManager().getCachedEntity(DecisionDefinitionEntity.class, decisionDefinitionId);
        if (decisionDefinition == null) {
            decisionDefinition = commandContext.getDecisionDefinitionManager().findDecisionDefinitionById(decisionDefinitionId);
        }
        EnsureUtil.ensureNotNull(DecisionDefinitionNotFoundException.class, "no deployed decision definition found with id '" + decisionDefinitionId + "'", "decisionDefinition", (Object)decisionDefinition);
        decisionDefinition = this.resolveDecisionDefinition(decisionDefinition);
        return decisionDefinition;
    }

    public DecisionDefinition findDeployedLatestDecisionDefinitionByKey(String decisionDefinitionKey) {
        EnsureUtil.ensureNotNull("Invalid decision definition key", "decisionDefinitionKey", (Object)decisionDefinitionKey);
        DecisionDefinitionEntity decisionDefinition = Context.getCommandContext().getDecisionDefinitionManager().findLatestDecisionDefinitionByKey(decisionDefinitionKey);
        EnsureUtil.ensureNotNull(DecisionDefinitionNotFoundException.class, "no decision definition deployed with key '" + decisionDefinitionKey + "'", "decisionDefinition", (Object)decisionDefinition);
        decisionDefinition = this.resolveDecisionDefinition(decisionDefinition);
        return decisionDefinition;
    }

    public DecisionDefinition findDeployedLatestDecisionDefinitionByKeyAndTenantId(String decisionDefinitionKey, String tenantId) {
        EnsureUtil.ensureNotNull("Invalid decision definition key", "decisionDefinitionKey", (Object)decisionDefinitionKey);
        DecisionDefinitionEntity decisionDefinition = Context.getCommandContext().getDecisionDefinitionManager().findLatestDecisionDefinitionByKeyAndTenantId(decisionDefinitionKey, tenantId);
        EnsureUtil.ensureNotNull(DecisionDefinitionNotFoundException.class, "no decision definition deployed with key '" + decisionDefinitionKey + "' and tenant-id '" + tenantId + "'", "decisionDefinition", (Object)decisionDefinition);
        decisionDefinition = this.resolveDecisionDefinition(decisionDefinition);
        return decisionDefinition;
    }

    public DecisionDefinition findDeployedDecisionDefinitionByDeploymentAndKey(String deploymentId, String decisionDefinitionKey) {
        DecisionDefinitionEntity decisionDefinition = Context.getCommandContext().getDecisionDefinitionManager().findDecisionDefinitionByDeploymentAndKey(deploymentId, decisionDefinitionKey);
        EnsureUtil.ensureNotNull(DecisionDefinitionNotFoundException.class, "no decision definition deployed with key = '" + decisionDefinitionKey + "' in deployment = '" + deploymentId + "'", "decisionDefinition", (Object)decisionDefinition);
        decisionDefinition = this.resolveDecisionDefinition(decisionDefinition);
        return decisionDefinition;
    }

    public DecisionDefinition findDeployedDecisionDefinitionByKeyAndVersion(String decisionDefinitionKey, Integer decisionDefinitionVersion) {
        DecisionDefinitionEntity decisionDefinition = Context.getCommandContext().getDecisionDefinitionManager().findDecisionDefinitionByKeyAndVersion(decisionDefinitionKey, decisionDefinitionVersion);
        EnsureUtil.ensureNotNull(DecisionDefinitionNotFoundException.class, "no decision definition deployed with key = '" + decisionDefinitionKey + "' and version = '" + decisionDefinitionVersion + "'", "decisionDefinition", (Object)decisionDefinition);
        decisionDefinition = this.resolveDecisionDefinition(decisionDefinition);
        return decisionDefinition;
    }

    public DecisionDefinition findDeployedDecisionDefinitionByKeyVersionAndTenantId(String decisionDefinitionKey, Integer decisionDefinitionVersion, String tenantId) {
        DecisionDefinitionEntity decisionDefinition = Context.getCommandContext().getDecisionDefinitionManager().findDecisionDefinitionByKeyVersionAndTenantId(decisionDefinitionKey, decisionDefinitionVersion, tenantId);
        EnsureUtil.ensureNotNull(DecisionDefinitionNotFoundException.class, "no decision definition deployed with key = '" + decisionDefinitionKey + "', version = '" + decisionDefinitionVersion + "' and tenant-id '" + tenantId + "'", "decisionDefinition", (Object)decisionDefinition);
        decisionDefinition = this.resolveDecisionDefinition(decisionDefinition);
        return decisionDefinition;
    }

    public DecisionDefinitionEntity resolveDecisionDefinition(DecisionDefinitionEntity decisionDefinition) {
        String decisionDefinitionId = decisionDefinition.getId();
        String deploymentId = decisionDefinition.getDeploymentId();
        DecisionDefinitionEntity cachedDecisionDefinition = this.decisionDefinitionCache.get(decisionDefinitionId);
        if (cachedDecisionDefinition == null) {
            DeploymentEntity deployment = Context.getCommandContext().getDeploymentManager().findDeploymentById(deploymentId);
            deployment.setNew(false);
            this.deploy(deployment);
            cachedDecisionDefinition = this.decisionDefinitionCache.get(decisionDefinitionId);
            EnsureUtil.ensureNotNull("deployment '" + deploymentId + "' didn't put decision definition '" + decisionDefinitionId + "' in the cache", "cachedDecisionDefinition", (Object)cachedDecisionDefinition);
        }
        return cachedDecisionDefinition;
    }

    public DmnModelInstance findDmnModelInstanceForDecisionDefinition(String decisionDefinitionId) {
        DmnModelInstance dmnModelInstance = this.dmnModelInstanceCache.get(decisionDefinitionId);
        if (dmnModelInstance == null) {
            DecisionDefinitionEntity decisionDefinition = this.findDeployedDecisionDefinitionById(decisionDefinitionId);
            final String deploymentId = decisionDefinition.getDeploymentId();
            final String resourceName = decisionDefinition.getResourceName();
            final CommandContext commandContext = Context.getCommandContext();
            InputStream dmnResourceInputStream = commandContext.runWithoutAuthorization(new Callable<InputStream>(){

                @Override
                public InputStream call() throws Exception {
                    return new GetDeploymentResourceCmd(deploymentId, resourceName).execute(commandContext);
                }
            });
            try {
                dmnModelInstance = Dmn.readModelFromStream((InputStream)dmnResourceInputStream);
            }
            catch (Exception e) {
                throw LOG.loadModelException("DMN", "decision", decisionDefinitionId, e);
            }
            this.dmnModelInstanceCache.put(decisionDefinitionId, dmnModelInstance);
        }
        return dmnModelInstance;
    }

    public void addDecisionDefinition(DecisionDefinitionEntity decisionDefinition) {
        this.decisionDefinitionCache.put(decisionDefinition.getId(), decisionDefinition);
    }

    public void removeDecisionDefinition(String decisionDefinitionId) {
        this.decisionDefinitionCache.remove(decisionDefinitionId);
        this.dmnModelInstanceCache.remove(decisionDefinitionId);
    }

    public void discardDecisionDefinitionCache() {
        this.decisionDefinitionCache.clear();
        this.dmnModelInstanceCache.clear();
    }

    public Map<String, BpmnModelInstance> getBpmnModelInstanceCache() {
        return this.bpmnModelInstanceCache;
    }

    public Map<String, CmmnModelInstance> getCmmnModelInstanceCache() {
        return this.cmmnModelInstanceCache;
    }

    public Map<String, DmnModelInstance> getDmnModelInstanceCache() {
        return this.dmnModelInstanceCache;
    }

    public Map<String, ProcessDefinitionEntity> getProcessDefinitionCache() {
        return this.processDefinitionCache;
    }

    public void setProcessDefinitionCache(Map<String, ProcessDefinitionEntity> processDefinitionCache) {
        this.processDefinitionCache = processDefinitionCache;
    }

    public Map<String, CaseDefinitionEntity> getCaseDefinitionCache() {
        return this.caseDefinitionCache;
    }

    public void setCaseDefinitionCache(Map<String, CaseDefinitionEntity> caseDefinitionCache) {
        this.caseDefinitionCache = caseDefinitionCache;
    }

    public List<Deployer> getDeployers() {
        return this.deployers;
    }

    public void setDeployers(List<Deployer> deployers) {
        this.deployers = deployers;
    }

    public void removeDeployment(String deploymentId) {
        this.removeAllProcessDefinitionsByDeploymentId(deploymentId);
        this.removeAllCaseDefinitionsByDeploymentId(deploymentId);
        this.removeAllDecisionDefinitionsByDeploymentId(deploymentId);
    }

    protected void removeAllProcessDefinitionsByDeploymentId(final String deploymentId) {
        CommandContext commandContext = Context.getCommandContext();
        List<ProcessDefinition> allDefinitionsForDeployment = commandContext.runWithoutAuthorization(new Callable<List<ProcessDefinition>>(){

            @Override
            public List<ProcessDefinition> call() throws Exception {
                return new ProcessDefinitionQueryImpl().deploymentId(deploymentId).list();
            }
        });
        for (ProcessDefinition processDefinition : allDefinitionsForDeployment) {
            try {
                this.removeProcessDefinition(processDefinition.getId());
            }
            catch (Exception e) {
                LOG.removeEntryFromDeploymentCacheFailure("process", processDefinition.getId(), e);
            }
        }
    }

    protected void removeAllCaseDefinitionsByDeploymentId(String deploymentId) {
        List allDefinitionsForDeployment = new CaseDefinitionQueryImpl().deploymentId(deploymentId).list();
        for (CaseDefinition caseDefinition : allDefinitionsForDeployment) {
            try {
                this.removeCaseDefinition(caseDefinition.getId());
            }
            catch (Exception e) {
                LOG.removeEntryFromDeploymentCacheFailure("case", caseDefinition.getId(), e);
            }
        }
    }

    protected void removeAllDecisionDefinitionsByDeploymentId(String deploymentId) {
        List allDefinitionsForDeployment = new DecisionDefinitionQueryImpl().deploymentId(deploymentId).list();
        for (DecisionDefinition decisionDefinition : allDefinitionsForDeployment) {
            try {
                this.removeDecisionDefinition(decisionDefinition.getId());
            }
            catch (Exception e) {
                LOG.removeEntryFromDeploymentCacheFailure("decision", decisionDefinition.getId(), e);
            }
        }
    }
}

