/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.io.InputStream;
import java.io.Serializable;
import java.util.concurrent.Callable;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.bpmn.diagram.ProcessDiagramLayoutFactory;
import org.camunda.bpm.engine.impl.cfg.CommandChecker;
import org.camunda.bpm.engine.impl.cmd.GetDeploymentProcessDiagramCmd;
import org.camunda.bpm.engine.impl.cmd.GetDeploymentProcessModelCmd;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.repository.DiagramLayout;

public class GetDeploymentProcessDiagramLayoutCmd
implements Command<DiagramLayout>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String processDefinitionId;

    public GetDeploymentProcessDiagramLayoutCmd(String processDefinitionId) {
        if (processDefinitionId == null || processDefinitionId.length() < 1) {
            throw new ProcessEngineException("The process definition id is mandatory, but '" + processDefinitionId + "' has been provided.");
        }
        this.processDefinitionId = processDefinitionId;
    }

    @Override
    public DiagramLayout execute(final CommandContext commandContext) {
        ProcessDefinitionEntity processDefinition = Context.getProcessEngineConfiguration().getDeploymentCache().findDeployedProcessDefinitionById(this.processDefinitionId);
        for (CommandChecker checker : commandContext.getProcessEngineConfiguration().getCommandCheckers()) {
            checker.checkReadProcessDefinition(processDefinition);
        }
        InputStream processModelStream = commandContext.runWithoutAuthorization(new Callable<InputStream>(){

            @Override
            public InputStream call() throws Exception {
                return new GetDeploymentProcessModelCmd(GetDeploymentProcessDiagramLayoutCmd.this.processDefinitionId).execute(commandContext);
            }
        });
        InputStream processDiagramStream = commandContext.runWithoutAuthorization(new Callable<InputStream>(){

            @Override
            public InputStream call() throws Exception {
                return new GetDeploymentProcessDiagramCmd(GetDeploymentProcessDiagramLayoutCmd.this.processDefinitionId).execute(commandContext);
            }
        });
        return new ProcessDiagramLayoutFactory().getProcessDiagramLayout(processModelStream, processDiagramStream);
    }
}

