/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.io.Serializable;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.AttachmentEntity;
import org.camunda.bpm.engine.impl.persistence.entity.PropertyChange;
import org.camunda.bpm.engine.impl.persistence.entity.TaskEntity;

public class DeleteAttachmentCmd
implements Command<Object>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String attachmentId;

    public DeleteAttachmentCmd(String attachmentId) {
        this.attachmentId = attachmentId;
    }

    @Override
    public Object execute(CommandContext commandContext) {
        AttachmentEntity attachment = commandContext.getDbEntityManager().selectById(AttachmentEntity.class, this.attachmentId);
        commandContext.getDbEntityManager().delete(attachment);
        if (attachment.getContentId() != null) {
            commandContext.getByteArrayManager().deleteByteArrayById(attachment.getContentId());
        }
        if (attachment.getTaskId() != null) {
            TaskEntity task = commandContext.getTaskManager().findTaskById(attachment.getTaskId());
            PropertyChange propertyChange = new PropertyChange("name", null, attachment.getName());
            commandContext.getOperationLogManager().logAttachmentOperation("DeleteAttachment", task, propertyChange);
        }
        return null;
    }
}

