/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.util.concurrent.Callable;
import org.camunda.bpm.engine.MismatchingMessageCorrelationException;
import org.camunda.bpm.engine.impl.MessageCorrelationBuilderImpl;
import org.camunda.bpm.engine.impl.cmd.AbstractCorrelateMessageCmd;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.runtime.CorrelationHandler;
import org.camunda.bpm.engine.impl.runtime.CorrelationSet;
import org.camunda.bpm.engine.impl.runtime.MessageCorrelationResult;
import org.camunda.bpm.engine.impl.util.EnsureUtil;

public class CorrelateMessageCmd
extends AbstractCorrelateMessageCmd
implements Command<Void> {
    public CorrelateMessageCmd(MessageCorrelationBuilderImpl messageCorrelationBuilderImpl) {
        super(messageCorrelationBuilderImpl);
    }

    @Override
    public Void execute(final CommandContext commandContext) {
        EnsureUtil.ensureAtLeastOneNotNull("At least one of the following correlation criteria has to be present: messageName, businessKey, correlationKeys, processInstanceId", this.messageName, this.builder.getBusinessKey(), this.builder.getCorrelationProcessInstanceVariables(), this.builder.getProcessInstanceId());
        final CorrelationHandler correlationHandler = Context.getProcessEngineConfiguration().getCorrelationHandler();
        final CorrelationSet correlationSet = new CorrelationSet(this.builder);
        MessageCorrelationResult correlationResult = commandContext.runWithoutAuthorization(new Callable<MessageCorrelationResult>(){

            @Override
            public MessageCorrelationResult call() throws Exception {
                return correlationHandler.correlateMessage(commandContext, CorrelateMessageCmd.this.messageName, correlationSet);
            }
        });
        if (correlationResult == null) {
            throw new MismatchingMessageCorrelationException(this.messageName, "No process definition or execution matches the parameters");
        }
        this.checkAuthorization(correlationResult);
        if ("execution".equals(correlationResult.getResultType())) {
            this.triggerExecution(commandContext, correlationResult);
        } else {
            this.instantiateProcess(commandContext, correlationResult);
        }
        return null;
    }
}

