/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl;

import java.util.Map;
import org.camunda.bpm.engine.ExternalTaskService;
import org.camunda.bpm.engine.externaltask.ExternalTaskQuery;
import org.camunda.bpm.engine.externaltask.ExternalTaskQueryBuilder;
import org.camunda.bpm.engine.impl.ExternalTaskQueryImpl;
import org.camunda.bpm.engine.impl.ServiceImpl;
import org.camunda.bpm.engine.impl.cmd.CompleteExternalTaskCmd;
import org.camunda.bpm.engine.impl.cmd.HandleExternalTaskBpmnErrorCmd;
import org.camunda.bpm.engine.impl.cmd.HandleExternalTaskFailureCmd;
import org.camunda.bpm.engine.impl.cmd.SetExternalTaskPriorityCmd;
import org.camunda.bpm.engine.impl.cmd.SetExternalTaskRetriesCmd;
import org.camunda.bpm.engine.impl.cmd.UnlockExternalTaskCmd;
import org.camunda.bpm.engine.impl.externaltask.ExternalTaskQueryTopicBuilderImpl;

public class ExternalTaskServiceImpl
extends ServiceImpl
implements ExternalTaskService {
    @Override
    public ExternalTaskQueryBuilder fetchAndLock(int maxTasks, String workerId) {
        return this.fetchAndLock(maxTasks, workerId, false);
    }

    @Override
    public ExternalTaskQueryBuilder fetchAndLock(int maxTasks, String workerId, boolean usePriority) {
        return new ExternalTaskQueryTopicBuilderImpl(this.commandExecutor, workerId, maxTasks, usePriority);
    }

    @Override
    public void complete(String externalTaskId, String workerId) {
        this.commandExecutor.execute(new CompleteExternalTaskCmd(externalTaskId, workerId, null));
    }

    @Override
    public void complete(String externalTaskId, String workerId, Map<String, Object> variables) {
        this.commandExecutor.execute(new CompleteExternalTaskCmd(externalTaskId, workerId, variables));
    }

    @Override
    public void handleFailure(String externalTaskId, String workerId, String errorMessage, int retries, long retryDuration) {
        this.commandExecutor.execute(new HandleExternalTaskFailureCmd(externalTaskId, workerId, errorMessage, retries, retryDuration));
    }

    @Override
    public void handleBpmnError(String externalTaskId, String workerId, String errorCode) {
        this.commandExecutor.execute(new HandleExternalTaskBpmnErrorCmd(externalTaskId, workerId, errorCode));
    }

    @Override
    public void unlock(String externalTaskId) {
        this.commandExecutor.execute(new UnlockExternalTaskCmd(externalTaskId));
    }

    @Override
    public void setRetries(String externalTaskId, int retries) {
        this.commandExecutor.execute(new SetExternalTaskRetriesCmd(externalTaskId, retries));
    }

    @Override
    public void setPriority(String externalTaskId, long priority) {
        this.commandExecutor.execute(new SetExternalTaskPriorityCmd(externalTaskId, priority));
    }

    @Override
    public ExternalTaskQuery createExternalTaskQuery() {
        return new ExternalTaskQueryImpl(this.commandExecutor);
    }
}

