/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.tree;

import java.util.ArrayList;
import java.util.List;
import org.camunda.bpm.engine.impl.tree.TreeVisitor;

public abstract class TreeWalker<T> {
    protected T currentElement;
    protected List<TreeVisitor<T>> preVisitor = new ArrayList<TreeVisitor<T>>();
    protected List<TreeVisitor<T>> postVisitor = new ArrayList<TreeVisitor<T>>();

    protected abstract T nextElement();

    public TreeWalker(T initialElement) {
        this.currentElement = initialElement;
    }

    public TreeWalker<T> addPreVisitor(TreeVisitor<T> collector) {
        this.preVisitor.add(collector);
        return this;
    }

    public TreeWalker<T> addPostVisitor(TreeVisitor<T> collector) {
        this.postVisitor.add(collector);
        return this;
    }

    public void walkWhile() {
        this.walkWhile(new NullCondition());
    }

    public void walkUntil() {
        this.walkUntil(new NullCondition());
    }

    public T walkWhile(WalkCondition<T> condition) {
        while (!condition.isFulfilled(this.currentElement)) {
            for (TreeVisitor<T> collector : this.preVisitor) {
                collector.visit(this.currentElement);
            }
            this.currentElement = this.nextElement();
            for (TreeVisitor<T> collector : this.postVisitor) {
                collector.visit(this.currentElement);
            }
        }
        return this.getCurrentElement();
    }

    public T walkUntil(WalkCondition<T> condition) {
        do {
            for (TreeVisitor<T> collector : this.preVisitor) {
                collector.visit(this.currentElement);
            }
            this.currentElement = this.nextElement();
            for (TreeVisitor<T> collector : this.postVisitor) {
                collector.visit(this.currentElement);
            }
        } while (!condition.isFulfilled(this.currentElement));
        return this.getCurrentElement();
    }

    public T getCurrentElement() {
        return this.currentElement;
    }

    public static class NullCondition<S>
    implements WalkCondition<S> {
        @Override
        public boolean isFulfilled(S element) {
            return element == null;
        }

        public static <S> WalkCondition<S> notNull() {
            return new NullCondition<S>();
        }
    }

    public static interface WalkCondition<S> {
        public boolean isFulfilled(S var1);
    }
}

