/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.persistence.entity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.camunda.bpm.engine.AuthorizationException;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.authorization.Authorization;
import org.camunda.bpm.engine.authorization.MissingAuthorization;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.history.HistoricProcessInstance;
import org.camunda.bpm.engine.history.UserOperationLogEntry;
import org.camunda.bpm.engine.impl.AbstractQuery;
import org.camunda.bpm.engine.impl.ActivityStatisticsQueryImpl;
import org.camunda.bpm.engine.impl.AuthorizationQueryImpl;
import org.camunda.bpm.engine.impl.DeploymentQueryImpl;
import org.camunda.bpm.engine.impl.DeploymentStatisticsQueryImpl;
import org.camunda.bpm.engine.impl.EventSubscriptionQueryImpl;
import org.camunda.bpm.engine.impl.ExternalTaskQueryImpl;
import org.camunda.bpm.engine.impl.HistoricActivityInstanceQueryImpl;
import org.camunda.bpm.engine.impl.HistoricActivityStatisticsQueryImpl;
import org.camunda.bpm.engine.impl.HistoricDecisionInstanceQueryImpl;
import org.camunda.bpm.engine.impl.HistoricDetailQueryImpl;
import org.camunda.bpm.engine.impl.HistoricIncidentQueryImpl;
import org.camunda.bpm.engine.impl.HistoricJobLogQueryImpl;
import org.camunda.bpm.engine.impl.HistoricProcessInstanceQueryImpl;
import org.camunda.bpm.engine.impl.HistoricTaskInstanceQueryImpl;
import org.camunda.bpm.engine.impl.HistoricVariableInstanceQueryImpl;
import org.camunda.bpm.engine.impl.IncidentQueryImpl;
import org.camunda.bpm.engine.impl.JobDefinitionQueryImpl;
import org.camunda.bpm.engine.impl.JobQueryImpl;
import org.camunda.bpm.engine.impl.ProcessDefinitionQueryImpl;
import org.camunda.bpm.engine.impl.ProcessDefinitionStatisticsQueryImpl;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.TaskQueryImpl;
import org.camunda.bpm.engine.impl.UserOperationLogQueryImpl;
import org.camunda.bpm.engine.impl.VariableInstanceQueryImpl;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.db.AuthorizationCheck;
import org.camunda.bpm.engine.impl.db.CompositePermissionCheck;
import org.camunda.bpm.engine.impl.db.DbEntity;
import org.camunda.bpm.engine.impl.db.EnginePersistenceLogger;
import org.camunda.bpm.engine.impl.db.ListQueryParameterObject;
import org.camunda.bpm.engine.impl.db.PermissionCheck;
import org.camunda.bpm.engine.impl.db.PermissionCheckBuilder;
import org.camunda.bpm.engine.impl.dmn.entity.repository.DecisionDefinitionEntity;
import org.camunda.bpm.engine.impl.dmn.entity.repository.DecisionDefinitionQueryImpl;
import org.camunda.bpm.engine.impl.identity.Authentication;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.AbstractManager;
import org.camunda.bpm.engine.impl.persistence.entity.AuthorizationEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricJobLogEventEntity;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricTaskInstanceEntity;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.TaskEntity;
import org.camunda.bpm.engine.impl.util.CollectionUtil;
import org.camunda.bpm.engine.impl.util.EnsureUtil;

public class AuthorizationManager
extends AbstractManager {
    protected static final EnginePersistenceLogger LOG = ProcessEngineLogger.PERSISTENCE_LOGGER;
    public static final String DEFAULT_AUTHORIZATION_CHECK = "defaultAuthorizationCheck";

    public Authorization createNewAuthorization(int type) {
        this.checkAuthorization(Permissions.CREATE, Resources.AUTHORIZATION, null);
        return new AuthorizationEntity(type);
    }

    @Override
    public void insert(DbEntity authorization) {
        this.checkAuthorization(Permissions.CREATE, Resources.AUTHORIZATION, null);
        this.getDbEntityManager().insert(authorization);
    }

    public List<Authorization> selectAuthorizationByQueryCriteria(AuthorizationQueryImpl authorizationQuery) {
        this.configureQuery((AbstractQuery)authorizationQuery, (Resource)Resources.AUTHORIZATION);
        return this.getDbEntityManager().selectList("selectAuthorizationByQueryCriteria", authorizationQuery);
    }

    public Long selectAuthorizationCountByQueryCriteria(AuthorizationQueryImpl authorizationQuery) {
        this.configureQuery((AbstractQuery)authorizationQuery, (Resource)Resources.AUTHORIZATION);
        return (Long)this.getDbEntityManager().selectOne("selectAuthorizationCountByQueryCriteria", authorizationQuery);
    }

    public AuthorizationEntity findAuthorizationByUserIdAndResourceId(int type, String userId, Resource resource, String resourceId) {
        return this.findAuthorization(type, userId, null, resource, resourceId);
    }

    public AuthorizationEntity findAuthorizationByGroupIdAndResourceId(int type, String groupId, Resource resource, String resourceId) {
        return this.findAuthorization(type, null, groupId, resource, resourceId);
    }

    public AuthorizationEntity findAuthorization(int type, String userId, String groupId, Resource resource, String resourceId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("type", type);
        params.put("userId", userId);
        params.put("groupId", groupId);
        params.put("resourceId", resourceId);
        if (resource != null) {
            params.put("resourceType", resource.resourceType());
        }
        return (AuthorizationEntity)this.getDbEntityManager().selectOne("selectAuthorizationByParameters", params);
    }

    public void update(AuthorizationEntity authorization) {
        this.checkAuthorization(Permissions.UPDATE, Resources.AUTHORIZATION, authorization.getId());
        this.getDbEntityManager().merge(authorization);
    }

    @Override
    public void delete(DbEntity authorization) {
        this.checkAuthorization(Permissions.DELETE, Resources.AUTHORIZATION, authorization.getId());
        this.deleteAuthorizationsByResourceId(Resources.AUTHORIZATION, authorization.getId());
        super.delete(authorization);
    }

    public void checkAuthorization(PermissionCheck ... permissionChecks) {
        EnsureUtil.ensureNotNull("permissionChecks", permissionChecks);
        for (PermissionCheck permissionCheck : permissionChecks) {
            EnsureUtil.ensureNotNull("permissionCheck", (Object)permissionCheck);
        }
        this.checkAuthorization(CollectionUtil.asArrayList(permissionChecks));
    }

    public void checkAuthorization(List<PermissionCheck> permissionChecks) {
        String userId;
        boolean isAuthorized;
        Authentication currentAuthentication = this.getCurrentAuthentication();
        CommandContext commandContext = this.getCommandContext();
        if (this.isAuthorizationEnabled() && currentAuthentication != null && commandContext.isAuthorizationCheckEnabled() && !(isAuthorized = this.isAuthorized(userId = currentAuthentication.getUserId(), currentAuthentication.getGroupIds(), permissionChecks))) {
            ArrayList<MissingAuthorization> info = new ArrayList<MissingAuthorization>();
            for (PermissionCheck check : permissionChecks) {
                info.add(new MissingAuthorization(check.getPermission().getName(), check.getResource().resourceName(), check.getResourceId()));
            }
            throw new AuthorizationException(userId, info);
        }
    }

    public void checkAuthorization(Permission permission, Resource resource) {
        this.checkAuthorization(permission, resource, null);
    }

    @Override
    public void checkAuthorization(Permission permission, Resource resource, String resourceId) {
        boolean isAuthorized;
        Authentication currentAuthentication = this.getCurrentAuthentication();
        CommandContext commandContext = Context.getCommandContext();
        if (this.isAuthorizationEnabled() && currentAuthentication != null && commandContext.isAuthorizationCheckEnabled() && !(isAuthorized = this.isAuthorized(currentAuthentication.getUserId(), currentAuthentication.getGroupIds(), permission, resource, resourceId))) {
            throw new AuthorizationException(currentAuthentication.getUserId(), permission.getName(), resource.resourceName(), resourceId);
        }
    }

    public boolean isAuthorized(Permission permission, Resource resource, String resourceId) {
        Authentication currentAuthentication = this.getCurrentAuthentication();
        if (this.isAuthorizationEnabled() && currentAuthentication != null) {
            return this.isAuthorized(currentAuthentication.getUserId(), currentAuthentication.getGroupIds(), permission, resource, resourceId);
        }
        return true;
    }

    public boolean isAuthorized(String userId, List<String> groupIds, Permission permission, Resource resource, String resourceId) {
        PermissionCheck permCheck = new PermissionCheck();
        permCheck.setPermission(permission);
        permCheck.setResource(resource);
        permCheck.setResourceId(resourceId);
        ArrayList<PermissionCheck> permissionChecks = new ArrayList<PermissionCheck>();
        permissionChecks.add(permCheck);
        return this.isAuthorized(userId, groupIds, permissionChecks);
    }

    public boolean isAuthorized(String userId, List<String> groupIds, List<PermissionCheck> permissionChecks) {
        AuthorizationCheck authCheck = new AuthorizationCheck();
        authCheck.setAuthUserId(userId);
        authCheck.setAuthGroupIds(groupIds);
        authCheck.setAtomicPermissionChecks(permissionChecks);
        return this.getDbEntityManager().selectBoolean("isUserAuthorizedForResource", authCheck);
    }

    public void configureQuery(ListQueryParameterObject query) {
        Authentication currentAuthentication = this.getCurrentAuthentication();
        CommandContext commandContext = this.getCommandContext();
        query.getPermissionChecks().clear();
        if (this.isAuthorizationEnabled() && currentAuthentication != null && commandContext.isAuthorizationCheckEnabled()) {
            query.setAuthorizationCheckEnabled(true);
            String currentUserId = currentAuthentication.getUserId();
            List<String> currentGroupIds = currentAuthentication.getGroupIds();
            query.setAuthUserId(currentUserId);
            query.setAuthGroupIds(currentGroupIds);
        } else {
            query.setAuthorizationCheckEnabled(false);
            query.setAuthUserId(null);
            query.setAuthGroupIds(null);
        }
    }

    public void configureQuery(AbstractQuery query, Resource resource) {
        this.configureQuery(query, resource, "RES.ID_");
    }

    public void configureQuery(AbstractQuery query, Resource resource, String queryParam) {
        this.configureQuery(query, resource, queryParam, Permissions.READ);
    }

    public void configureQuery(AbstractQuery query, Resource resource, String queryParam, Permission permission) {
        this.configureQuery(query);
        this.addPermissionCheck(query, resource, queryParam, permission);
    }

    protected void addPermissionCheck(ListQueryParameterObject query, Resource resource, String queryParam, Permission permission) {
        CommandContext commandContext = this.getCommandContext();
        if (this.isAuthorizationEnabled() && this.getCurrentAuthentication() != null && commandContext.isAuthorizationCheckEnabled()) {
            PermissionCheck permCheck = new PermissionCheck();
            permCheck.setResource(resource);
            permCheck.setResourceIdQueryParam(queryParam);
            permCheck.setPermission(permission);
            query.addAtomicPermissionCheck(permCheck);
        }
    }

    protected void addPermissionCheck(AuthorizationCheck authCheck, CompositePermissionCheck compositeCheck) {
        CommandContext commandContext = this.getCommandContext();
        if (this.isAuthorizationEnabled() && this.getCurrentAuthentication() != null && commandContext.isAuthorizationCheckEnabled()) {
            authCheck.setPermissionChecks(compositeCheck);
        }
    }

    public void deleteAuthorizationsByResourceId(Resource resource, String resourceId) {
        if (resourceId == null) {
            throw new IllegalArgumentException("Resource id cannot be null");
        }
        if (this.isAuthorizationEnabled()) {
            HashMap<String, Object> deleteParams = new HashMap<String, Object>();
            deleteParams.put("resourceType", resource.resourceType());
            deleteParams.put("resourceId", resourceId);
            this.getDbEntityManager().delete(AuthorizationEntity.class, "deleteAuthorizationsForResourceId", deleteParams);
        }
    }

    public void isCamundaAdmin() {
        Authentication currentAuthentication = this.getCurrentAuthentication();
        CommandContext commandContext = Context.getCommandContext();
        if (this.isAuthorizationEnabled() && currentAuthentication != null && commandContext.isAuthorizationCheckEnabled()) {
            IdentityService identityService = Context.getProcessEngineConfiguration().getIdentityService();
            String userId = currentAuthentication.getUserId();
            long count = identityService.createUserQuery().userId(userId).memberOfGroup("camunda-admin").count();
            if (count == 0L) {
                throw LOG.notAMemberException(userId, "camunda-admin");
            }
        }
    }

    public void checkCreateDeployment() {
        this.checkAuthorization(Permissions.CREATE, Resources.DEPLOYMENT);
    }

    public void checkReadDeployment(String deploymentId) {
        this.checkAuthorization(Permissions.READ, Resources.DEPLOYMENT, deploymentId);
    }

    public void checkDeleteDeployment(String deploymentId) {
        this.checkAuthorization(Permissions.DELETE, Resources.DEPLOYMENT, deploymentId);
    }

    public void checkReadProcessDefinition(ProcessDefinitionEntity definition) {
        this.checkReadProcessDefinition(definition.getKey());
    }

    public void checkReadProcessDefinition(String processDefinitionKey) {
        this.checkAuthorization(Permissions.READ, Resources.PROCESS_DEFINITION, processDefinitionKey);
    }

    public void checkUpdateProcessDefinitionById(String processDefinitionId) {
        ProcessDefinitionEntity definition = this.getProcessDefinitionManager().findLatestProcessDefinitionById(processDefinitionId);
        String processDefinitionKey = definition.getKey();
        this.checkUpdateProcessDefinitionByKey(processDefinitionKey);
    }

    public void checkUpdateProcessDefinitionByKey(String processDefinitionKey) {
        this.checkAuthorization(Permissions.UPDATE, Resources.PROCESS_DEFINITION, processDefinitionKey);
    }

    public void checkCreateProcessInstance(ProcessDefinitionEntity definition) {
        this.checkAuthorization(Permissions.CREATE, Resources.PROCESS_INSTANCE);
        this.checkAuthorization(Permissions.CREATE_INSTANCE, Resources.PROCESS_DEFINITION, definition.getKey());
    }

    public void checkReadProcessInstance(String processInstanceId) {
        ExecutionEntity execution = this.getProcessInstanceManager().findExecutionById(processInstanceId);
        if (execution != null) {
            this.checkReadProcessInstance(execution);
        }
    }

    public void checkReadProcessInstance(ExecutionEntity execution) {
        ProcessDefinitionEntity processDefinition = (ProcessDefinitionEntity)execution.getProcessDefinition();
        PermissionCheck firstCheck = new PermissionCheck();
        firstCheck.setPermission(Permissions.READ);
        firstCheck.setResource(Resources.PROCESS_INSTANCE);
        firstCheck.setResourceId(execution.getProcessInstanceId());
        PermissionCheck secondCheck = new PermissionCheck();
        secondCheck.setPermission(Permissions.READ_INSTANCE);
        secondCheck.setResource(Resources.PROCESS_DEFINITION);
        secondCheck.setResourceId(processDefinition.getKey());
        secondCheck.setAuthorizationNotFoundReturnValue(0L);
        this.checkAuthorization(firstCheck, secondCheck);
    }

    public void checkReadProcessInstance(JobEntity job) {
        if (job.getProcessDefinitionKey() == null) {
            return;
        }
        PermissionCheck firstCheck = new PermissionCheck();
        firstCheck.setPermission(Permissions.READ);
        firstCheck.setResource(Resources.PROCESS_INSTANCE);
        firstCheck.setResourceId(job.getProcessInstanceId());
        PermissionCheck secondCheck = new PermissionCheck();
        secondCheck.setPermission(Permissions.READ_INSTANCE);
        secondCheck.setResource(Resources.PROCESS_DEFINITION);
        secondCheck.setResourceId(job.getProcessDefinitionKey());
        secondCheck.setAuthorizationNotFoundReturnValue(0L);
        this.checkAuthorization(firstCheck, secondCheck);
    }

    public void checkReadHistoricJobLog(HistoricJobLogEventEntity historicJobLog) {
        if (historicJobLog.getProcessDefinitionKey() != null) {
            this.checkAuthorization(Permissions.READ_HISTORY, Resources.PROCESS_DEFINITION, historicJobLog.getProcessDefinitionKey());
        }
    }

    public void checkUpdateProcessInstanceById(String processInstanceId) {
        ExecutionEntity execution = this.getProcessInstanceManager().findExecutionById(processInstanceId);
        if (execution != null) {
            this.checkUpdateProcessInstance(execution);
        }
    }

    public void checkUpdateProcessInstance(ExecutionEntity execution) {
        ProcessDefinitionEntity processDefinition = (ProcessDefinitionEntity)execution.getProcessDefinition();
        PermissionCheck firstCheck = new PermissionCheck();
        firstCheck.setPermission(Permissions.UPDATE);
        firstCheck.setResource(Resources.PROCESS_INSTANCE);
        firstCheck.setResourceId(execution.getProcessInstanceId());
        PermissionCheck secondCheck = new PermissionCheck();
        secondCheck.setPermission(Permissions.UPDATE_INSTANCE);
        secondCheck.setResource(Resources.PROCESS_DEFINITION);
        secondCheck.setResourceId(processDefinition.getKey());
        secondCheck.setAuthorizationNotFoundReturnValue(0L);
        this.checkAuthorization(firstCheck, secondCheck);
    }

    public void checkUpdateProcessInstance(JobEntity job) {
        if (job.getProcessDefinitionKey() == null) {
            return;
        }
        PermissionCheck firstCheck = new PermissionCheck();
        firstCheck.setPermission(Permissions.UPDATE);
        firstCheck.setResource(Resources.PROCESS_INSTANCE);
        firstCheck.setResourceId(job.getProcessInstanceId());
        PermissionCheck secondCheck = new PermissionCheck();
        secondCheck.setPermission(Permissions.UPDATE_INSTANCE);
        secondCheck.setResource(Resources.PROCESS_DEFINITION);
        secondCheck.setResourceId(job.getProcessDefinitionKey());
        secondCheck.setAuthorizationNotFoundReturnValue(0L);
        this.checkAuthorization(firstCheck, secondCheck);
    }

    public void checkUpdateProcessInstanceByProcessDefinitionId(String processDefinitionId) {
        ProcessDefinitionEntity definition = this.getProcessDefinitionManager().findLatestProcessDefinitionById(processDefinitionId);
        if (definition != null) {
            String processDefinitionKey = definition.getKey();
            this.checkUpdateProcessInstanceByProcessDefinitionKey(processDefinitionKey);
        }
    }

    public void checkUpdateProcessInstanceByProcessDefinitionKey(String processDefinitionKey) {
        PermissionCheck firstCheck = new PermissionCheck();
        firstCheck.setPermission(Permissions.UPDATE);
        firstCheck.setResource(Resources.PROCESS_INSTANCE);
        PermissionCheck secondCheck = new PermissionCheck();
        secondCheck.setPermission(Permissions.UPDATE_INSTANCE);
        secondCheck.setResource(Resources.PROCESS_DEFINITION);
        secondCheck.setResourceId(processDefinitionKey);
        secondCheck.setAuthorizationNotFoundReturnValue(0L);
        this.checkAuthorization(firstCheck, secondCheck);
    }

    public void checkDeleteProcessInstance(ExecutionEntity execution) {
        ProcessDefinitionEntity processDefinition = (ProcessDefinitionEntity)execution.getProcessDefinition();
        PermissionCheck firstCheck = new PermissionCheck();
        firstCheck.setPermission(Permissions.DELETE);
        firstCheck.setResource(Resources.PROCESS_INSTANCE);
        firstCheck.setResourceId(execution.getProcessInstanceId());
        PermissionCheck secondCheck = new PermissionCheck();
        secondCheck.setPermission(Permissions.DELETE_INSTANCE);
        secondCheck.setResource(Resources.PROCESS_DEFINITION);
        secondCheck.setResourceId(processDefinition.getKey());
        secondCheck.setAuthorizationNotFoundReturnValue(0L);
        this.checkAuthorization(firstCheck, secondCheck);
    }

    public void checkDeleteHistoricProcessInstance(HistoricProcessInstance instance) {
        this.checkAuthorization(Permissions.DELETE_HISTORY, Resources.PROCESS_DEFINITION, instance.getProcessDefinitionKey());
    }

    public void checkCreateTask() {
        this.checkAuthorization(Permissions.CREATE, Resources.TASK);
    }

    public void checkReadTask(TaskEntity task) {
        String taskId = task.getId();
        String executionId = task.getExecutionId();
        if (executionId != null) {
            ExecutionEntity execution = task.getExecution();
            ProcessDefinitionEntity processDefinition = (ProcessDefinitionEntity)execution.getProcessDefinition();
            PermissionCheck readPermissionCheck = new PermissionCheck();
            readPermissionCheck.setPermission(Permissions.READ);
            readPermissionCheck.setResource(Resources.TASK);
            readPermissionCheck.setResourceId(taskId);
            PermissionCheck readTaskPermissionCheck = new PermissionCheck();
            readTaskPermissionCheck.setPermission(Permissions.READ_TASK);
            readTaskPermissionCheck.setResource(Resources.PROCESS_DEFINITION);
            readTaskPermissionCheck.setResourceId(processDefinition.getKey());
            readTaskPermissionCheck.setAuthorizationNotFoundReturnValue(0L);
            this.checkAuthorization(readPermissionCheck, readTaskPermissionCheck);
        } else {
            String caseExecutionId = task.getCaseExecutionId();
            if (caseExecutionId == null) {
                this.checkAuthorization(Permissions.READ, Resources.TASK, taskId);
            }
        }
    }

    public void checkUpdateTask(TaskEntity task) {
        String taskId = task.getId();
        String executionId = task.getExecutionId();
        if (executionId != null) {
            ExecutionEntity execution = task.getExecution();
            ProcessDefinitionEntity processDefinition = (ProcessDefinitionEntity)execution.getProcessDefinition();
            PermissionCheck updatePermissionCheck = new PermissionCheck();
            updatePermissionCheck.setPermission(Permissions.UPDATE);
            updatePermissionCheck.setResource(Resources.TASK);
            updatePermissionCheck.setResourceId(taskId);
            PermissionCheck updateTaskPermissionCheck = new PermissionCheck();
            updateTaskPermissionCheck.setPermission(Permissions.UPDATE_TASK);
            updateTaskPermissionCheck.setResource(Resources.PROCESS_DEFINITION);
            updateTaskPermissionCheck.setResourceId(processDefinition.getKey());
            updateTaskPermissionCheck.setAuthorizationNotFoundReturnValue(0L);
            this.checkAuthorization(updatePermissionCheck, updateTaskPermissionCheck);
        } else {
            String caseExecutionId = task.getCaseExecutionId();
            if (caseExecutionId == null) {
                this.checkAuthorization(Permissions.UPDATE, Resources.TASK, taskId);
            }
        }
    }

    public void checkDeleteTask(TaskEntity task) {
        String taskId = task.getId();
        String executionId = task.getExecutionId();
        String caseExecutionId = task.getCaseExecutionId();
        if (executionId == null && caseExecutionId == null) {
            this.checkAuthorization(Permissions.DELETE, Resources.TASK, taskId);
        }
    }

    public void checkDeleteHistoricTaskInstance(HistoricTaskInstanceEntity task) {
        if (task != null && task.getExecutionId() != null) {
            this.checkAuthorization(Permissions.DELETE_HISTORY, Resources.PROCESS_DEFINITION, task.getProcessDefinitionKey());
        }
    }

    public void checkDeleteUserOperationLog(UserOperationLogEntry entry) {
        String processDefinitionKey;
        if (entry != null && (processDefinitionKey = entry.getProcessDefinitionKey()) != null) {
            this.checkAuthorization(Permissions.DELETE_HISTORY, Resources.PROCESS_DEFINITION, processDefinitionKey);
        }
    }

    public void checkDeleteHistoricDecisionInstance(String decisionDefinitionKey) {
        this.checkAuthorization(Permissions.DELETE_HISTORY, Resources.DECISION_DEFINITION, decisionDefinitionKey);
    }

    public void checkEvaluateDecision(String decisionDefinitionKey) {
        this.checkAuthorization(Permissions.CREATE_INSTANCE, Resources.DECISION_DEFINITION, decisionDefinitionKey);
    }

    public void configureDeploymentQuery(DeploymentQueryImpl query) {
        this.configureQuery((AbstractQuery)query, (Resource)Resources.DEPLOYMENT);
    }

    public void configureProcessDefinitionQuery(ProcessDefinitionQueryImpl query) {
        this.configureQuery(query, Resources.PROCESS_DEFINITION, "RES.KEY_");
    }

    public void configureExecutionQuery(AbstractQuery query) {
        this.configureQuery(query);
        this.addPermissionCheck(query, Resources.PROCESS_INSTANCE, "RES.PROC_INST_ID_", Permissions.READ);
        this.addPermissionCheck(query, Resources.PROCESS_DEFINITION, "P.KEY_", Permissions.READ_INSTANCE);
    }

    public void configureTaskQuery(TaskQueryImpl query) {
        query.getPermissionChecks().clear();
        query.getTaskPermissionChecks().clear();
        Authentication currentAuthentication = this.getCurrentAuthentication();
        CommandContext commandContext = this.getCommandContext();
        if (this.isAuthorizationEnabled() && currentAuthentication != null && commandContext.isAuthorizationCheckEnabled()) {
            this.configureQuery(query);
            this.addPermissionCheck(query, Resources.TASK, "RES.ID_", Permissions.READ);
            this.addPermissionCheck(query, Resources.PROCESS_DEFINITION, "PROCDEF.KEY_", Permissions.READ_TASK);
            PermissionCheck standaloneTaskPermissionCheck = new PermissionCheck();
            standaloneTaskPermissionCheck.setPermission(Permissions.READ);
            standaloneTaskPermissionCheck.setResource(Resources.TASK);
            standaloneTaskPermissionCheck.setResourceIdQueryParam("RES.ID_");
            standaloneTaskPermissionCheck.setAuthorizationNotFoundReturnValue(0L);
            query.addTaskPermissionCheck(standaloneTaskPermissionCheck);
        }
    }

    public void configureEventSubscriptionQuery(EventSubscriptionQueryImpl query) {
        this.configureQuery(query);
        this.addPermissionCheck(query, Resources.PROCESS_INSTANCE, "RES.PROC_INST_ID_", Permissions.READ);
        this.addPermissionCheck(query, Resources.PROCESS_DEFINITION, "PROCDEF.KEY_", Permissions.READ_INSTANCE);
    }

    public void configureIncidentQuery(IncidentQueryImpl query) {
        this.configureQuery(query);
        this.addPermissionCheck(query, Resources.PROCESS_INSTANCE, "RES.PROC_INST_ID_", Permissions.READ);
        this.addPermissionCheck(query, Resources.PROCESS_DEFINITION, "PROCDEF.KEY_", Permissions.READ_INSTANCE);
    }

    protected void configureVariableInstanceQuery(VariableInstanceQueryImpl query) {
        query.getPermissionChecks().clear();
        query.getTaskPermissionChecks().clear();
        Authentication currentAuthentication = this.getCurrentAuthentication();
        CommandContext commandContext = this.getCommandContext();
        if (this.isAuthorizationEnabled() && currentAuthentication != null && commandContext.isAuthorizationCheckEnabled()) {
            this.configureQuery(query);
            this.addPermissionCheck(query, Resources.PROCESS_INSTANCE, "RES.PROC_INST_ID_", Permissions.READ);
            this.addPermissionCheck(query, Resources.PROCESS_DEFINITION, "PROCDEF.KEY_", Permissions.READ_INSTANCE);
            PermissionCheck taskPermissionCheck = new PermissionCheck();
            taskPermissionCheck.setResource(Resources.TASK);
            taskPermissionCheck.setPermission(Permissions.READ);
            taskPermissionCheck.setResourceIdQueryParam("RES.TASK_ID_");
            taskPermissionCheck.setAuthorizationNotFoundReturnValue(0L);
            query.addTaskPermissionCheck(taskPermissionCheck);
        }
    }

    public void configureJobDefinitionQuery(JobDefinitionQueryImpl query) {
        this.configureQuery(query, Resources.PROCESS_DEFINITION, "RES.PROC_DEF_KEY_");
    }

    public void configureJobQuery(JobQueryImpl query) {
        this.configureQuery(query);
        this.addPermissionCheck(query, Resources.PROCESS_INSTANCE, "RES.PROCESS_INSTANCE_ID_", Permissions.READ);
        this.addPermissionCheck(query, Resources.PROCESS_DEFINITION, "RES.PROCESS_DEF_KEY_", Permissions.READ_INSTANCE);
    }

    public void configureHistoricProcessInstanceQuery(HistoricProcessInstanceQueryImpl query) {
        this.configureQuery(query, Resources.PROCESS_DEFINITION, "RES.PROC_DEF_KEY_", Permissions.READ_HISTORY);
    }

    public void configureHistoricActivityInstanceQuery(HistoricActivityInstanceQueryImpl query) {
        this.configureQuery(query, Resources.PROCESS_DEFINITION, "RES.PROC_DEF_KEY_", Permissions.READ_HISTORY);
    }

    public void configureHistoricTaskInstanceQuery(HistoricTaskInstanceQueryImpl query) {
        this.configureQuery(query, Resources.PROCESS_DEFINITION, "RES.PROC_DEF_KEY_", Permissions.READ_HISTORY);
    }

    public void configureHistoricVariableInstanceQuery(HistoricVariableInstanceQueryImpl query) {
        this.configureQuery(query, Resources.PROCESS_DEFINITION, "RES.PROC_DEF_KEY_", Permissions.READ_HISTORY);
    }

    public void configureHistoricDetailQuery(HistoricDetailQueryImpl query) {
        this.configureQuery(query, Resources.PROCESS_DEFINITION, "RES.PROC_DEF_KEY_", Permissions.READ_HISTORY);
    }

    public void configureHistoricJobLogQuery(HistoricJobLogQueryImpl query) {
        this.configureQuery(query, Resources.PROCESS_DEFINITION, "RES.PROCESS_DEF_KEY_", Permissions.READ_HISTORY);
    }

    public void configureHistoricIncidentQuery(HistoricIncidentQueryImpl query) {
        this.configureQuery(query, Resources.PROCESS_DEFINITION, "RES.PROC_DEF_KEY_", Permissions.READ_HISTORY);
    }

    public void configureHistoricActivityStatisticsQuery(HistoricActivityStatisticsQueryImpl query) {
        this.configureQuery(query, Resources.PROCESS_DEFINITION, "PROC_DEF_KEY_", Permissions.READ_HISTORY);
    }

    public void configureHistoricDecisionInstanceQuery(HistoricDecisionInstanceQueryImpl query) {
        this.configureQuery(query, Resources.DECISION_DEFINITION, "DEC_DEF_KEY_", Permissions.READ_HISTORY);
    }

    public void configureUserOperationLogQuery(UserOperationLogQueryImpl query) {
        this.configureQuery(query, Resources.PROCESS_DEFINITION, "RES.PROC_DEF_KEY_", Permissions.READ_HISTORY);
    }

    public void configureDeploymentStatisticsQuery(DeploymentStatisticsQueryImpl query) {
        this.configureQuery(query, Resources.DEPLOYMENT, "DEPLOYMENT.ID_");
        query.getProcessInstancePermissionChecks().clear();
        query.getJobPermissionChecks().clear();
        query.getIncidentPermissionChecks().clear();
        Authentication currentAuthentication = this.getCurrentAuthentication();
        CommandContext commandContext = this.getCommandContext();
        if (this.isAuthorizationEnabled() && currentAuthentication != null && commandContext.isAuthorizationCheckEnabled()) {
            PermissionCheck firstProcessInstancePermissionCheck = new PermissionCheck();
            firstProcessInstancePermissionCheck.setResource(Resources.PROCESS_INSTANCE);
            firstProcessInstancePermissionCheck.setPermission(Permissions.READ);
            firstProcessInstancePermissionCheck.setResourceIdQueryParam("EXECUTION.PROC_INST_ID_");
            PermissionCheck secondProcessInstancePermissionCheck = new PermissionCheck();
            secondProcessInstancePermissionCheck.setResource(Resources.PROCESS_DEFINITION);
            secondProcessInstancePermissionCheck.setPermission(Permissions.READ_INSTANCE);
            secondProcessInstancePermissionCheck.setResourceIdQueryParam("PROCDEF.KEY_");
            secondProcessInstancePermissionCheck.setAuthorizationNotFoundReturnValue(0L);
            query.addProcessInstancePermissionCheck(firstProcessInstancePermissionCheck);
            query.addProcessInstancePermissionCheck(secondProcessInstancePermissionCheck);
            if (query.isFailedJobsToInclude()) {
                PermissionCheck firstJobPermissionCheck = new PermissionCheck();
                firstJobPermissionCheck.setResource(Resources.PROCESS_INSTANCE);
                firstJobPermissionCheck.setPermission(Permissions.READ);
                firstJobPermissionCheck.setResourceIdQueryParam("JOB.PROCESS_INSTANCE_ID_");
                PermissionCheck secondJobPermissionCheck = new PermissionCheck();
                secondJobPermissionCheck.setResource(Resources.PROCESS_DEFINITION);
                secondJobPermissionCheck.setPermission(Permissions.READ_INSTANCE);
                secondJobPermissionCheck.setResourceIdQueryParam("JOB.PROCESS_DEF_KEY_");
                secondJobPermissionCheck.setAuthorizationNotFoundReturnValue(0L);
                query.addJobPermissionCheck(firstJobPermissionCheck);
                query.addJobPermissionCheck(secondJobPermissionCheck);
            }
            if (query.isIncidentsToInclude()) {
                PermissionCheck firstIncidentPermissionCheck = new PermissionCheck();
                firstIncidentPermissionCheck.setResource(Resources.PROCESS_INSTANCE);
                firstIncidentPermissionCheck.setPermission(Permissions.READ);
                firstIncidentPermissionCheck.setResourceIdQueryParam("INC.PROC_INST_ID_");
                PermissionCheck secondIncidentPermissionCheck = new PermissionCheck();
                secondIncidentPermissionCheck.setResource(Resources.PROCESS_DEFINITION);
                secondIncidentPermissionCheck.setPermission(Permissions.READ_INSTANCE);
                secondIncidentPermissionCheck.setResourceIdQueryParam("PROCDEF.KEY_");
                secondIncidentPermissionCheck.setAuthorizationNotFoundReturnValue(0L);
                query.addIncidentPermissionCheck(firstIncidentPermissionCheck);
                query.addIncidentPermissionCheck(secondIncidentPermissionCheck);
            }
        }
    }

    public void configureProcessDefinitionStatisticsQuery(ProcessDefinitionStatisticsQueryImpl query) {
        this.configureQuery(query, Resources.PROCESS_DEFINITION, "PROCDEF.KEY_");
        query.getProcessInstancePermissionChecks().clear();
        query.getJobPermissionChecks().clear();
        query.getIncidentPermissionChecks().clear();
        Authentication currentAuthentication = this.getCurrentAuthentication();
        CommandContext commandContext = this.getCommandContext();
        if (this.isAuthorizationEnabled() && currentAuthentication != null && commandContext.isAuthorizationCheckEnabled()) {
            PermissionCheck firstProcessInstancePermissionCheck = new PermissionCheck();
            firstProcessInstancePermissionCheck.setResource(Resources.PROCESS_INSTANCE);
            firstProcessInstancePermissionCheck.setPermission(Permissions.READ);
            firstProcessInstancePermissionCheck.setResourceIdQueryParam("E.PROC_INST_ID_");
            PermissionCheck secondProcessInstancePermissionCheck = new PermissionCheck();
            secondProcessInstancePermissionCheck.setResource(Resources.PROCESS_DEFINITION);
            secondProcessInstancePermissionCheck.setPermission(Permissions.READ_INSTANCE);
            secondProcessInstancePermissionCheck.setResourceIdQueryParam("P.KEY_");
            secondProcessInstancePermissionCheck.setAuthorizationNotFoundReturnValue(0L);
            query.addProcessInstancePermissionCheck(firstProcessInstancePermissionCheck);
            query.addProcessInstancePermissionCheck(secondProcessInstancePermissionCheck);
            if (query.isFailedJobsToInclude()) {
                PermissionCheck firstJobPermissionCheck = new PermissionCheck();
                firstJobPermissionCheck.setResource(Resources.PROCESS_INSTANCE);
                firstJobPermissionCheck.setPermission(Permissions.READ);
                firstJobPermissionCheck.setResourceIdQueryParam("PROCESS_INSTANCE_ID_");
                PermissionCheck secondJobPermissionCheck = new PermissionCheck();
                secondJobPermissionCheck.setResource(Resources.PROCESS_DEFINITION);
                secondJobPermissionCheck.setPermission(Permissions.READ_INSTANCE);
                secondJobPermissionCheck.setResourceIdQueryParam("PROCESS_DEF_KEY_");
                secondJobPermissionCheck.setAuthorizationNotFoundReturnValue(0L);
                query.addJobPermissionCheck(firstJobPermissionCheck);
                query.addJobPermissionCheck(secondJobPermissionCheck);
            }
            if (query.isIncidentsToInclude()) {
                PermissionCheck firstIncidentPermissionCheck = new PermissionCheck();
                firstIncidentPermissionCheck.setResource(Resources.PROCESS_INSTANCE);
                firstIncidentPermissionCheck.setPermission(Permissions.READ);
                firstIncidentPermissionCheck.setResourceIdQueryParam("I.PROC_INST_ID_");
                PermissionCheck secondIncidentPermissionCheck = new PermissionCheck();
                secondIncidentPermissionCheck.setResource(Resources.PROCESS_DEFINITION);
                secondIncidentPermissionCheck.setPermission(Permissions.READ_INSTANCE);
                secondIncidentPermissionCheck.setResourceIdQueryParam("PROCDEF.KEY_");
                secondIncidentPermissionCheck.setAuthorizationNotFoundReturnValue(0L);
                query.addIncidentPermissionCheck(firstIncidentPermissionCheck);
                query.addIncidentPermissionCheck(secondIncidentPermissionCheck);
            }
        }
    }

    public void configureActivityStatisticsQuery(ActivityStatisticsQueryImpl query) {
        this.configureQuery(query);
        query.getProcessInstancePermissionChecks().clear();
        query.getJobPermissionChecks().clear();
        query.getIncidentPermissionChecks().clear();
        Authentication currentAuthentication = this.getCurrentAuthentication();
        CommandContext commandContext = this.getCommandContext();
        if (this.isAuthorizationEnabled() && currentAuthentication != null && commandContext.isAuthorizationCheckEnabled()) {
            PermissionCheck firstProcessInstancePermissionCheck = new PermissionCheck();
            firstProcessInstancePermissionCheck.setResource(Resources.PROCESS_INSTANCE);
            firstProcessInstancePermissionCheck.setPermission(Permissions.READ);
            firstProcessInstancePermissionCheck.setResourceIdQueryParam("E.PROC_INST_ID_");
            PermissionCheck secondProcessInstancePermissionCheck = new PermissionCheck();
            secondProcessInstancePermissionCheck.setResource(Resources.PROCESS_DEFINITION);
            secondProcessInstancePermissionCheck.setPermission(Permissions.READ_INSTANCE);
            secondProcessInstancePermissionCheck.setResourceIdQueryParam("P.KEY_");
            secondProcessInstancePermissionCheck.setAuthorizationNotFoundReturnValue(0L);
            query.addProcessInstancePermissionCheck(firstProcessInstancePermissionCheck);
            query.addProcessInstancePermissionCheck(secondProcessInstancePermissionCheck);
            if (query.isFailedJobsToInclude()) {
                PermissionCheck firstJobPermissionCheck = new PermissionCheck();
                firstJobPermissionCheck.setResource(Resources.PROCESS_INSTANCE);
                firstJobPermissionCheck.setPermission(Permissions.READ);
                firstJobPermissionCheck.setResourceIdQueryParam("JOB.PROCESS_INSTANCE_ID_");
                PermissionCheck secondJobPermissionCheck = new PermissionCheck();
                secondJobPermissionCheck.setResource(Resources.PROCESS_DEFINITION);
                secondJobPermissionCheck.setPermission(Permissions.READ_INSTANCE);
                secondJobPermissionCheck.setResourceIdQueryParam("JOB.PROCESS_DEF_KEY_");
                secondJobPermissionCheck.setAuthorizationNotFoundReturnValue(0L);
                query.addJobPermissionCheck(firstJobPermissionCheck);
                query.addJobPermissionCheck(secondJobPermissionCheck);
            }
            if (query.isIncidentsToInclude()) {
                PermissionCheck firstIncidentPermissionCheck = new PermissionCheck();
                firstIncidentPermissionCheck.setResource(Resources.PROCESS_INSTANCE);
                firstIncidentPermissionCheck.setPermission(Permissions.READ);
                firstIncidentPermissionCheck.setResourceIdQueryParam("I.PROC_INST_ID_");
                PermissionCheck secondIncidentPermissionCheck = new PermissionCheck();
                secondIncidentPermissionCheck.setResource(Resources.PROCESS_DEFINITION);
                secondIncidentPermissionCheck.setPermission(Permissions.READ_INSTANCE);
                secondIncidentPermissionCheck.setResourceIdQueryParam("PROCDEF.KEY_");
                secondIncidentPermissionCheck.setAuthorizationNotFoundReturnValue(0L);
                query.addIncidentPermissionCheck(firstIncidentPermissionCheck);
                query.addIncidentPermissionCheck(secondIncidentPermissionCheck);
            }
        }
    }

    public void configureExternalTaskQuery(ExternalTaskQueryImpl query) {
        this.configureQuery(query);
        this.addPermissionCheck(query, Resources.PROCESS_INSTANCE, "RES.PROC_INST_ID_", Permissions.READ);
        this.addPermissionCheck(query, Resources.PROCESS_DEFINITION, "RES.PROC_DEF_KEY_", Permissions.READ_INSTANCE);
    }

    public void configureExternalTaskFetch(ListQueryParameterObject parameter) {
        this.configureQuery(parameter);
        CompositePermissionCheck permissionCheck = new PermissionCheckBuilder().conjunctive().composite().disjunctive().atomicCheck(Resources.PROCESS_INSTANCE, "RES.PROC_INST_ID_", Permissions.READ).atomicCheck(Resources.PROCESS_DEFINITION, "RES.PROC_DEF_KEY_", Permissions.READ_INSTANCE).done().composite().disjunctive().atomicCheck(Resources.PROCESS_INSTANCE, "RES.PROC_INST_ID_", Permissions.UPDATE).atomicCheck(Resources.PROCESS_DEFINITION, "RES.PROC_DEF_KEY_", Permissions.UPDATE_INSTANCE).done().build();
        this.addPermissionCheck(parameter, permissionCheck);
    }

    public void configureDecisionDefinitionQuery(DecisionDefinitionQueryImpl query) {
        this.configureQuery(query, Resources.DECISION_DEFINITION, "RES.KEY_");
    }

    public void checkReadDecisionDefinition(DecisionDefinitionEntity decisionDefinition) {
        this.checkReadDecisionDefinition(decisionDefinition.getKey());
    }

    public void checkReadDecisionDefinition(String decisionDefinitionKey) {
        this.checkAuthorization(Permissions.READ, Resources.DECISION_DEFINITION, decisionDefinitionKey);
    }
}

