/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.dmn.cmd;

import java.io.Serializable;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.dmn.entity.repository.DecisionDefinitionEntity;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.deploy.DeploymentCache;
import org.camunda.bpm.engine.impl.persistence.entity.AuthorizationManager;
import org.camunda.bpm.engine.impl.util.EnsureUtil;
import org.camunda.bpm.engine.repository.DecisionDefinition;

public class GetDeploymentDecisionDefinitionCmd
implements Command<DecisionDefinition>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String decisionDefinitionId;

    public GetDeploymentDecisionDefinitionCmd(String decisionDefinitionId) {
        this.decisionDefinitionId = decisionDefinitionId;
    }

    @Override
    public DecisionDefinition execute(CommandContext commandContext) {
        EnsureUtil.ensureNotNull("decisionDefinitionId", (Object)this.decisionDefinitionId);
        DeploymentCache deploymentCache = Context.getProcessEngineConfiguration().getDeploymentCache();
        DecisionDefinitionEntity decisionDefinition = deploymentCache.findDeployedDecisionDefinitionById(this.decisionDefinitionId);
        AuthorizationManager authorizationManager = commandContext.getAuthorizationManager();
        authorizationManager.checkReadDecisionDefinition(decisionDefinition);
        return decisionDefinition;
    }
}

