/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import org.camunda.bpm.engine.exception.NotFoundException;
import org.camunda.bpm.engine.exception.NotValidException;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.oplog.UserOperationLogContext;
import org.camunda.bpm.engine.impl.oplog.UserOperationLogContextEntry;
import org.camunda.bpm.engine.impl.oplog.UserOperationLogContextEntryBuilder;
import org.camunda.bpm.engine.impl.persistence.entity.AuthorizationManager;
import org.camunda.bpm.engine.impl.persistence.entity.JobDefinitionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.PropertyChange;
import org.camunda.bpm.engine.impl.util.EnsureUtil;

public class SetJobDefinitionPriorityCmd
implements Command<Void> {
    public static final String JOB_DEFINITION_OVERRIDING_PRIORITY = "overridingPriority";
    protected String jobDefinitionId;
    protected Long priority;
    protected boolean cascade = false;

    public SetJobDefinitionPriorityCmd(String jobDefinitionId, Long priority, boolean cascade) {
        this.jobDefinitionId = jobDefinitionId;
        this.priority = priority;
        this.cascade = cascade;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        EnsureUtil.ensureNotNull(NotValidException.class, "jobDefinitionId", (Object)this.jobDefinitionId);
        JobDefinitionEntity jobDefinition = commandContext.getJobDefinitionManager().findById(this.jobDefinitionId);
        EnsureUtil.ensureNotNull(NotFoundException.class, "Job definition with id '" + this.jobDefinitionId + "' does not exist", "jobDefinition", (Object)jobDefinition);
        this.checkAuthorization(commandContext, jobDefinition);
        Long currentPriority = jobDefinition.getOverridingJobPriority();
        jobDefinition.setJobPriority(this.priority);
        UserOperationLogContext opLogContext = new UserOperationLogContext();
        this.createJobDefinitionOperationLogEntry(opLogContext, currentPriority, jobDefinition);
        if (this.cascade && this.priority != null) {
            commandContext.getJobManager().updateJobPriorityByDefinitionId(this.jobDefinitionId, this.priority);
            this.createCascadeJobsOperationLogEntry(opLogContext, jobDefinition);
        }
        commandContext.getOperationLogManager().logUserOperations(opLogContext);
        return null;
    }

    protected void checkAuthorization(CommandContext commandContext, JobDefinitionEntity jobDefinition) {
        AuthorizationManager authorizationManager = commandContext.getAuthorizationManager();
        String processDefinitionKey = jobDefinition.getProcessDefinitionKey();
        authorizationManager.checkUpdateProcessDefinitionByKey(processDefinitionKey);
        if (this.cascade) {
            authorizationManager.checkUpdateProcessInstanceByProcessDefinitionKey(processDefinitionKey);
        }
    }

    protected void createJobDefinitionOperationLogEntry(UserOperationLogContext opLogContext, Long previousPriority, JobDefinitionEntity jobDefinition) {
        PropertyChange propertyChange = new PropertyChange(JOB_DEFINITION_OVERRIDING_PRIORITY, previousPriority, jobDefinition.getOverridingJobPriority());
        UserOperationLogContextEntry entry = UserOperationLogContextEntryBuilder.entry("SetPriority", "JobDefinition").inContextOf(jobDefinition).propertyChanges(propertyChange).create();
        opLogContext.addEntry(entry);
    }

    protected void createCascadeJobsOperationLogEntry(UserOperationLogContext opLogContext, JobDefinitionEntity jobDefinition) {
        PropertyChange propertyChange = new PropertyChange("priority", null, jobDefinition.getOverridingJobPriority());
        UserOperationLogContextEntry entry = UserOperationLogContextEntryBuilder.entry("SetPriority", "Job").inContextOf(jobDefinition).propertyChanges(propertyChange).create();
        opLogContext.addEntry(entry);
    }
}

