/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import org.camunda.bpm.engine.exception.NotFoundException;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.AuthorizationManager;
import org.camunda.bpm.engine.impl.persistence.entity.ExternalTaskEntity;
import org.camunda.bpm.engine.impl.util.EnsureUtil;

public class SetExternalTaskRetriesCmd
implements Command<Void> {
    protected String externalTaskId;
    protected int retries;

    public SetExternalTaskRetriesCmd(String externalTaskId, int retries) {
        this.externalTaskId = externalTaskId;
        this.retries = retries;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        this.validateInput();
        ExternalTaskEntity externalTask = commandContext.getExternalTaskManager().findExternalTaskById(this.externalTaskId);
        EnsureUtil.ensureNotNull(NotFoundException.class, "External task with id '" + this.externalTaskId + "' not found", "externalTask", (Object)externalTask);
        AuthorizationManager authorizationManager = commandContext.getAuthorizationManager();
        authorizationManager.checkUpdateProcessInstanceById(externalTask.getProcessInstanceId());
        externalTask.setRetriesAndManageIncidents(this.retries);
        return null;
    }

    protected void validateInput() {
        EnsureUtil.ensureNotNull("externalTaskId", (Object)this.externalTaskId);
        EnsureUtil.ensureGreaterThanOrEqual("retries", this.retries, 0L);
    }
}

