/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.util.Map;
import org.camunda.bpm.engine.impl.cmd.AbstractSetVariableCmd;
import org.camunda.bpm.engine.impl.core.variable.scope.AbstractVariableScope;
import org.camunda.bpm.engine.impl.persistence.entity.AuthorizationManager;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.PropertyChange;
import org.camunda.bpm.engine.impl.util.EnsureUtil;

public class SetExecutionVariablesCmd
extends AbstractSetVariableCmd {
    private static final long serialVersionUID = 1L;

    public SetExecutionVariablesCmd(String executionId, Map<String, ? extends Object> variables, boolean isLocal) {
        super(executionId, variables, isLocal);
    }

    @Override
    protected ExecutionEntity getEntity() {
        EnsureUtil.ensureNotNull("executionId", (Object)this.entityId);
        ExecutionEntity execution = this.commandContext.getExecutionManager().findExecutionById(this.entityId);
        EnsureUtil.ensureNotNull("execution " + this.entityId + " doesn't exist", "execution", (Object)execution);
        AuthorizationManager authorizationManager = this.commandContext.getAuthorizationManager();
        authorizationManager.checkUpdateProcessInstance(execution);
        return execution;
    }

    @Override
    protected void logVariableOperation(AbstractVariableScope scope) {
        ExecutionEntity execution = (ExecutionEntity)scope;
        this.commandContext.getOperationLogManager().logVariableOperation(this.getLogEntryOperation(), execution.getId(), null, PropertyChange.EMPTY_CHANGE);
    }
}

