/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.bpmn.parser;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.jobexecutor.EventSubscriptionJobDeclaration;
import org.camunda.bpm.engine.impl.persistence.entity.EventSubscriptionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.MessageEventSubscriptionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.SignalEventSubscriptionEntity;
import org.camunda.bpm.engine.impl.pvm.PvmScope;
import org.camunda.bpm.engine.impl.pvm.process.ActivityImpl;
import org.camunda.bpm.engine.impl.pvm.runtime.LegacyBehavior;

public class EventSubscriptionDeclaration
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final String eventName;
    protected final String eventType;
    protected boolean async;
    protected String activityId = null;
    protected String eventScopeActivityId = null;
    protected boolean isStartEvent;
    protected Boolean isParallelMultiInstance = null;
    protected EventSubscriptionJobDeclaration jobDeclaration = null;

    public EventSubscriptionDeclaration(String eventName, String eventType) {
        this.eventName = eventName;
        this.eventType = eventType;
    }

    public String getEventName() {
        return this.eventName;
    }

    public boolean isAsync() {
        return this.async;
    }

    public void setAsync(boolean async) {
        this.async = async;
    }

    public void setActivityId(String activityId) {
        this.activityId = activityId;
    }

    public String getActivityId() {
        return this.activityId;
    }

    public void setEventScopeActivityId(String eventScopeActivityId) {
        this.eventScopeActivityId = eventScopeActivityId;
    }

    public String getEventScopeActivityId() {
        return this.eventScopeActivityId;
    }

    public boolean isStartEvent() {
        return this.isStartEvent;
    }

    public void setStartEvent(boolean isStartEvent) {
        this.isStartEvent = isStartEvent;
    }

    public String getEventType() {
        return this.eventType;
    }

    public void setJobDeclaration(EventSubscriptionJobDeclaration jobDeclaration) {
        this.jobDeclaration = jobDeclaration;
    }

    public EventSubscriptionEntity createSubscription(ExecutionEntity execution) {
        if (this.isStartEvent()) {
            return null;
        }
        return this.createEventSubscription(execution);
    }

    private EventSubscriptionEntity createEventSubscription(ExecutionEntity execution) {
        EventSubscriptionEntity eventSubscriptionEntity = null;
        if (this.eventType.equals("message")) {
            eventSubscriptionEntity = new MessageEventSubscriptionEntity(execution);
        } else if (this.eventType.equals("signal")) {
            eventSubscriptionEntity = new SignalEventSubscriptionEntity(execution);
        } else {
            throw new ProcessEngineException("Found event definition of unknown type: " + this.eventType);
        }
        eventSubscriptionEntity.setEventName(this.eventName);
        if (this.activityId != null) {
            ActivityImpl activity = execution.getProcessDefinition().findActivity(this.activityId);
            eventSubscriptionEntity.setActivity(activity);
        }
        eventSubscriptionEntity.insert();
        LegacyBehavior.removeLegacySubscriptionOnParent(execution, eventSubscriptionEntity);
        return eventSubscriptionEntity;
    }

    public static List<EventSubscriptionDeclaration> getDeclarationsForScope(PvmScope scope) {
        Object result = scope.getProperty("eventDefinitions");
        if (result != null) {
            return (List)result;
        }
        return Collections.emptyList();
    }
}

